/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.prefs.MultipleFileDomains;
import mpi.eudico.client.annotator.search.viewer.EAFMultipleFileUtilities;
import mpi.eudico.client.annotator.smfsearch.IMDISessionParser;
import mpi.eudico.client.annotator.smfsearch.ImdiSearchServiceParser;
import mpi.eudico.client.annotator.util.ElanFileFilter;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MFDomainDialog
extends JDialog
implements ActionListener,
MouseListener,
ListSelectionListener {
    private List<String> searchDirs;
    private List<String> searchPaths;
    private DefaultListModel model;
    private JList domainList;
    private JButton newButton;
    private JButton fromIMDIButton;
    private JButton applyButton;
    private JButton removeButton;

    public MFDomainDialog(Frame owner) throws HeadlessException {
        super(owner);
        this.initComponents();
    }

    public MFDomainDialog(Dialog owner) throws HeadlessException {
        super(owner);
        this.initComponents();
    }

    public MFDomainDialog(Frame owner, boolean modal) throws HeadlessException {
        super(owner, modal);
        this.initComponents();
    }

    public MFDomainDialog(Frame owner, String title) throws HeadlessException {
        super(owner, title);
        this.initComponents();
    }

    public MFDomainDialog(Dialog owner, boolean modal) throws HeadlessException {
        super(owner, modal);
        this.initComponents();
    }

    public MFDomainDialog(Dialog owner, String title) throws HeadlessException {
        super(owner, title);
        this.initComponents();
    }

    public MFDomainDialog(Frame owner, String title, boolean modal) throws HeadlessException {
        super(owner, title, modal);
        this.initComponents();
    }

    public MFDomainDialog(Dialog owner, String title, boolean modal) throws HeadlessException {
        super(owner, title, modal);
        this.initComponents();
    }

    protected void initComponents() {
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        JPanel newPanel = new JPanel(new GridBagLayout());
        JPanel domainsPanel = new JPanel(new GridBagLayout());
        this.newButton = new JButton(ElanLocale.getString("MultipleFileSearch.NewDomain"));
        this.newButton.addActionListener(this);
        newPanel.setBorder(new TitledBorder(ElanLocale.getString("MultipleFileSearch.NewDomainSpecify")));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = insets;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        newPanel.add((Component)this.newButton, gbc);
        this.fromIMDIButton = new JButton(ElanLocale.getString("MultipleFileSearch.NewDomainFromIMDI"));
        this.fromIMDIButton.addActionListener(this);
        gbc.gridy = 1;
        newPanel.add((Component)this.fromIMDIButton, gbc);
        gbc.gridy = 0;
        this.getContentPane().add((Component)newPanel, gbc);
        domainsPanel.setBorder(new TitledBorder(ElanLocale.getString("MultipleFileSearch.ExistingDomain")));
        this.model = new DefaultListModel();
        this.loadDomainList();
        this.domainList = new JList(this.model);
        this.domainList.addListSelectionListener(this);
        this.domainList.addMouseListener(this);
        this.applyButton = new JButton(ElanLocale.getString("MultipleFileSearch.Load"));
        this.applyButton.addActionListener(this);
        this.applyButton.setEnabled(false);
        this.removeButton = new JButton(ElanLocale.getString("Button.Delete"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(this);
        gbc.fill = 1;
        gbc.weighty = 1.0;
        domainsPanel.add((Component)new JScrollPane(this.domainList), gbc);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 6, 0));
        buttonPanel.add(this.removeButton);
        buttonPanel.add(this.applyButton);
        gbc = new GridBagConstraints();
        gbc.anchor = 11;
        gbc.insets = insets;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridy = 1;
        domainsPanel.add((Component)buttonPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = insets;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.gridy = 1;
        this.getContentPane().add((Component)domainsPanel, gbc);
        this.postInit();
    }

    protected void postInit() {
        this.pack();
        int w = 280;
        int h = 450;
        this.setSize(this.getSize().width < w ? w : this.getSize().width, this.getSize().height < h ? h : this.getSize().height);
        this.setLocationRelativeTo(this.getParent());
    }

    private void loadDomainList() {
        if (this.model != null) {
            this.model.removeAllElements();
            List<String> currDoms = MultipleFileDomains.getInstance().getDomainList();
            for (int i = 0; i < currDoms.size(); ++i) {
                this.model.addElement(currDoms.get(i));
            }
        }
    }

    public List<String> getSearchPaths() {
        if (this.searchPaths == null) {
            return new ArrayList<String>(1);
        }
        return this.searchPaths;
    }

    public List<String> getSearchDirs() {
        if (this.searchDirs == null) {
            return new ArrayList<String>(1);
        }
        return this.searchDirs;
    }

    public void setSearchDirs(List searchDirs) {
        this.searchDirs = searchDirs;
    }

    public void setSearchPaths(List searchPaths) {
        this.searchPaths = searchPaths;
    }

    private void showWarningMessage(String message) {
        JOptionPane.showMessageDialog(this, message, ElanLocale.getString("Message.Warning"), 2);
    }

    private void saveDomain() {
        String option = JOptionPane.showInputDialog(this, ElanLocale.getString("MultipleFileSearch.Message.Name"), ElanLocale.getString("MultipleFileSearch.SaveDomain"), -1);
        if (option != null) {
            List<String> currDoms = MultipleFileDomains.getInstance().getDomainList();
            if (currDoms.contains(option)) {
                Object[] repOptions = new String[]{ElanLocale.getString("Button.Yes"), ElanLocale.getString("Button.No")};
                int opt = JOptionPane.showOptionDialog(this, ElanLocale.getString("MultipleFileSearch.Message.Replace"), ElanLocale.getString("Message.Warning"), 1, 3, null, repOptions, repOptions[0]);
                if (opt == 0) {
                    MultipleFileDomains.getInstance().addDomain(option, this.searchDirs, this.searchPaths);
                } else {
                    String tmp = option;
                    for (int count = 1; count < 40; ++count) {
                        tmp = option + "-" + count;
                        if (currDoms.contains(tmp)) continue;
                        MultipleFileDomains.getInstance().addDomain(tmp, this.searchDirs, this.searchPaths);
                        break;
                    }
                }
            } else {
                MultipleFileDomains.getInstance().addDomain(option, this.searchDirs, this.searchPaths);
            }
        }
    }

    private void createNewDomain() {
        this.searchDirs = this.searchDirs == null ? new ArrayList<String>(10) : new ArrayList<String>(this.searchDirs);
        this.searchPaths = this.searchPaths == null ? new ArrayList<String>(10) : new ArrayList<String>(this.searchPaths);
        boolean specified = EAFMultipleFileUtilities.specifyDomain(this, this.searchDirs, this.searchPaths);
        if (specified) {
            this.saveDomain();
        }
    }

    private void domainFromImdiSearch() {
        JFileChooser chooser = new JFileChooser();
        String dirPath = (String)Preferences.get("MultipleFileSearchLastDir", null);
        if (dirPath != null) {
            chooser.setCurrentDirectory(new File(dirPath));
        }
        chooser.setFileFilter(ElanFileFilter.createFileFilter(22));
        chooser.setDialogTitle(ElanLocale.getString("MultipleFileSearch.SelectImdiFile"));
        chooser.setFileSelectionMode(0);
        int option = chooser.showOpenDialog(this);
        if (option == 0) {
            String lastDirPath = chooser.getCurrentDirectory().getAbsolutePath();
            Preferences.set("MultipleFileSearchLastDir", lastDirPath, null);
            File imdiFile = chooser.getSelectedFile();
            if (imdiFile == null || !imdiFile.exists()) {
                this.showWarningMessage(ElanLocale.getString("Menu.Dialog.Message0"));
            }
            try {
                ImdiSearchServiceParser ssParser = new ImdiSearchServiceParser(imdiFile.getAbsolutePath());
                List<String> corpPaths = ssParser.getSessionFiles();
                if (corpPaths == null || corpPaths.size() == 0) {
                    this.showWarningMessage(ElanLocale.getString("MultipleFileSearch.Message.NoSessions"));
                    return;
                }
                int failedSessionFiles = 0;
                ArrayList<String> eafPaths = new ArrayList<String>();
                try {
                    IMDISessionParser sessParser = new IMDISessionParser();
                    List<String> tmpList = null;
                    for (int i = 0; i < corpPaths.size(); ++i) {
                        try {
                            tmpList = sessParser.parse(corpPaths.get(i));
                            if (tmpList == null) {
                                ++failedSessionFiles;
                                continue;
                            }
                            for (int j = 0; j < tmpList.size(); ++j) {
                                String tmpPath = tmpList.get(j);
                                if (eafPaths.contains(tmpPath)) continue;
                                eafPaths.add(tmpPath);
                            }
                            continue;
                        }
                        catch (Exception ex) {
                            ++failedSessionFiles;
                        }
                    }
                    if (failedSessionFiles > 0) {
                        this.showWarningMessage(ElanLocale.getString("MultipleFileSearch.Message.FailedSessions") + " " + failedSessionFiles);
                    }
                    if (eafPaths.size() == 0) {
                        this.showWarningMessage(ElanLocale.getString("MultipleFileSearch.Message.NoEAF"));
                        return;
                    }
                    this.searchPaths = eafPaths;
                    this.searchDirs = new ArrayList<String>(0);
                }
                catch (SAXException saxe) {
                    this.showWarningMessage(ElanLocale.getString("MultipleFileSearch.Message.NoParser"));
                }
            }
            catch (SAXException sax) {
                this.showWarningMessage(ElanLocale.getString("MultipleFileSearch.Message.NoSearchLoad"));
                return;
            }
            catch (IOException ioe) {
                this.showWarningMessage(ElanLocale.getString("MultipleFileSearch.Message.NoSearchLoad"));
                return;
            }
        } else {
            return;
        }
        this.saveDomain();
        this.setVisible(false);
        this.dispose();
    }

    private void loadDomain(String domainName) {
        Map<String, List<String>> domain = MultipleFileDomains.getInstance().getDomain(domainName);
        if (domain != null) {
            List<String> paths;
            List<String> dirs = domain.get(domainName + ".Dirs");
            if (dirs == null) {
                dirs = new ArrayList<String>(0);
            }
            if ((paths = domain.get(domainName + ".Paths")) == null) {
                paths = new ArrayList<String>(0);
            }
            this.searchDirs = dirs;
            this.searchPaths = paths;
            Preferences.set("LastUsedMFSearchDomain", domainName, null, false, false);
            this.setVisible(false);
            this.dispose();
        } else {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("MultipleFileSearch.Message.NoLoad"), ElanLocale.getString("Message.Warning"), 0);
        }
    }

    private void loadDomains(Object[] domainNames) {
        if (domainNames == null || domainNames.length == 0) {
            return;
        }
        ArrayList<String> allPaths = new ArrayList<String>();
        ArrayList<String> allDirs = new ArrayList<String>();
        Map<String, List<String>> domain = null;
        for (int i = 0; i < domainNames.length; ++i) {
            List<String> path;
            String elem;
            int j;
            String name = (String)domainNames[i];
            domain = MultipleFileDomains.getInstance().getDomain(name);
            if (domain == null) continue;
            List<String> dir = domain.get(name + ".Dirs");
            if (dir != null) {
                for (j = 0; j < dir.size(); ++j) {
                    elem = dir.get(j);
                    if (allDirs.contains(elem)) continue;
                    allDirs.add(elem);
                }
            }
            if ((path = domain.get(name + ".Paths")) == null) continue;
            for (j = 0; j < path.size(); ++j) {
                elem = path.get(j);
                if (allPaths.contains(elem)) continue;
                allPaths.add(elem);
            }
        }
        this.searchDirs = allDirs;
        this.searchPaths = allPaths;
        this.setVisible(false);
        this.dispose();
    }

    private void removeDomains(Object[] domainNames) {
        if (domainNames != null && domainNames.length != 0) {
            int option = JOptionPane.showConfirmDialog(this, ElanLocale.getString("MultipleFileSearch.Message.Delete"), ElanLocale.getString("Message.Warning"), 0);
            if (option != 0) {
                return;
            }
            for (int i = 0; i < domainNames.length; ++i) {
                MultipleFileDomains.getInstance().removeDomain((String)domainNames[i]);
            }
            this.loadDomainList();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.newButton) {
            this.createNewDomain();
        } else {
            if (e.getSource() == this.fromIMDIButton) {
                this.domainFromImdiSearch();
                return;
            }
            if (e.getSource() == this.applyButton) {
                Object[] vals = this.domainList.getSelectedValues();
                if (vals == null) return;
                if (vals.length == 1) {
                    this.loadDomain((String)vals[0]);
                } else {
                    this.loadDomains(vals);
                }
            } else if (e.getSource() == this.removeButton) {
                Object[] vals = this.domainList.getSelectedValues();
                if (vals == null) return;
                this.removeDomains(vals);
                return;
            }
        }
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        String namedDomain;
        int selIndex;
        if (e.getClickCount() >= 2 && (selIndex = this.domainList.locationToIndex(e.getPoint())) > -1 && (namedDomain = (String)this.model.elementAt(selIndex)) != null) {
            this.loadDomain(namedDomain);
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.domainList) {
            boolean sel = this.domainList.getSelectedIndices().length > 0;
            this.applyButton.setEnabled(sel);
            this.removeButton.setEnabled(sel);
        }
    }
}

