/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.util.ElanFileFilter;

public class MultiFileChooser
extends JComponent
implements ActionListener {
    public static final int GENERIC = 0;
    public static final int MEDIA_TEMPLATE = 1;
    private JFileChooser chooser;
    private JList fileList;
    private DefaultListModel model;
    private JPanel selPanel;
    private JRadioButton mediaRB;
    private JRadioButton templateRB;
    private JButton remoteButton;
    private JButton okButton;
    private JButton cancelButton;
    private JButton copyButton;
    private JButton removeButton;
    private JButton upButton;
    private JButton downButton;
    private String dialogTitle;
    private JDialog dialog;
    private FileFilter mediaFilter;
    private FileFilter templateFilter;
    private FileFilter qtFilter;
    private FileFilter mp4Filter;
    private int returnValue = -1;
    private int mode = 1;

    public MultiFileChooser() {
        this(0);
    }

    public MultiFileChooser(int mode) {
        if (mode >= 0 && mode <= 1) {
            this.mode = mode;
        }
        this.initComponents();
    }

    private void initComponents() {
        this.mediaRB = new JRadioButton();
        this.templateRB = new JRadioButton();
        this.remoteButton = new JButton();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.removeButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.copyButton = new JButton();
        ImageIcon REMOVE_ICON = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Remove.gif"));
        ImageIcon UP_ICON = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Up.gif"));
        ImageIcon DOWN_ICON = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Down.gif"));
        this.removeButton.setIcon(REMOVE_ICON);
        this.upButton.setIcon(UP_ICON);
        this.downButton.setIcon(DOWN_ICON);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        Insets insets = new Insets(2, 2, 2, 2);
        this.chooser = new JFileChooser();
        this.chooser.setMultiSelectionEnabled(true);
        this.chooser.setControlButtonsAreShown(false);
        this.chooser.setPreferredSize(new Dimension((int)this.chooser.getPreferredSize().getWidth() - 80, (int)this.chooser.getPreferredSize().getHeight()));
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = insets;
        this.add((Component)this.chooser, gbc);
        JPanel midPanel = new JPanel(new GridBagLayout());
        this.copyButton.setText(" >> ");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 10;
        gbc.insets = new Insets(4, 6, 4, 6);
        midPanel.add((Component)this.copyButton, gbc);
        this.selPanel = new JPanel(new GridBagLayout());
        this.selPanel.setBorder(new TitledBorder(ElanLocale.getString("Frame.ElanFrame.NewDialog.RadioFileType")));
        ButtonGroup bg = new ButtonGroup();
        this.mediaRB.setSelected(true);
        this.mediaRB.setText(ElanLocale.getString("Frame.ElanFrame.NewDialog.RadioButtonMedia"));
        this.templateRB.setText(ElanLocale.getString("Frame.ElanFrame.NewDialog.RadioButtonTemplate"));
        bg.add(this.mediaRB);
        bg.add(this.templateRB);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.insets = insets;
        this.selPanel.add((Component)this.mediaRB, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.insets = insets;
        this.selPanel.add((Component)this.templateRB, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 15;
        gbc.insets = new Insets(4, 6, 4, 6);
        midPanel.add((Component)this.selPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 11;
        gbc.fill = 3;
        gbc.weighty = 1.0;
        this.add((Component)midPanel, gbc);
        JPanel rightPanel = new JPanel(new GridBagLayout());
        JPanel infoPanel = new JPanel(new GridBagLayout());
        Dimension dim = new Dimension(70, 40);
        infoPanel.setPreferredSize(dim);
        infoPanel.setMinimumSize(dim);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 10;
        gbc.insets = insets;
        gbc.fill = 2;
        gbc.weighty = 1.0;
        infoPanel.add(new JLabel(ElanLocale.getString("Frame.ElanFrame.NewDialog.Selected")));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = insets;
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        rightPanel.add((Component)infoPanel, gbc);
        this.model = new DefaultListModel();
        this.fileList = new JList(this.model);
        this.fileList.setSelectionMode(2);
        JScrollPane jsp = new JScrollPane(this.fileList);
        jsp.setPreferredSize(new Dimension(jsp.getPreferredSize().getSize().width - 30, jsp.getPreferredSize().getSize().height));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = insets;
        gbc.anchor = 11;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        rightPanel.add((Component)jsp, gbc);
        JPanel controlPanel = new JPanel(new GridLayout(1, 3, 6, 6));
        controlPanel.add(this.removeButton);
        controlPanel.add(this.upButton);
        controlPanel.add(this.downButton);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = insets;
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        rightPanel.add((Component)controlPanel, gbc);
        this.remoteButton.setText(ElanLocale.getString("Frame.ElanFrame.NewDialog.RemoteMedia"));
        this.remoteButton.addActionListener(this);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = 11;
        gbc.insets = new Insets(7, 2, 3, 2);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        rightPanel.add((Component)this.remoteButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.anchor = 11;
        gbc.insets = insets;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)rightPanel, gbc);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 6, 6));
        this.okButton.setText(ElanLocale.getString("Button.OK"));
        this.cancelButton.setText(ElanLocale.getString("Button.Cancel"));
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        JPanel butBorderPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        butBorderPanel.add((Component)new JPanel(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 13;
        gbc.insets = insets;
        butBorderPanel.add((Component)buttonPanel, gbc);
        butBorderPanel.setBorder(new CompoundBorder(new LineBorder(Color.GRAY, 1), new EmptyBorder(6, 6, 6, 6)));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 3;
        gbc.anchor = 10;
        gbc.insets = insets;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.add((Component)butBorderPanel, gbc);
        this.chooser.addActionListener(this);
        this.copyButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.upButton.addActionListener(this);
        this.downButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.mediaRB.addActionListener(this);
        this.templateRB.addActionListener(this);
        if (this.mode == 0) {
            this.selPanel.setVisible(false);
            this.remoteButton.setVisible(false);
        } else {
            this.mediaFilter = ElanFileFilter.createFileFilter(2);
            this.templateFilter = ElanFileFilter.createFileFilter(4);
            this.qtFilter = ElanFileFilter.createFileFilter(17);
            this.mp4Filter = ElanFileFilter.createFileFilter(16);
            this.chooser.addChoosableFileFilter(this.mediaFilter);
            this.chooser.addChoosableFileFilter(this.mp4Filter);
            this.chooser.addChoosableFileFilter(this.qtFilter);
            Object val = Preferences.get("Media.LastUsedMediaType", null);
            if (val instanceof Integer) {
                int type = (Integer)val;
                if (type == 2) {
                    this.chooser.setFileFilter(this.mediaFilter);
                } else if (type == 16) {
                    this.chooser.setFileFilter(this.mp4Filter);
                } else if (type == 17) {
                    this.chooser.setFileFilter(this.qtFilter);
                } else {
                    this.chooser.setFileFilter(this.chooser.getAcceptAllFileFilter());
                }
            } else {
                this.chooser.setFileFilter(this.chooser.getAcceptAllFileFilter());
            }
            String mediaDir = (String)Preferences.get("MediaDir", null);
            this.chooser.setCurrentDirectory(new File(mediaDir == null ? Constants.USERHOME : mediaDir));
        }
    }

    public Object[] getFiles() {
        Object[] obj = new Object[this.model.getSize()];
        for (int i = 0; i < obj.length; ++i) {
            obj[i] = this.model.getElementAt(i);
        }
        return obj;
    }

    public void setFiles(File[] files) {
        this.model.clear();
        for (int i = 0; i < files.length; ++i) {
            this.model.insertElementAt(files[i], i);
        }
        this.fileList.setSelectedIndex(0);
        this.fileList.ensureIndexIsVisible(0);
    }

    public void clearList() {
        this.model.clear();
    }

    private void addRemoteFile() {
        Object rf = JOptionPane.showInputDialog(this, ElanLocale.getString("Frame.ElanFrame.NewDialog.RemoteLabel"), ElanLocale.getString("Frame.ElanFrame.NewDialog.RemoteMedia"), -1, null, null, "rtsp://");
        if (rf == null) {
            return;
        }
        String url = (String)rf;
        url.replace('\\', '/');
        boolean valid = true;
        if (!url.startsWith("rtsp")) {
            int ds = url.indexOf("//");
            url = ds > -1 ? "rtsp:" + url.substring(ds) : "rtsp://" + url;
        }
        if (url.indexOf("://") != 4) {
            valid = false;
        }
        int dot = url.lastIndexOf(46);
        int slash = url.lastIndexOf(47);
        if (dot < 0 || dot < slash || dot > slash && slash <= 7) {
            valid = false;
        }
        if (!valid) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("Frame.ElanFrame.NewDialog.RemoteMessage") + url, ElanLocale.getString("Message.Error"), 0);
            this.addRemoteFile();
        } else {
            int curIndex = this.fileList.getSelectedIndex();
            this.model.add(curIndex + 1, url);
            this.fileList.setSelectedIndex(curIndex + 1);
        }
    }

    private void copyFile() {
        int curIndex;
        String strCurDir = null;
        if (this.chooser.isMultiSelectionEnabled()) {
            File[] files = this.chooser.getSelectedFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!this.model.contains(files[i])) {
                    curIndex = this.fileList.getSelectedIndex();
                    this.model.add(curIndex + 1, files[i]);
                    this.fileList.setSelectedIndex(curIndex + 1);
                }
                if (i != 0) continue;
                strCurDir = files[i].getAbsolutePath();
                strCurDir = new File(strCurDir).getParent();
            }
        } else {
            File f = this.chooser.getSelectedFile();
            if (f != null) {
                curIndex = this.fileList.getSelectedIndex();
                this.model.add(curIndex + 1, f);
                this.fileList.setSelectedIndex(curIndex + 1);
                strCurDir = f.getAbsolutePath();
                strCurDir = new File(strCurDir).getParent();
            }
        }
        boolean isMedia = false;
        boolean isTemplate = false;
        FileFilter[] filters = this.chooser.getChoosableFileFilters();
        for (int i = 0; i < filters.length; ++i) {
            if (filters[i] == this.mediaFilter) {
                isMedia = true;
                break;
            }
            if (filters[i] != this.templateFilter) continue;
            isTemplate = true;
            break;
        }
        if (isTemplate) {
            if (strCurDir != null) {
                Preferences.set("TemplateDir", strCurDir, null);
            }
        } else if (isMedia) {
            if (strCurDir != null) {
                Preferences.set("MediaDir", strCurDir, null);
            }
            FileFilter ff = this.chooser.getFileFilter();
            int type = -1;
            if (ff == this.mediaFilter) {
                type = 2;
            } else if (ff == this.mp4Filter) {
                type = 16;
            } else if (ff == this.qtFilter) {
                type = 17;
            }
            Preferences.set("Media.LastUsedMediaType", new Integer(type), null);
        }
    }

    private void removeFile() {
        int[] selIndices = this.fileList.getSelectedIndices();
        if (selIndices.length == 0) {
            return;
        }
        for (int i = selIndices.length - 1; i >= 0; --i) {
            this.model.removeElementAt(selIndices[i]);
        }
        if (selIndices[0] < this.model.getSize()) {
            this.fileList.setSelectedIndex(selIndices[0]);
            this.fileList.ensureIndexIsVisible(selIndices[0]);
        }
    }

    private void moveUp() {
        int[] selIndices = this.fileList.getSelectedIndices();
        if (selIndices.length == 0) {
            return;
        }
        for (int i = 0; i < selIndices.length; ++i) {
            if (selIndices[i] == i) continue;
            this.model.insertElementAt(this.model.remove(selIndices[i]), selIndices[i] - 1);
        }
        int[] newSels = new int[selIndices.length];
        for (int i = 0; i < selIndices.length; ++i) {
            newSels[i] = selIndices[i] == i ? i : selIndices[i] - 1;
        }
        this.fileList.setSelectedIndices(newSels);
    }

    private void moveDown() {
        int[] selIndices = this.fileList.getSelectedIndices();
        if (selIndices.length == 0) {
            return;
        }
        int unmovableIndex = this.model.getSize() - 1;
        int[] newSels = new int[selIndices.length];
        for (int i = selIndices.length - 1; i >= 0; --i) {
            if (selIndices[i] == unmovableIndex) {
                --unmovableIndex;
                newSels[i] = selIndices[i];
                continue;
            }
            this.model.insertElementAt(this.model.remove(selIndices[i]), selIndices[i] + 1);
            newSels[i] = selIndices[i] + 1;
        }
        this.fileList.setSelectedIndices(newSels);
    }

    private void apply() {
        this.returnValue = 0;
        if (this.dialog != null) {
            this.dialog.dispose();
        }
    }

    private void cancel() {
        this.returnValue = 1;
        if (this.dialog != null) {
            this.dialog.dispose();
        }
    }

    private void setMediaFilter() {
        boolean isMedia = false;
        FileFilter[] filters = this.chooser.getChoosableFileFilters();
        for (int i = 0; i < filters.length; ++i) {
            if (filters[i] != this.mediaFilter) continue;
            isMedia = true;
            break;
        }
        if (!isMedia) {
            File selectedFile = this.chooser.getSelectedFile();
            if (selectedFile != null) {
                String strTemplateDir = selectedFile.getAbsolutePath();
                strTemplateDir = new File(strTemplateDir).getParent();
                Preferences.set("TemplateDir", strTemplateDir, null);
            }
            this.chooser.removeChoosableFileFilter(this.templateFilter);
            this.chooser.addChoosableFileFilter(this.mediaFilter);
            this.chooser.addChoosableFileFilter(this.mp4Filter);
            this.chooser.addChoosableFileFilter(this.qtFilter);
            Object val = Preferences.get("Media.LastUsedMediaType", null);
            if (val instanceof Integer) {
                int type = (Integer)val;
                if (type == 2) {
                    this.chooser.setFileFilter(this.mediaFilter);
                } else if (type == 16) {
                    this.chooser.setFileFilter(this.mp4Filter);
                } else if (type == 17) {
                    this.chooser.setFileFilter(this.qtFilter);
                } else {
                    this.chooser.setFileFilter(this.chooser.getAcceptAllFileFilter());
                }
            } else {
                this.chooser.setFileFilter(this.chooser.getAcceptAllFileFilter());
            }
            String mediaDir = (String)Preferences.get("MediaDir", null);
            this.chooser.setCurrentDirectory(new File(mediaDir == null ? Constants.USERHOME : mediaDir));
        }
    }

    private void setTemplateFilter() {
        boolean isTemplate = false;
        FileFilter[] filters = this.chooser.getChoosableFileFilters();
        for (int i = 0; i < filters.length; ++i) {
            if (filters[i] != this.templateFilter) continue;
            isTemplate = true;
            break;
        }
        if (!isTemplate) {
            File selectedFile = this.chooser.getSelectedFile();
            if (selectedFile != null) {
                String strMediaDir = selectedFile.getAbsolutePath();
                strMediaDir = new File(strMediaDir).getParent();
                Preferences.set("MediaDir", strMediaDir, null);
            }
            this.chooser.removeChoosableFileFilter(this.mediaFilter);
            this.chooser.removeChoosableFileFilter(this.mp4Filter);
            this.chooser.removeChoosableFileFilter(this.qtFilter);
            this.chooser.addChoosableFileFilter(this.templateFilter);
            String templateDir = (String)Preferences.get("TemplateDir", null);
            this.chooser.setCurrentDirectory(new File(templateDir == null ? Constants.USERHOME : templateDir));
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.copyButton) {
            this.copyFile();
        } else if (src == this.removeButton) {
            this.removeFile();
        } else if (src == this.upButton) {
            this.moveUp();
        } else if (src == this.downButton) {
            this.moveDown();
        } else if (src == this.okButton) {
            this.apply();
        } else if (src == this.cancelButton) {
            this.cancel();
        } else if (src == this.chooser) {
            this.copyFile();
        } else if (src == this.mediaRB) {
            this.setMediaFilter();
        } else if (src == this.templateRB) {
            this.setTemplateFilter();
        } else if (src == this.remoteButton) {
            this.addRemoteFile();
        }
    }

    public static void main(String[] args) {
    }

    public int showDialog(Component parent, String approveButtonText) throws HeadlessException {
        if (approveButtonText != null) {
            this.setApproveButtonText(approveButtonText);
        }
        this.dialog = this.createDialog(parent);
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MultiFileChooser.this.returnValue = 1;
            }
        });
        this.returnValue = -1;
        this.dialog.setVisible(true);
        this.dialog.dispose();
        this.dialog = null;
        return this.returnValue;
    }

    protected JDialog createDialog(Component parent) throws HeadlessException {
        Frame frame = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        ClosableDialog dia = new ClosableDialog(frame, this.dialogTitle, true);
        Container contentPane = dia.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this, "Center");
        dia.pack();
        dia.setLocationRelativeTo(parent);
        return dia;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        if (this.mode != mode) {
            this.mode = mode;
            if (mode == 0) {
                this.selPanel.setVisible(false);
            } else {
                this.selPanel.setVisible(true);
            }
        }
    }

    public File getCurrentDirectory() {
        return this.chooser.getCurrentDirectory();
    }

    public void setCurrentDirectory(File dir) {
        this.chooser.setCurrentDirectory(dir);
    }

    public void setApproveButtonText(String approveButtonText) {
        this.okButton.setText(approveButtonText);
    }

    public String getApproveButtonText() {
        return this.okButton.getText();
    }

    public void setFileFilter(FileFilter filter) {
        this.chooser.setFileFilter(filter);
    }

    public FileFilter getFileFilter() {
        return this.chooser.getFileFilter();
    }

    public FileFilter[] getChoosableFileFilters() {
        return this.chooser.getChoosableFileFilters();
    }

    public void addChoosableFileFilter(FileFilter filter) {
        this.chooser.addChoosableFileFilter(filter);
    }

    public boolean removeChoosableFileFilter(FileFilter f) {
        return this.chooser.removeChoosableFileFilter(f);
    }

    public void resetChoosableFileFilters() {
        this.chooser.resetChoosableFileFilters();
    }

    public void setFileSelectionMode(int mode) {
        this.chooser.setFileSelectionMode(mode);
    }

    public int getFileSelectionMode() {
        return this.chooser.getFileSelectionMode();
    }

    public boolean isFileSelectionEnabled() {
        return this.chooser.isFileSelectionEnabled();
    }

    public void setDialogTitle(String title) {
        this.dialogTitle = title;
        if (this.dialog != null) {
            this.dialog.setTitle(title);
        }
    }
}

