/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.LineBorder;

public class MultiVertSplitPane
extends JComponent
implements ComponentListener,
MouseListener,
MouseMotionListener {
    private final int DIV_HEIGHT = 8;
    private List<Container> components;
    private List<Container> dividers;
    private int curSPY = -1;
    private int curSPH = -1;
    private int startXY = 0;
    private boolean dragging = false;
    static JPanel testScroll;

    public MultiVertSplitPane() {
        this.setLayout(null);
        this.setDoubleBuffered(false);
        this.components = new ArrayList<Container>(4);
        this.dividers = new ArrayList<Container>(4);
        this.setBorder(new BevelBorder(1));
        LookAndFeel.installColors(this, "SplitPane.background", "SplitPane.foreground");
        this.addComponentListener(this);
    }

    public void addComponent(Container container, int index) {
        if (this.components.size() == 0) {
            this.components.add(container);
        } else {
            JPanel divid = this.createDivider();
            if (index <= 0) {
                this.components.add(0, container);
                this.dividers.add(0, divid);
                this.add(divid);
            } else if (index >= this.components.size()) {
                this.components.add(container);
                this.dividers.add(divid);
                this.add(divid);
            } else {
                this.components.add(index, container);
                this.dividers.add(index - 1, divid);
                this.add(divid);
            }
        }
        this.add(container);
    }

    public int getNumComponents() {
        return this.components.size();
    }

    public Component getComponentAt(int index) {
        if (index < 0 || index > this.components.size() - 1) {
            throw new ArrayIndexOutOfBoundsException("Index: " + index + " < 0 or >= than number of components: " + this.components.size());
        }
        return this.components.get(index);
    }

    public int getIndexOf(Component comp) {
        return this.components.indexOf(comp);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    public void paint(Graphics g) {
        super.paint(g);
    }

    private JPanel createDivider() {
        JPanel divid = new JPanel(null);
        divid.setBorder(new LineBorder(Color.GRAY, 1));
        divid.addMouseListener(this);
        divid.addMouseMotionListener(this);
        JLabel iconLabel = new JLabel();
        iconLabel.setIcon(new ArrowIcon(true));
        divid.add(iconLabel);
        iconLabel.setBounds(4, 1, 8, 8);
        JLabel iconLabel2 = new JLabel();
        iconLabel2.setIcon(new ArrowIcon(false));
        divid.add(iconLabel2);
        iconLabel2.setBounds(12, 1, 8, 8);
        return divid;
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        if (this.components.size() == 0) {
            this.repaint();
            return;
        }
        int border = this.getBorder().getBorderInsets((Component)this).top;
        if (this.curSPH == -1) {
            int i;
            this.curSPH = this.getHeight();
            this.curSPY = this.getY();
            float cHeight = (float)(this.getHeight() - 2 * border - this.dividers.size() * 8) / (float)this.components.size();
            for (i = this.components.size() - 1; i > -1; --i) {
                this.components.get(i).setBounds(border, (int)((float)i * cHeight) + i * 8 + border, this.getWidth() - 2 * border, (int)cHeight);
            }
            for (i = 0; i < this.dividers.size(); ++i) {
                this.dividers.get(i).setBounds(border, (int)((float)(i + 1) * cHeight) + i * 8 + border, this.getWidth() - 2 * border, 8);
            }
        } else {
            Rectangle rect;
            int i;
            for (i = this.components.size() - 1; i > -1; --i) {
                rect = this.components.get(i).getBounds();
                rect.width = this.getWidth() - 2 * border;
                this.components.get(i).setBounds(rect);
            }
            for (i = 0; i < this.dividers.size(); ++i) {
                rect = this.dividers.get(i).getBounds();
                rect.width = this.getWidth() - 2 * border;
                this.dividers.get(i).setBounds(rect);
            }
            if (this.curSPH == this.getHeight()) {
                this.repaint();
                return;
            }
            if (this.curSPH > this.getHeight()) {
                if (this.curSPY == this.getY()) {
                    rect = this.components.get(this.components.size() - 1).getBounds();
                    rect.height = this.getHeight() - border - rect.y;
                    if (rect.height < 0) {
                        rect.height = 0;
                    }
                    this.components.get(this.components.size() - 1).setBounds(rect);
                    for (int i2 = this.dividers.size() - 1; i2 >= 0; --i2) {
                        int maxH = this.getHeight() - border - (this.dividers.size() - 1 - i2) * 8;
                        Rectangle b2 = this.dividers.get(i2).getBounds();
                        if (b2.y + 8 > maxH) {
                            b2.y = maxH - 8;
                            this.dividers.get(i2).setBounds(b2);
                            rect.y = maxH;
                            this.components.get(i2 + 1).setBounds(rect);
                            Rectangle b3 = this.components.get(i2).getBounds();
                            if (b3.y + b3.height <= b2.y) continue;
                            b3.height = b2.y - b3.y;
                            if (b3.height < 0) {
                                b3.height = 0;
                            }
                            this.components.get(i2).setBounds(b3);
                            continue;
                        }
                        break;
                    }
                } else {
                    int decr = this.getY() - this.curSPY;
                    rect = this.components.get(0).getBounds();
                    rect.height -= decr;
                    if (rect.height < 0) {
                        rect.height = 0;
                    }
                    this.components.get(0).setBounds(rect);
                    for (int i3 = 0; i3 < this.dividers.size(); ++i3) {
                        int minY = border + i3 * 8;
                        Rectangle b2 = this.dividers.get(i3).getBounds();
                        b2.y -= decr;
                        if (b2.y < minY) {
                            rect.y = b2.y = minY;
                            rect.height = 0;
                            this.components.get(i3).setBounds(rect);
                        }
                        this.dividers.get(i3).setBounds(b2);
                        Rectangle b3 = this.components.get(i3 + 1).getBounds();
                        b3.y -= decr;
                        this.components.get(i3 + 1).setBounds(b3);
                        if (b3.y < minY + 8) {
                            int dif = minY + 8 - b3.y;
                            b3.y = minY + 8;
                            b3.height -= dif;
                            if (b3.height < 0) {
                                b3.height = 0;
                            }
                        }
                        this.components.get(i3 + 1).setBounds(b3);
                    }
                }
            } else if (this.curSPY == this.getY()) {
                rect = this.components.get(this.components.size() - 1).getBounds();
                rect.height = this.getHeight() - border - rect.y;
                if (rect.height < 0) {
                    rect.height = 0;
                }
                this.components.get(this.components.size() - 1).setBounds(rect);
            } else {
                System.out.println("Increase top");
                rect = this.components.get(0).getBounds();
                rect.height = rect.height + (rect.y - this.getY()) - border;
                this.components.get(0).setBounds(rect);
            }
            this.curSPH = this.getHeight();
            this.curSPY = this.getY();
        }
        this.repaint();
    }

    public void componentShown(ComponentEvent e) {
        System.out.println("Split shown");
    }

    public static void main(String[] args) {
        MultiVertSplitPane sp = new MultiVertSplitPane();
        JPanel first = new JPanel();
        first.setBackground(Color.MAGENTA);
        sp.addComponent(first, 0);
        JPanel sec = new JPanel();
        sec.setBackground(Color.GREEN);
        sp.addComponent(sec, 1);
        JPanel third = new JPanel();
        third.setBackground(Color.BLUE);
        sp.addComponent(third, 2);
        JFrame testFrame = new JFrame();
        testFrame.getContentPane().setLayout(new BorderLayout());
        testFrame.setSize(400, 300);
        testFrame.setVisible(true);
        testFrame.getContentPane().add((Component)sp, "Center");
        testScroll = new JPanel();
        testScroll.setBackground(Color.YELLOW);
        testScroll.addMouseListener(sp);
        testScroll.setBounds(2, 2, 30, 30);
        testFrame.getContentPane().add((Component)testScroll, "North");
    }

    public void mouseClicked(MouseEvent e) {
        System.out.println("clicked");
        if (e.getComponent() == testScroll) {
            System.out.println("clicked-2");
            Rectangle r = testScroll.getBounds();
            r.height += 20;
            testScroll.setBounds(r);
            r = this.getBounds();
            r.y += 20;
            r.height -= 20;
            this.setBounds(r);
            this.invalidate();
        }
    }

    public void mouseEntered(MouseEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(8));
    }

    public void mouseExited(MouseEvent e) {
        if (!this.dragging) {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void mousePressed(MouseEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(8));
        this.startXY = e.getY();
        this.dragging = true;
    }

    public void mouseReleased(MouseEvent e) {
        if (this.dragging) {
            int dist = e.getY() - this.startXY;
            this.adjustSizes(e.getComponent(), dist);
        }
        this.startXY = 0;
        this.dragging = false;
    }

    public void mouseDragged(MouseEvent e) {
        int dist = e.getY() - this.startXY;
        this.adjustSizes(e.getComponent(), dist);
    }

    public void mouseMoved(MouseEvent e) {
    }

    private void adjustSizes(Component divider, int amount) {
        if (divider == null || amount == 0) {
            return;
        }
        int minY = this.getBorder().getBorderInsets((Component)this).top;
        int maxY = this.getHeight() - minY - 8;
        int index = this.dividers.indexOf(divider);
        if (index > -1) {
            Rectangle rect = divider.getBounds();
            int oldY = rect.y;
            int nextY = rect.y + amount;
            if (amount < 0) {
                if (index > 0) {
                    minY = this.dividers.get(index - 1).getY() + 8;
                }
            } else if (index < this.dividers.size() - 1) {
                maxY = this.dividers.get(index + 1).getY() - 8;
            }
            if (amount < 0) {
                nextY = nextY > minY ? nextY : minY;
            } else {
                int n = nextY = nextY < maxY ? nextY : maxY;
            }
            if (nextY == oldY) {
                return;
            }
            rect.y = nextY;
            divider.setBounds(rect);
            rect = this.components.get(index).getBounds();
            rect.height = nextY - rect.y;
            this.components.get(index).setBounds(rect);
            rect = this.components.get(index + 1).getBounds();
            int oldYH = rect.y + rect.height;
            rect.y = nextY + 8;
            rect.height = oldYH - rect.y;
            this.components.get(index + 1).setBounds(rect);
            this.components.get(index).repaint();
            this.components.get(index + 1).repaint();
            divider.repaint();
        }
    }

    class ArrowIcon
    implements Icon {
        Polygon pol = new Polygon();

        public ArrowIcon(boolean up) {
            if (up) {
                this.pol.addPoint(1, 5);
                this.pol.addPoint(4, 1);
                this.pol.addPoint(7, 5);
            } else {
                this.pol.addPoint(1, 1);
                this.pol.addPoint(7, 1);
                this.pol.addPoint(4, 5);
            }
        }

        public int getIconHeight() {
            return 6;
        }

        public int getIconWidth() {
            return 8;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setColor(UIManager.getColor("Panel.foreground"));
            g2d.fillPolygon(this.pol);
            g2d.dispose();
        }
    }
}

