/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.server.corpora.util.ProcessReport;
import mpi.eudico.server.corpora.util.SimpleReport;

public class ReportDialog
extends ClosableDialog {
    private ProcessReport report;

    public ReportDialog(ProcessReport report) throws HeadlessException {
        this.report = report;
        this.initComponents();
    }

    public ReportDialog(Dialog owner, ProcessReport report) throws HeadlessException {
        super(owner);
        this.report = report;
        this.initComponents();
    }

    public ReportDialog(Frame owner, ProcessReport report) throws HeadlessException {
        super(owner);
        this.report = report;
        this.initComponents();
    }

    private void initComponents() {
        this.setTitle(ElanLocale.getString("ProcessReport"));
        this.getContentPane().setLayout(new BorderLayout(2, 2));
        JPanel content = new JPanel(new BorderLayout(4, 4));
        if (this.report != null) {
            if (this.report.getName() != null && this.report.getName().length() > 0) {
                content.setBorder(new TitledBorder(this.report.getName()));
            } else {
                content.setBorder(new TitledBorder(ElanLocale.getString("ProcessReport")));
            }
            if (this.report instanceof SimpleReport) {
                JTextArea area = new JTextArea(this.report.getReportAsString());
                area.setLineWrap(false);
                JScrollPane pane = new JScrollPane(area);
                Dimension dim = new Dimension(400, 300);
                pane.setPreferredSize(dim);
                pane.setMinimumSize(dim);
                content.add(pane);
            } else {
                JTextArea area = new JTextArea(this.report.getReportAsString());
                area.setLineWrap(false);
                JScrollPane pane = new JScrollPane(area);
                Dimension dim = new Dimension(400, 300);
                pane.setPreferredSize(dim);
                pane.setMinimumSize(dim);
                content.add(pane);
            }
        } else {
            JLabel mes = new JLabel(ElanLocale.getString("ProcessReport.NoReport"));
            mes.setPreferredSize(new Dimension(200, 80));
            content.add(mes);
        }
        this.getContentPane().add(content);
        this.pack();
        if (this.getParent() != null) {
            this.setLocationRelativeTo(this.getParent());
        }
    }
}

