/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.ElanLocale;

public class ResizeComponent
extends JPanel
implements MouseListener,
MouseMotionListener,
ActionListener {
    private JLabel iconLabel;
    private ElanLayoutManager manager;
    private int orientation = 0;
    private int forComponent = 0;
    private JPopupMenu popup;
    private int startXY = 0;
    private boolean dragging = false;
    public static final int MEDIA_AREA = 0;
    public static final int CONTROL_PANEL = 1;
    private boolean decrease = false;

    public ResizeComponent(ElanLayoutManager manager, int orientation) {
        this.manager = manager;
        if (orientation == 1) {
            this.orientation = orientation;
        }
        this.initComponents();
    }

    public ResizeComponent(ElanLayoutManager manager, int orientation, int forComponent) {
        this.manager = manager;
        if (orientation == 1) {
            this.orientation = orientation;
        }
        this.forComponent = forComponent;
        this.initComponents();
    }

    public void changeBehaviourToDecrease(boolean value) {
        this.decrease = value;
    }

    private void initComponents() {
        this.setLayout(null);
        this.iconLabel = new JLabel();
        try {
            if (this.orientation == 1) {
                ImageIcon icon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/ResizeDivider.gif"));
                this.iconLabel.setIcon(icon);
            } else {
                ImageIcon icon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/ResizeDividerH8.gif"));
                this.iconLabel.setIcon(icon);
            }
        }
        catch (Exception ex) {
            if (this.orientation == 1) {
                this.iconLabel.setText("^");
            }
            this.iconLabel.setText("<>");
        }
        this.add(this.iconLabel);
        this.iconLabel.setBounds(0, 0, 16, 16);
        this.setPreferredSize(new Dimension(16, 16));
        this.setBorder(new LineBorder(Constants.DEFAULTBACKGROUNDCOLOR, 1));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    private void createPopupMenu() {
        this.popup = new JPopupMenu();
        JMenuItem item = new JMenuItem(ElanLocale.getString("Button.Default"));
        item.addActionListener(this);
        this.popup.add(item);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e) && e.getButton() == 1 ^ e.isMetaDown() || e.isPopupTrigger()) {
            if (this.popup == null) {
                this.createPopupMenu();
            }
            this.popup.show(this, e.getX(), e.getY());
            return;
        }
        if (this.orientation == 0) {
            this.setCursor(Cursor.getPredefinedCursor(11));
            this.startXY = e.getX();
        } else {
            this.setCursor(Cursor.getPredefinedCursor(8));
            this.startXY = e.getY();
        }
        this.dragging = true;
    }

    public void mouseReleased(MouseEvent e) {
        if (this.dragging) {
            if (this.orientation == 0) {
                int dist = e.getX() - this.startXY;
                if (this.decrease) {
                    dist = -1 * dist;
                }
                if (this.forComponent == 1) {
                    this.manager.setMultiTierControlPanelWidth(this.manager.getMultiTierControlPanelWidth() + dist);
                } else {
                    this.manager.setMediaAreaWidth(this.manager.getMediaAreaWidth() + dist);
                }
            } else {
                int dist = e.getY() - this.startXY;
                if (this.decrease) {
                    dist = -1 * dist;
                }
                this.manager.setMediaAreaHeight(this.manager.getMediaAreaHeight() + dist);
            }
        }
        this.startXY = 0;
        this.dragging = false;
    }

    public void mouseEntered(MouseEvent e) {
        if (this.orientation == 1) {
            this.setCursor(Cursor.getPredefinedCursor(8));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(11));
        }
    }

    public void mouseExited(MouseEvent e) {
        if (!this.dragging) {
            // empty if block
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.orientation == 0) {
            int dist = e.getX() - this.startXY;
            if (this.decrease) {
                dist = -1 * dist;
            }
            if (this.forComponent == 1) {
                this.manager.setMultiTierControlPanelWidth(this.manager.getMultiTierControlPanelWidth() + dist);
            } else {
                this.manager.setMediaAreaWidth(this.manager.getMediaAreaWidth() + dist);
            }
        } else {
            int dist = e.getY() - this.startXY;
            if (this.decrease) {
                dist = -1 * dist;
            }
            this.manager.setMediaAreaHeight(this.manager.getMediaAreaHeight() + dist);
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (this.orientation == 1) {
            this.setCursor(Cursor.getPredefinedCursor(8));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(11));
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.forComponent == 0) {
            this.manager.setMediaAreaHeight(250);
        } else if (this.forComponent == 1 && this.orientation == 0) {
            this.manager.setMultiTierControlPanelWidth(120);
        }
    }
}

