/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.ComponentInputMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.viewer.SegmentationViewer;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.client.mediacontrol.ControllerListener;
import mpi.eudico.client.mediacontrol.StartEvent;
import mpi.eudico.client.mediacontrol.StopEvent;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;
import mpi.eudico.util.TimeInterval;

public class SegmentationDialog
extends ClosableDialog
implements ActionListener,
ItemListener,
ControllerListener {
    private JComboBox tierComboBox;
    private JLabel keyLabel;
    private JLabel titleLabel;
    private JPanel titlePanel;
    private JLabel tierLabel;
    private JRadioButton oneClickRB;
    private JRadioButton twoClicksRB;
    private ButtonGroup optionButtonGroup;
    private JPanel tierSelectionPanel;
    private JPanel tierPreviewPanel;
    private JPanel controlPanel;
    private JButton applyButton;
    private JButton closeButton;
    private JPanel buttonPanel;
    private TranscriptionImpl transcription;
    private ElanMediaPlayer player;
    private JPanel fixedOptPanel;
    private JRadioButton oneClickFixedRB;
    private JLabel durLabel;
    private JTextField durTF;
    private JRadioButton beginStrokeRB;
    private JRadioButton endStrokeRB;
    private ButtonGroup boundGroup;
    private final String EMPTY = "-";
    private final int TWO_TIMES_SEGMENTATION = 0;
    private final int ONE_TIME_SEGMENTTATION = 1;
    private final int ONE_TIME_FIXED_SEGMENTTATION = 2;
    private boolean singleStrokeIsBegin = true;
    private long fixedDuration = 1000L;
    private ArrayList timeSegments;
    private String curTier;
    private CVEntry[] entries;
    private int mode = 0;
    private long lastSegmentTime = -1L;
    private int timeCount = 0;
    private SegmentationViewer previewer;
    private InputMap mainInputMap;
    private InputMap cvInputMap;
    private ActionMap mainActionMap;
    private ActionMap cvActionMap;

    public SegmentationDialog(Transcription transcription) {
        super((Frame)ELANCommandFactory.getRootFrame(transcription), true);
        this.transcription = (TranscriptionImpl)transcription;
        this.player = ELANCommandFactory.getViewerManager(transcription).getMasterMediaPlayer();
        this.previewer = new SegmentationViewer(transcription);
        this.timeSegments = new ArrayList();
        this.initComponents();
        this.postInit();
        this.extractRootTiers();
    }

    private void extractRootTiers() {
        if (this.transcription != null) {
            Vector tiers = this.transcription.getTiers();
            Iterator tierIt = tiers.iterator();
            TierImpl tier = null;
            while (tierIt.hasNext()) {
                tier = (TierImpl)tierIt.next();
                if (tier.getLinguisticType().getConstraints() != null) continue;
                this.tierComboBox.addItem(tier.getName());
            }
            if (this.tierComboBox.getModel().getSize() == 0) {
                this.tierComboBox.addItem("-");
            }
        } else {
            this.tierComboBox.addItem("-");
        }
        this.curTier = (String)this.tierComboBox.getSelectedItem();
        if (!this.curTier.equals("-")) {
            this.previewer.setTier(this.transcription.getTierWithId(this.curTier));
        }
    }

    private void initComponents() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                SegmentationDialog.this.closeDialog(evt);
            }
        });
        this.tierComboBox = new JComboBox();
        this.keyLabel = new JLabel();
        this.titleLabel = new JLabel();
        this.titlePanel = new JPanel();
        this.tierLabel = new JLabel();
        this.oneClickRB = new JRadioButton();
        this.twoClicksRB = new JRadioButton();
        this.optionButtonGroup = new ButtonGroup();
        this.tierSelectionPanel = new JPanel();
        this.tierPreviewPanel = new JPanel();
        this.controlPanel = new JPanel();
        this.applyButton = new JButton();
        this.closeButton = new JButton();
        this.buttonPanel = new JPanel();
        this.fixedOptPanel = new JPanel(new GridBagLayout());
        this.oneClickFixedRB = new JRadioButton();
        this.durLabel = new JLabel();
        this.durTF = new JTextField(6);
        this.beginStrokeRB = new JRadioButton();
        this.endStrokeRB = new JRadioButton();
        this.boundGroup = new ButtonGroup();
        this.updateLocale();
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        Insets optInsets = new Insets(1, 6, 0, 6);
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(16.0f));
        this.titlePanel.add(this.titleLabel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.titlePanel, gridBagConstraints);
        this.tierSelectionPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = optInsets;
        this.tierSelectionPanel.add((Component)this.tierLabel, gridBagConstraints);
        this.tierComboBox.addItemListener(this);
        this.tierComboBox.setMaximumRowCount(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = optInsets;
        this.tierSelectionPanel.add((Component)this.tierComboBox, gridBagConstraints);
        this.twoClicksRB.setSelected(true);
        this.optionButtonGroup.add(this.twoClicksRB);
        this.twoClicksRB.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = optInsets;
        gridBagConstraints.weightx = 1.0;
        this.tierSelectionPanel.add((Component)this.twoClicksRB, gridBagConstraints);
        this.optionButtonGroup.add(this.oneClickRB);
        this.oneClickRB.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = optInsets;
        this.tierSelectionPanel.add((Component)this.oneClickRB, gridBagConstraints);
        this.optionButtonGroup.add(this.oneClickFixedRB);
        this.oneClickFixedRB.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = optInsets;
        this.tierSelectionPanel.add((Component)this.oneClickFixedRB, gridBagConstraints);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        gbc.insets = optInsets;
        this.fixedOptPanel.add((Component)this.durLabel, gbc);
        this.durTF.setText(String.valueOf(this.fixedDuration));
        gbc.gridx = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.fixedOptPanel.add((Component)this.durTF, gbc);
        this.beginStrokeRB.setSelected(true);
        this.boundGroup.add(this.beginStrokeRB);
        this.beginStrokeRB.addActionListener(this);
        gbc.gridwidth = 2;
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.fixedOptPanel.add((Component)this.beginStrokeRB, gbc);
        this.endStrokeRB.addActionListener(this);
        this.boundGroup.add(this.endStrokeRB);
        gbc.gridy = 2;
        this.fixedOptPanel.add((Component)this.endStrokeRB, gbc);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = optInsets;
        this.tierSelectionPanel.add((Component)this.fixedOptPanel, gridBagConstraints);
        this.keyLabel.setFont(Constants.DEFAULTFONT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = optInsets;
        this.tierSelectionPanel.add((Component)this.keyLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.tierSelectionPanel, gridBagConstraints);
        Dimension tpd = new Dimension(400, 60);
        this.tierPreviewPanel.setMinimumSize(tpd);
        this.tierPreviewPanel.setPreferredSize(tpd);
        this.tierPreviewPanel.setLayout(new GridBagLayout());
        this.previewer.setBorder(new LineBorder(Constants.SHAREDCOLOR3, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.tierPreviewPanel.add((Component)this.previewer, gridBagConstraints);
        this.controlPanel.setLayout(new GridLayout(1, 3, 6, 0));
        this.controlPanel.add(new JButton(ELANCommandFactory.getCommandAction(this.transcription, "Menu.Play.GoToBegin")));
        this.controlPanel.add(new JButton(ELANCommandFactory.getCommandAction(this.transcription, "Menu.Play.GoToPreviousScrollview")));
        this.controlPanel.add(new JButton(ELANCommandFactory.getCommandAction(this.transcription, "Menu.Play.1SecLeft")));
        this.controlPanel.add(new JButton(ELANCommandFactory.getCommandAction(this.transcription, "Menu.Play.PlayPause")));
        this.controlPanel.add(new JButton(ELANCommandFactory.getCommandAction(this.transcription, "Menu.Play.1SecRight")));
        this.controlPanel.add(new JButton(ELANCommandFactory.getCommandAction(this.transcription, "Menu.Play.GoToNextScrollview")));
        this.controlPanel.add(new JButton(ELANCommandFactory.getCommandAction(this.transcription, "Menu.Play.GoToEnd")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = insets;
        this.tierPreviewPanel.add((Component)this.controlPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.tierPreviewPanel, gridBagConstraints);
        this.buttonPanel.setLayout(new GridLayout(1, 2, 6, 0));
        this.applyButton.addActionListener(this);
        this.buttonPanel.add(this.applyButton);
        this.closeButton.addActionListener(this);
        this.buttonPanel.add(this.closeButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = insets;
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.enableFixedDurUI(false);
    }

    private void postInit() {
        this.pack();
        Rectangle dialogBounds = (Rectangle)Preferences.get("SegmentationDialogBounds", null);
        if (dialogBounds != null) {
            this.setBounds(dialogBounds);
        } else {
            int w = 550;
            int h = 380;
            this.setSize(this.getSize().width < w ? w : this.getSize().width, this.getSize().height < h ? h : this.getSize().height);
            this.setLocationRelativeTo(this.getParent());
        }
        this.setResizable(true);
        this.mainInputMap = this.getRootPane().getInputMap(2);
        this.mainActionMap = this.getRootPane().getActionMap();
        if (this.mainInputMap instanceof ComponentInputMap && this.mainActionMap != null) {
            Action[] invActions = new Action[]{ELANCommandFactory.getCommandAction(this.transcription, "Menu.Play.PlayPause"), ELANCommandFactory.getCommandAction(this.transcription, "Menu.Play.GoToBegin"), ELANCommandFactory.getCommandAction(this.transcription, "Menu.Play.GoToEnd"), ELANCommandFactory.getCommandAction(this.transcription, "Menu.Play.GoToPreviousScrollview"), ELANCommandFactory.getCommandAction(this.transcription, "Menu.Play.GoToNextScrollview"), ELANCommandFactory.getCommandAction(this.transcription, "Menu.Play.1SecLeft"), ELANCommandFactory.getCommandAction(this.transcription, "Menu.Play.1SecRight"), ELANCommandFactory.getCommandAction(this.transcription, "Menu.Play.Previous"), ELANCommandFactory.getCommandAction(this.transcription, "Menu.Play.Next"), ELANCommandFactory.getCommandAction(this.transcription, "Menu.Play.1PixelLeft"), ELANCommandFactory.getCommandAction(this.transcription, "Menu.Play.1PixelRight"), new SegmentAction()};
            String id = "Act-";
            for (int i = 0; i < invActions.length; ++i) {
                String nextId = id + i;
                this.mainInputMap.put((KeyStroke)invActions[i].getValue("AcceleratorKey"), nextId);
                this.mainActionMap.put(nextId, invActions[i]);
            }
        }
        if (this.transcription != null) {
            ELANCommandFactory.getViewerManager(this.transcription).connectListener(this);
            ELANCommandFactory.getViewerManager(this.transcription).connectListener(this.previewer);
        }
    }

    private void updateLocale() {
        this.setTitle(ElanLocale.getString("SegmentationDialog.Title"));
        this.titleLabel.setText(ElanLocale.getString("SegmentationDialog.Title"));
        this.keyLabel.setText(ElanLocale.getString("SegmentationDialog.Label.Key") + "  " + ELANCommandFactory.convertAccKey(KeyStroke.getKeyStroke(10, 0)));
        this.tierSelectionPanel.setBorder(new TitledBorder(ElanLocale.getString("SegmentationDialog.Title")));
        this.tierPreviewPanel.setBorder(new TitledBorder(ElanLocale.getString("SegmentationDialog.Preview")));
        this.tierLabel.setText(ElanLocale.getString("SegmentationDialog.Label.Tier"));
        this.oneClickRB.setText(ElanLocale.getString("SegmentationDialog.Mode.SingleStroke"));
        this.twoClicksRB.setText(ElanLocale.getString("SegmentationDialog.Mode.DoubleStroke"));
        this.applyButton.setText(ElanLocale.getString("Button.Apply"));
        this.closeButton.setText(ElanLocale.getString("Button.Cancel"));
        this.oneClickFixedRB.setText(ElanLocale.getString("SegmentationDialog.Mode.SingleStrokeFixed"));
        this.durLabel.setText(ElanLocale.getString("SegmentationDialog.Label.Duration"));
        this.beginStrokeRB.setText(ElanLocale.getString("SegmentationDialog.Label.BeginStroke"));
        this.endStrokeRB.setText(ElanLocale.getString("SegmentationDialog.Label.EndStroke"));
    }

    private void closeDialog(WindowEvent evt) {
        if (this.transcription != null) {
            ELANCommandFactory.getViewerManager(this.transcription).disconnectListener(this);
            ELANCommandFactory.getViewerManager(this.transcription).destroyViewer(this.previewer);
        }
        this.savePreferences();
        this.setVisible(false);
        this.dispose();
    }

    private void savePreferences() {
        Preferences.set("SegmentationDialogBounds", this.getBounds(), null);
    }

    private void enableUI(boolean enable) {
        this.tierComboBox.setEnabled(enable);
        this.twoClicksRB.setEnabled(enable);
        this.oneClickRB.setEnabled(enable);
        this.oneClickFixedRB.setEnabled(enable);
        if (this.oneClickFixedRB.isSelected() && enable) {
            this.enableFixedDurUI(enable);
        } else {
            this.enableFixedDurUI(false);
        }
    }

    private void enableFixedDurUI(boolean enable) {
        this.fixedOptPanel.setEnabled(enable);
        this.durLabel.setEnabled(enable);
        this.durTF.setEditable(enable);
        this.beginStrokeRB.setEnabled(enable);
        this.endStrokeRB.setEnabled(enable);
    }

    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.applyButton) {
            Command c = ELANCommandFactory.createCommand(this.transcription, "CommandActions.AddSegmentation");
            c.execute(this.transcription, new Object[]{this.curTier, this.timeSegments});
            this.closeDialog(null);
        } else if (source == this.closeButton) {
            this.closeDialog(null);
        } else if (source == this.oneClickRB) {
            if (this.mode != 1) {
                this.timeCount = 0;
                this.lastSegmentTime = -1L;
            }
            this.enableFixedDurUI(false);
        } else if (source == this.twoClicksRB) {
            if (this.mode != 0) {
                this.timeCount = 0;
                this.lastSegmentTime = -1L;
            }
            this.enableFixedDurUI(false);
        } else if (source == this.oneClickFixedRB) {
            if (this.mode != 2) {
                this.timeCount = 0;
                this.lastSegmentTime = -1L;
            }
            this.enableFixedDurUI(true);
        } else if (source == this.beginStrokeRB) {
            this.singleStrokeIsBegin = true;
        } else if (source == this.endStrokeRB) {
            this.singleStrokeIsBegin = false;
        }
    }

    public void itemStateChanged(ItemEvent ie) {
        if (ie.getStateChange() == 1) {
            String newSel = (String)this.tierComboBox.getSelectedItem();
            if (newSel.equals(this.curTier)) {
                return;
            }
            if (this.player != null && this.player.isPlaying()) {
                this.player.stop();
            }
            if (this.timeSegments.size() > 0) {
                if (this.showConfirmDialog(ElanLocale.getString("SegmentationDialog.Message.Apply"))) {
                    Command c = ELANCommandFactory.createCommand(this.transcription, "CommandActions.AddSegmentation");
                    c.execute(this.transcription, new Object[]{this.curTier, this.timeSegments});
                }
                this.timeSegments = new ArrayList();
                this.timeCount = 0;
                this.lastSegmentTime = -1L;
            }
            this.curTier = newSel;
            this.entries = null;
            if (!this.curTier.equals("-")) {
                TierImpl t = (TierImpl)this.transcription.getTierWithId(this.curTier);
                this.previewer.setTier(t);
                String cvname = t.getLinguisticType().getControlledVocabylaryName();
                if (cvname != null) {
                    ControlledVocabulary cv = this.transcription.getControlledVocabulary(cvname);
                    if (cv != null) {
                        this.entries = cv.getEntries();
                        if (this.cvInputMap == null) {
                            this.cvInputMap = new ComponentInputMap(this.getRootPane());
                            this.mainInputMap.setParent(this.cvInputMap);
                        } else {
                            this.cvInputMap.clear();
                        }
                        if (this.cvActionMap == null) {
                            this.cvActionMap = new ActionMap();
                            this.mainActionMap.setParent(this.cvActionMap);
                        } else {
                            this.cvActionMap.clear();
                        }
                        String cveId = "cve-";
                        for (int i = 0; i < this.entries.length; ++i) {
                            if (this.entries[i].getShortcutKeyCode() <= 0) continue;
                            String nextId = cveId + i;
                            SegmentAction sa = new SegmentAction(this.entries[i]);
                            this.cvInputMap.put((KeyStroke)sa.getValue("AcceleratorKey"), nextId);
                            this.cvActionMap.put(nextId, sa);
                        }
                    } else {
                        if (this.cvInputMap != null) {
                            this.cvInputMap.clear();
                        }
                        if (this.cvActionMap != null) {
                            this.cvActionMap.clear();
                        }
                    }
                } else {
                    if (this.cvInputMap != null) {
                        this.cvInputMap.clear();
                    }
                    if (this.cvActionMap != null) {
                        this.cvActionMap.clear();
                    }
                }
            } else {
                if (this.cvInputMap != null) {
                    this.cvInputMap.clear();
                }
                if (this.cvActionMap != null) {
                    this.cvActionMap.clear();
                }
            }
        }
    }

    public void controllerUpdate(ControllerEvent event) {
        if (event instanceof StartEvent) {
            if (this.twoClicksRB.isSelected()) {
                this.mode = 0;
            } else if (this.oneClickRB.isSelected()) {
                this.mode = 1;
            } else {
                this.mode = 2;
                String durVal = this.durTF.getText();
                try {
                    this.fixedDuration = Long.parseLong(durVal);
                }
                catch (NumberFormatException nfe) {
                    this.fixedDuration = 1000L;
                    this.durTF.setText(String.valueOf(this.fixedDuration));
                }
            }
            this.enableUI(false);
        } else if (event instanceof StopEvent) {
            this.enableUI(true);
        }
    }

    public void addSegmentTime(CVEntry cve) {
        if (this.player == null) {
            return;
        }
        long cur = this.player.getMediaTime();
        if (this.mode == 0) {
            if (cur != this.lastSegmentTime) {
                ++this.timeCount;
                if (this.timeCount % 2 != 0) {
                    this.lastSegmentTime = cur;
                    this.previewer.setCurrentBeginTime(this.lastSegmentTime);
                } else {
                    if (cve != null) {
                        AnnotationDataRecord adr = cur > this.lastSegmentTime ? new AnnotationDataRecord(this.curTier, cve.getValue(), this.lastSegmentTime, cur) : new AnnotationDataRecord(this.curTier, cve.getValue(), cur, this.lastSegmentTime);
                        adr.setExtRef(cve.getExternalRef());
                        if (adr.getEndTime() - adr.getBeginTime() > 0L) {
                            this.timeSegments.add(adr);
                            this.previewer.addSegment(adr);
                        }
                    } else {
                        TimeInterval ti = cur > this.lastSegmentTime ? new TimeInterval(this.lastSegmentTime, cur) : new TimeInterval(cur, this.lastSegmentTime);
                        if (ti.getDuration() > 0L) {
                            this.timeSegments.add(ti);
                            this.previewer.addSegment(ti);
                        }
                    }
                    this.lastSegmentTime = cur;
                }
            }
        } else if (this.mode == 1) {
            if (this.lastSegmentTime == -1L) {
                ++this.timeCount;
                this.lastSegmentTime = cur;
                this.previewer.setCurrentBeginTime(this.lastSegmentTime);
            } else if (cur != this.lastSegmentTime) {
                ++this.timeCount;
                if (cve != null) {
                    AnnotationDataRecord adr = cur > this.lastSegmentTime ? new AnnotationDataRecord(this.curTier, cve.getValue(), this.lastSegmentTime, cur) : new AnnotationDataRecord(this.curTier, cve.getValue(), cur, this.lastSegmentTime);
                    adr.setExtRef(cve.getExternalRef());
                    if (adr.getEndTime() - adr.getBeginTime() > 0L) {
                        this.timeSegments.add(adr);
                        this.previewer.addSegment(adr);
                    }
                } else {
                    TimeInterval ti = cur > this.lastSegmentTime ? new TimeInterval(this.lastSegmentTime, cur) : new TimeInterval(cur, this.lastSegmentTime);
                    if (ti.getDuration() > 0L) {
                        this.timeSegments.add(ti);
                        this.previewer.addSegment(ti);
                    }
                }
                this.lastSegmentTime = cur;
            }
        } else {
            if (cve != null) {
                AnnotationDataRecord adr;
                if (this.singleStrokeIsBegin) {
                    adr = new AnnotationDataRecord(this.curTier, cve.getValue(), cur, cur + this.fixedDuration);
                } else {
                    long bb = cur - this.fixedDuration;
                    if (bb < 0L) {
                        bb = 0L;
                    }
                    adr = new AnnotationDataRecord(this.curTier, cve.getValue(), bb, cur);
                }
                adr.setExtRef(cve.getExternalRef());
                if (adr.getEndTime() - adr.getBeginTime() > 0L) {
                    this.timeSegments.add(adr);
                    this.previewer.addSegment(adr);
                }
            } else {
                TimeInterval ti = null;
                if (this.singleStrokeIsBegin) {
                    ti = new TimeInterval(cur, cur + this.fixedDuration);
                } else {
                    long bb = cur - this.fixedDuration;
                    if (bb < 0L) {
                        bb = 0L;
                    }
                    ti = new TimeInterval(bb, cur);
                }
                if (ti.getDuration() > 0L) {
                    this.timeSegments.add(ti);
                    this.previewer.addSegment(ti);
                }
            }
            this.lastSegmentTime = cur;
        }
    }

    private boolean showConfirmDialog(String message) {
        int confirm = JOptionPane.showConfirmDialog(this, message, ElanLocale.getString("Message.Warning"), 0);
        return confirm == 0;
    }

    class SegmentAction
    extends AbstractAction {
        public SegmentAction() {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, 0));
            this.putValue("Default", null);
        }

        public SegmentAction(CVEntry cve) {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(cve.getShortcutKeyCode(), 0));
            this.putValue("Default", cve);
        }

        public void actionPerformed(ActionEvent e) {
            Object val = this.getValue("Default");
            if (val instanceof CVEntry) {
                SegmentationDialog.this.addSegmentTime((CVEntry)val);
            } else {
                SegmentationDialog.this.addSegmentTime(null);
            }
        }
    }
}

