/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.viewer.SegmentationViewer2;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.client.mediacontrol.ControllerListener;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class SegmentationPanel
extends JPanel
implements ControllerListener,
ActionListener {
    private JLabel keyLabel;
    private JRadioButton oneClickRB;
    private JRadioButton twoClicksRB;
    private ButtonGroup optionButtonGroup;
    private JPanel tierSelectionPanel;
    private JButton applyButton;
    private TranscriptionImpl transcription;
    private JPanel fixedOptPanel;
    private JRadioButton oneClickFixedRB;
    private JLabel durLabel;
    private JTextField durTF;
    private JRadioButton beginStrokeRB;
    private JRadioButton endStrokeRB;
    private ButtonGroup boundGroup;
    private JCheckBox delayCB;
    private JTextField delayTF;
    private boolean singleStrokeIsBegin = true;
    private long fixedDuration = 1000L;
    private int mode = 0;
    private SegmentationViewer2 viewer;

    public SegmentationPanel(SegmentationViewer2 viewer) {
        this.viewer = viewer;
        this.initComponents();
    }

    private void initComponents() {
        this.keyLabel = new JLabel();
        this.oneClickRB = new JRadioButton();
        this.twoClicksRB = new JRadioButton();
        this.optionButtonGroup = new ButtonGroup();
        this.tierSelectionPanel = new JPanel();
        this.applyButton = new JButton();
        this.fixedOptPanel = new JPanel(new GridBagLayout());
        this.oneClickFixedRB = new JRadioButton();
        this.durLabel = new JLabel();
        this.durTF = new JTextField(6);
        this.beginStrokeRB = new JRadioButton();
        this.endStrokeRB = new JRadioButton();
        this.boundGroup = new ButtonGroup();
        this.delayCB = new JCheckBox();
        this.delayTF = new JTextField(4);
        this.delayTF.setEnabled(false);
        this.updateLocale();
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        Insets optInsets = new Insets(1, 6, 0, 6);
        this.tierSelectionPanel.setLayout(new GridBagLayout());
        this.twoClicksRB.setSelected(true);
        this.optionButtonGroup.add(this.twoClicksRB);
        this.twoClicksRB.addActionListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        this.tierSelectionPanel.add((Component)this.twoClicksRB, gridBagConstraints);
        this.optionButtonGroup.add(this.oneClickRB);
        this.oneClickRB.addActionListener(this);
        gridBagConstraints.gridy = 1;
        this.tierSelectionPanel.add((Component)this.oneClickRB, gridBagConstraints);
        this.optionButtonGroup.add(this.oneClickFixedRB);
        this.oneClickFixedRB.addActionListener(this);
        gridBagConstraints.gridy = 2;
        this.tierSelectionPanel.add((Component)this.oneClickFixedRB, gridBagConstraints);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        gbc.insets = optInsets;
        this.fixedOptPanel.add((Component)this.durLabel, gbc);
        this.durTF.setText(String.valueOf(this.fixedDuration));
        this.durTF.addActionListener(this);
        gbc.gridx = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.fixedOptPanel.add((Component)this.durTF, gbc);
        this.beginStrokeRB.setSelected(true);
        this.boundGroup.add(this.beginStrokeRB);
        this.beginStrokeRB.addActionListener(this);
        gbc.gridwidth = 2;
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.fixedOptPanel.add((Component)this.beginStrokeRB, gbc);
        this.endStrokeRB.addActionListener(this);
        this.boundGroup.add(this.endStrokeRB);
        gbc.gridy = 2;
        this.fixedOptPanel.add((Component)this.endStrokeRB, gbc);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(1, 28, 2, 6);
        this.tierSelectionPanel.add((Component)this.fixedOptPanel, gridBagConstraints);
        JPanel delayPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        delayPanel.add((Component)this.delayCB, gbc);
        this.delayCB.addActionListener(this);
        gbc.gridx = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 6, 0, 0);
        delayPanel.add((Component)this.delayTF, gbc);
        this.delayTF.addActionListener(this);
        gbc.gridx = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        delayPanel.add((Component)new JPanel(), gbc);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.tierSelectionPanel.add((Component)delayPanel, gridBagConstraints);
        this.keyLabel.setFont(Constants.DEFAULTFONT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = optInsets;
        gridBagConstraints.weighty = 0.1;
        this.tierSelectionPanel.add((Component)this.keyLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.tierSelectionPanel, gridBagConstraints);
        this.enableFixedDurUI(false);
        this.readPreferences();
    }

    public void updateLocale() {
        this.keyLabel.setText(ElanLocale.getString("SegmentationDialog.Label.Key") + "  " + ELANCommandFactory.convertAccKey(KeyStroke.getKeyStroke(10, 0)));
        this.oneClickRB.setText(ElanLocale.getString("SegmentationDialog.Mode.SingleStroke"));
        this.twoClicksRB.setText(ElanLocale.getString("SegmentationDialog.Mode.DoubleStroke"));
        this.applyButton.setText(ElanLocale.getString("Button.Apply"));
        this.oneClickFixedRB.setText(ElanLocale.getString("SegmentationDialog.Mode.SingleStrokeFixed"));
        this.durLabel.setText(ElanLocale.getString("SegmentationDialog.Label.Duration"));
        this.beginStrokeRB.setText(ElanLocale.getString("SegmentationDialog.Label.BeginStroke"));
        this.endStrokeRB.setText(ElanLocale.getString("SegmentationDialog.Label.EndStroke"));
        this.delayCB.setText(ElanLocale.getString("SegmentationDialog.Label.Delay"));
    }

    private void enableUI(boolean enable) {
        this.twoClicksRB.setEnabled(enable);
        this.oneClickRB.setEnabled(enable);
        this.oneClickFixedRB.setEnabled(enable);
        if (this.oneClickFixedRB.isSelected() && enable) {
            this.enableFixedDurUI(enable);
        } else {
            this.enableFixedDurUI(false);
        }
    }

    private void enableFixedDurUI(boolean enable) {
        this.fixedOptPanel.setEnabled(enable);
        this.durLabel.setEnabled(enable);
        this.durTF.setEditable(enable);
        this.beginStrokeRB.setEnabled(enable);
        this.endStrokeRB.setEnabled(enable);
    }

    private void readPreferences() {
        Object pref = Preferences.get("SegmentationMode.Mode", null);
        if (pref instanceof String) {
            String modeString = (String)pref;
            if (modeString.equals("adjacent")) {
                this.mode = 1;
                this.oneClickRB.setSelected(true);
                this.viewer.setSegmentationMode(this.mode);
            } else if (modeString.equals("fixed-duration")) {
                this.mode = 2;
                this.oneClickFixedRB.setSelected(true);
                this.viewer.setSegmentationMode(this.mode);
            }
        }
        if ((pref = Preferences.get("SegmentationMode.MarkBegin", null)) instanceof Boolean) {
            this.singleStrokeIsBegin = (Boolean)pref;
            this.beginStrokeRB.setSelected(this.singleStrokeIsBegin);
            this.endStrokeRB.setSelected(!this.singleStrokeIsBegin);
            this.viewer.setSingleStrokeIsBegin(this.singleStrokeIsBegin);
        }
        if ((pref = Preferences.get("SegmentationMode.FixedDuration", null)) instanceof Long) {
            Long duration = (Long)pref;
            this.durTF.setText(String.valueOf(duration));
            this.viewer.setFixedSegmentDuration(duration);
        }
        if ((pref = Preferences.get("SegmentationMode.DelayMode", null)) instanceof Boolean) {
            this.delayCB.setSelected((Boolean)pref);
            this.delayTF.setEnabled((Boolean)pref);
        }
        if ((pref = Preferences.get("SegmentationMode.DelayDuration", null)) instanceof Long) {
            this.delayTF.setText(String.valueOf((Long)pref));
            if (this.delayCB.isSelected()) {
                this.viewer.setDelayDuration((Long)pref);
            }
        }
    }

    private void setPreference(String key, Object value) {
        Preferences.set(key, value, null, false, false);
    }

    public void controllerUpdate(ControllerEvent event) {
    }

    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.oneClickRB) {
            if (this.mode != 1) {
                this.mode = 1;
                this.viewer.setSegmentationMode(1);
                this.setPreference("SegmentationMode.Mode", "adjacent");
            }
            this.enableFixedDurUI(false);
            this.oneClickRB.transferFocusUpCycle();
        } else if (source == this.twoClicksRB) {
            if (this.mode != 0) {
                this.mode = 0;
                this.viewer.setSegmentationMode(0);
                this.setPreference("SegmentationMode.Mode", "non-adjacent");
            }
            this.enableFixedDurUI(false);
            this.twoClicksRB.transferFocusUpCycle();
        } else if (source == this.oneClickFixedRB) {
            if (this.mode != 2) {
                this.mode = 2;
                this.viewer.setSegmentationMode(2);
                this.setPreference("SegmentationMode.Mode", "fixed-duration");
            }
            this.enableFixedDurUI(true);
            this.oneClickFixedRB.transferFocusUpCycle();
        } else if (source == this.beginStrokeRB) {
            this.singleStrokeIsBegin = true;
            this.viewer.setSingleStrokeIsBegin(true);
            this.beginStrokeRB.transferFocusUpCycle();
            this.setPreference("SegmentationMode.MarkBegin", true);
        } else if (source == this.endStrokeRB) {
            this.singleStrokeIsBegin = false;
            this.viewer.setSingleStrokeIsBegin(false);
            this.endStrokeRB.transferFocusUpCycle();
            this.setPreference("SegmentationMode.MarkBegin", false);
        } else if (source == this.durTF) {
            try {
                long dur = Long.parseLong(this.durTF.getText());
                this.durTF.transferFocusUpCycle();
                this.viewer.setFixedSegmentDuration(dur);
                this.setPreference("SegmentationMode.FixedDuration", dur);
            }
            catch (NumberFormatException nfe) {
                this.durTF.selectAll();
                this.durTF.requestFocus();
            }
            this.durTF.transferFocusUpCycle();
        } else if (source == this.delayCB) {
            this.delayTF.setEnabled(this.delayCB.isSelected());
            if (this.delayCB.isSelected()) {
                try {
                    long delay = Long.parseLong(this.delayTF.getText());
                    this.viewer.setDelayDuration(delay);
                }
                catch (NumberFormatException nfe) {}
            } else {
                this.viewer.setDelayDuration(0L);
            }
            this.delayCB.transferFocusUpCycle();
            this.setPreference("SegmentationMode.DelayMode", this.delayCB.isSelected());
        } else if (source == this.delayTF) {
            try {
                long delay = Long.parseLong(this.delayTF.getText());
                this.delayTF.transferFocusUpCycle();
                this.viewer.setDelayDuration(delay);
                this.setPreference("SegmentationMode.DelayDuration", delay);
            }
            catch (NumberFormatException nfe) {
                this.delayTF.selectAll();
                this.delayTF.requestFocus();
            }
        }
    }
}

