/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.ShortcutsUtil;
import mpi.eudico.client.annotator.gui.ColumnSorter;
import mpi.eudico.client.annotator.gui.ShortcutEditPanel;
import mpi.eudico.client.annotator.gui.ShortcutReplaceDialog;

public class ShortcutPanel
extends JPanel
implements ActionListener {
    private JTable table;
    private String[][] data;
    public Map<String, KeyStroke> allShortCuts;
    private JComboBox sortBox;
    private JButton cancelButton;
    private JButton editButton;
    private JButton reloadButton;
    private JButton saveButton;
    private ShortcutsUtil scu = ShortcutsUtil.getInstance();
    public Boolean replaceShortcut = false;

    public ShortcutPanel() {
        this.setLayout(new GridBagLayout());
        this.allShortCuts = new LinkedHashMap<String, KeyStroke>(this.scu.getCurrentShortcuts());
        Object[] columnNames = new String[]{ElanLocale.getString("Shortcuts.Table.Description"), ElanLocale.getString("Shortcuts.Table.Category"), ElanLocale.getString("Shortcuts.Table.Key"), "ActionID", "Keycode", "Modifiercode"};
        ArrayList<String> allActions = new ArrayList<String>();
        for (Map.Entry<String, KeyStroke> pairs : this.allShortCuts.entrySet()) {
            String anAction = pairs.getKey();
            allActions.add(anAction);
        }
        String[] nameArray = allActions.toArray(new String[0]);
        int numberOfShortCuts = this.allShortCuts.size();
        this.data = new String[this.allShortCuts.size()][];
        for (int i = 0; i < numberOfShortCuts; ++i) {
            String actionName = nameArray[i];
            String description = this.scu.getDescriptionForAction(actionName);
            String category = ElanLocale.getString(this.scu.getCategoryForAction(actionName));
            KeyStroke ks = this.allShortCuts.get(actionName);
            String keyStrokeName = this.scu.getDescriptionForKeyStroke(ks);
            String keyCode = "";
            String modCode = "";
            if (ks != null) {
                keyCode = Integer.toString(ks.getKeyCode());
                modCode = Integer.toString(ks.getModifiers());
            }
            String[] row = new String[]{description, category, keyStrokeName, actionName, keyCode, modCode};
            this.data[i] = row;
        }
        DefaultTableModel model = new DefaultTableModel(this.data, columnNames);
        this.table = new JTable(model){

            public boolean isCellEditable(int rowIndex, int colIndex) {
                return false;
            }
        };
        this.table.getTableHeader().setReorderingAllowed(false);
        Collections.sort(model.getDataVector(), new ColumnSorter(0));
        this.table.getColumn("ActionID").setMinWidth(0);
        this.table.getColumn("ActionID").setMaxWidth(0);
        this.table.getColumn("Keycode").setMinWidth(0);
        this.table.getColumn("Keycode").setMaxWidth(0);
        this.table.getColumn("Modifiercode").setMinWidth(0);
        this.table.getColumn("Modifiercode").setMaxWidth(0);
        this.table.setSelectionMode(0);
        JScrollPane scrollPane = new JScrollPane(this.table);
        GridBagConstraints gbc = new GridBagConstraints();
        Insets insets = new Insets(2, 6, 2, 6);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = insets;
        this.add((Component)scrollPane, gbc);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 6, 2, 2));
        JLabel sortLabel = new JLabel(ElanLocale.getString("Shortcuts.Table.SortBy"));
        sortLabel.setHorizontalAlignment(4);
        sortLabel.setVerticalTextPosition(3);
        sortLabel.setHorizontalTextPosition(10);
        buttonPanel.add(sortLabel);
        String[] sortOptions = new String[]{ElanLocale.getString("Shortcuts.Table.Description"), ElanLocale.getString("Shortcuts.Table.Category"), ElanLocale.getString("Shortcuts.Table.Key")};
        this.sortBox = new JComboBox<String>(sortOptions);
        this.sortBox.addActionListener(this);
        buttonPanel.add(this.sortBox);
        this.editButton = new JButton(ElanLocale.getString("Shortcuts.Button.Edit"));
        this.editButton.addActionListener(this);
        this.editButton.setVerticalTextPosition(0);
        this.editButton.setHorizontalTextPosition(10);
        buttonPanel.add(this.editButton);
        this.saveButton = new JButton(ElanLocale.getString("Button.Save"));
        this.saveButton.addActionListener(this);
        this.saveButton.setVerticalTextPosition(0);
        this.saveButton.setHorizontalTextPosition(10);
        buttonPanel.add(this.saveButton);
        this.reloadButton = new JButton(ElanLocale.getString("Shortcuts.Button.Default"));
        this.reloadButton.addActionListener(this);
        this.reloadButton.setVerticalTextPosition(0);
        this.reloadButton.setHorizontalTextPosition(10);
        buttonPanel.add(this.reloadButton);
        this.cancelButton = new JButton(ElanLocale.getString("Button.Cancel"));
        this.cancelButton.addActionListener(this);
        this.cancelButton.setVerticalTextPosition(0);
        this.cancelButton.setHorizontalTextPosition(10);
        buttonPanel.add(this.cancelButton);
        gbc.gridy = 1;
        gbc.fill = 0;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        this.add((Component)buttonPanel, gbc);
    }

    public void actionPerformed(ActionEvent e) {
        int row;
        if (e.getSource() == this.sortBox) {
            JComboBox cb = (JComboBox)e.getSource();
            int index = cb.getSelectedIndex();
            DefaultTableModel dtmodel = (DefaultTableModel)this.table.getModel();
            Vector<Vector> data = dtmodel.getDataVector();
            Collections.sort(data, new ColumnSorter(index));
            dtmodel.fireTableStructureChanged();
            this.table.getColumn("ActionID").setMinWidth(0);
            this.table.getColumn("ActionID").setMaxWidth(0);
            this.table.getColumn("Keycode").setMinWidth(0);
            this.table.getColumn("Keycode").setMaxWidth(0);
            this.table.getColumn("Modifiercode").setMinWidth(0);
            this.table.getColumn("Modifiercode").setMaxWidth(0);
        }
        if (e.getSource() == this.editButton && (row = this.table.getSelectedRow()) > -1) {
            int column = 3;
            String selectedAction = (String)this.table.getValueAt(row, column);
            this.createEditWindow(selectedAction);
        }
        if (e.getSource() == this.saveButton) {
            int rowNumber = this.table.getRowCount();
            HashMap<String, List<String>> shortcutMap = new HashMap<String, List<String>>(rowNumber);
            for (int i = 0; i < rowNumber; ++i) {
                String actionName = (String)this.table.getValueAt(i, 3);
                String keycode = (String)this.table.getValueAt(i, 4);
                String modcode = (String)this.table.getValueAt(i, 5);
                ArrayList<String> codes = new ArrayList<String>(2);
                codes.add(keycode);
                codes.add(modcode);
                shortcutMap.put(actionName, codes);
            }
            this.scu.saveCurrentShortcuts(shortcutMap);
            SwingUtilities.getWindowAncestor(this).setVisible(false);
            this.scu.readCurrentShortcuts();
        }
        if (e.getSource() == this.reloadButton) {
            this.scu.restoreDefaultShortcuts();
            this.refreshTable();
            this.allShortCuts = this.scu.getCurrentShortcuts();
        }
        if (e.getSource() == this.cancelButton) {
            SwingUtilities.getWindowAncestor(this).setVisible(false);
        }
    }

    private void refreshTable() {
        Map<String, KeyStroke> allShortCuts = this.scu.getCurrentShortcuts();
        int noOfRows = this.table.getRowCount();
        for (int i = 0; i < noOfRows; ++i) {
            String action;
            KeyStroke aKeyStroke;
            int tableKeyCode = 0;
            int tableModCode = 0;
            int dataKeyCode = 0;
            int dataModCode = 0;
            String tableKeyCodeAsString = (String)this.table.getValueAt(i, 4);
            String tableModCodeAsString = (String)this.table.getValueAt(i, 5);
            if (tableKeyCodeAsString != "") {
                tableKeyCode = Integer.parseInt(tableKeyCodeAsString);
            }
            if (tableModCodeAsString != "") {
                tableModCode = Integer.parseInt(tableModCodeAsString);
            }
            if ((aKeyStroke = allShortCuts.get(action = (String)this.table.getValueAt(i, 3))) != null) {
                dataKeyCode = aKeyStroke.getKeyCode();
                dataModCode = aKeyStroke.getModifiers();
            }
            if (tableKeyCode == dataKeyCode && tableModCode == dataModCode) continue;
            this.table.setValueAt(Integer.toString(dataKeyCode), i, 4);
            this.table.setValueAt(Integer.toString(dataModCode), i, 5);
            String keyStrokeName = this.scu.getDescriptionForKeyStroke(aKeyStroke);
            this.table.setValueAt(keyStrokeName, i, 2);
        }
    }

    private void createEditWindow(String selectedAction) {
        ShortcutEditPanel.createAndShowGUI(this, selectedAction);
    }

    public final String getActionNameForKeyStroke(KeyStroke ks) {
        for (String action : this.allShortCuts.keySet()) {
            KeyStroke a_keystroke = this.allShortCuts.get(action);
            if (a_keystroke == null || !a_keystroke.equals(ks)) continue;
            return action;
        }
        return null;
    }

    public void changeShortcut(KeyStroke ks) {
        int row = this.table.getSelectedRow();
        int desc_col = 2;
        int action_col = 3;
        int keycode_col = 4;
        int mod_col = 5;
        String actionDesc = this.scu.getDescriptionForAction(this.getActionNameForKeyStroke(ks));
        String keydesc = this.scu.getDescriptionForKeyStroke(ks);
        String keycodestring = "";
        String modstring = "";
        if (ks != null) {
            if (this.allShortCuts.containsValue(ks)) {
                ShortcutReplaceDialog srd = new ShortcutReplaceDialog(this, ks);
                srd.pack();
                srd.setLocationRelativeTo((JDialog)SwingUtilities.getWindowAncestor(this));
                srd.setModal(true);
                srd.setVisible(true);
                if (this.replaceShortcut.booleanValue()) {
                    String oldAction = this.getActionNameForKeyStroke(ks);
                    int oldRow = this.getRowForAction(oldAction);
                    if (oldRow == -1) {
                        return;
                    }
                    this.table.setValueAt("", oldRow, desc_col);
                    this.table.setValueAt("", oldRow, keycode_col);
                    this.table.setValueAt("", oldRow, mod_col);
                    this.allShortCuts.put(oldAction, null);
                } else {
                    return;
                }
            }
            keycodestring = Integer.toString(ks.getKeyCode());
            modstring = Integer.toString(ks.getModifiers());
        }
        String action = (String)this.table.getValueAt(row, action_col);
        this.table.setValueAt(keydesc, row, desc_col);
        this.table.setValueAt(keycodestring, row, keycode_col);
        this.table.setValueAt(modstring, row, mod_col);
        this.allShortCuts.put(action, ks);
    }

    private int getRowForAction(String oldAction) {
        int noOfRows = this.table.getRowCount();
        int action_col = 3;
        for (int i = 0; i < noOfRows; ++i) {
            String tableresult = (String)this.table.getValueAt(i, action_col);
            if (tableresult.compareTo(oldAction) != 0) continue;
            return i;
        }
        return -1;
    }

    public static void createAndShowGUI(Window owner) {
        JDialog frame = null;
        if (owner instanceof Dialog) {
            frame = new JDialog((Dialog)owner, ElanLocale.getString("Shortcuts.Table.Title"), true);
        } else if (owner instanceof Frame) {
            frame = new JDialog((Frame)owner, ElanLocale.getString("Shortcuts.Table.Title"), true);
        }
        if (frame == null) {
            return;
        }
        ShortcutPanel newContentPane = new ShortcutPanel();
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        frame.pack();
        frame.setLocationRelativeTo(owner);
        frame.setVisible(true);
    }
}

