/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShowHideMoreTiersDlg
extends ClosableDialog
implements ActionListener,
MouseListener {
    private Transcription trans;
    private Vector allTiers;
    private Vector visibleTiers;
    private Vector<String> allTierNames;
    private Vector<LinguisticType> allLinguisticTypes;
    private Vector<String> allLinTypeNames;
    private Vector<String> visibleTypeNames;
    private Vector<String> allParticipants;
    private Vector<String> visibleParts;
    private Vector<String> allAnnotators;
    private Vector<String> visibleAnns;
    private final String NOT_SPECIFIED = "not specified";
    private final String SHOW_TIERS = ElanLocale.getString("MultiTierControlPanel.Menu.ShowTiers");
    private final String SHOW_TYPES = ElanLocale.getString("MultiTierControlPanel.Menu.ShowLinguisticType");
    private final String SHOW_PART = ElanLocale.getString("MultiTierControlPanel.Menu.ShowParticipant");
    private final String SHOW_ANN = ElanLocale.getString("MultiTierControlPanel.Menu.ShowAnnotator");
    private JPanel checkboxPanel;
    private JButton showAllButton;
    private JButton hideAllButton;
    private JButton applyButton;
    private JButton cancelButton;
    private JButton sortButton;
    private JButton sortDefaultButton;
    private JTabbedPane showTabPane;
    private boolean sortAlphabetically = false;
    private int currentTabIndex = 0;

    public ShowHideMoreTiersDlg(Transcription trans, Vector visibleTiers) {
        this(trans, visibleTiers, null);
    }

    public ShowHideMoreTiersDlg(Transcription trans, Vector visibleTiers, Component component) {
        super(ELANCommandFactory.getRootFrame(trans), ElanLocale.getString("MultiTierControlPanel.Menu.VisibleTiers"), true);
        this.trans = trans;
        this.allTiers = trans.getTiers();
        this.visibleTiers = visibleTiers;
        this.allLinguisticTypes = trans.getLinguisticTypes();
        this.allLinTypeNames = new Vector();
        this.allTierNames = new Vector();
        this.allParticipants = new Vector();
        this.allAnnotators = new Vector();
        this.visibleTypeNames = new Vector();
        this.visibleParts = new Vector();
        this.visibleAnns = new Vector();
        this.initDialog();
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocation(component);
        this.setVisible(true);
    }

    private void initDialog() {
        JCheckBox checkbox;
        int i;
        this.showAllButton = new JButton(ElanLocale.getString("MultiTierControlPanel.Menu.ShowAllTiers"));
        this.showAllButton.addActionListener(this);
        this.hideAllButton = new JButton(ElanLocale.getString("MultiTierControlPanel.Menu.HideAllTiers"));
        this.hideAllButton.addActionListener(this);
        this.applyButton = new JButton(ElanLocale.getString("Button.OK"));
        this.applyButton.addActionListener(this);
        this.cancelButton = new JButton(ElanLocale.getString("Button.Cancel"));
        this.cancelButton.addActionListener(this);
        this.sortButton = new JButton(ElanLocale.getString("MultiTierControlPanel.Menu.Button.Sort"));
        this.sortButton.addActionListener(this);
        this.sortDefaultButton = new JButton(ElanLocale.getString("MultiTierControlPanel.Menu.Button.Default"));
        this.sortDefaultButton.addActionListener(this);
        this.showTabPane = new JTabbedPane();
        JPanel buttonPanel1 = new JPanel(new GridBagLayout());
        buttonPanel1.add(this.sortButton);
        buttonPanel1.add(this.sortDefaultButton);
        buttonPanel1.add(this.showAllButton);
        buttonPanel1.add(this.hideAllButton);
        GridLayout gl = new GridLayout(1, 2, 6, 2);
        JPanel buttonPanel2 = new JPanel(gl);
        buttonPanel2.add(this.applyButton);
        buttonPanel2.add(this.cancelButton);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().setPreferredSize(new Dimension(600, 400));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 11;
        gbc.insets = new Insets(2, 6, 2, 6);
        gbc.gridy = 1;
        gbc.gridx = 0;
        this.getContentPane().add((Component)buttonPanel1, gbc);
        gbc.gridy = 1;
        gbc.gridx = 2;
        gbc.anchor = 13;
        this.getContentPane().add((Component)buttonPanel2, gbc);
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 3;
        gbc.fill = 1;
        this.getContentPane().add((Component)this.showTabPane, gbc);
        this.getRootPane().setDefaultButton(this.applyButton);
        this.checkboxPanel = new JPanel();
        BoxLayout box = new BoxLayout(this.checkboxPanel, 1);
        this.checkboxPanel.setLayout(box);
        for (i = 0; i < this.allTiers.size(); ++i) {
            String annName;
            TierImpl tier = (TierImpl)this.allTiers.get(i);
            checkbox = new JCheckBox(tier.getName());
            this.allTierNames.add(tier.getName());
            this.checkboxPanel.add(checkbox);
            String partName = tier.getParticipant();
            if (partName.length() == 0) {
                partName = "not specified";
            }
            if (!this.allParticipants.contains(partName)) {
                this.allParticipants.add(partName);
            }
            if ((annName = tier.getAnnotator()).length() == 0) {
                annName = "not specified";
            }
            if (this.allAnnotators.contains(annName)) continue;
            this.allAnnotators.add(annName);
        }
        this.showTabPane.add(this.SHOW_TIERS, new JScrollPane(this.checkboxPanel));
        this.checkboxPanel = new JPanel();
        box = new BoxLayout(this.checkboxPanel, 1);
        this.checkboxPanel.setLayout(box);
        for (i = 0; i < this.allLinguisticTypes.size(); ++i) {
            String type = this.allLinguisticTypes.get(i).getLinguisticTypeName();
            this.allLinTypeNames.add(type);
            checkbox = new JCheckBox(type);
            this.checkboxPanel.add(checkbox);
        }
        this.showTabPane.add(this.SHOW_TYPES, new JScrollPane(this.checkboxPanel));
        this.checkboxPanel = new JPanel();
        box = new BoxLayout(this.checkboxPanel, 1);
        this.checkboxPanel.setLayout(box);
        for (i = 0; i < this.allParticipants.size(); ++i) {
            checkbox = new JCheckBox(this.allParticipants.get(i));
            this.checkboxPanel.add(checkbox);
        }
        this.showTabPane.addTab(this.SHOW_PART, new JScrollPane(this.checkboxPanel));
        this.checkboxPanel = new JPanel();
        box = new BoxLayout(this.checkboxPanel, 1);
        this.checkboxPanel.setLayout(box);
        for (i = 0; i < this.allAnnotators.size(); ++i) {
            checkbox = new JCheckBox(this.allAnnotators.get(i));
            this.checkboxPanel.add(checkbox);
        }
        this.showTabPane.addTab(this.SHOW_ANN, new JScrollPane(this.checkboxPanel));
        this.showTabPane.addMouseListener(this);
        this.showTiers();
    }

    private void updateTab(int index, Vector<String> sortedList) {
        JPanel checkboxPanel = (JPanel)((JScrollPane)this.showTabPane.getComponentAt(index)).getViewport().getView();
        checkboxPanel.removeAll();
        for (int i = 0; i < sortedList.size(); ++i) {
            checkboxPanel.add(new JCheckBox(sortedList.get(i)));
        }
        this.showTabPane.repaint();
        this.updateTabAtIndex(index);
    }

    private void updateShowTiersTab() {
        int index = this.showTabPane.indexOfTab(this.SHOW_TIERS);
        JPanel checkboxPanel = (JPanel)((JScrollPane)this.showTabPane.getComponentAt(index)).getViewport().getView();
        checkboxPanel.removeAll();
        for (int i = 0; i < this.allTierNames.size(); ++i) {
            checkboxPanel.add(new JCheckBox(this.allTierNames.get(i)));
        }
        this.showTabPane.repaint();
        this.showTiers();
    }

    private void updateShowTypesTab() {
        int index = this.showTabPane.indexOfTab(this.SHOW_TYPES);
        JPanel checkboxPanel = (JPanel)((JScrollPane)this.showTabPane.getComponentAt(index)).getViewport().getView();
        checkboxPanel.removeAll();
        for (int i = 0; i < this.allLinTypeNames.size(); ++i) {
            checkboxPanel.add(new JCheckBox(this.allLinTypeNames.get(i)));
        }
        this.showTabPane.repaint();
        this.showTypes();
    }

    private void updateShowPartTab() {
        int index = this.showTabPane.indexOfTab(this.SHOW_PART);
        JPanel checkboxPanel = (JPanel)((JScrollPane)this.showTabPane.getComponentAt(index)).getViewport().getView();
        checkboxPanel.removeAll();
        for (int i = 0; i < this.allParticipants.size(); ++i) {
            checkboxPanel.add(new JCheckBox(this.allParticipants.get(i)));
        }
        this.showTabPane.repaint();
        this.showParticipants();
    }

    private void updateShowAnnTab() {
        int index = this.showTabPane.indexOfTab(this.SHOW_ANN);
        JPanel checkboxPanel = (JPanel)((JScrollPane)this.showTabPane.getComponentAt(index)).getViewport().getView();
        checkboxPanel.removeAll();
        for (int i = 0; i < this.allAnnotators.size(); ++i) {
            checkboxPanel.add(new JCheckBox(this.allAnnotators.get(i)));
        }
        this.showTabPane.repaint();
        this.showAnnotators();
    }

    private void setLocation(Component component) {
        if (component != null) {
            Point p = new Point(0, 0);
            SwingUtilities.convertPointToScreen(p, component);
            int windowHeight = SwingUtilities.getWindowAncestor(component).getHeight();
            if (this.getHeight() > windowHeight) {
                this.setSize(this.getWidth(), windowHeight);
            }
            p.x += component.getWidth();
            p.y -= this.getHeight() - component.getHeight();
            this.setLocation(p);
        } else {
            this.setLocationRelativeTo(this.getParent());
        }
    }

    public Vector<String> getVisibleTierNames() {
        Vector<String> visibleTierNames = null;
        if (this.visibleTiers != null) {
            visibleTierNames = new Vector<String>();
            for (int i = 0; i < this.visibleTiers.size(); ++i) {
                TierImpl tier = (TierImpl)this.visibleTiers.get(i);
                visibleTierNames.add(tier.getName());
            }
        }
        return visibleTierNames;
    }

    private void showTiers() {
        int index = this.showTabPane.indexOfTab(this.SHOW_TIERS);
        JPanel checkboxPanel = (JPanel)((JScrollPane)this.showTabPane.getComponentAt(index)).getViewport().getView();
        Vector<String> visibleTierNames = this.getVisibleTierNames();
        Component[] boxes = checkboxPanel.getComponents();
        for (int i = 0; i < boxes.length; ++i) {
            if (!(boxes[i] instanceof JCheckBox)) continue;
            if (visibleTierNames.contains(((JCheckBox)boxes[i]).getText())) {
                ((JCheckBox)boxes[i]).setSelected(true);
                continue;
            }
            ((JCheckBox)boxes[i]).setSelected(false);
        }
    }

    private void showTypes() {
        int index = this.showTabPane.indexOfTab(this.SHOW_TYPES);
        JPanel checkboxPanel = (JPanel)((JScrollPane)this.showTabPane.getComponentAt(index)).getViewport().getView();
        Component[] boxes = checkboxPanel.getComponents();
        for (int i = 0; i < boxes.length; ++i) {
            if (!(boxes[i] instanceof JCheckBox)) continue;
            if (this.visibleTypeNames.contains(((JCheckBox)boxes[i]).getText())) {
                ((JCheckBox)boxes[i]).setSelected(true);
                continue;
            }
            ((JCheckBox)boxes[i]).setSelected(false);
        }
    }

    private void showParticipants() {
        int index = this.showTabPane.indexOfTab(this.SHOW_PART);
        JPanel checkboxPanel = (JPanel)((JScrollPane)this.showTabPane.getComponentAt(index)).getViewport().getView();
        Component[] boxes = checkboxPanel.getComponents();
        for (int i = 0; i < boxes.length; ++i) {
            if (!(boxes[i] instanceof JCheckBox)) continue;
            if (this.visibleParts.contains(((JCheckBox)boxes[i]).getText())) {
                ((JCheckBox)boxes[i]).setSelected(true);
                continue;
            }
            ((JCheckBox)boxes[i]).setSelected(false);
        }
    }

    private void showAnnotators() {
        int index = this.showTabPane.indexOfTab(this.SHOW_ANN);
        JPanel checkboxPanel = (JPanel)((JScrollPane)this.showTabPane.getComponentAt(index)).getViewport().getView();
        Component[] boxes = checkboxPanel.getComponents();
        for (int i = 0; i < boxes.length; ++i) {
            if (!(boxes[i] instanceof JCheckBox)) continue;
            if (this.visibleAnns.contains(((JCheckBox)boxes[i]).getText())) {
                ((JCheckBox)boxes[i]).setSelected(true);
                continue;
            }
            ((JCheckBox)boxes[i]).setSelected(false);
        }
    }

    private void updateTiers() {
        int index = this.showTabPane.indexOfTab(this.SHOW_TIERS);
        JPanel checkboxPanel = (JPanel)((JScrollPane)this.showTabPane.getComponentAt(index)).getViewport().getView();
        Vector<String> oldVisibleTierNames = this.getVisibleTierNames();
        boolean valueChanged = false;
        this.visibleTiers.clear();
        Component[] boxes = checkboxPanel.getComponents();
        for (int i = 0; i < boxes.length; ++i) {
            if (!(boxes[i] instanceof JCheckBox) || !((JCheckBox)boxes[i]).isSelected()) continue;
            String tierName = ((JCheckBox)boxes[i]).getText();
            this.visibleTiers.add(this.trans.getTierWithId(tierName));
            if (oldVisibleTierNames.contains(tierName)) continue;
            valueChanged = true;
        }
        if (valueChanged) {
            this.visibleTypeNames.clear();
            this.visibleParts.clear();
            this.visibleAnns.clear();
        }
    }

    private void updateLinguisticTypes() {
        String typeName;
        int i;
        int index = this.showTabPane.indexOfTab(this.SHOW_TYPES);
        JPanel checkboxPanel = (JPanel)((JScrollPane)this.showTabPane.getComponentAt(index)).getViewport().getView();
        boolean changed = false;
        Vector<String> selectedTypes = new Vector<String>();
        Component[] boxes = checkboxPanel.getComponents();
        for (i = 0; i < boxes.length; ++i) {
            if (!(boxes[i] instanceof JCheckBox) || !((JCheckBox)boxes[i]).isSelected() || selectedTypes.contains(typeName = ((JCheckBox)boxes[i]).getText())) continue;
            selectedTypes.add(typeName);
        }
        if (selectedTypes.size() != this.visibleTypeNames.size()) {
            changed = true;
        } else {
            for (i = 0; i < selectedTypes.size(); ++i) {
                if (this.visibleTypeNames.contains(selectedTypes.get(i))) continue;
                changed = true;
                break;
            }
        }
        if (changed) {
            this.visibleTypeNames = selectedTypes;
            this.visibleTiers.clear();
            for (i = 0; i < this.visibleTypeNames.size(); ++i) {
                typeName = this.visibleTypeNames.get(i);
                if (typeName.equals("not specified")) {
                    typeName = "";
                }
                this.visibleTiers.addAll(this.trans.getTiersWithLinguisticType(typeName));
            }
            this.visibleAnns.clear();
            this.visibleParts.clear();
        }
    }

    private void updateParticipants() {
        int i;
        int index = this.showTabPane.indexOfTab(this.SHOW_PART);
        JPanel checkboxPanel = (JPanel)((JScrollPane)this.showTabPane.getComponentAt(index)).getViewport().getView();
        boolean changed = false;
        Vector<String> selectedPart = new Vector<String>();
        Component[] boxes = checkboxPanel.getComponents();
        for (i = 0; i < boxes.length; ++i) {
            String partName;
            if (!(boxes[i] instanceof JCheckBox) || !((JCheckBox)boxes[i]).isSelected() || selectedPart.contains(partName = ((JCheckBox)boxes[i]).getText())) continue;
            selectedPart.add(partName);
        }
        if (selectedPart.size() != this.visibleParts.size()) {
            changed = true;
        } else {
            for (i = 0; i < selectedPart.size(); ++i) {
                if (this.visibleParts.contains(selectedPart.get(i))) continue;
                changed = true;
                break;
            }
        }
        if (changed) {
            this.visibleTiers.clear();
            this.visibleParts = selectedPart;
            for (i = 0; i < this.allTiers.size(); ++i) {
                TierImpl tier = (TierImpl)this.allTiers.get(i);
                String partName = tier.getParticipant();
                if (partName.length() == 0) {
                    partName = "not specified";
                }
                if (!this.visibleParts.contains(partName)) continue;
                this.visibleTiers.add(tier);
            }
            this.visibleTypeNames.clear();
            this.visibleAnns.clear();
        }
    }

    private void updateAnnotators() {
        int i;
        int index = this.showTabPane.indexOfTab(this.SHOW_ANN);
        JPanel checkboxPanel = (JPanel)((JScrollPane)this.showTabPane.getComponentAt(index)).getViewport().getView();
        boolean changed = false;
        Vector<String> selectedAnn = new Vector<String>();
        Component[] boxes = checkboxPanel.getComponents();
        for (i = 0; i < boxes.length; ++i) {
            String annName;
            if (!(boxes[i] instanceof JCheckBox) || !((JCheckBox)boxes[i]).isSelected() || selectedAnn.contains(annName = ((JCheckBox)boxes[i]).getText())) continue;
            selectedAnn.add(annName);
        }
        if (selectedAnn.size() != this.visibleAnns.size()) {
            changed = true;
        } else {
            for (i = 0; i < selectedAnn.size(); ++i) {
                if (this.visibleAnns.contains(selectedAnn.get(i))) continue;
                changed = true;
                break;
            }
        }
        if (changed) {
            this.visibleAnns = selectedAnn;
            this.visibleTiers.clear();
            for (i = 0; i < this.allTiers.size(); ++i) {
                TierImpl tier = (TierImpl)this.allTiers.get(i);
                String annName = tier.getAnnotator();
                if (annName.length() == 0) {
                    annName = "not specified";
                }
                if (!this.visibleAnns.contains(annName)) continue;
                this.visibleTiers.add(tier);
            }
            this.visibleTypeNames.clear();
            this.visibleParts.clear();
        }
    }

    private void setAllSelected(boolean selected) {
        int index = this.showTabPane.getSelectedIndex();
        JPanel checkboxPanel = (JPanel)((JScrollPane)this.showTabPane.getComponentAt(index)).getViewport().getView();
        Component[] boxes = checkboxPanel.getComponents();
        for (int i = 0; i < boxes.length; ++i) {
            if (!(boxes[i] instanceof JCheckBox)) continue;
            ((JCheckBox)boxes[i]).setSelected(selected);
        }
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.showAllButton) {
            this.setAllSelected(true);
        } else if (source == this.hideAllButton) {
            this.setAllSelected(false);
        } else if (source == this.applyButton) {
            this.updateChanges(this.showTabPane.getSelectedIndex());
            this.close();
        } else if (source == this.cancelButton) {
            this.visibleTiers = null;
            this.close();
        } else if (source == this.sortButton) {
            this.sortAlphabetically = true;
            int index = this.showTabPane.getSelectedIndex();
            this.updateChanges(index);
            this.sortAlphabetically(index);
        } else if (source == this.sortDefaultButton) {
            this.sortAlphabetically = false;
            int index = this.showTabPane.getSelectedIndex();
            this.updateChanges(index);
            this.sortInDefaultOrder(index);
        }
    }

    private void sortInDefaultOrder(int index) {
        String tabName = this.showTabPane.getTitleAt(index);
        if (tabName.equals(this.SHOW_TYPES)) {
            this.updateTab(index, this.allLinTypeNames);
        } else if (tabName.equals(this.SHOW_TIERS)) {
            this.updateTab(index, this.allTierNames);
        } else if (tabName.equals(this.SHOW_PART)) {
            this.updateTab(index, this.allParticipants);
        } else if (tabName.equals(this.SHOW_ANN)) {
            this.updateTab(index, this.allAnnotators);
        }
    }

    private void sortAlphabetically(int index) {
        String tabName = this.showTabPane.getTitleAt(index);
        if (tabName.equals(this.SHOW_TYPES)) {
            Object[] array = this.allLinTypeNames.toArray();
            Arrays.sort(array);
            Vector<String> sortedLinTypeNames = new Vector<String>();
            for (int i = 0; i < array.length; ++i) {
                sortedLinTypeNames.add((String)array[i]);
            }
            this.updateTab(index, sortedLinTypeNames);
        } else if (tabName.equals(this.SHOW_TIERS)) {
            Object[] array = this.allTierNames.toArray();
            Arrays.sort(array);
            Vector<String> sortedTierNames = new Vector<String>();
            for (int i = 0; i < array.length; ++i) {
                sortedTierNames.add((String)array[i]);
            }
            this.updateTab(index, sortedTierNames);
        } else if (tabName.equals(this.SHOW_PART)) {
            Object[] array = this.allParticipants.toArray();
            Arrays.sort(array);
            Vector<String> sortedParticipants = new Vector<String>();
            for (int i = 0; i < array.length; ++i) {
                sortedParticipants.add((String)array[i]);
            }
            this.updateTab(index, sortedParticipants);
        } else if (tabName.equals(this.SHOW_ANN)) {
            Object[] array = this.allAnnotators.toArray();
            Arrays.sort(array);
            Vector<String> sortedAnnotators = new Vector<String>();
            for (int i = 0; i < array.length; ++i) {
                sortedAnnotators.add((String)array[i]);
            }
            this.updateTab(index, sortedAnnotators);
        }
    }

    private void updateChanges(int index) {
        String tabName = this.showTabPane.getTitleAt(index);
        if (tabName.equals(this.SHOW_TYPES)) {
            this.updateLinguisticTypes();
        } else if (tabName.equals(this.SHOW_TIERS)) {
            this.updateTiers();
        } else if (tabName.equals(this.SHOW_PART)) {
            this.updateParticipants();
        } else if (tabName.equals(this.SHOW_ANN)) {
            this.updateAnnotators();
        }
    }

    private void updateTabAtIndex(int index) {
        String tabName = this.showTabPane.getTitleAt(index);
        if (tabName.equals(this.SHOW_TYPES)) {
            this.showTypes();
        } else if (tabName.equals(this.SHOW_TIERS)) {
            this.showTiers();
        } else if (tabName.equals(this.SHOW_PART)) {
            this.showParticipants();
        } else if (tabName.equals(this.SHOW_ANN)) {
            this.showAnnotators();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getSource() == this.showTabPane) {
            this.updateChanges(this.currentTabIndex);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getSource() == this.showTabPane) {
            this.currentTabIndex = this.showTabPane.getSelectedIndex();
            this.updateTabAtIndex(this.currentTabIndex);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

