/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.ClosableDialog;

public class TextExportFileChooser
extends JComponent
implements ActionListener {
    private JFileChooser chooser;
    private JButton okButton;
    private JButton cancelButton;
    private String dialogTitle;
    private JDialog dialog;
    private int returnValue = -1;
    private JLabel encLabel;
    private JComboBox encodingBox;

    public TextExportFileChooser() {
        this.initComponents();
    }

    private void initComponents() {
        this.encLabel = new JLabel("Encoding: ");
        this.encodingBox = new JComboBox();
        this.encodingBox.addItem("ISO-LATIN");
        this.encodingBox.addItem("UTF-8");
        this.encodingBox.addItem("UTF-16");
        this.encodingBox.setSelectedIndex(1);
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(0, 6, 6, 6);
        this.chooser = new JFileChooser();
        this.chooser.setDialogType(1);
        this.chooser.setControlButtonsAreShown(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this.chooser, gbc);
        JPanel encPanel = new JPanel();
        encPanel.add(this.encLabel);
        encPanel.add(this.encodingBox);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 15;
        gbc.fill = 0;
        gbc.insets = insets;
        this.add((Component)encPanel, gbc);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 6, 6));
        this.okButton.setText(ElanLocale.getString("Menu.File.Save"));
        this.okButton.addActionListener(this);
        this.cancelButton.setText(ElanLocale.getString("Button.Cancel"));
        this.cancelButton.addActionListener(this);
        if (System.getProperty("os.name").startsWith("Mac OS X")) {
            buttonPanel.add(this.cancelButton);
            buttonPanel.add(this.okButton);
        } else {
            buttonPanel.add(this.okButton);
            buttonPanel.add(this.cancelButton);
        }
        JPanel butBorderPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        butBorderPanel.add((Component)new JPanel(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 13;
        gbc.insets = insets;
        butBorderPanel.add((Component)buttonPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 15;
        gbc.fill = 2;
        gbc.insets = insets;
        this.add((Component)butBorderPanel, gbc);
    }

    public int showSaveDialog(Component parent, String approveButtonText) throws HeadlessException {
        if (approveButtonText != null) {
            this.chooser.setApproveButtonText(approveButtonText);
        }
        this.dialog = this.createDialog(parent);
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                TextExportFileChooser.this.returnValue = 1;
            }
        });
        this.returnValue = -1;
        this.dialog.setVisible(true);
        this.dialog.dispose();
        this.dialog = null;
        return this.returnValue;
    }

    protected JDialog createDialog(Component parent) throws HeadlessException {
        Frame frame = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        ClosableDialog dialog = new ClosableDialog(frame, this.dialogTitle, true);
        Container contentPane = dialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this, "Center");
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        return dialog;
    }

    public String getSelectedEncoding() {
        String enc = (String)this.encodingBox.getSelectedItem();
        if (enc == null) {
            enc = "UTF-8";
        } else if (enc.equals("ISO-LATIN")) {
            enc = "ISO-8859-1";
        }
        return enc;
    }

    public void setSelectedEncoding(String encoding) {
        this.encodingBox.setSelectedItem(encoding);
    }

    public File getCurrentDirectory() {
        return this.chooser.getCurrentDirectory();
    }

    public void setCurrentDirectory(File dir) {
        this.chooser.setCurrentDirectory(dir);
    }

    public File getSelectedFile() {
        return this.chooser.getSelectedFile();
    }

    public void setFileFilter(FileFilter filter) {
        this.chooser.setFileFilter(filter);
    }

    public FileFilter getFileFilter() {
        return this.chooser.getFileFilter();
    }

    public void setDialogTitle(String title) {
        this.dialogTitle = title;
        if (this.dialog != null) {
            this.dialog.setTitle(title);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            Component c = this.getTextField(this.chooser);
            if (c instanceof JTextField) {
                String fileName = ((JTextField)c).getText();
                this.chooser.setSelectedFile(new File(this.chooser.getCurrentDirectory(), fileName));
            }
            this.returnValue = 0;
            this.dialog.setVisible(false);
        } else if (e.getSource() == this.cancelButton) {
            this.returnValue = 1;
            this.dialog.setVisible(false);
        }
    }

    private Component getTextField(Container container) {
        Component c = null;
        if (container != null) {
            Component[] cc = container.getComponents();
            for (int i = 0; i < cc.length; ++i) {
                c = cc[i];
                if (c instanceof JTextField) {
                    return c;
                }
                if (!(c instanceof Container) || !((c = this.getTextField((Container)c)) instanceof JTextField)) continue;
                return c;
            }
        }
        return c;
    }
}

