/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.tier.TierExportTableModel;
import mpi.eudico.client.util.CheckBoxTableCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TierSortAndSelectDialog
extends ClosableDialog
implements ActionListener,
ListSelectionListener {
    private List<String> tierOrder;
    private List<String> selectedTiers;
    protected JPanel buttonPanel;
    private JButton cancelButton;
    private JButton okButton;
    protected JPanel tierButtonPanel;
    protected JButton downButton;
    protected JButton upButton;
    protected JButton allButton;
    protected JButton noneButton;
    protected DefaultTableModel model;
    protected JPanel tierSelectionPanel;
    protected JTable tierTable;
    protected final String SELECT_COLUMN = "select";
    protected final String TIER_NAME_COLUMN = "tier";
    private List<String> returnedTiers = null;

    public TierSortAndSelectDialog(Frame owner, List<String> tierOrder, List<String> selectedTiers) throws HeadlessException {
        super(owner);
        this.tierOrder = tierOrder;
        this.selectedTiers = selectedTiers;
        this.initComponents();
    }

    public TierSortAndSelectDialog(Frame owner, boolean modal, List<String> tierOrder, List<String> selectedTiers) throws HeadlessException {
        super(owner, modal);
        this.tierOrder = tierOrder;
        this.selectedTiers = selectedTiers;
        this.initComponents();
    }

    public TierSortAndSelectDialog(Dialog owner, List<String> tierOrder, List<String> selectedTiers) throws HeadlessException {
        super(owner);
        this.tierOrder = tierOrder;
        this.selectedTiers = selectedTiers;
        this.initComponents();
    }

    public TierSortAndSelectDialog(Dialog owner, boolean modal, List<String> tierOrder, List<String> selectedTiers) throws HeadlessException {
        super(owner, modal);
        this.tierOrder = tierOrder;
        this.selectedTiers = selectedTiers;
        this.initComponents();
    }

    private void initComponents() {
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets = new Insets(4, 6, 4, 6);
        this.model = new TierExportTableModel();
        this.tierTable = new JTable(this.model);
        this.model.setColumnIdentifiers(new String[]{"select", "tier"});
        this.tierTable.getColumn("select").setCellEditor(new DefaultCellEditor(new JCheckBox()));
        this.tierTable.getColumn("select").setCellRenderer(new CheckBoxTableCellRenderer());
        this.tierTable.getColumn("select").setMaxWidth(30);
        this.tierTable.setShowVerticalLines(false);
        this.tierTable.setTableHeader(null);
        this.tierTable.getSelectionModel().addListSelectionListener(this);
        if (this.tierOrder != null) {
            for (String name : this.tierOrder) {
                if (this.selectedTiers != null) {
                    if (this.selectedTiers.contains(name)) {
                        this.model.addRow(new Object[]{Boolean.TRUE, name});
                        continue;
                    }
                    this.model.addRow(new Object[]{Boolean.FALSE, name});
                    continue;
                }
                this.model.addRow(new Object[]{Boolean.TRUE, name});
            }
        }
        this.tierSelectionPanel = new JPanel(new GridBagLayout());
        Dimension tableDim = new Dimension(50, 100);
        JScrollPane tierScrollPane = new JScrollPane(this.tierTable);
        tierScrollPane.setPreferredSize(tableDim);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = insets;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.tierSelectionPanel.add((Component)tierScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = insets;
        this.getContentPane().add((Component)this.tierSelectionPanel, gridBagConstraints);
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.allButton = new JButton(ElanLocale.getString("Button.SelectAll"));
        this.noneButton = new JButton(ElanLocale.getString("Button.SelectNone"));
        this.tierButtonPanel = new JPanel(new GridBagLayout());
        try {
            ImageIcon upIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Up16.gif"));
            ImageIcon downIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Down16.gif"));
            this.upButton.setIcon(upIcon);
            this.downButton.setIcon(downIcon);
        }
        catch (Exception ex) {
            this.upButton.setText("Up");
            this.downButton.setText("Down");
        }
        this.upButton.addActionListener(this);
        this.downButton.addActionListener(this);
        this.allButton.addActionListener(this);
        this.noneButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        this.tierButtonPanel.add((Component)this.upButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        this.tierButtonPanel.add((Component)this.downButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        this.tierButtonPanel.add((Component)this.allButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = insets;
        this.tierButtonPanel.add((Component)this.noneButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.tierSelectionPanel.add((Component)this.tierButtonPanel, gridBagConstraints);
        this.cancelButton = new JButton(ElanLocale.getString("Button.Cancel"));
        this.cancelButton.addActionListener(this);
        this.okButton = new JButton(ElanLocale.getString("Button.OK"));
        this.okButton.addActionListener(this);
        this.buttonPanel = new JPanel(new GridLayout(1, 2, 6, 0));
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = insets;
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.pack();
        int minW = 300;
        int minH = 400;
        this.setSize(Math.max(minW, this.getWidth()), Math.max(minH, this.getHeight()));
    }

    private List<String> getSelectedTiers() {
        int includeCol = this.model.findColumn("select");
        int nameCol = this.model.findColumn("tier");
        ArrayList<String> selectedTiers = new ArrayList<String>();
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            Boolean include = (Boolean)this.model.getValueAt(i, includeCol);
            if (!include.booleanValue()) continue;
            selectedTiers.add((String)this.model.getValueAt(i, nameCol));
        }
        return selectedTiers;
    }

    public List<String> getValue() {
        return this.returnedTiers;
    }

    public List<String> getTierOrder() {
        int nameCol = this.model.findColumn("tier");
        ArrayList<String> orderedTiers = new ArrayList<String>();
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            orderedTiers.add((String)this.model.getValueAt(i, nameCol));
        }
        return orderedTiers;
    }

    protected void moveDown() {
        if (this.tierTable == null || this.model == null || this.model.getRowCount() < 2) {
            return;
        }
        int[] selected = this.tierTable.getSelectedRows();
        for (int i = selected.length - 1; i >= 0; --i) {
            int row = selected[i];
            if (row >= this.model.getRowCount() - 1 || this.tierTable.isRowSelected(row + 1)) continue;
            this.model.moveRow(row, row, row + 1);
            this.tierTable.changeSelection(row, 0, true, false);
            this.tierTable.changeSelection(row + 1, 0, true, false);
        }
    }

    protected void moveUp() {
        if (this.tierTable == null || this.model == null || this.model.getRowCount() < 2) {
            return;
        }
        int[] selected = this.tierTable.getSelectedRows();
        for (int i = 0; i < selected.length; ++i) {
            int row = selected[i];
            if (row <= 0 || this.tierTable.isRowSelected(row - 1)) continue;
            this.model.moveRow(row, row, row - 1);
            this.tierTable.changeSelection(row, 0, true, false);
            this.tierTable.changeSelection(row - 1, 0, true, false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.allButton) {
            if (this.model != null) {
                for (int i = 0; i < this.tierTable.getRowCount(); ++i) {
                    this.model.setValueAt(Boolean.TRUE, i, 0);
                }
            }
        } else if (ae.getSource() == this.noneButton) {
            if (this.model != null) {
                for (int i = 0; i < this.tierTable.getRowCount(); ++i) {
                    this.model.setValueAt(Boolean.FALSE, i, 0);
                }
            }
        } else if (ae.getSource() == this.upButton) {
            this.moveUp();
        } else if (ae.getSource() == this.downButton) {
            this.moveDown();
        } else if (ae.getSource() == this.cancelButton) {
            this.setVisible(false);
            this.dispose();
        } else if (ae.getSource() == this.okButton) {
            this.returnedTiers = this.getSelectedTiers();
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        if (this.model != null && lse.getValueIsAdjusting()) {
            int b = lse.getFirstIndex();
            int e = lse.getLastIndex();
            int col = this.model.findColumn("select");
            for (int i = b; i <= e; ++i) {
                if (!this.tierTable.isRowSelected(i)) continue;
                this.model.setValueAt(Boolean.TRUE, i, col);
            }
        }
    }
}

