/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.imports;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.annotator.util.ElanFileFilter;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.util.TimeFormatter;

public class MergeStep1
extends StepPane
implements ActionListener,
ItemListener {
    private TranscriptionImpl curTranscription;
    private JButton browseSource1;
    private JButton browseSource2;
    private JButton browseDest;
    private JTextField source1Field;
    private JTextField source2Field;
    private JTextField destField;
    private JTextField timeFrameField;
    private JCheckBox curTransCB;
    private JCheckBox appendAnnCB;
    private JRadioButton appendWitMediaDurRB;
    private JRadioButton appendWithLastAnnRB;
    private JRadioButton appendWithGivenTimeRB;
    private JPanel firstSourcePanel;
    private JPanel secSourcePanel;
    private JPanel appendOptionsPanel;
    private JPanel desSourcePanel;
    private boolean src1Ready = false;
    private boolean src2Ready = false;
    private boolean destReady = false;
    private long timeFrame = 0L;

    public MergeStep1(MultiStepPane multiPane) {
        super(multiPane);
        this.initComponents();
    }

    public MergeStep1(MultiStepPane multiPane, TranscriptionImpl curTranscription) {
        super(multiPane);
        this.curTranscription = curTranscription;
        this.initComponents();
    }

    public void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.browseSource1 = new JButton(ElanLocale.getString("Button.Browse"));
        this.browseSource2 = new JButton(ElanLocale.getString("Button.Browse"));
        this.browseDest = new JButton(ElanLocale.getString("Button.Browse"));
        this.source1Field = new JTextField();
        this.source2Field = new JTextField();
        this.destField = new JTextField();
        this.timeFrameField = new JTextField();
        this.timeFrameField.setEnabled(false);
        this.timeFrameField.setEditable(true);
        this.source1Field.setEditable(false);
        this.source1Field.setEnabled(false);
        this.source2Field.setEditable(false);
        this.source2Field.setEnabled(false);
        this.destField.setEditable(false);
        this.destField.setEnabled(false);
        this.curTransCB = new JCheckBox(ElanLocale.getString("MergeTranscriptionDialog.Label.UseCurrent"));
        this.appendAnnCB = new JCheckBox(ElanLocale.getString("MergeTranscriptionDialog.Label.AppendAnnotation"));
        this.appendAnnCB.addItemListener(this);
        this.appendWitMediaDurRB = new JRadioButton(ElanLocale.getString("MergeTranscriptionDialog.Label.AppendWithCurMediaDur"));
        this.appendWitMediaDurRB.setEnabled(false);
        this.appendWithLastAnnRB = new JRadioButton(ElanLocale.getString("MergeTranscriptionDialog.Label.AppendWithLastAnn"));
        this.appendWithLastAnnRB.setSelected(true);
        this.appendWithLastAnnRB.setEnabled(false);
        this.appendWithGivenTimeRB = new JRadioButton(ElanLocale.getString("MergeTranscriptionDialog.Label.AppendWithGivenTime"));
        this.appendWithGivenTimeRB.setEnabled(false);
        this.appendWithGivenTimeRB.addItemListener(this);
        Insets insets = new Insets(4, 6, 4, 6);
        GridBagConstraints gbc = new GridBagConstraints();
        this.firstSourcePanel = new JPanel();
        this.firstSourcePanel.setLayout(new GridBagLayout());
        this.firstSourcePanel.setBorder(new TitledBorder(ElanLocale.getString("MergeTranscriptionDialog.Label.Source1")));
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = insets;
        if (this.curTranscription != null) {
            this.curTransCB.setSelected(true);
            this.source1Field.setText(this.curTranscription.getFullPath());
            this.browseSource1.setEnabled(false);
            this.src1Ready = true;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 18;
            this.firstSourcePanel.add((Component)this.curTransCB, gbc);
            gbc.gridy = 1;
            gbc.gridwidth = 2;
            gbc.anchor = 17;
            this.firstSourcePanel.add((Component)this.source1Field, gbc);
            gbc.gridx = 2;
            gbc.gridwidth = 1;
            gbc.fill = 0;
            gbc.anchor = 13;
            gbc.weightx = 0.0;
            this.firstSourcePanel.add((Component)this.browseSource1, gbc);
            this.curTransCB.addItemListener(this);
        } else {
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 2;
            this.firstSourcePanel.add((Component)this.source1Field, gbc);
            gbc.gridx = 2;
            gbc.gridwidth = 1;
            gbc.fill = 0;
            gbc.anchor = 13;
            gbc.weightx = 0.0;
            this.firstSourcePanel.add((Component)this.browseSource1, gbc);
        }
        this.appendOptionsPanel = new JPanel();
        this.appendOptionsPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(2, 0, 2, 0);
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        if (this.curTranscription != null) {
            this.appendOptionsPanel.add((Component)this.appendWitMediaDurRB, gbc);
            gbc.gridy = 1;
            this.appendOptionsPanel.add((Component)this.appendWithLastAnnRB, gbc);
            gbc.gridy = 2;
            this.appendOptionsPanel.add((Component)this.appendWithGivenTimeRB, gbc);
            gbc.gridx = 1;
            this.appendOptionsPanel.add((Component)this.timeFrameField, gbc);
        } else {
            this.appendOptionsPanel.add((Component)this.appendWithLastAnnRB, gbc);
            gbc.gridy = 1;
            this.appendOptionsPanel.add((Component)this.appendWithGivenTimeRB, gbc);
            gbc.gridx = 1;
            this.appendOptionsPanel.add((Component)this.timeFrameField, gbc);
        }
        this.secSourcePanel = new JPanel();
        this.secSourcePanel.setLayout(new GridBagLayout());
        this.secSourcePanel.setBorder(new TitledBorder(ElanLocale.getString("MergeTranscriptionDialog.Label.Source2")));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.insets = insets;
        this.secSourcePanel.add((Component)this.source2Field, gbc);
        gbc.gridx = 2;
        gbc.fill = 0;
        gbc.anchor = 13;
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        this.secSourcePanel.add((Component)this.browseSource2, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        this.secSourcePanel.add((Component)this.appendAnnCB, gbc);
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(2, 22, 2, 4);
        this.secSourcePanel.add((Component)this.appendOptionsPanel, gbc);
        ButtonGroup group = new ButtonGroup();
        group.add(this.appendWitMediaDurRB);
        group.add(this.appendWithGivenTimeRB);
        group.add(this.appendWithLastAnnRB);
        this.desSourcePanel = new JPanel();
        this.desSourcePanel.setLayout(new GridBagLayout());
        this.desSourcePanel.setBorder(new TitledBorder(ElanLocale.getString("MergeTranscriptionDialog.Label.Destination")));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = insets;
        gbc.gridwidth = 2;
        this.desSourcePanel.add((Component)this.destField, gbc);
        gbc.gridx = 2;
        gbc.fill = 0;
        gbc.anchor = 13;
        gbc.weightx = 0.0;
        this.desSourcePanel.add((Component)this.browseDest, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.insets = insets;
        this.add((Component)this.firstSourcePanel, gbc);
        gbc.gridy = 1;
        this.add((Component)this.secSourcePanel, gbc);
        gbc.gridy = 2;
        this.add((Component)this.desSourcePanel, gbc);
        this.browseSource1.addActionListener(this);
        this.browseSource2.addActionListener(this);
        this.browseDest.addActionListener(this);
    }

    public String getStepTitle() {
        return ElanLocale.getString("MergeTranscriptionDialog.Title");
    }

    public void enterStepForward() {
    }

    public void enterStepBackward() {
        this.multiPane.setButtonEnabled(1, true);
        this.multiPane.setButtonEnabled(4, true);
    }

    public boolean leaveStepForward() {
        if (this.appendWithGivenTimeRB.isSelected()) {
            this.multiPane.putStepProperty("givenTimeFrame", this.timeFrame);
        }
        if (this.curTransCB.isSelected()) {
            this.multiPane.putStepProperty("Source1", this.curTranscription);
        } else {
            this.multiPane.putStepProperty("Source1", this.source1Field.getText());
        }
        if (this.appendAnnCB.isSelected()) {
            this.multiPane.putStepProperty("appendAnnsWithMedia", this.appendWitMediaDurRB.isSelected());
            this.multiPane.putStepProperty("appendAnnsWithGivenTime", this.appendWithGivenTimeRB.isSelected());
            this.multiPane.putStepProperty("appendAnnsLastAnns", this.appendWithLastAnnRB.isSelected());
        } else {
            this.multiPane.putStepProperty("appendAnnsWithMedia", false);
            this.multiPane.putStepProperty("appendAnnsWithGivenTime", false);
            this.multiPane.putStepProperty("appendAnnsLastAnns", false);
        }
        this.multiPane.putStepProperty("Source2", this.source2Field.getText());
        this.multiPane.putStepProperty("Destination", this.destField.getText());
        return true;
    }

    private String getOpenFileName() {
        String eafDir = (String)Preferences.get("LastUsedEAFDir", null);
        if (eafDir == null) {
            eafDir = System.getProperty("user.dir");
        }
        JFileChooser chooser = new JFileChooser();
        chooser.setApproveButtonText("Select");
        chooser.setCurrentDirectory(new File(eafDir));
        chooser.setDialogTitle(ElanLocale.getString("MergeTranscriptionDialog.SelectEAF"));
        File eafFile = null;
        FileFilter filter = ElanFileFilter.createFileFilter(3);
        chooser.setFileFilter(filter);
        if (chooser.showOpenDialog(this) == 0) {
            File curDir = chooser.getCurrentDirectory();
            if (curDir != null) {
                Preferences.set("LastUsedEAFDir", curDir.getAbsolutePath(), null);
            }
            if ((eafFile = chooser.getSelectedFile()) != null) {
                String name = eafFile.getAbsolutePath();
                if (this.isExistingEAF(name)) {
                    return name;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    private String getSaveFileName() {
        String eafDir = (String)Preferences.get("LastUsedEAFDir", null);
        if (eafDir == null) {
            eafDir = System.getProperty("user.dir");
        }
        JFileChooser chooser = new JFileChooser();
        chooser.setApproveButtonText("Save");
        chooser.setCurrentDirectory(new File(eafDir));
        chooser.setDialogTitle(ElanLocale.getString("MergeTranscriptionDialog.SelectEAF"));
        File eafFile = null;
        FileFilter filter = ElanFileFilter.createFileFilter(3);
        chooser.setFileFilter(filter);
        if (chooser.showSaveDialog(this) == 0) {
            File curDir = chooser.getCurrentDirectory();
            if (curDir != null) {
                Preferences.set("LastUsedEAFDir", curDir.getAbsolutePath(), null);
            }
            if ((eafFile = chooser.getSelectedFile()) != null) {
                File f;
                String name = eafFile.getAbsolutePath();
                if (!this.validEAFName(name)) {
                    name = name + "." + FileExtension.EAF_EXT[0];
                }
                if ((f = new File(name)).exists()) {
                    if (JOptionPane.showConfirmDialog(null, name + "\n" + ElanLocale.getString("MergeTranscriptionDialog.Warning.DestinationExists"), ElanLocale.getString("Message.Warning"), 0) == 1) {
                        return null;
                    }
                    return name;
                }
                return name;
            }
            return null;
        }
        return null;
    }

    private boolean isExistingEAF(String fileName) {
        if (fileName == null) {
            return false;
        }
        File f = new File(fileName);
        if (!f.exists()) {
            return false;
        }
        return this.validEAFName(fileName);
    }

    private boolean validEAFName(String name) {
        if (name == null) {
            return false;
        }
        String lowerPathName = name.toLowerCase();
        String[] exts = FileExtension.EAF_EXT;
        boolean validExt = false;
        for (int i = 0; i < exts.length; ++i) {
            if (!lowerPathName.endsWith("." + exts[i])) continue;
            validExt = true;
            break;
        }
        return validExt;
    }

    private void checkCondition() {
        if (this.src1Ready && this.src2Ready && this.destReady) {
            if (this.source1Field.getText().equals(this.source2Field.getText())) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("MergeTranscriptionDialog.Warning.SameSources"), ElanLocale.getString("Message.Warning"), 2);
                this.multiPane.setButtonEnabled(1, false);
                return;
            }
            if (this.source1Field.getText().equals(this.destField.getText()) || this.source2Field.getText().equals(this.destField.getText())) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("MergeTranscriptionDialog.Warning.DestinationIsSource"), ElanLocale.getString("Message.Warning"), 2);
                this.multiPane.setButtonEnabled(1, false);
                return;
            }
            if (this.appendWithGivenTimeRB.isSelected()) {
                String textValue = this.timeFrameField.getText().trim();
                try {
                    this.timeFrame = TimeFormatter.toMilliSeconds(textValue);
                }
                catch (NumberFormatException nfe) {
                    JOptionPane.showMessageDialog(this, ElanLocale.getString("MergeTranscriptionDialog.Message.InvalidNumber"), ElanLocale.getString("Message.Warning"), 2);
                    this.timeFrameField.selectAll();
                    this.timeFrameField.requestFocus();
                    return;
                }
            }
            this.multiPane.setButtonEnabled(1, true);
        } else {
            this.multiPane.setButtonEnabled(1, false);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.browseSource1) {
            String name = this.getOpenFileName();
            if (name != null) {
                this.source1Field.setText(name);
                this.src1Ready = true;
            } else {
                this.src1Ready = this.isExistingEAF(this.source1Field.getText());
            }
        } else if (e.getSource() == this.browseSource2) {
            String name = this.getOpenFileName();
            if (name != null) {
                this.source2Field.setText(name);
                this.src2Ready = true;
            } else {
                this.src2Ready = this.isExistingEAF(this.source2Field.getText());
            }
        } else {
            String name = this.getSaveFileName();
            if (name != null) {
                this.destField.setText(name);
                this.destReady = true;
            } else {
                this.destReady = this.destField.getText() != null && this.destField.getText().length() > 4;
            }
        }
        this.checkCondition();
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.curTransCB) {
            if (this.curTransCB.isSelected()) {
                this.browseSource1.setEnabled(false);
                this.source1Field.setText(this.curTranscription.getFullPath());
                if (this.appendAnnCB.isSelected()) {
                    this.appendWitMediaDurRB.setEnabled(true);
                }
                this.src1Ready = true;
            } else {
                this.browseSource1.setEnabled(true);
                this.source1Field.setText("");
                this.appendWitMediaDurRB.setEnabled(false);
                this.src1Ready = false;
            }
        }
        if (e.getSource() == this.appendWithGivenTimeRB) {
            if (this.appendWithGivenTimeRB.isSelected()) {
                this.timeFrameField.setEnabled(true);
                this.timeFrameField.requestFocus();
            } else {
                this.timeFrameField.setEnabled(false);
            }
        } else if (e.getSource() == this.appendAnnCB) {
            if (this.appendAnnCB.isSelected()) {
                if (this.curTransCB.isSelected()) {
                    this.appendWitMediaDurRB.setEnabled(true);
                } else {
                    this.appendWitMediaDurRB.setEnabled(false);
                }
                if (this.appendWithGivenTimeRB.isSelected()) {
                    this.timeFrameField.setEnabled(true);
                    this.timeFrameField.requestFocus();
                }
            } else {
                this.appendWitMediaDurRB.setEnabled(false);
            }
            this.appendWithLastAnnRB.setEnabled(this.appendAnnCB.isSelected());
            this.appendWithGivenTimeRB.setEnabled(this.appendAnnCB.isSelected());
        }
        this.checkCondition();
    }
}

