/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.imports;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import mpi.eudico.client.annotator.util.AnnotationRecreator;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.ProgressListener;
import mpi.eudico.server.corpora.clom.TranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.ACMTranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.util.ControlledVocabulary;

public class TranscriptionMerger
implements ClientLogger {
    private ArrayList listeners;
    private File source1File;
    private File source2File;
    private File destinationFile;
    private TranscriptionImpl transcription;
    private TranscriptionImpl transcription2;
    private TranscriptionImpl destTranscription;
    private MergeThread mergeThread;
    private final int LOAD_PERCENTAGE = 15;

    public TranscriptionMerger(String source1, String source2, String destination) throws IOException {
        if (source1 == null || source2 == null) {
            LOG.warning("Sources for merging cannot be null.");
            throw new NullPointerException("Sources for merging cannot be null.");
        }
        if (destination == null) {
            LOG.warning("Destination for merging cannot be null.");
            throw new NullPointerException("Destination for merging cannot be null.");
        }
        this.source1File = new File(source1);
        this.source2File = new File(source2);
        if (!this.source1File.exists() || !this.source2File.exists()) {
            LOG.warning("Sources for merging must be existing files.");
            throw new IllegalArgumentException("Sources for merging must be existing files.");
        }
        this.destinationFile = new File(destination);
        if (!this.destinationFile.exists()) {
            this.destinationFile.createNewFile();
        }
        if (!this.destinationFile.canWrite() || this.destinationFile.isDirectory()) {
            LOG.warning("Cannot write to file: " + this.destinationFile.getAbsolutePath());
            throw new IOException("Cannot write to file: " + this.destinationFile.getAbsolutePath());
        }
    }

    public TranscriptionMerger(TranscriptionImpl transcription, String source2, String destination) throws IOException {
        if (transcription == null || source2 == null) {
            LOG.warning("Sources for merging cannot be null.");
            throw new NullPointerException("Sources for merging cannot be null.");
        }
        if (destination == null) {
            LOG.warning("Destination for merging cannot be null.");
            throw new NullPointerException("Destination for merging cannot be null.");
        }
        this.source2File = new File(source2);
        if (!this.source1File.exists() || !this.source2File.exists()) {
            LOG.warning("Sources for merging must be existing files.");
            throw new IllegalArgumentException("Sources for merging must be existing files.");
        }
        this.destinationFile = new File(destination);
        if (!this.destinationFile.exists()) {
            this.destinationFile.createNewFile();
        }
        if (!this.destinationFile.canWrite() || this.destinationFile.isDirectory()) {
            LOG.warning("Cannot write to file: " + this.destinationFile.getAbsolutePath());
            throw new IOException("Cannot write to file: " + this.destinationFile.getAbsolutePath());
        }
    }

    public void startMerge() {
        this.mergeThread = new MergeThread(TranscriptionMerger.class.getName());
        this.mergeThread.start();
    }

    private void firstTranscription() {
        block3: {
            if (this.transcription == null) {
                this.progressUpdate(5, "Loading first source file...");
                try {
                    this.destTranscription = new TranscriptionImpl(this.source1File.getAbsolutePath());
                    this.destTranscription.setNotifying(false);
                    this.destTranscription.setChanged();
                    this.progressUpdate(15, "First transcription loaded...");
                    LOG.info("First transcription loaded...");
                }
                catch (Exception rex) {
                    this.progressInterrupt("Could not load the first source file...");
                    LOG.warning("Could not load the first source file...");
                    if (this.mergeThread == null) break block3;
                    this.mergeThread.interrupt();
                }
            }
        }
    }

    private void secondTranscription() {
        block2: {
            this.progressUpdate(20, "Loading second source file...");
            try {
                this.transcription2 = new TranscriptionImpl(this.source2File.getAbsolutePath());
                this.progressUpdate(30, "Second transcription loaded...");
                LOG.info("Second transcription loaded...");
            }
            catch (Exception rex) {
                this.progressInterrupt("Could not load the second source file...");
                LOG.warning("Could not load the second source file...");
                if (this.mergeThread == null) break block2;
                this.mergeThread.interrupt();
            }
        }
    }

    private void mergeTranscriptions() {
        block11: {
            this.progressUpdate(30, "Adding Tiers, LinguisticTypes and ControlledVocabularies...");
            try {
                DefaultMutableTreeNode node;
                int i;
                int i2;
                Vector firstTiers = this.destTranscription.getTiers();
                Vector secondTiers = this.transcription2.getTiers();
                Vector<Object> tiersToAdd = new Vector<Object>();
                Hashtable<String, TierImpl> firstTierTable = new Hashtable<String, TierImpl>();
                TierImpl t = null;
                String name = null;
                for (i2 = 0; i2 < firstTiers.size(); ++i2) {
                    t = (TierImpl)firstTiers.get(i2);
                    name = t.getName();
                    firstTierTable.put(name, t);
                }
                for (i2 = 0; i2 < secondTiers.size(); ++i2) {
                    t = (TierImpl)secondTiers.get(i2);
                    name = t.getName();
                    if (firstTierTable.containsKey(name)) continue;
                    tiersToAdd.add(t);
                    LOG.info("Adding tier to list of tiers: " + t.getName());
                }
                DefaultMutableTreeNode sortedRootNode = new DefaultMutableTreeNode("sortRoot");
                Hashtable<TierImpl, DefaultMutableTreeNode> nodes = new Hashtable<TierImpl, DefaultMutableTreeNode>();
                for (i = 0; i < tiersToAdd.size(); ++i) {
                    t = (TierImpl)tiersToAdd.get(i);
                    node = new DefaultMutableTreeNode(t);
                    nodes.put(t, node);
                }
                for (i = 0; i < tiersToAdd.size(); ++i) {
                    t = (TierImpl)tiersToAdd.get(i);
                    if (t.getParentTier() == null || !tiersToAdd.contains(t.getParentTier())) {
                        node = (DefaultMutableTreeNode)nodes.get(t);
                        sortedRootNode.add((DefaultMutableTreeNode)nodes.get(t));
                        continue;
                    }
                    ((DefaultMutableTreeNode)nodes.get(t.getParentTier())).add((DefaultMutableTreeNode)nodes.get(t));
                }
                tiersToAdd.clear();
                Enumeration<TreeNode> en = sortedRootNode.breadthFirstEnumeration();
                while (en.hasMoreElements()) {
                    node = (DefaultMutableTreeNode)en.nextElement();
                    if (!(node.getUserObject() instanceof TierImpl)) continue;
                    tiersToAdd.add(node.getUserObject());
                }
                this.addTiersTypesAndCVs(tiersToAdd);
                int tierStartProgress = 45;
                int numTopTiers = Math.max(sortedRootNode.getChildCount(), 1);
                this.progressUpdate(tierStartProgress, "Start adding annotations...");
                int progressPerIndepTier = 40 / numTopTiers;
                int tierNum = 1;
                String busy = "...";
                Enumeration<TreeNode> topTierEnum = sortedRootNode.children();
                while (topTierEnum.hasMoreElements()) {
                    DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)topTierEnum.nextElement();
                    Object o = node2.getUserObject();
                    if (!(o instanceof TierImpl)) continue;
                    TierImpl tier = (TierImpl)o;
                    this.progressUpdate(tierStartProgress, "Merging tier: " + tier.getName());
                    LOG.info("Merging tier: " + tier.getName());
                    Vector annotations = tier.getAnnotations();
                    int numAnn = annotations.size();
                    if (numAnn > 0) {
                        int ppa = progressPerIndepTier / numAnn;
                        AbstractAnnotation ann = null;
                        DefaultMutableTreeNode recordNode = null;
                        for (int i3 = 0; i3 < numAnn; ++i3) {
                            ann = (AbstractAnnotation)annotations.get(i3);
                            recordNode = AnnotationRecreator.createTreeForAnnotation(ann);
                            AnnotationRecreator.createAnnotationFromTree(this.destTranscription, recordNode);
                            this.progressUpdate(tierStartProgress + ppa * i3, busy);
                        }
                        LOG.info("Added " + numAnn + " annotations to " + tier.getName());
                    }
                    this.progressUpdate(tierStartProgress + tierNum * progressPerIndepTier, "Done merging tier: " + tier.getName());
                    LOG.info("Done merging tier: " + tier.getName());
                    ++tierNum;
                }
                this.progressUpdate(85, "Saving transcription...");
                TranscriptionStore transcriptionStore = ACMTranscriptionStore.getCurrentTranscriptionStore();
                transcriptionStore.storeTranscription(this.destTranscription, null, new Vector(), this.destinationFile.getAbsolutePath(), 0);
                LOG.info("Transcription saved to: " + this.destinationFile.getAbsolutePath());
                this.progressComplete("Completed merging transcription...");
            }
            catch (Exception rex) {
                this.progressInterrupt("Error while merging: " + rex.getMessage());
                if (this.mergeThread == null) break block11;
                this.mergeThread.interrupt();
            }
        }
    }

    private void addTiersTypesAndCVs(Vector tiersToAdd) {
        Vector destTypes;
        ControlledVocabulary cv;
        String typeName;
        LinguisticType lt;
        TierImpl t;
        int i;
        if (tiersToAdd == null || this.destTranscription == null || this.transcription2 == null) {
            LOG.warning("Transcription or tiers null");
            return;
        }
        Hashtable<String, ControlledVocabulary> renamedCVS = new Hashtable<String, ControlledVocabulary>();
        Hashtable<String, LinguisticType> renamedTypes = new Hashtable<String, LinguisticType>();
        ArrayList<LinguisticType> typesToAdd = new ArrayList<LinguisticType>();
        ArrayList<ControlledVocabulary> cvsToAdd = new ArrayList<ControlledVocabulary>();
        LinguisticType lt2 = null;
        ControlledVocabulary cv2 = null;
        for (i = 0; i < tiersToAdd.size(); ++i) {
            t = (TierImpl)tiersToAdd.get(i);
            lt = t.getLinguisticType();
            if (!typesToAdd.contains(lt)) {
                typesToAdd.add(lt);
            }
            typeName = lt.getLinguisticTypeName();
            if (!lt.isUsingControlledVocabulary() || cvsToAdd.contains(cv = this.transcription2.getControlledVocabulary(lt.getControlledVocabylaryName()))) continue;
            cvsToAdd.add(cv);
        }
        for (i = 0; i < cvsToAdd.size(); ++i) {
            cv = (ControlledVocabulary)cvsToAdd.get(i);
            cv2 = this.destTranscription.getControlledVocabulary(cv.getName());
            if (cv2 == null) {
                this.destTranscription.addControlledVocabulary(cv);
                LOG.info("Added Controlled Vocabulary: " + cv.getName());
                continue;
            }
            if (cv.equals(cv2)) continue;
            String newCVName = cv.getName() + "-copy";
            renamedCVS = new Hashtable();
            LOG.info("Renamed Controlled Vocabulary: " + cv.getName() + " to " + newCVName);
            renamedCVS.put(cv.getName(), cv);
            cv.setName(newCVName);
            this.destTranscription.addControlledVocabulary(cv);
            LOG.info("Added Controlled Vocabulary: " + cv.getName());
        }
        for (i = 0; i < typesToAdd.size(); ++i) {
            lt = (LinguisticType)typesToAdd.get(i);
            typeName = lt.getLinguisticTypeName();
            if (lt.isUsingControlledVocabulary() && renamedCVS.containsKey(lt.getControlledVocabylaryName())) {
                cv2 = (ControlledVocabulary)renamedCVS.get(lt.getControlledVocabylaryName());
                lt.setControlledVocabularyName(cv2.getName());
            }
            if ((destTypes = this.destTranscription.getLinguisticTypes()).contains(lt)) continue;
            lt2 = null;
            boolean typeNameExists = false;
            for (int j = 0; j < destTypes.size(); ++j) {
                lt2 = (LinguisticType)destTypes.get(j);
                if (!lt.getLinguisticTypeName().equals(lt2.getLinguisticTypeName())) continue;
                typeNameExists = true;
                break;
            }
            if (!typeNameExists) {
                this.destTranscription.addLinguisticType(lt);
                LOG.info("Added Linguistic Type: " + lt.getLinguisticTypeName());
                continue;
            }
            if (lt.equals(lt2)) continue;
            String newLTName = lt.getLinguisticTypeName() + "-copy";
            renamedTypes = new Hashtable();
            LOG.info("Renamed Linguistic Type: " + lt.getLinguisticTypeName() + " to " + newLTName);
            renamedTypes.put(lt.getLinguisticTypeName(), lt);
            lt.setLinguisticTypeName(newLTName);
            this.destTranscription.addLinguisticType(lt);
            LOG.info("Added Linguistic Type: " + lt.getLinguisticTypeName());
        }
        for (i = 0; i < tiersToAdd.size(); ++i) {
            t = (TierImpl)tiersToAdd.get(i);
            TierImpl t2 = (TierImpl)t.getParentTier();
            String parentTierName = null;
            if (t2 != null) {
                parentTierName = t2.getName();
            }
            TierImpl newTier = null;
            if (parentTierName == null) {
                newTier = new TierImpl(t.getName(), t.getParticipant(), this.destTranscription, null);
            } else {
                t2 = (TierImpl)this.destTranscription.getTierWithId(parentTierName);
                if (t2 != null) {
                    newTier = new TierImpl(t2, t.getName(), t.getParticipant(), this.destTranscription, null);
                } else {
                    LOG.warning("The parent tier: " + parentTierName + " for tier: " + t.getName() + " was not found in the destination transcription");
                }
            }
            if (newTier == null) continue;
            lt = t.getLinguisticType();
            destTypes = this.destTranscription.getLinguisticTypes();
            if (destTypes.contains(lt)) {
                newTier.setLinguisticType(lt);
                if (this.destTranscription.getTierWithId(newTier.getName()) == null) {
                    this.destTranscription.addTier(newTier);
                    LOG.info("Created and added tier to destination: " + newTier.getName());
                }
            } else {
                LOG.warning("Could not add tier: " + newTier.getName() + " because the Linguistic Type was not found in the destination transcription.");
            }
            newTier.setDefaultLocale(t.getDefaultLocale());
            newTier.setAnnotator(t.getAnnotator());
        }
    }

    private void progressUpdate(int percent, String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((ProgressListener)this.listeners.get(i)).progressUpdated(this, percent, message);
            }
        }
    }

    private void progressComplete(String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((ProgressListener)this.listeners.get(i)).progressCompleted(this, message);
            }
        }
    }

    private void progressInterrupt(String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((ProgressListener)this.listeners.get(i)).progressInterrupted(this, message);
            }
        }
    }

    public synchronized void addProgressListener(ProgressListener pl) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(2);
        }
        this.listeners.add(pl);
    }

    public synchronized void removeProgressListener(ProgressListener pl) {
        if (pl != null && this.listeners != null) {
            this.listeners.remove(pl);
        }
    }

    class MergeThread
    extends Thread {
        public MergeThread() {
        }

        public MergeThread(String name) {
            super(name);
        }

        public void run() {
            TranscriptionMerger.this.firstTranscription();
            TranscriptionMerger.this.secondTranscription();
            TranscriptionMerger.this.mergeTranscriptions();
        }

        public void interrupt() {
            LOG.warning("Merge thread interrupted.");
            TranscriptionMerger.this.progressInterrupt("Merging interrupted...");
            super.interrupt();
        }
    }
}

