/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.integration;

import java.io.IOException;
import java.util.HashMap;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class IMDISessionParser {
    public static final String EAF = "text/x-eaf+xml";
    private XMLReader reader;
    private HashMap filesMap = new HashMap(3);

    public IMDISessionParser() {
        try {
            this.reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            this.reader.setFeature("http://xml.org/sax/features/namespaces", true);
            this.reader.setContentHandler(new SessionHandler());
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public void parse(String pathToImdiSession) throws IOException, SAXException {
        if (pathToImdiSession == null) {
            return;
        }
        this.reader.parse(pathToImdiSession);
    }

    public HashMap getFilesMap() {
        return this.filesMap;
    }

    public static void main(String[] args) {
        if (args != null && args.length > 0) {
            try {
                new IMDISessionParser().parse(args[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class SessionHandler
    implements ContentHandler {
        private final String MF = "MediaFile";
        private final String WRITTEN_RES = "WrittenResource";
        private final String LINK = "ResourceLink";
        private final String TYPE = "Type";
        private final String FORMAT = "Format";
        private final String VIDEO = "video";
        private final String AUDIO = "audio";
        private String curResLink;
        private String curContent;
        private String curFormat;
        private String curType;

        SessionHandler() {
        }

        public void endDocument() throws SAXException {
        }

        public void startDocument() throws SAXException {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.curContent = new String(ch, start, length);
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void skippedEntity(String name) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (localName.equals("Type")) {
                this.curType = this.curContent;
            } else if (localName.equals("Format")) {
                this.curFormat = this.curContent;
            } else if (localName.equals("ResourceLink")) {
                this.curResLink = this.curContent;
            } else if (localName.equals("WrittenResource")) {
                if (this.curFormat.equalsIgnoreCase(IMDISessionParser.EAF) && !IMDISessionParser.this.filesMap.containsKey(IMDISessionParser.EAF) && this.curResLink != null && this.curResLink.length() > 0) {
                    IMDISessionParser.this.filesMap.put(IMDISessionParser.EAF, this.curResLink);
                }
                this.resetFields();
            } else if (localName.equals("MediaFile")) {
                if (this.curType.equalsIgnoreCase("video")) {
                    if (!IMDISessionParser.this.filesMap.containsKey("video") && this.curResLink != null && this.curResLink.length() > 0) {
                        IMDISessionParser.this.filesMap.put("video", this.curResLink);
                    }
                } else if (this.curType.equalsIgnoreCase("audio") && !IMDISessionParser.this.filesMap.containsKey("audio") && this.curResLink != null && this.curResLink.length() > 0) {
                    IMDISessionParser.this.filesMap.put("audio", this.curResLink);
                }
                this.resetFields();
            }
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        }

        void resetFields() {
            this.curResLink = null;
            this.curContent = null;
            this.curFormat = null;
            this.curType = null;
        }
    }
}

