/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.interlinear.BlockMetrics;
import mpi.eudico.client.annotator.interlinear.PixelRenderer;
import mpi.eudico.client.annotator.interlinear.ToolboxMetrics;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class Interlinear {
    public static final int CM = 0;
    public static final int INCH = 1;
    public static final int PIXEL = 2;
    public static final int NUM_CHARACTERS = 3;
    public static final int EACH_BLOCK = 0;
    public static final int BLOCK_BOUNDARY = 1;
    public static final int WITHIN_BLOCKS = 2;
    public static final int NO_WRAP = 3;
    public static final int NEXT_LINE = 4;
    public static final int END_OF_BLOCK = 5;
    public static final int HHMMSSMS = 0;
    public static final int SSMS = 1;
    public static final int MS = 2;
    public static final int ONE_DIGITS = 1;
    public static final int TWO_DIGITS = 2;
    public static final int THREE_DIGITS = 3;
    public static final int PIXELS = 0;
    public static final int BYTES = 1;
    public static final int CHARACTERS = 2;
    public static final int DEFAULT_FONT_SIZE = 12;
    public static Font DEFAULTFONT = new Font("MS Arial Unicode", 0, 12);
    public static Font MONOSPACED_FONT = new Font("Monospaced", 0, 12);
    public static final int TIMECODE_FONT_SIZE = 10;
    public static final int TEMPLATE = 0;
    public static final int HIDE_EMPTY_LINES = 1;
    public static final int EXTERNALLY_SPECIFIED = 0;
    public static final int TIER_HIERARCHY = 1;
    public static final int BY_LINGUISTIC_TYPE = 2;
    public static final int BY_PARTICIPANT = 3;
    public static final int USER_DEFINED = 4;
    public static final int SINGLE_TIMECODE = 0;
    public static final int MULTIPLE_TIMECODE = 1;
    public static final int MIN_SILENCE = 20;
    public static final int UTF8 = 0;
    public static final int ISOLATIN = 1;
    public static final int SIL = 2;
    public static final int PRINT = 100;
    public static final int INTERLINEAR_TEXT = 101;
    public static final int SHOEBOX_TEXT = 102;
    public static final int HTML = 103;
    public static final int DEFAULT_NUM_CHARS = 80;
    public static final int LABEL_VALUE_MARGIN = 3;
    public static final int DEFAULT_TEXT_BLOCK_SPACING = 2;
    private final TranscriptionImpl transcription;
    private int width;
    private int height;
    private ArrayList visibleTiers;
    private boolean tierLabelsShown;
    private long[] visibleTimeInterval;
    private int blockWrapStyle;
    private int lineWrapStyle;
    private boolean timeCodeShown;
    private int timeCodeType;
    private boolean playSoundSel;
    private String mediaURL;
    private HashMap fonts;
    private HashMap fontSizes;
    private boolean emptySlotsShown;
    private int lineSpacing;
    private int blockSpacing = -1;
    private int emptySpace;
    private Annotation activeAnnotation;
    private long[] selection;
    private long mediaTime;
    private int alignmentUnit;
    private int emptyLineStyle;
    private int sortingStyle;
    private HashMap charEncodings;
    private int outputMode;
    private int timeCodeMultiplicity;
    private BlockMetrics metrics;
    private int pageHeight;
    private boolean selectionOnly = false;
    private long timeOffset = 0L;
    private boolean insertTabs = false;
    private boolean tabsReplaceSpaces = false;
    private boolean showPageNumber = true;
    public int pageNumberAreaHeight = 14;
    private final String EMPTY = "";
    private boolean showSilenceDuration = false;
    private int minSilenceDuration;
    private int noOfDecimalDigits;
    final String prefSelectionOnly = "Interlinear.SelectionOnly";
    final String prefSilenceDurationShown = "Interlinear.SilenceDurationShown";
    final String prefMinSilenceDurationValue = "Interlinear.MinSilenceDurationValue";
    final String prefNoOfDecimalDigits = "Interlinear.prefNoOfDecimalDigits";
    final String prefLabelsShown = "Interlinear.LabelsShown";
    final String prefTimeCodeShown = "Interlinear.TimeCodeShown";
    final String prefEmptyLineStyle = "Interlinear.EmptyLineStyle";
    final String prefTimeCodeType = "Interlinear.TimeCodeType";
    final String prefPlaySoundSel = "Interlinear.PlayMediaSel";
    final String prefBlockWrapStyle = "Interlinear.BlockWrapStyle";
    final String prefLineWrapStyle = "Interlinear.LineWrapStyle";
    final String prefBlockSpacing = "Interlinear.BlockSpacing";
    final String prefBlockSpacingTextOut = "Interlinear.BlockSpacing.Text";
    final String prefLineSpacing = "Interlinear.LineSpacing";
    final String prefTierSortingStyle = "Interlinear.TierSortingStyle";
    final String prefVisibleTiers = "Interlinear.VisibleTiers";
    final String prefTierOrder = "Interlinear.TierOrder";
    final String prefFontSizes = "Interlinear.FontSizes";
    final String prefNumCharPerLine = "Interlinear.NumCharPerLine";
    final String prefHTMLPixWidth = "Interlinear.HTMLPixWidth";
    final String prefInsertTab = "Interlinear.InsertSpace";
    final String prefTabsInsteadOfSpaces = "Interlinear.TabsInsteadOfSpaces";
    final String prefPageNumber = "Interlinear.PageNumber";

    public Interlinear(TranscriptionImpl tr) {
        this(tr, 100);
    }

    public Interlinear(TranscriptionImpl tr, int mode) {
        this.transcription = tr;
        this.outputMode = mode < 100 || mode > 103 ? 100 : mode;
        this.metrics = mode == 102 ? new ToolboxMetrics(this) : new BlockMetrics(this);
        this.setDefaultValues();
    }

    private void resetMetrics() {
        this.metrics.reset();
    }

    private void setDefaultValues() {
        if (this.outputMode == 100) {
            this.width = 550;
            this.height = this.pageHeight = 600;
            this.alignmentUnit = 0;
            this.blockSpacing = 0;
            this.emptySpace = 10;
            this.emptySlotsShown = false;
        } else if (this.outputMode == 101) {
            this.width = 80;
            this.pageHeight = this.height = 800;
            this.alignmentUnit = 2;
            this.emptySpace = 1;
            this.emptySlotsShown = false;
        } else if (this.outputMode == 102) {
            this.width = 80;
            this.pageHeight = this.height = 800;
            this.alignmentUnit = 2;
            this.emptySpace = 1;
            this.emptySlotsShown = false;
        } else {
            this.width = 800;
            this.pageHeight = 800;
            this.height = 800;
            this.alignmentUnit = 0;
            this.emptySpace = 10;
            this.emptySlotsShown = true;
        }
        this.tierLabelsShown = true;
        this.blockWrapStyle = 1;
        this.lineWrapStyle = 4;
        this.timeCodeShown = false;
        this.timeCodeType = 0;
        this.minSilenceDuration = 20;
        this.noOfDecimalDigits = 2;
        this.emptyLineStyle = 1;
        this.sortingStyle = 0;
        this.timeCodeMultiplicity = 1;
        this.visibleTiers = new ArrayList();
        this.fonts = new HashMap();
        this.fontSizes = new HashMap();
        this.charEncodings = new HashMap();
        if (this.transcription != null) {
            this.visibleTiers.addAll(this.transcription.getTiers());
            for (TierImpl t : this.visibleTiers) {
                if (this.outputMode == 100 || this.outputMode == 103) {
                    this.setFont(t.getName(), DEFAULTFONT);
                } else {
                    this.setFont(t.getName(), MONOSPACED_FONT);
                }
                this.setFontSize(t.getName(), 12);
            }
        }
        this.loadPreferences();
    }

    public void savePreferences() {
        Preferences.set("Interlinear.SelectionOnly", new Boolean(this.selectionOnly), (Transcription)this.transcription);
        Preferences.set("Interlinear.BlockWrapStyle", this.blockWrapStyle, null);
        Preferences.set("Interlinear.LabelsShown", new Boolean(this.tierLabelsShown), null);
        Preferences.set("Interlinear.LineSpacing", this.lineSpacing, null);
        Preferences.set("Interlinear.LineWrapStyle", this.lineWrapStyle, null);
        Preferences.set("Interlinear.TierSortingStyle", this.sortingStyle, null);
        Preferences.set("Interlinear.TimeCodeType", this.timeCodeType, null);
        Preferences.set("Interlinear.TimeCodeShown", new Boolean(this.timeCodeShown), null);
        Preferences.set("Interlinear.EmptyLineStyle", this.emptyLineStyle, null);
        Preferences.set("Interlinear.PlayMediaSel", new Boolean(this.playSoundSel), null);
        if (this.showSilenceDuration) {
            Preferences.set("Interlinear.SilenceDurationShown", new Boolean(this.showSilenceDuration), null);
            Preferences.set("Interlinear.MinSilenceDurationValue", this.minSilenceDuration, null);
            Preferences.set("Interlinear.prefNoOfDecimalDigits", this.noOfDecimalDigits, null);
        } else {
            Preferences.set("Interlinear.SilenceDurationShown", new Boolean(this.showSilenceDuration), null);
        }
        String[] tierNames = new String[this.visibleTiers.size()];
        for (int i = 0; i < this.visibleTiers.size(); ++i) {
            tierNames[i] = ((Tier)this.visibleTiers.get(i)).getName();
        }
        Preferences.set("Interlinear.VisibleTiers", tierNames, (Transcription)this.transcription);
        if (this.outputMode == 100) {
            Preferences.set("Interlinear.FontSizes", this.fontSizes, (Transcription)this.transcription);
            Preferences.set("Interlinear.BlockSpacing", this.blockSpacing, null);
            Preferences.set("Interlinear.PageNumber", new Boolean(this.showPageNumber), null);
        } else if (this.outputMode == 103) {
            Preferences.set("Interlinear.FontSizes", this.fontSizes, (Transcription)this.transcription);
            Preferences.set("Interlinear.HTMLPixWidth", this.getWidth(), null);
            Preferences.set("Interlinear.BlockSpacing.Text", this.blockSpacing, null);
        } else {
            Preferences.set("Interlinear.NumCharPerLine", this.width, null);
            Preferences.set("Interlinear.BlockSpacing.Text", this.blockSpacing, null);
            if (this.outputMode == 101) {
                Preferences.set("Interlinear.InsertSpace", new Boolean(this.insertTabs), null);
                Preferences.set("Interlinear.TabsInsteadOfSpaces", new Boolean(this.tabsReplaceSpaces), null);
            }
        }
    }

    void loadPreferences() {
        Object curPref = Preferences.get("Interlinear.SelectionOnly", this.transcription);
        if (curPref instanceof Boolean) {
            this.setSelectionOnly((Boolean)curPref);
        }
        if ((curPref = Preferences.get("Interlinear.EmptyLineStyle", null)) instanceof Integer) {
            this.setEmptyLineStyle((Integer)curPref);
        }
        if ((curPref = Preferences.get("Interlinear.BlockWrapStyle", null)) instanceof Integer) {
            this.setBlockWrapStyle((Integer)curPref);
        }
        if ((curPref = Preferences.get("Interlinear.LineWrapStyle", null)) instanceof Integer) {
            this.setLineWrapStyle((Integer)curPref);
        }
        if ((curPref = Preferences.get("Interlinear.LabelsShown", null)) instanceof Boolean) {
            this.setTierLabelsShown((Boolean)curPref);
        }
        if ((curPref = Preferences.get("Interlinear.TimeCodeShown", null)) instanceof Boolean) {
            this.setTimeCodeShown((Boolean)curPref);
        }
        if ((curPref = Preferences.get("Interlinear.TimeCodeType", null)) instanceof Integer) {
            this.setTimeCodeType((Integer)curPref);
        }
        if ((curPref = Preferences.get("Interlinear.PlayMediaSel", null)) instanceof Boolean) {
            this.setPlaySoundSel((Boolean)curPref);
        }
        if ((curPref = Preferences.get("Interlinear.SilenceDurationShown", null)) instanceof Boolean) {
            this.setShowSilenceDuration((Boolean)curPref);
        }
        if ((curPref = Preferences.get("Interlinear.MinSilenceDurationValue", null)) instanceof Integer) {
            this.setMinSilenceDuration((Integer)curPref);
        }
        if ((curPref = Preferences.get("Interlinear.prefNoOfDecimalDigits", null)) instanceof Integer) {
            this.setNumOfDecimalDigits((Integer)curPref);
        }
        if ((curPref = Preferences.get("Interlinear.VisibleTiers", this.transcription)) instanceof String[] || curPref instanceof ArrayList) {
            int i;
            ArrayList<TierImpl> allVis = new ArrayList<TierImpl>();
            String name = null;
            TierImpl t = null;
            if (curPref instanceof String[]) {
                String[] vis = (String[])curPref;
                for (i = 0; i < vis.length; ++i) {
                    name = vis[i];
                    t = (TierImpl)this.transcription.getTierWithId(name);
                    if (t == null) continue;
                    allVis.add(t);
                }
            } else {
                ArrayList visList = (ArrayList)curPref;
                for (i = 0; i < visList.size(); ++i) {
                    name = (String)visList.get(i);
                    t = (TierImpl)this.transcription.getTierWithId(name);
                    if (t == null) continue;
                    allVis.add(t);
                }
            }
            Object allOrdered = Preferences.get("Interlinear.TierOrder", this.transcription);
            ArrayList at = new ArrayList();
            if (allOrdered instanceof ArrayList) {
                at = (ArrayList)allOrdered;
            }
            Vector v = this.transcription.getTiers();
            for (int j = 0; j < v.size(); ++j) {
                t = (TierImpl)v.get(j);
                name = t.getName();
                if (allVis.contains(t) || at.contains(name)) continue;
                allVis.add(t);
            }
            this.setVisibleTiers(allVis);
        }
        if (this.outputMode == 100 || this.outputMode == 103) {
            curPref = Preferences.get("Interlinear.FontSizes", this.transcription);
            if (curPref instanceof HashMap) {
                this.fontSizes = (HashMap)curPref;
                for (String tierName : this.fontSizes.keySet()) {
                    Object size = this.fontSizes.get(tierName);
                    if (!(size instanceof Integer)) continue;
                    this.setFontSize(tierName, (Integer)size);
                }
            }
            if ((curPref = Preferences.get("TierFonts", this.transcription)) instanceof HashMap) {
                HashMap foMap = (HashMap)curPref;
                Iterator keyIt = foMap.keySet().iterator();
                String key = null;
                Font ft = null;
                while (keyIt.hasNext()) {
                    key = (String)keyIt.next();
                    ft = (Font)foMap.get(key);
                    if (key == null || ft == null) continue;
                    this.setFont(key, ft);
                }
            }
            if ((curPref = Preferences.get("Interlinear.LineSpacing", null)) instanceof Integer) {
                this.setLineSpacing((Integer)curPref);
            }
            if ((curPref = Preferences.get("Interlinear.BlockSpacing", null)) instanceof Integer) {
                this.setBlockSpacing((Integer)curPref);
            }
            if (this.outputMode == 100 && (curPref = Preferences.get("Interlinear.PageNumber", null)) instanceof Boolean) {
                this.setShowPageNumber((Boolean)curPref);
            }
        }
        if (this.outputMode == 103) {
            curPref = Preferences.get("Interlinear.HTMLPixWidth", null);
            if (curPref instanceof Integer) {
                this.setWidth((Integer)curPref);
            }
            if ((curPref = Preferences.get("Interlinear.BlockSpacing.Text", null)) instanceof Integer) {
                this.setBlockSpacing((Integer)curPref);
            }
        } else if (this.outputMode != 100) {
            curPref = Preferences.get("Interlinear.NumCharPerLine", null);
            if (curPref instanceof Integer) {
                this.setWidth((Integer)curPref);
            }
            if ((curPref = Preferences.get("Interlinear.BlockSpacing.Text", null)) instanceof Integer) {
                this.setBlockSpacing((Integer)curPref);
            }
        }
        if (this.outputMode == 101) {
            curPref = Preferences.get("Interlinear.InsertSpace", null);
            if (curPref instanceof Boolean) {
                this.setInsertTabs((Boolean)curPref);
            }
            if ((curPref = Preferences.get("Interlinear.TabsInsteadOfSpaces", null)) instanceof Boolean) {
                this.setTabsReplaceSpaces((Boolean)curPref);
            }
        }
    }

    public void renderView(BufferedImage bi) {
        this.calculateMetrics(bi.getGraphics());
    }

    public void renderView() {
        this.calculateMetrics();
    }

    public boolean renderPage(Graphics g, int pageIndex) {
        if (this.alignmentUnit == 0) {
            PixelRenderer.render(this, g, pageIndex);
            return true;
        }
        return false;
    }

    protected void calculateMetrics(Graphics graphics) {
        this.resetMetrics();
        this.metrics.calculateAnnotationBlocks(graphics);
        this.metrics.calculatePrintBlocks();
        this.metrics.calculatePageBreaks();
        this.setHeight(this.pageHeight * this.metrics.getPageBreaks().size());
    }

    protected void calculateMetrics() {
        this.resetMetrics();
        this.metrics.calculateAnnotationBlocks(null);
        this.metrics.calculatePrintBlocks();
        this.metrics.calculatePageBreaks();
    }

    public void drawViewOnImage(BufferedImage bi, int[] offset) {
        if (this.alignmentUnit == 0) {
            PixelRenderer.render(this, bi, offset);
        } else {
            PixelRenderer.renderCharacterPreview(this, bi, offset);
        }
    }

    public Annotation getActiveAnnotation() {
        return this.activeAnnotation;
    }

    public int getAlignmentUnit() {
        return this.alignmentUnit;
    }

    public int getBlockWrapStyle() {
        return this.blockWrapStyle;
    }

    public boolean isEmptySlotsShown() {
        return this.emptySlotsShown;
    }

    public Font getFont(String tierName) {
        Font f = (Font)this.fonts.get(tierName);
        if (f == null) {
            f = DEFAULTFONT;
        }
        return f;
    }

    public int getFontSize(String tierName) {
        int size = 0;
        Integer sizeInt = (Integer)this.fontSizes.get(tierName);
        size = sizeInt != null ? sizeInt : 12;
        return size;
    }

    public int getHeight() {
        if (this.height > 0) {
            return this.height;
        }
        return 0;
    }

    public int getLineSpacing() {
        return this.lineSpacing;
    }

    public int getBlockSpacing() {
        if (this.blockSpacing < 0) {
            if (this.outputMode == 100) {
                return 20 + 3 * this.getLineSpacing();
            }
            return 2;
        }
        return this.blockSpacing;
    }

    public void setBlockSpacing(int blockSpacing) {
        this.blockSpacing = blockSpacing;
    }

    public int getLineWrapStyle() {
        return this.lineWrapStyle;
    }

    public String getMediaURL() throws IOException {
        Vector mds = this.transcription.getMediaDescriptors();
        if (mds != null && mds.size() > 0) {
            MediaDescriptor md = (MediaDescriptor)mds.get(0);
            if (md.mediaURL != null && !md.mediaURL.equals("")) {
                this.mediaURL = md.mediaURL;
            }
        } else {
            this.mediaURL = "";
        }
        return this.mediaURL;
    }

    public boolean isMediaVideo() {
        Vector mds = this.transcription.getMediaDescriptors();
        if (mds != null && mds.size() > 0) {
            MediaDescriptor md = (MediaDescriptor)mds.get(0);
            if (md.mimeType != null && md.mimeType.startsWith("video")) {
                return true;
            }
        }
        return false;
    }

    public long getMediaTime() {
        return this.mediaTime;
    }

    public long[] getSelection() {
        return this.selection;
    }

    public boolean isTierLabelsShown() {
        return this.tierLabelsShown;
    }

    public boolean isPlaySoundSel() {
        return this.playSoundSel;
    }

    public boolean isTimeCodeShown() {
        return this.timeCodeShown;
    }

    public int getTimeCodeType() {
        return this.timeCodeType;
    }

    public ArrayList getVisibleTiers() {
        return this.visibleTiers;
    }

    public long[] getVisibleTimeInterval() {
        return this.visibleTimeInterval;
    }

    public int getWidth() {
        if (this.width > 0) {
            return this.width;
        }
        return 0;
    }

    public void setActiveAnnotation(Annotation annotation) {
        this.activeAnnotation = annotation;
    }

    public void setAlignmentUnit(int i) {
        this.alignmentUnit = i;
    }

    public void setBlockWrapStyle(int i) {
        this.blockWrapStyle = i;
    }

    public void setEmptySlotsShown(boolean b) {
        this.emptySlotsShown = b;
    }

    public void setHeight(int i) {
        this.height = i;
    }

    public void setLineSpacing(int i) {
        this.lineSpacing = i;
    }

    public void setLineWrapStyle(int i) {
        this.lineWrapStyle = i;
    }

    public void setMediaTime(long l) {
        this.mediaTime = l;
    }

    public void setSelection(long[] ls) {
        this.selection = ls;
    }

    public void setTierLabelsShown(boolean show) {
        this.tierLabelsShown = show;
    }

    public void setTimeCodeShown(boolean b) {
        this.timeCodeShown = b;
    }

    public void setShowSilenceDuration(boolean b) {
        this.showSilenceDuration = b;
    }

    public boolean isShowSilenceDuration() {
        return this.showSilenceDuration;
    }

    public void setMinSilenceDuration(int i) {
        this.minSilenceDuration = i;
    }

    public int getMinSilenceDuration() {
        return this.minSilenceDuration;
    }

    public void setTimeCodeType(int i) {
        this.timeCodeType = i;
    }

    public void setPlaySoundSel(boolean b) {
        this.playSoundSel = b;
    }

    public int getNumOfDecimalDigits() {
        return this.noOfDecimalDigits;
    }

    public void setNumOfDecimalDigits(int digits) {
        this.noOfDecimalDigits = digits;
    }

    public void setVisibleTiers(String[] strings) {
        this.visibleTiers.clear();
        if (strings != null) {
            for (int i = 0; i < strings.length; ++i) {
                Tier t = this.transcription.getTierWithId(strings[i]);
                if (t == null) continue;
                this.visibleTiers.add(t);
            }
        }
    }

    public void setVisibleTiers(ArrayList visTiers) {
        if (visTiers != null) {
            this.visibleTiers = visTiers;
        } else {
            this.visibleTiers.clear();
        }
    }

    public void setVisibleTimeInterval(long[] ls) {
        this.visibleTimeInterval = ls;
    }

    public void setWidth(int i) {
        this.width = i;
    }

    public void setFont(String tierName, Font f) {
        int fontSize = this.getFontSize(tierName);
        f = f.deriveFont((float)fontSize);
        this.fonts.put(tierName, f);
    }

    public void setFontSize(String tierName, int size) {
        this.fontSizes.put(tierName, new Integer(size));
        this.fonts.put(tierName, this.getFont(tierName).deriveFont((float)size));
    }

    public int getEmptyLineStyle() {
        return this.emptyLineStyle;
    }

    public void setEmptyLineStyle(int i) {
        this.emptyLineStyle = i;
    }

    public int getSortingStyle() {
        return this.sortingStyle;
    }

    public void setSortingStyle(int i) {
        this.sortingStyle = i;
    }

    public TranscriptionImpl getTranscription() {
        return this.transcription;
    }

    public int getOutputMode() {
        return this.outputMode;
    }

    public void setOutputMode(int mode) {
        this.outputMode = mode;
    }

    public int getPageHeight() {
        return this.pageHeight;
    }

    public void setPageHeight(int height) {
        this.pageHeight = height;
    }

    public int getCharEncoding(String tierName) {
        int encoding = 0;
        if (tierName == null) {
            return encoding;
        }
        if (!this.charEncodings.containsKey(tierName)) {
            return encoding;
        }
        Integer encodingInt = (Integer)this.charEncodings.get(tierName);
        if (encodingInt != null) {
            encoding = encodingInt;
        }
        return encoding;
    }

    public void setCharEncoding(String tierName, int charEncoding) {
        this.charEncodings.put(tierName, new Integer(charEncoding));
    }

    public int getEmptySpace() {
        return this.emptySpace;
    }

    public BlockMetrics getMetrics() {
        return this.metrics;
    }

    public boolean isSelectionOnly() {
        return this.selectionOnly;
    }

    public void setSelectionOnly(boolean b) {
        this.selectionOnly = b;
    }

    public void setTimeCodeMultiplicity(int style) {
        this.timeCodeMultiplicity = style;
    }

    public int getTimeCodeMultiplicity() {
        return this.timeCodeMultiplicity;
    }

    public boolean isInsertTabs() {
        return this.insertTabs;
    }

    public void setInsertTabs(boolean insertTabs) {
        this.insertTabs = insertTabs;
    }

    public boolean isTabsReplaceSpaces() {
        return this.tabsReplaceSpaces;
    }

    public void setTabsReplaceSpaces(boolean tabsReplaceSpaces) {
        this.tabsReplaceSpaces = tabsReplaceSpaces;
    }

    public long getTimeOffset() {
        return this.timeOffset;
    }

    public void setTimeOffset(long timeOffset) {
        this.timeOffset = timeOffset;
    }

    public boolean isShowPageNumber() {
        return this.showPageNumber;
    }

    public void setShowPageNumber(boolean showPageNumber) {
        this.showPageNumber = showPageNumber;
    }
}

