/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear;

import java.util.ArrayList;
import mpi.eudico.client.annotator.interlinear.InterlinearAnnotation;
import mpi.eudico.client.annotator.interlinear.InterlinearTier;

public class InterlinearBlock {
    private boolean startOfAnnotationBlock = false;
    private ArrayList printTiers;
    private int occBlockWidth;

    public InterlinearBlock(ArrayList printTiers) {
        this.printTiers = printTiers;
    }

    public InterlinearTier getPrintTier(String tierName) {
        for (int i = 0; i < this.printTiers.size(); ++i) {
            InterlinearTier pt = (InterlinearTier)this.printTiers.get(i);
            if (!pt.getTierName().equals(tierName)) continue;
            return pt;
        }
        return null;
    }

    public ArrayList getPrintTiers() {
        return this.printTiers;
    }

    public int getNumberOfLines() {
        int lines = 0;
        for (int i = 0; i < this.printTiers.size(); ++i) {
            InterlinearTier pt = (InterlinearTier)this.printTiers.get(i);
            lines += pt.getNumLines();
        }
        return lines;
    }

    public void removeEmptyTiers() {
        for (int i = this.printTiers.size() - 1; i >= 0; --i) {
            InterlinearTier pt = (InterlinearTier)this.printTiers.get(i);
            if (pt.getAnnotations().size() == 0) {
                this.printTiers.remove(i);
                continue;
            }
            InterlinearAnnotation ia = null;
            int size = pt.getAnnotations().size();
            boolean empty = true;
            for (int j = 0; j < size; ++j) {
                ia = (InterlinearAnnotation)pt.getAnnotations().get(j);
                if (ia.getValue().equals("")) continue;
                empty = false;
                break;
            }
            if (!empty) continue;
            this.printTiers.remove(i);
        }
    }

    public void removeEmptySlotOnlyTiers() {
        InterlinearAnnotation ia = null;
        for (int i = this.printTiers.size() - 1; i >= 0; --i) {
            InterlinearTier pt = (InterlinearTier)this.printTiers.get(i);
            int size = pt.getAnnotations().size();
            boolean empty = true;
            for (int j = 0; j < size; ++j) {
                ia = (InterlinearAnnotation)pt.getAnnotations().get(j);
                if (ia.getValue().equals("")) continue;
                empty = false;
                break;
            }
            if (!empty) continue;
            this.printTiers.remove(i);
        }
    }

    public int getOccupiedBlockWidth() {
        return this.occBlockWidth;
    }

    public void setOccupiedBlockWidth(int occBlockWidth) {
        this.occBlockWidth = occBlockWidth;
        for (int i = 0; i < this.printTiers.size(); ++i) {
            ((InterlinearTier)this.printTiers.get(i)).setPrintWidth(occBlockWidth);
        }
    }

    public int calculateOccupiedBlockWidth() {
        int curWidth = 0;
        for (int i = 0; i < this.printTiers.size(); ++i) {
            int tWidth = ((InterlinearTier)this.printTiers.get(i)).getPrintAdvance();
            if (tWidth <= curWidth) continue;
            curWidth = tWidth;
        }
        return curWidth;
    }

    public boolean isStartOfAnnotationBlock() {
        return this.startOfAnnotationBlock;
    }

    public void setStartOfAnnotationBlock(boolean startOfAnnotationBlock) {
        this.startOfAnnotationBlock = startOfAnnotationBlock;
    }
}

