/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import mpi.eudico.client.annotator.commands.PrintCommand;
import mpi.eudico.client.annotator.interlinear.Interlinear;

public class InterlinearPrintable
implements Printable,
Pageable {
    private Interlinear interlinear;

    public InterlinearPrintable(Interlinear interlinear) {
        this.interlinear = interlinear;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        int pw = (int)pageFormat.getImageableWidth();
        int ph = (int)pageFormat.getImageableHeight();
        if (this.interlinear.getWidth() != pw || this.interlinear.getPageHeight() != ph) {
            this.interlinear.setWidth(pw);
            this.interlinear.setPageHeight(ph);
            this.interlinear.calculateMetrics(graphics);
        }
        if (pageIndex > this.getNumberOfPages() - 1) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        this.interlinear.renderPage(g2d, pageIndex);
        return 0;
    }

    public int getNumberOfPages() {
        return this.interlinear.getMetrics().getPageBreaks().size();
    }

    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        if (pageIndex < 0) {
            throw new IndexOutOfBoundsException("Page Index: " + pageIndex + " < 0");
        }
        if (pageIndex >= this.getNumberOfPages()) {
            throw new IndexOutOfBoundsException("Page Index: " + pageIndex + " > " + (this.getNumberOfPages() - 1));
        }
        return PrintCommand.pageFormat;
    }

    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        if (pageIndex < 0) {
            throw new IndexOutOfBoundsException("Page Index: " + pageIndex + " < 0");
        }
        if (pageIndex >= this.getNumberOfPages()) {
            throw new IndexOutOfBoundsException("Page Index: " + pageIndex + " > " + (this.getNumberOfPages() - 1));
        }
        return this;
    }
}

