/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear;

import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import mpi.eudico.client.annotator.interlinear.BlockMetrics;
import mpi.eudico.client.annotator.interlinear.EmptyPrintTier;
import mpi.eudico.client.annotator.interlinear.Interlinear;
import mpi.eudico.client.annotator.interlinear.InterlinearAnnotation;
import mpi.eudico.client.annotator.interlinear.InterlinearBlock;
import mpi.eudico.client.annotator.interlinear.InterlinearTier;
import mpi.eudico.client.annotator.interlinear.ToolboxRecordBlock;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.util.TimeFormatter;

public class ToolboxMetrics
extends BlockMetrics {
    private final String ELAN_BEGIN = "ELANBegin";
    private final String ELAN_END = "ELANEnd";
    private final String ELAN_PART = "ELANParticipant";
    private final String at = "@";
    private final String UNKNOWN = "unknown";
    private HashMap tierToMarkerMap;
    private List levelOneNonInterTiers;
    private List markerNames;
    private List markersWithBlank;
    private Tier beginTier;
    private Tier endTier;
    private Tier partTier;
    private ArrayList toolboxBlocks;

    public ToolboxMetrics(Interlinear interlinearizer) {
        super(interlinearizer);
        interlinearizer.setTimeCodeShown(false);
        this.tierToMarkerMap = new HashMap();
        this.markerNames = new ArrayList();
        this.markersWithBlank = new ArrayList();
        this.levelOneNonInterTiers = new ArrayList();
        this.toolboxBlocks = new ArrayList();
    }

    public void setVisibleMarkerNames(List markerNames) {
        if (markerNames == null) {
            this.interlinearizer.setVisibleTiers(new ArrayList(this.transcription.getTiers()));
            this.visibleTiers = this.interlinearizer.getVisibleTiers();
        } else {
            this.markerNames = markerNames;
            this.visibleTiers = new ArrayList();
            ArrayList allTiers = new ArrayList(this.transcription.getTiers());
            String name = null;
            String tierName = null;
            TierImpl tier = null;
            int atIndex = -1;
            for (int i = 0; i < markerNames.size(); ++i) {
                name = (String)markerNames.get(i);
                if (name.equals("ELANBegin")) {
                    this.beginTier = new TierImpl(name, null);
                    continue;
                }
                if (name.equals("ELANEnd")) {
                    this.endTier = new TierImpl(name, null);
                    continue;
                }
                if (!name.equals("ELANParticipant")) continue;
                this.partTier = new TierImpl(name, null);
            }
            for (int j = 0; j < allTiers.size(); ++j) {
                tier = (TierImpl)allTiers.get(j);
                tierName = tier.getName();
                atIndex = tierName.indexOf("@");
                if (atIndex > 0) {
                    if (!markerNames.contains(tierName = tierName.substring(0, atIndex))) continue;
                    this.visibleTiers.add(tier);
                    this.tierToMarkerMap.put(tier.getName(), tierName);
                    continue;
                }
                if (!markerNames.contains(tierName)) continue;
                this.visibleTiers.add(tier);
                this.tierToMarkerMap.put(tierName, tierName);
            }
            this.interlinearizer.setVisibleTiers(this.visibleTiers);
        }
    }

    public void setMarkersWithBlankLine(List markersWithBlank) {
        if (markersWithBlank != null) {
            this.markersWithBlank = markersWithBlank;
        }
    }

    public boolean isMarkerWithBlankLine(String markerName) {
        if (this.markersWithBlank != null && markerName != null) {
            return this.markersWithBlank.contains(markerName);
        }
        return false;
    }

    public void calculateAnnotationBlocks(Graphics g) {
        super.calculateAnnotationBlocks(g);
        DefaultMutableTreeNode curNode = null;
        DefaultMutableTreeNode rootNode = null;
        InterlinearAnnotation curAnn = null;
        long bt = 0L;
        long et = 0L;
        for (int i = 0; i < this.annotationBlocks.size(); ++i) {
            String part = null;
            rootNode = (DefaultMutableTreeNode)this.annotationBlocks.get(i);
            Enumeration<TreeNode> en = rootNode.breadthFirstEnumeration();
            while (en.hasMoreElements()) {
                curNode = (DefaultMutableTreeNode)en.nextElement();
                curAnn = (InterlinearAnnotation)curNode.getUserObject();
                String tierName = curAnn.getTierName();
                String nextTierName = (String)this.tierToMarkerMap.get(tierName);
                if (curNode.getLevel() == 1 && curAnn.type == 1 && !this.levelOneNonInterTiers.contains(nextTierName)) {
                    this.levelOneNonInterTiers.add(nextTierName);
                }
                if (curNode.isRoot()) {
                    bt = curAnn.bt;
                    et = curAnn.et;
                    int index = tierName.indexOf("@");
                    if (index > -1 && index < tierName.length() - 1) {
                        part = tierName.substring(index + 1);
                    }
                }
                curAnn.setTierName(nextTierName);
            }
            if (this.markerNames.contains("ELANBegin")) {
                InterlinearAnnotation la = new InterlinearAnnotation("ELANBegin", 1);
                if (this.interlinearizer.getTimeCodeType() == 0) {
                    la.setValue(TimeFormatter.toString(bt + this.interlinearizer.getTimeOffset()));
                } else if (this.interlinearizer.getTimeCodeType() == 1) {
                    la.setValue(TimeFormatter.toSSMSString(bt + this.interlinearizer.getTimeOffset()));
                } else {
                    la.setValue(String.valueOf(bt + this.interlinearizer.getTimeOffset()));
                }
                rootNode.add(new DefaultMutableTreeNode(la));
            }
            if (this.markerNames.contains("ELANEnd")) {
                InterlinearAnnotation la = new InterlinearAnnotation("ELANEnd", 1);
                if (this.interlinearizer.getTimeCodeType() == 0) {
                    la.setValue(TimeFormatter.toString(et + this.interlinearizer.getTimeOffset()));
                } else if (this.interlinearizer.getTimeCodeType() == 1) {
                    la.setValue(TimeFormatter.toSSMSString(et + this.interlinearizer.getTimeOffset()));
                } else {
                    la.setValue(String.valueOf(et + this.interlinearizer.getTimeOffset()));
                }
                rootNode.add(new DefaultMutableTreeNode(la));
            }
            if (!this.markerNames.contains("ELANParticipant") || part == null) continue;
            InterlinearAnnotation la = new InterlinearAnnotation("ELANParticipant", 1);
            if (part != null) {
                la.setValue(part);
            } else {
                la.setValue("unknown");
            }
            rootNode.add(new DefaultMutableTreeNode(la));
        }
        if (this.beginTier != null) {
            this.visibleTiers.add(this.beginTier);
        }
        if (this.endTier != null) {
            this.visibleTiers.add(this.endTier);
        }
        if (this.partTier != null) {
            this.visibleTiers.add(this.partTier);
        }
        if (this.markerNames != null) {
            this.tierTemplate.clear();
            this.tierTemplate.addAll(this.markerNames);
        }
    }

    public void calculatePrintBlocks() {
        super.calculatePrintBlocks();
        if (this.interlinearizer.getWidth() != Integer.MAX_VALUE || this.interlinearizer.getOutputMode() == 102) {
            this.toolboxBlocks.clear();
            this.toolboxBlocks.ensureCapacity(this.printBlocks.size());
            ArrayList<InterlinearBlock> group = new ArrayList<InterlinearBlock>(3);
            InterlinearBlock printBlock = null;
            ToolboxRecordBlock trb = null;
            for (int i = 0; i < this.printBlocks.size(); ++i) {
                printBlock = (InterlinearBlock)this.printBlocks.get(i);
                if (printBlock.isStartOfAnnotationBlock()) {
                    if (group.size() > 1) {
                        trb = this.convertToToolboxBlock(group, this.interlinearizer.getLineWrapStyle());
                        if (trb != null) {
                            this.toolboxBlocks.add(trb);
                        }
                    } else if (group.size() == 1 && (trb = this.convertToToolboxBlock((InterlinearBlock)group.get(0), this.interlinearizer.getLineWrapStyle())) != null) {
                        this.toolboxBlocks.add(trb);
                    }
                    group.clear();
                }
                group.add(printBlock);
            }
            if (group.size() > 1) {
                trb = this.convertToToolboxBlock(group, this.interlinearizer.getLineWrapStyle());
                if (trb != null) {
                    this.toolboxBlocks.add(trb);
                }
            } else if (group.size() == 1 && (trb = this.convertToToolboxBlock((InterlinearBlock)group.get(0), this.interlinearizer.getLineWrapStyle())) != null) {
                this.toolboxBlocks.add(trb);
            }
        }
    }

    private void wrapToEndOfBlock(ArrayList blocks) {
        if (blocks == null || blocks.size() <= 1) {
            return;
        }
        InterlinearBlock printBlock = (InterlinearBlock)blocks.get(0);
        ArrayList tiers = printBlock.getPrintTiers();
        InterlinearTier pt = null;
        InterlinearTier nextPt = null;
        InterlinearAnnotation pa = null;
        String[] lines = null;
        boolean interlinearBlockStarted = false;
        for (int i = 0; i < tiers.size(); ++i) {
            pt = (InterlinearTier)tiers.get(i);
            if (i > 0 && !interlinearBlockStarted && !this.levelOneNonInterTiers.contains(pt.getTierName())) {
                interlinearBlockStarted = true;
                continue;
            }
            if (interlinearBlockStarted && this.levelOneNonInterTiers.contains(pt.getTierName())) {
                pa = (InterlinearAnnotation)pt.getAnnotations().get(0);
                nextPt = ((InterlinearBlock)blocks.get(blocks.size() - 1)).getPrintTier(pt.getTierName());
                if (nextPt == null || nextPt.getAnnotations().size() != 0) continue;
                nextPt.addAnnotation(pa);
                pt.getAnnotations().clear();
                pt.setNumLines(1);
                continue;
            }
            if (pt.getAnnotations().size() != 1 || (lines = (pa = (InterlinearAnnotation)pt.getAnnotations().get(0)).getLines()) == null || lines.length <= 1 || (nextPt = ((InterlinearBlock)blocks.get(blocks.size() - 1)).getPrintTier(pt.getTierName())) == null || nextPt.getAnnotations().size() != 0) continue;
            InterlinearAnnotation nextAnn = new InterlinearAnnotation(nextPt.getTierName(), 1);
            if (lines.length > 2) {
                pa.setValue(lines[0]);
                pa.setLines(null);
                String[] restLines = new String[lines.length - 1];
                for (int j = 1; j < lines.length; ++j) {
                    restLines[j - 1] = lines[j];
                }
                nextAnn.setLines(restLines);
            } else {
                pa.setValue(lines[0]);
                pa.setLines(null);
                nextAnn.setValue(lines[1]);
            }
            nextPt.addAnnotation(nextAnn);
        }
    }

    private ToolboxRecordBlock convertToToolboxBlock(ArrayList blocks, int lineWrapStyle) {
        if (blocks == null) {
            return null;
        }
        ToolboxRecordBlock trb = new ToolboxRecordBlock();
        InterlinearBlock printBlock = null;
        ArrayList tiers = null;
        ArrayList<InterlinearTier> leftovers = new ArrayList<InterlinearTier>();
        InterlinearTier pt = null;
        InterlinearTier nextPt = null;
        InterlinearAnnotation pa = null;
        InterlinearAnnotation nextAnn = null;
        String[] lines = null;
        int insertIndex = -1;
        for (int k = 0; k < blocks.size(); ++k) {
            int i;
            printBlock = (InterlinearBlock)blocks.get(k);
            tiers = printBlock.getPrintTiers();
            if (k == 0) {
                for (i = 0; i < tiers.size(); ++i) {
                    pt = (InterlinearTier)tiers.get(i);
                    trb.addPrintTier(pt);
                }
                continue;
            }
            leftovers.clear();
            for (i = 0; i < tiers.size(); ++i) {
                pt = (InterlinearTier)tiers.get(i);
                if (pt.getAnnotations().size() <= 0) continue;
                leftovers.add(pt);
            }
            if (leftovers.size() <= 0) continue;
            pt = (InterlinearTier)leftovers.get(leftovers.size() - 1);
            if (insertIndex == -1) {
                insertIndex = trb.lastIndexOfTier(pt.getTierName());
            }
            int n = ++insertIndex;
            ++insertIndex;
            trb.insertEmptyPrintTier(n);
            for (int j = 0; j < leftovers.size(); ++j) {
                trb.insertPrintTier(insertIndex++, (InterlinearTier)leftovers.get(j));
            }
            if (k != blocks.size() - 1) continue;
            trb.insertEmptyPrintTier(insertIndex++);
        }
        if (lineWrapStyle == 5) {
            boolean emptyLineInserted = false;
            tiers = trb.getPrintTiers();
            int numTiers = tiers.size();
            for (int i = 0; i < numTiers; ++i) {
                Object tiObj = tiers.get(i);
                if (tiObj instanceof EmptyPrintTier || (pt = (InterlinearTier)tiObj).getAnnotations().size() != 1 || (lines = (pa = (InterlinearAnnotation)pt.getAnnotations().get(0)).getLines()) == null || lines.length <= 1) continue;
                nextPt = new InterlinearTier(pt.getTierName());
                nextAnn = new InterlinearAnnotation(nextPt.getTierName(), 1);
                if (lines.length > 2) {
                    pa.setValue(lines[0]);
                    pa.setLines(null);
                    String[] restLines = new String[lines.length - 1];
                    for (int j = 1; j < lines.length; ++j) {
                        restLines[j - 1] = lines[j];
                    }
                    nextAnn.setLines(restLines);
                } else {
                    pa.setValue(lines[0]);
                    pa.setLines(null);
                    nextAnn.setValue(lines[1]);
                }
                nextPt.addAnnotation(nextAnn);
                if (!emptyLineInserted) {
                    trb.addEmptyPrintTier();
                    emptyLineInserted = true;
                }
                trb.addPrintTier(nextPt);
            }
        }
        return trb;
    }

    private ToolboxRecordBlock convertToToolboxBlock(InterlinearBlock printBlock, int lineWrapStyle) {
        ToolboxRecordBlock trb;
        block11: {
            InterlinearTier pt;
            ArrayList tiers;
            block10: {
                int i;
                if (printBlock == null) {
                    return null;
                }
                trb = new ToolboxRecordBlock();
                tiers = printBlock.getPrintTiers();
                pt = null;
                InterlinearTier nextPt = null;
                InterlinearAnnotation pa = null;
                InterlinearAnnotation nextAnn = null;
                String[] lines = null;
                if (lineWrapStyle != 5) break block10;
                ArrayList<InterlinearTier> tiersToAdd = new ArrayList<InterlinearTier>();
                for (i = 0; i < tiers.size(); ++i) {
                    pt = (InterlinearTier)tiers.get(i);
                    if (pt.getAnnotations().size() == 1) {
                        pa = (InterlinearAnnotation)pt.getAnnotations().get(0);
                        lines = pa.getLines();
                        if (lines != null) {
                            if (lines.length <= 1) {
                                trb.addPrintTier(pt);
                                continue;
                            }
                            nextPt = new InterlinearTier(pt.getTierName());
                            nextAnn = new InterlinearAnnotation(nextPt.getTierName(), 1);
                            if (lines.length > 2) {
                                pa.setValue(lines[0]);
                                pa.setLines(null);
                                String[] restLines = new String[lines.length - 1];
                                for (int j = 1; j < lines.length; ++j) {
                                    restLines[j - 1] = lines[j];
                                }
                                nextAnn.setLines(restLines);
                            } else {
                                pa.setValue(lines[0]);
                                pa.setLines(null);
                                nextAnn.setValue(lines[1]);
                            }
                            nextPt.addAnnotation(nextAnn);
                            tiersToAdd.add(nextPt);
                            trb.addPrintTier(pt);
                            continue;
                        }
                        trb.addPrintTier(pt);
                        continue;
                    }
                    trb.addPrintTier(pt);
                }
                if (tiersToAdd.size() <= 0) break block11;
                trb.addEmptyPrintTier();
                for (i = 0; i < tiersToAdd.size(); ++i) {
                    trb.addPrintTier((InterlinearTier)tiersToAdd.get(i));
                }
                break block11;
            }
            for (int i = 0; i < tiers.size(); ++i) {
                pt = (InterlinearTier)tiers.get(i);
                trb.addPrintTier(pt);
            }
        }
        return trb;
    }

    Tier getTierWithId(String name) {
        if (name.equals("ELANBegin")) {
            return this.beginTier;
        }
        if (name.equals("ELANEnd")) {
            return this.endTier;
        }
        if (name.equals("ELANParticipant")) {
            return this.partTier;
        }
        Tier t = super.getTierWithId(name);
        if (t == null) {
            for (String tierName : this.tierToMarkerMap.keySet()) {
                if (tierName.indexOf("@") <= 0 || !tierName.startsWith(name)) continue;
                t = this.transcription.getTierWithId(tierName);
                break;
            }
        }
        return t;
    }

    public ArrayList getToolboxBlocks() {
        if (this.toolboxBlocks.size() == 0) {
            return null;
        }
        return this.toolboxBlocks;
    }
}

