/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ElanMediaPlayerController;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.grid.GridViewer;
import mpi.eudico.client.annotator.gui.ResizeComponent;
import mpi.eudico.client.annotator.layout.ModeLayoutManager;
import mpi.eudico.client.annotator.layout.PlayerLayoutModel;
import mpi.eudico.client.annotator.layout.ViewerLayoutModel;
import mpi.eudico.client.annotator.recognizer.gui.AudioRecognizerPanel;
import mpi.eudico.client.annotator.recognizer.gui.VideoRecognizerPanel;
import mpi.eudico.client.annotator.viewer.AbstractViewer;
import mpi.eudico.client.annotator.viewer.InterlinearViewer;
import mpi.eudico.client.annotator.viewer.LexiconEntryViewer;
import mpi.eudico.client.annotator.viewer.MetadataViewer;
import mpi.eudico.client.annotator.viewer.MultiTierControlPanel;
import mpi.eudico.client.annotator.viewer.MultiTierViewer;
import mpi.eudico.client.annotator.viewer.SignalViewer;
import mpi.eudico.client.annotator.viewer.SingleTierViewer;
import mpi.eudico.client.annotator.viewer.SingleTierViewerPanel;
import mpi.eudico.client.annotator.viewer.SubtitleViewer;
import mpi.eudico.client.annotator.viewer.TextViewer;
import mpi.eudico.client.annotator.viewer.TimeLineViewer;
import mpi.eudico.client.annotator.viewer.TimeSeriesViewer;
import mpi.eudico.p2p.CollaborationPanel;

public class AnnotationManager
implements ModeLayoutManager {
    private ElanLayoutManager layoutManager;
    Container container;
    private ViewerManager2 viewerManager;
    private boolean showTimeLineViewer;
    private boolean showInterlinearViewer;
    List viewerList;
    private ElanMediaPlayerController mediaPlayerController;
    private SignalViewer signalViewer;
    JComponent signalComponent;
    private TimeLineViewer timeLineViewer;
    private InterlinearViewer interlinearViewer;
    TimeSeriesViewer timeseriesViewer;
    JComponent timeseriesComponent;
    JSplitPane wav_tsSplitPane;
    private JPanel timeLineComponent;
    private MultiTierControlPanel multiTierControlPanel;
    private JSplitPane timeLineSplitPane;
    private ResizeComponent vertMediaResizer;
    private JTabbedPane tabPane;
    private JTabbedPane leftTabPane;
    private JPanel gridPanel;
    private JPanel textPanel;
    private JPanel subtitlePanel;
    private JComponent lexiconPanel;
    private JComponent audioRecognizerPanel;
    private JComponent videoRecognizerPanel;
    private JPanel controlPanel;
    private JComponent metadataPanel;
    private boolean mediaInCentre = false;
    private boolean gridViewerLeft;
    private boolean textViewerLeft;
    private boolean subtitleViewerLeft;
    private boolean lexiconViewerLeft;
    private boolean audioRecognizerLeft;
    private boolean videoRecognizerLeft;
    private boolean metaDataLeft;
    private List<String> viewerSortOrder;
    private boolean oneRowForVisuals = false;
    private boolean preferenceChanged = false;
    private int minTabWidth = 150;
    private int numOfPlayers;

    public AnnotationManager(ViewerManager2 viewerManager, ElanLayoutManager elanLayoutManager) {
        this.viewerManager = viewerManager;
        this.layoutManager = elanLayoutManager;
        this.container = this.layoutManager.getContainer();
        this.viewerList = new ArrayList(4);
        this.showTimeLineViewer = true;
        this.viewerSortOrder = new ArrayList<String>();
        this.controlPanel = new JPanel();
        this.controlPanel.setName(ElanLocale.getString("Tab.Controls"));
        this.controlPanel.setLayout(new GridLayout(2, 1, 10, 10));
        this.controlPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.vertMediaResizer = new ResizeComponent(this.layoutManager, 1);
        this.container.add(this.vertMediaResizer);
    }

    public void add(Object object) {
        if (object instanceof ElanMediaPlayerController) {
            this.setMediaPlayerController((ElanMediaPlayerController)object);
        } else if (object instanceof SignalViewer) {
            this.setSignalViewer((SignalViewer)object);
        } else if (object instanceof TimeLineViewer) {
            this.setTimeLineViewer((TimeLineViewer)object);
        } else if (object instanceof InterlinearViewer) {
            this.setInterlinearViewer((InterlinearViewer)object);
        } else if (object instanceof GridViewer) {
            this.addSingleTierViewer((SingleTierViewer)object);
        } else if (object instanceof TextViewer) {
            this.addSingleTierViewer((SingleTierViewer)object);
        } else if (object instanceof SubtitleViewer) {
            this.addSingleTierViewer((SingleTierViewer)object);
        } else if (object instanceof CollaborationPanel) {
            this.addToTabPane("P2P", (Component)object);
        } else if (object instanceof TimeSeriesViewer) {
            this.setTimeSeriesViewer((TimeSeriesViewer)object);
        } else if (object instanceof AudioRecognizerPanel) {
            this.audioRecognizerPanel = (JComponent)object;
            this.addToTabPane(ElanLocale.getString("Tab.AudioRecognizer"), this.audioRecognizerPanel);
        } else if (object instanceof VideoRecognizerPanel) {
            this.videoRecognizerPanel = (JComponent)object;
            this.addToTabPane(ElanLocale.getString("Tab.VideoRecognizer"), this.videoRecognizerPanel);
        } else if (object instanceof MetadataViewer) {
            this.metadataPanel = (JComponent)object;
            this.addToTabPane(ElanLocale.getString("Tab.Metadata"), (MetadataViewer)object);
        } else if (object instanceof LexiconEntryViewer) {
            this.lexiconPanel = (JComponent)object;
            this.addToTabPane(ElanLocale.getString("LexiconEntryViewer.Lexicon"), (Component)object);
        }
    }

    private void setMediaPlayerController(ElanMediaPlayerController mediaPlayerController) {
        this.mediaPlayerController = mediaPlayerController;
        this.container.add(mediaPlayerController.getPlayButtonsPanel());
        this.container.add(mediaPlayerController.getTimePanel());
        this.container.add(mediaPlayerController.getModePanel());
        this.container.add(mediaPlayerController.getSelectionPanel());
        this.container.add(mediaPlayerController.getSelectionButtonsPanel());
        this.container.add(mediaPlayerController.getAnnotationNavigationPanel());
        this.container.add(mediaPlayerController.getSliderPanel());
        this.container.add(mediaPlayerController.getAnnotationDensityViewer());
        this.container.add(mediaPlayerController.getVolumeIconPanel());
        this.controlPanel.add(mediaPlayerController.getVolumePanel());
        this.controlPanel.add(mediaPlayerController.getRatePanel());
        this.addToTabPane(ElanLocale.getString("Tab.Controls"), this.controlPanel);
    }

    private void setTimeLineViewer(TimeLineViewer timeLineViewer) {
        this.timeLineViewer = timeLineViewer;
        if (this.timeLineComponent == null) {
            this.timeLineComponent = new JPanel();
            this.timeLineComponent.setLayout(null);
        }
        if (this.multiTierControlPanel == null) {
            this.multiTierControlPanel = this.viewerManager.getMultiTierControlPanel();
            this.multiTierControlPanel.setSize(120, 120);
            ResizeComponent mcpResize = new ResizeComponent(this.layoutManager, 0, 1);
            mcpResize.setSize(8, 16);
            this.multiTierControlPanel.setResizeComponent(mcpResize);
            this.timeLineComponent.add(this.multiTierControlPanel);
        }
        if (this.interlinearViewer != null) {
            this.viewerManager.disableViewer(this.interlinearViewer);
        }
        this.timeLineComponent.add(timeLineViewer);
        this.getTimeLineSplitPane().setBottomComponent(this.timeLineComponent);
        if (this.getTimeLineSplitPane().getTopComponent() != null) {
            Integer sigHeight = (Integer)Preferences.get("LayoutManager.SplitPaneDividerLocation", this.viewerManager.getTranscription());
            if (sigHeight != null && sigHeight > 70) {
                this.getTimeLineSplitPane().setDividerLocation(sigHeight);
            } else {
                this.getTimeLineSplitPane().setDividerLocation(70);
            }
            this.getTimeLineSplitPane().setDividerLocation(70);
        }
        this.doLayout();
    }

    private void setInterlinearViewer(InterlinearViewer interlinearViewer) {
        this.interlinearViewer = interlinearViewer;
        if (this.timeLineComponent == null) {
            this.timeLineComponent = new JPanel();
            this.timeLineComponent.setLayout(null);
        }
        if (this.multiTierControlPanel == null) {
            this.multiTierControlPanel = this.viewerManager.getMultiTierControlPanel();
            this.multiTierControlPanel.setSize(120, 120);
            ResizeComponent mcpResize = new ResizeComponent(this.layoutManager, 0, 1);
            mcpResize.setSize(8, 16);
            this.multiTierControlPanel.setResizeComponent(mcpResize);
            this.timeLineComponent.add(this.multiTierControlPanel);
        }
        if (this.timeLineViewer != null) {
            this.viewerManager.disableViewer(this.timeLineViewer);
        }
        this.timeLineComponent.add(interlinearViewer);
        this.getTimeLineSplitPane().setBottomComponent(this.timeLineComponent);
        this.doLayout();
    }

    private void setSignalViewer(SignalViewer signalViewer) {
        this.signalViewer = signalViewer;
        if (this.timeseriesViewer == null) {
            if (this.signalComponent == null) {
                this.signalComponent = new JPanel();
                this.signalComponent.setLayout(null);
                this.signalComponent.addComponentListener(this.layoutManager.new ElanLayoutManager.SignalSplitPaneListener());
            }
            this.signalComponent.add(signalViewer);
            this.getTimeLineSplitPane().setTopComponent(this.signalComponent);
            Integer sigHeight = (Integer)Preferences.get("LayoutManager.SplitPaneDividerLocation", this.viewerManager.getTranscription());
            if (sigHeight != null && sigHeight > 70) {
                this.timeLineSplitPane.setDividerLocation(sigHeight);
            } else {
                this.timeLineSplitPane.setDividerLocation(70);
            }
        } else {
            int curHeight = this.timeseriesComponent.getHeight();
            this.getTimeLineSplitPane().setTopComponent(null);
            this.signalComponent = new JPanel();
            this.signalComponent.setLayout(null);
            this.signalComponent.add(signalViewer);
            this.wav_tsSplitPane = this.getWav_TSSplitPane();
            this.wav_tsSplitPane.setTopComponent(this.timeseriesComponent);
            this.wav_tsSplitPane.setBottomComponent(this.signalComponent);
            this.wav_tsSplitPane.setDividerLocation(curHeight / 2);
            this.getTimeLineSplitPane().setTopComponent(this.wav_tsSplitPane);
            this.timeLineComponent.addComponentListener(this.layoutManager.new ElanLayoutManager.SignalSplitPaneListener());
            this.getTimeLineSplitPane().setDividerLocation(curHeight);
            Integer divLoc = (Integer)Preferences.get("LayoutManager.TSWavSplitPaneDividerLocation", this.viewerManager.getTranscription());
            if (divLoc != null && this.wav_tsSplitPane != null) {
                this.wav_tsSplitPane.setDividerLocation(divLoc);
            }
        }
        this.doLayout();
    }

    void setTimeSeriesViewer(TimeSeriesViewer timeseriesViewer) {
        if (this.timeseriesViewer == null) {
            this.timeseriesViewer = timeseriesViewer;
            ViewerLayoutModel vlm = new ViewerLayoutModel(timeseriesViewer, this.layoutManager);
            this.viewerList.add(vlm);
            boolean detached = false;
            Boolean detObj = (Boolean)Preferences.get("TimeSeriesViewer.Detached", this.viewerManager.getTranscription());
            if (detObj != null) {
                detached = detObj;
            }
            if (detached) {
                vlm.detach();
                timeseriesViewer.setAttached(false);
                return;
            }
        }
        if (this.signalViewer == null) {
            this.timeseriesComponent = new JPanel();
            this.timeseriesComponent.setLayout(null);
            this.timeseriesComponent.addComponentListener(this.layoutManager.new ElanLayoutManager.SignalSplitPaneListener());
            this.timeseriesComponent.add(timeseriesViewer);
            this.getTimeLineSplitPane().setTopComponent(this.timeseriesComponent);
            int divLoc = this.timeseriesComponent.getHeight() < 70 ? 70 : this.timeseriesComponent.getHeight();
            Integer sigHeight = (Integer)Preferences.get("LayoutManager.SplitPaneDividerLocation", this.viewerManager.getTranscription());
            if (sigHeight != null && sigHeight > 70) {
                divLoc = sigHeight;
            }
            this.timeLineSplitPane.setDividerLocation(divLoc);
            timeseriesViewer.setAttached(true);
            if (this.multiTierControlPanel != null) {
                timeseriesViewer.setVerticalRulerWidth(this.multiTierControlPanel.getWidth());
            }
        } else {
            Integer divLoc;
            ComponentListener[] cListeners = this.signalComponent.getComponentListeners();
            for (int i = 0; i < cListeners.length; ++i) {
                if (!(cListeners[i] instanceof ElanLayoutManager.SignalSplitPaneListener)) continue;
                this.signalComponent.removeComponentListener(cListeners[i]);
            }
            int curHeight = this.getTimeLineSplitPane().getDividerLocation();
            this.timeseriesComponent = new JPanel();
            this.timeseriesComponent.setLayout(null);
            this.timeseriesComponent.add(timeseriesViewer);
            this.getTimeLineSplitPane().setTopComponent(null);
            this.wav_tsSplitPane = this.getWav_TSSplitPane();
            this.wav_tsSplitPane.setTopComponent(this.timeseriesComponent);
            this.wav_tsSplitPane.setBottomComponent(this.signalComponent);
            this.wav_tsSplitPane.setDividerLocation(curHeight / 2);
            this.getTimeLineSplitPane().setTopComponent(this.wav_tsSplitPane);
            this.getTimeLineSplitPane().setDividerLocation(curHeight);
            this.timeseriesComponent.addComponentListener(this.layoutManager.new ElanLayoutManager.SignalSplitPaneListener());
            this.timeLineComponent.addComponentListener(this.layoutManager.new ElanLayoutManager.SignalSplitPaneListener());
            timeseriesViewer.setAttached(true);
            if (this.multiTierControlPanel != null) {
                timeseriesViewer.setVerticalRulerWidth(this.multiTierControlPanel.getWidth());
                timeseriesViewer.setBounds(this.timeseriesComponent.getBounds());
            }
            if ((divLoc = (Integer)Preferences.get("LayoutManager.TSWavSplitPaneDividerLocation", this.viewerManager.getTranscription())) != null && this.wav_tsSplitPane != null && divLoc < curHeight - 20) {
                this.wav_tsSplitPane.setDividerLocation(divLoc);
            }
        }
        this.doLayout();
    }

    private void addToTabPane(String tabName, Component component) {
        this.getTabPane().insertTab(tabName, null, component, tabName, this.getIndexOfComponent(this.getTabPane(), component));
        this.preferenceChanged = true;
        this.doLayout();
    }

    private void addSingleTierViewer(SingleTierViewer viewer) {
        SingleTierViewerPanel panel = this.viewerManager.createSingleTierViewerPanel();
        panel.setViewer(viewer);
        if (viewer instanceof GridViewer) {
            this.gridPanel = panel;
            this.addToTabPane(ElanLocale.getString("Tab.Grid"), panel);
        } else if (viewer instanceof TextViewer) {
            this.textPanel = panel;
            this.addToTabPane(ElanLocale.getString("Tab.Text"), panel);
        } else if (viewer instanceof SubtitleViewer) {
            this.getSubtitlePanel().add(panel);
        }
        this.doLayout();
    }

    public void remove(Object object) {
        if (object instanceof SignalViewer) {
            this.removeSignalViewer();
        } else if (object instanceof TimeSeriesViewer) {
            this.removeTimeSeriesViewer();
        } else if (object instanceof CollaborationPanel) {
            this.removeFromTabPane((Component)object);
        } else if (object instanceof AudioRecognizerPanel) {
            this.removeFromTabPane((Component)object);
        } else if (object instanceof VideoRecognizerPanel) {
            this.removeFromTabPane((Component)object);
        } else if (object instanceof MetadataViewer) {
            this.removeFromTabPane((Component)object);
        } else if (object instanceof GridViewer) {
            this.removeFromTabPane(this.gridPanel);
        } else if (object instanceof TextViewer) {
            this.removeFromTabPane(this.textPanel);
        } else if (object instanceof SubtitleViewer) {
            this.removeFromTabPane(this.subtitlePanel);
        } else if (object instanceof LexiconEntryViewer) {
            this.removeFromTabPane((Component)object);
        }
    }

    private void removeFromTabPane(Component component) {
        if (this.getTabPane().indexOfComponent(component) >= 0) {
            this.getTabPane().remove(component);
        } else if (this.getLeftTabPane().indexOfComponent(component) >= 0) {
            this.getLeftTabPane().remove(component);
        }
    }

    private void removeSignalViewer() {
        if (this.signalViewer != null && this.signalComponent != null) {
            if (this.wav_tsSplitPane != null && this.wav_tsSplitPane.getBottomComponent() == this.signalComponent) {
                Component topComp = this.wav_tsSplitPane.getTopComponent();
                this.wav_tsSplitPane.setTopComponent(null);
                this.wav_tsSplitPane.setBottomComponent(null);
                this.getTimeLineSplitPane().setTopComponent(topComp);
                this.signalComponent.remove(this.signalViewer);
                this.signalViewer = null;
                this.signalComponent = null;
                this.doLayout();
            } else {
                this.signalComponent.remove(this.signalViewer);
                this.getTimeLineSplitPane().setTopComponent(null);
                this.doLayout();
                this.signalViewer = null;
                this.signalComponent = null;
            }
        }
    }

    private void removeTimeSeriesViewer() {
        if (this.timeseriesViewer != null) {
            ViewerLayoutModel vlm = null;
            for (int i = 0; i < this.viewerList.size(); ++i) {
                vlm = (ViewerLayoutModel)this.viewerList.get(i);
                if (vlm.viewer == this.timeseriesViewer) break;
                vlm = null;
            }
            if (vlm == null) {
                return;
            }
            if (vlm.isAttached()) {
                if (this.wav_tsSplitPane != null) {
                    int curHeight = this.getTimeLineSplitPane().getDividerLocation();
                    this.wav_tsSplitPane.setTopComponent(null);
                    this.wav_tsSplitPane.setBottomComponent(null);
                    this.timeseriesComponent.remove(this.timeseriesViewer);
                    this.timeseriesComponent = null;
                    this.wav_tsSplitPane = null;
                    if (this.signalComponent != null) {
                        this.getTimeLineSplitPane().setTopComponent(this.signalComponent);
                        this.getTimeLineSplitPane().setDividerLocation(curHeight);
                        this.signalComponent.setSize(this.signalComponent.getWidth(), curHeight);
                    } else {
                        this.getTimeLineSplitPane().setTopComponent(null);
                    }
                } else {
                    this.getTimeLineSplitPane().setTopComponent(null);
                    if (this.timeseriesComponent != null) {
                        this.timeseriesComponent.remove(this.timeseriesViewer);
                        this.timeseriesComponent = null;
                    }
                }
                this.timeseriesViewer = null;
                this.doLayout();
            } else {
                vlm.attach();
                this.viewerList.remove(vlm);
                if (this.timeseriesComponent != null) {
                    this.timeseriesComponent.remove(vlm.viewer);
                    this.timeseriesComponent = null;
                }
                this.timeseriesViewer = null;
            }
        }
    }

    private JTabbedPane getTabPane() {
        if (this.tabPane == null) {
            this.tabPane = new JTabbedPane();
            this.container.add(this.tabPane);
        }
        return this.tabPane;
    }

    private JTabbedPane getLeftTabPane() {
        if (this.leftTabPane == null) {
            this.leftTabPane = new JTabbedPane();
            this.container.add(this.leftTabPane);
        }
        return this.leftTabPane;
    }

    private void destroyLeftPane() {
        if (this.leftTabPane != null) {
            this.container.remove(this.leftTabPane);
            this.leftTabPane = null;
        }
    }

    public void destroyViewer(Object object) {
        this.remove(object);
        if (object instanceof AudioRecognizerPanel) {
            this.audioRecognizerPanel = null;
        } else if (object instanceof VideoRecognizerPanel) {
            this.videoRecognizerPanel = null;
        } else if (object instanceof MetadataViewer) {
            this.metadataPanel = null;
        } else if (object instanceof GridViewer) {
            if (this.gridPanel instanceof SingleTierViewerPanel) {
                this.viewerManager.destroySingleTierViewerPanel((SingleTierViewerPanel)this.gridPanel);
            }
            this.gridPanel = null;
        } else if (object instanceof TextViewer) {
            if (this.textPanel instanceof SingleTierViewerPanel) {
                this.viewerManager.destroySingleTierViewerPanel((SingleTierViewerPanel)this.textPanel);
            }
            this.textPanel = null;
        } else if (object instanceof SubtitleViewer) {
            Component[] panel = this.subtitlePanel.getComponents();
            for (int i = 0; i < panel.length; ++i) {
                if (!(panel[i] instanceof SingleTierViewerPanel)) continue;
                this.viewerManager.destroySingleTierViewerPanel((SingleTierViewerPanel)panel[i]);
            }
            this.subtitlePanel = null;
        } else if (object instanceof InterlinearViewer) {
            if (this.layoutManager.getMode() == 1) {
                this.showTimeLineViewer();
            }
            this.interlinearViewer = null;
        } else if (object instanceof LexiconEntryViewer) {
            this.lexiconPanel = null;
        } else if (object instanceof TimeLineViewer) {
            this.timeLineViewer = null;
        }
    }

    private JPanel getSubtitlePanel() {
        if (this.subtitlePanel == null) {
            this.subtitlePanel = new JPanel(new GridLayout(0, 1));
            this.addToTabPane(ElanLocale.getString("Tab.Subtitles"), this.subtitlePanel);
        }
        return this.subtitlePanel;
    }

    private JSplitPane getTimeLineSplitPane() {
        if (this.timeLineSplitPane == null) {
            this.timeLineSplitPane = new JSplitPane(0);
            this.timeLineSplitPane.setOneTouchExpandable(true);
            this.timeLineSplitPane.setDividerLocation(0);
            this.timeLineSplitPane.setContinuousLayout(true);
            this.container.add(this.timeLineSplitPane);
        }
        return this.timeLineSplitPane;
    }

    private JSplitPane getWav_TSSplitPane() {
        if (this.wav_tsSplitPane == null) {
            this.wav_tsSplitPane = new JSplitPane(0);
            this.wav_tsSplitPane.setOneTouchExpandable(true);
            this.wav_tsSplitPane.setBorder(null);
            this.wav_tsSplitPane.setDividerLocation(0);
            this.wav_tsSplitPane.setDividerSize(6);
            this.wav_tsSplitPane.setContinuousLayout(true);
        }
        return this.wav_tsSplitPane;
    }

    public TimeLineViewer getTimeLineViewer() {
        return this.timeLineViewer;
    }

    public InterlinearViewer getInterlinearViewer() {
        return this.interlinearViewer;
    }

    public TimeSeriesViewer getTimeSeriesViewer() {
        return this.timeseriesViewer;
    }

    public MultiTierControlPanel getMultiTierControlPanel() {
        return this.multiTierControlPanel;
    }

    public MultiTierViewer getVisibleMultiTierViewer() {
        if (this.showTimeLineViewer) {
            return this.timeLineViewer;
        }
        return this.interlinearViewer;
    }

    private int getIndexOfComponent(JTabbedPane pane, Component component) {
        int index = 0;
        if (this.viewerSortOrder != null && this.viewerSortOrder.size() > 0) {
            for (int i = 0; i < this.viewerSortOrder.size(); ++i) {
                if (component == this.controlPanel) {
                    return pane.getTabCount();
                }
                if (this.viewerSortOrder.get(i).equalsIgnoreCase(ElanLocale.getString("Menu.View.Viewers.Grid"))) {
                    if (component == this.gridPanel) break;
                    if (pane.indexOfComponent(this.gridPanel) >= 0) {
                        ++index;
                    }
                }
                if (this.viewerSortOrder.get(i).equalsIgnoreCase(ElanLocale.getString("Menu.View.Viewers.Text"))) {
                    if (component == this.textPanel) break;
                    if (pane.indexOfComponent(this.textPanel) >= 0) {
                        ++index;
                    }
                }
                if (this.viewerSortOrder.get(i).equalsIgnoreCase(ElanLocale.getString("Menu.View.Viewers.Subtitles"))) {
                    if (component == this.subtitlePanel) break;
                    if (pane.indexOfComponent(this.subtitlePanel) >= 0) {
                        ++index;
                    }
                }
                if (this.viewerSortOrder.get(i).equalsIgnoreCase(ElanLocale.getString("LexiconEntryViewer.Lexicon"))) {
                    if (component == this.lexiconPanel) break;
                    if (pane.indexOfComponent(this.lexiconPanel) >= 0) {
                        ++index;
                    }
                }
                if (this.viewerSortOrder.get(i).equalsIgnoreCase(ElanLocale.getString("Menu.View.Viewers.Audio"))) {
                    if (component == this.audioRecognizerPanel) break;
                    if (pane.indexOfComponent(this.audioRecognizerPanel) >= 0) {
                        ++index;
                    }
                }
                if (this.viewerSortOrder.get(i).equalsIgnoreCase(ElanLocale.getString("Menu.View.Viewers.Video"))) {
                    if (component == this.videoRecognizerPanel) break;
                    if (pane.indexOfComponent(this.videoRecognizerPanel) >= 0) {
                        ++index;
                    }
                }
                if (!this.viewerSortOrder.get(i).equalsIgnoreCase(ElanLocale.getString("Menu.View.Viewers.MetaData"))) continue;
                if (pane.indexOfComponent(this.metadataPanel) >= 0) {
                    ++index;
                    continue;
                }
                if (component != this.metadataPanel) {
                    continue;
                }
                break;
            }
        } else {
            if (component == this.gridPanel) {
                return index;
            }
            index = pane.indexOfComponent(this.gridPanel);
            index = index != 0 ? 0 : 1;
            if (component == this.textPanel) {
                return index;
            }
            if (component == this.subtitlePanel) {
                int i = pane.indexOfComponent(this.textPanel);
                if (i >= 0) {
                    return i + 1;
                }
                return index;
            }
            if (component == this.lexiconPanel) {
                int i = pane.indexOfComponent(this.subtitlePanel);
                if (i >= 0) {
                    return i + 1;
                }
                return index;
            }
            if (component == this.audioRecognizerPanel) {
                int i = pane.indexOfComponent(this.lexiconPanel);
                if (i >= 0) {
                    return i + 1;
                }
                i = pane.indexOfComponent(this.subtitlePanel);
                if (i >= 0) {
                    return i + 1;
                }
                return index;
            }
            if (component == this.videoRecognizerPanel) {
                int i = pane.indexOfComponent(this.metadataPanel);
                if (i >= 0) {
                    return i;
                }
                i = pane.indexOfComponent(this.controlPanel);
                if (i >= 0) {
                    return i;
                }
                return pane.getTabCount();
            }
            if (component == this.metadataPanel) {
                int i = pane.indexOfComponent(this.controlPanel);
                if (i >= 0) {
                    return i;
                }
                return pane.getTabCount();
            }
            if (component == this.controlPanel) {
                return pane.getTabCount();
            }
        }
        return index;
    }

    private void reArrangeViewers() {
        if (this.mediaInCentre && this.layoutManager.getAttachedVisualPlayers().length > 0) {
            String tabName;
            int selectedIndexLeftPane = 0;
            int selectedIndexRightPane = 0;
            Component selectedLeftComponent = null;
            Component selectedRightComponent = null;
            if (this.getLeftTabPane().getTabCount() > 0) {
                selectedIndexLeftPane = this.getLeftTabPane().getSelectedIndex();
                selectedLeftComponent = this.getLeftTabPane().getSelectedComponent();
            }
            if (this.getTabPane().getTabCount() > 0) {
                selectedIndexRightPane = this.getTabPane().getSelectedIndex();
                selectedRightComponent = this.getTabPane().getSelectedComponent();
            }
            if (this.gridPanel != null) {
                tabName = ElanLocale.getString("Tab.Grid");
                if (this.gridViewerLeft) {
                    if (this.getTabPane().indexOfComponent(this.gridPanel) >= 0) {
                        this.getTabPane().remove(this.gridPanel);
                    }
                    if (this.getLeftTabPane().indexOfComponent(this.gridPanel) < 0) {
                        this.getLeftTabPane().insertTab(tabName, null, this.gridPanel, tabName, this.getIndexOfComponent(this.getLeftTabPane(), this.gridPanel));
                    } else {
                        this.getLeftTabPane().remove(this.gridPanel);
                        this.getLeftTabPane().insertTab(tabName, null, this.gridPanel, tabName, this.getIndexOfComponent(this.getLeftTabPane(), this.gridPanel));
                    }
                } else {
                    if (this.getLeftTabPane().indexOfComponent(this.gridPanel) >= 0) {
                        this.getLeftTabPane().remove(this.gridPanel);
                    }
                    if (this.getTabPane().indexOfComponent(this.gridPanel) < 0) {
                        this.getTabPane().insertTab(tabName, null, this.gridPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.gridPanel));
                    }
                }
            }
            if (this.textPanel != null) {
                tabName = ElanLocale.getString("Tab.Text");
                if (this.textViewerLeft) {
                    if (this.getTabPane().indexOfComponent(this.textPanel) >= 0) {
                        this.getTabPane().remove(this.textPanel);
                    }
                    if (this.getLeftTabPane().indexOfComponent(this.textPanel) < 0) {
                        this.getLeftTabPane().insertTab(tabName, null, this.textPanel, tabName, this.getIndexOfComponent(this.getLeftTabPane(), this.textPanel));
                    } else {
                        this.getLeftTabPane().remove(this.textPanel);
                        this.getLeftTabPane().insertTab(tabName, null, this.textPanel, tabName, this.getIndexOfComponent(this.getLeftTabPane(), this.textPanel));
                    }
                } else {
                    if (this.getLeftTabPane().indexOfComponent(this.textPanel) >= 0) {
                        this.getLeftTabPane().remove(this.textPanel);
                    }
                    if (this.getTabPane().indexOfComponent(this.textPanel) < 0) {
                        this.getTabPane().insertTab(tabName, null, this.textPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.textPanel));
                    }
                }
            }
            if (this.subtitlePanel != null) {
                tabName = ElanLocale.getString("Tab.Subtitles");
                if (this.subtitleViewerLeft) {
                    if (this.getTabPane().indexOfComponent(this.subtitlePanel) >= 0) {
                        this.getTabPane().remove(this.subtitlePanel);
                    }
                    if (this.getLeftTabPane().indexOfComponent(this.subtitlePanel) < 0) {
                        this.getLeftTabPane().insertTab(tabName, null, this.subtitlePanel, tabName, this.getIndexOfComponent(this.getLeftTabPane(), this.subtitlePanel));
                    } else {
                        this.getLeftTabPane().remove(this.subtitlePanel);
                        this.getLeftTabPane().insertTab(tabName, null, this.subtitlePanel, tabName, this.getIndexOfComponent(this.getLeftTabPane(), this.subtitlePanel));
                    }
                } else {
                    if (this.getLeftTabPane().indexOfComponent(this.subtitlePanel) >= 0) {
                        this.getLeftTabPane().remove(this.subtitlePanel);
                    }
                    if (this.getTabPane().indexOfComponent(this.subtitlePanel) < 0) {
                        this.getTabPane().insertTab(tabName, null, this.subtitlePanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.subtitlePanel));
                    }
                }
            }
            if (this.lexiconPanel != null) {
                tabName = ElanLocale.getString("LexiconEntryViewer.Lexicon");
                if (this.lexiconViewerLeft) {
                    if (this.getTabPane().indexOfComponent(this.lexiconPanel) >= 0) {
                        this.getTabPane().remove(this.lexiconPanel);
                    }
                    if (this.getLeftTabPane().indexOfComponent(this.lexiconPanel) < 0) {
                        this.getLeftTabPane().insertTab(tabName, null, this.lexiconPanel, tabName, this.getIndexOfComponent(this.getLeftTabPane(), this.lexiconPanel));
                    } else {
                        this.getLeftTabPane().remove(this.lexiconPanel);
                        this.getLeftTabPane().insertTab(tabName, null, this.lexiconPanel, tabName, this.getIndexOfComponent(this.getLeftTabPane(), this.lexiconPanel));
                    }
                } else {
                    if (this.getLeftTabPane().indexOfComponent(this.lexiconPanel) >= 0) {
                        this.getLeftTabPane().remove(this.lexiconPanel);
                    }
                    if (this.getTabPane().indexOfComponent(this.lexiconPanel) < 0) {
                        this.getTabPane().insertTab(tabName, null, this.lexiconPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.lexiconPanel));
                    }
                }
            }
            if (this.audioRecognizerPanel != null) {
                tabName = ElanLocale.getString("Tab.AudioRecognizer");
                if (this.audioRecognizerLeft) {
                    if (this.getTabPane().indexOfComponent(this.audioRecognizerPanel) >= 0) {
                        this.getTabPane().remove(this.audioRecognizerPanel);
                    }
                    if (this.getLeftTabPane().indexOfComponent(this.audioRecognizerPanel) < 0) {
                        this.getLeftTabPane().insertTab(tabName, null, this.audioRecognizerPanel, tabName, this.getIndexOfComponent(this.getLeftTabPane(), this.audioRecognizerPanel));
                    } else {
                        this.getLeftTabPane().remove(this.audioRecognizerPanel);
                        this.getLeftTabPane().insertTab(tabName, null, this.audioRecognizerPanel, tabName, this.getIndexOfComponent(this.getLeftTabPane(), this.audioRecognizerPanel));
                    }
                } else {
                    if (this.getLeftTabPane().indexOfComponent(this.audioRecognizerPanel) >= 0) {
                        this.getLeftTabPane().remove(this.audioRecognizerPanel);
                    }
                    if (this.getTabPane().indexOfComponent(this.audioRecognizerPanel) < 0) {
                        this.getTabPane().insertTab(tabName, null, this.audioRecognizerPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.audioRecognizerPanel));
                    }
                }
            }
            if (this.videoRecognizerPanel != null) {
                tabName = ElanLocale.getString("Tab.VideoRecognizer");
                if (this.videoRecognizerLeft) {
                    if (this.getTabPane().indexOfComponent(this.videoRecognizerPanel) >= 0) {
                        this.getTabPane().remove(this.videoRecognizerPanel);
                    }
                    if (this.getLeftTabPane().indexOfComponent(this.videoRecognizerPanel) < 0) {
                        this.getLeftTabPane().insertTab(tabName, null, this.videoRecognizerPanel, tabName, this.getIndexOfComponent(this.getLeftTabPane(), this.videoRecognizerPanel));
                    } else {
                        this.getLeftTabPane().remove(this.videoRecognizerPanel);
                        this.getLeftTabPane().insertTab(tabName, null, this.videoRecognizerPanel, tabName, this.getIndexOfComponent(this.getLeftTabPane(), this.videoRecognizerPanel));
                    }
                } else {
                    if (this.getLeftTabPane().indexOfComponent(this.videoRecognizerPanel) >= 0) {
                        this.getLeftTabPane().remove(this.videoRecognizerPanel);
                    }
                    if (this.getTabPane().indexOfComponent(this.videoRecognizerPanel) < 0) {
                        this.getTabPane().insertTab(tabName, null, this.videoRecognizerPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.videoRecognizerPanel));
                    }
                }
            }
            if (this.metadataPanel != null) {
                tabName = ElanLocale.getString("Tab.Metadata");
                if (this.metaDataLeft) {
                    if (this.getTabPane().indexOfComponent(this.metadataPanel) >= 0) {
                        this.getTabPane().remove(this.metadataPanel);
                    }
                    if (this.getLeftTabPane().indexOfComponent(this.metadataPanel) < 0) {
                        this.getLeftTabPane().insertTab(tabName, null, this.metadataPanel, tabName, this.getIndexOfComponent(this.getLeftTabPane(), this.metadataPanel));
                    } else {
                        this.getLeftTabPane().remove(this.metadataPanel);
                        this.getLeftTabPane().insertTab(tabName, null, this.metadataPanel, tabName, this.getIndexOfComponent(this.getLeftTabPane(), this.metadataPanel));
                    }
                } else {
                    if (this.getLeftTabPane().indexOfComponent(this.metadataPanel) >= 0) {
                        this.getLeftTabPane().remove(this.metadataPanel);
                    }
                    if (this.getTabPane().indexOfComponent(this.metadataPanel) < 0) {
                        this.getTabPane().insertTab(tabName, null, this.metadataPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.metadataPanel));
                    }
                }
            }
            if (this.getLeftTabPane().indexOfComponent(selectedLeftComponent) > 0) {
                this.getLeftTabPane().setSelectedComponent(selectedLeftComponent);
            } else if (this.getLeftTabPane().getTabCount() > selectedIndexLeftPane) {
                this.getLeftTabPane().setSelectedIndex(selectedIndexLeftPane);
            } else {
                this.getLeftTabPane().setSelectedIndex(this.getLeftTabPane().getTabCount() - 1);
            }
            if (this.getTabPane().indexOfComponent(selectedRightComponent) > 0) {
                this.getTabPane().setSelectedComponent(selectedRightComponent);
            } else if (this.getTabPane().getTabCount() > selectedIndexRightPane) {
                this.getTabPane().setSelectedIndex(selectedIndexRightPane);
            } else {
                this.getTabPane().setSelectedIndex(this.getTabPane().getTabCount() - 1);
            }
        } else {
            String tabName;
            int selectedIndex = 0;
            Component selectedComponent = null;
            if (this.getTabPane().getTabCount() > 0) {
                selectedIndex = this.getTabPane().getSelectedIndex();
                selectedComponent = this.getTabPane().getSelectedComponent();
            }
            if (this.gridPanel != null) {
                tabName = ElanLocale.getString("Tab.Grid");
                if (this.getTabPane().indexOfComponent(this.gridPanel) < 0) {
                    this.getTabPane().insertTab(tabName, null, this.gridPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.gridPanel));
                } else {
                    this.getTabPane().remove(this.gridPanel);
                    this.getTabPane().insertTab(tabName, null, this.gridPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.gridPanel));
                }
            }
            if (this.textPanel != null) {
                tabName = ElanLocale.getString("Tab.Text");
                if (this.getTabPane().indexOfComponent(this.textPanel) < 0) {
                    this.getTabPane().insertTab(tabName, null, this.textPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.textPanel));
                } else {
                    this.getTabPane().remove(this.textPanel);
                    this.getTabPane().insertTab(tabName, null, this.textPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.textPanel));
                }
            }
            if (this.subtitlePanel != null) {
                tabName = ElanLocale.getString("Tab.Subtitles");
                if (this.getTabPane().indexOfComponent(this.subtitlePanel) < 0) {
                    this.getTabPane().insertTab(tabName, null, this.subtitlePanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.subtitlePanel));
                } else {
                    this.getTabPane().remove(this.subtitlePanel);
                    this.getTabPane().insertTab(tabName, null, this.subtitlePanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.subtitlePanel));
                }
            }
            if (this.lexiconPanel != null) {
                tabName = ElanLocale.getString("LexiconEntryViewer.Lexicon");
                if (this.getTabPane().indexOfComponent(this.lexiconPanel) < 0) {
                    this.getTabPane().insertTab(tabName, null, this.lexiconPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.lexiconPanel));
                } else {
                    this.getTabPane().remove(this.lexiconPanel);
                    this.getTabPane().insertTab(tabName, null, this.lexiconPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.lexiconPanel));
                }
            }
            if (this.audioRecognizerPanel != null) {
                tabName = ElanLocale.getString("Tab.AudioRecognizer");
                if (this.getTabPane().indexOfComponent(this.audioRecognizerPanel) < 0) {
                    this.getTabPane().insertTab(tabName, null, this.audioRecognizerPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.audioRecognizerPanel));
                } else {
                    this.getTabPane().remove(this.audioRecognizerPanel);
                    this.getTabPane().insertTab(tabName, null, this.audioRecognizerPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.audioRecognizerPanel));
                }
            }
            if (this.videoRecognizerPanel != null) {
                tabName = ElanLocale.getString("Tab.VideoRecognizer");
                if (this.getTabPane().indexOfComponent(this.videoRecognizerPanel) < 0) {
                    this.getTabPane().insertTab(tabName, null, this.videoRecognizerPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.videoRecognizerPanel));
                } else {
                    this.getTabPane().remove(this.videoRecognizerPanel);
                    this.getTabPane().insertTab(tabName, null, this.videoRecognizerPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.videoRecognizerPanel));
                }
            }
            if (this.metadataPanel != null) {
                tabName = ElanLocale.getString("Tab.Metadata");
                if (this.getTabPane().indexOfComponent(this.metadataPanel) < 0) {
                    this.getTabPane().insertTab(tabName, null, this.metadataPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.metadataPanel));
                } else {
                    this.getTabPane().remove(this.metadataPanel);
                    this.getTabPane().insertTab(tabName, null, this.metadataPanel, tabName, this.getIndexOfComponent(this.getTabPane(), this.metadataPanel));
                }
            }
            if (this.getTabPane().indexOfComponent(selectedComponent) > 0) {
                this.getTabPane().setSelectedComponent(selectedComponent);
            } else if (this.getTabPane().getTabCount() > selectedIndex) {
                this.getTabPane().setSelectedIndex(selectedIndex);
            } else {
                this.getTabPane().setSelectedIndex(this.getTabPane().getTabCount() - 1);
            }
        }
    }

    public void showTimeLineViewer() {
        this.showTimeLineViewer = true;
        this.showInterlinearViewer = false;
        this.enableDisableLogic();
        this.doLayout();
    }

    public void showInterlinearViewer() {
        this.showTimeLineViewer = false;
        this.showInterlinearViewer = true;
        this.enableDisableLogic();
        this.doLayout();
    }

    private void enableDisableLogic() {
        if (this.showTimeLineViewer) {
            if (this.timeLineViewer != null) {
                this.viewerManager.enableViewer(this.timeLineViewer);
            }
            if (this.interlinearViewer != null) {
                this.viewerManager.disableViewer(this.interlinearViewer);
            }
            this.layoutManager.setPreference("LayoutManager.VisibleMultiTierViewer", TimeLineViewer.class.getName(), this.viewerManager.getTranscription());
            this.timeLineViewer.preferencesChanged();
        } else if (this.showInterlinearViewer) {
            if (this.timeLineViewer != null) {
                this.viewerManager.disableViewer(this.timeLineViewer);
            }
            if (this.interlinearViewer != null) {
                this.viewerManager.enableViewer(this.interlinearViewer);
            }
            this.layoutManager.setPreference("LayoutManager.VisibleMultiTierViewer", InterlinearViewer.class.getName(), this.viewerManager.getTranscription());
            this.interlinearViewer.preferencesChanged();
        }
    }

    public void detach(Object object) {
        if (object instanceof AbstractViewer) {
            this.container.remove((Component)object);
            if (object instanceof TimeSeriesViewer) {
                ViewerLayoutModel vlm = null;
                for (int i = 0; i < this.viewerList.size(); ++i) {
                    vlm = (ViewerLayoutModel)this.viewerList.get(i);
                    if (vlm.viewer == object) break;
                    vlm = null;
                }
                if (vlm == null) {
                    return;
                }
                if (this.wav_tsSplitPane != null) {
                    int curHeight = this.getTimeLineSplitPane().getDividerLocation();
                    this.wav_tsSplitPane.setTopComponent(null);
                    this.wav_tsSplitPane.setBottomComponent(null);
                    this.timeseriesComponent.remove(this.timeseriesViewer);
                    this.timeseriesComponent = null;
                    this.wav_tsSplitPane = null;
                    if (this.signalComponent != null) {
                        this.getTimeLineSplitPane().setTopComponent(this.signalComponent);
                        this.getTimeLineSplitPane().setDividerLocation(curHeight);
                        this.signalComponent.setSize(this.signalComponent.getWidth(), curHeight);
                    } else {
                        this.getTimeLineSplitPane().setTopComponent(null);
                    }
                } else {
                    this.getTimeLineSplitPane().setTopComponent(null);
                    if (this.timeseriesComponent != null) {
                        this.timeseriesComponent.remove(this.timeseriesViewer);
                        this.timeseriesComponent = null;
                    }
                }
                this.doLayout();
                vlm.detach();
            }
        }
    }

    public void attach(Object object) {
        if (object instanceof AbstractViewer) {
            ViewerLayoutModel vlm = null;
            for (int i = 0; i < this.viewerList.size(); ++i) {
                vlm = (ViewerLayoutModel)this.viewerList.get(i);
                if (vlm.viewer == object) break;
                vlm = null;
            }
            if (vlm == null) {
                return;
            }
            vlm.attach();
            if (vlm.viewer instanceof TimeSeriesViewer) {
                this.setTimeSeriesViewer((TimeSeriesViewer)vlm.viewer);
            }
        }
    }

    public void doLayout() {
        Integer selIndex;
        int rMargin;
        if (!this.layoutManager.isIntialized()) {
            return;
        }
        int containerWidth = this.container.getWidth();
        int containerHeight = this.container.getHeight();
        int containerMargin = 3;
        int componentMargin = 5;
        PlayerLayoutModel[] visualPlayers = this.layoutManager.getAttachedVisualPlayers();
        int numVisualPlayers = visualPlayers.length;
        int mediaAreaHeight = this.layoutManager.getMediaAreaHeight();
        int visibleMediaX = containerMargin;
        int visibleMediaY = containerMargin;
        int visibleMediaWidth = 0;
        int visibleMediaHeight = mediaAreaHeight;
        int firstMediaWidth = visibleMediaWidth;
        if (this.oneRowForVisuals) {
            if (numVisualPlayers >= 1) {
                int maxPerMedia = (containerWidth - this.minTabWidth) / numVisualPlayers;
                int maxUsedHeight = 0;
                for (int i = 0; i < numVisualPlayers && i < 4; ++i) {
                    Component visComp = visualPlayers[i].visualComponent;
                    float aspectRatio = visualPlayers[i].player.getAspectRatio();
                    int curWidth = 0;
                    int curHeight = 0;
                    if ((float)mediaAreaHeight * aspectRatio > (float)maxPerMedia) {
                        curWidth = maxPerMedia;
                        curHeight = (int)((float)maxPerMedia / aspectRatio);
                        maxUsedHeight = curHeight > maxUsedHeight ? curHeight : maxUsedHeight;
                    } else {
                        curWidth = (int)((float)mediaAreaHeight * aspectRatio);
                        curHeight = mediaAreaHeight;
                    }
                    if (i == 0) {
                        visibleMediaWidth = visibleMediaX + curWidth + componentMargin;
                        if (this.mediaInCentre) {
                            visibleMediaX = (containerWidth - visibleMediaWidth * numVisualPlayers) / 2;
                        }
                        visComp.setBounds(visibleMediaX, visibleMediaY, curWidth, curHeight);
                        firstMediaWidth = curWidth;
                        continue;
                    }
                    visComp.setBounds(visibleMediaX + visibleMediaWidth, visibleMediaY, curWidth, curHeight);
                    visibleMediaWidth = visibleMediaWidth + curWidth + componentMargin;
                }
            }
        } else {
            float secondAR;
            Component secondVisualComp;
            float aspectRatio;
            if (numVisualPlayers >= 1) {
                Component firstVisualComp = visualPlayers[0].visualComponent;
                aspectRatio = visualPlayers[0].player.getAspectRatio();
                int firstMediaHeight = mediaAreaHeight;
                firstMediaWidth = 352;
                if (visualPlayers[0].player.getSourceWidth() > 704 && mediaAreaHeight == 250) {
                    firstMediaWidth = visualPlayers[0].player.getSourceWidth() / 2;
                    firstMediaHeight = (int)((float)firstMediaWidth / aspectRatio);
                } else {
                    firstMediaWidth = (int)((float)firstMediaHeight * aspectRatio);
                }
                visibleMediaWidth = firstMediaWidth + componentMargin;
                visibleMediaHeight = firstMediaHeight;
                if (numVisualPlayers == 1) {
                    if (this.mediaInCentre) {
                        visibleMediaX = (containerWidth - visibleMediaWidth) / 2;
                    }
                    firstVisualComp.setBounds(containerMargin + visibleMediaX, visibleMediaY, firstMediaWidth, firstMediaHeight);
                }
            }
            if (numVisualPlayers == 2) {
                secondVisualComp = visualPlayers[1].visualComponent;
                aspectRatio = visualPlayers[1].player.getAspectRatio();
                int secondMediaWidth = (int)((float)visibleMediaHeight * aspectRatio);
                int secondMediaHeight = visibleMediaHeight;
                if (this.mediaInCentre) {
                    visibleMediaX = (containerWidth - (visibleMediaWidth + secondMediaWidth)) / 2;
                }
                visualPlayers[0].visualComponent.setBounds(containerMargin + visibleMediaX, visibleMediaY, firstMediaWidth, visibleMediaHeight);
                if (visualPlayers[1].player.getSourceWidth() > 704 && visualPlayers[1].player.getSourceWidth() > visualPlayers[0].player.getSourceWidth() && (secondMediaHeight = (int)((float)(secondMediaWidth = visualPlayers[1].player.getSourceWidth() / 2) / aspectRatio)) > visibleMediaHeight) {
                    visibleMediaHeight = secondMediaHeight;
                }
                secondVisualComp.setBounds(visibleMediaX + visibleMediaWidth, visibleMediaY, secondMediaWidth, secondMediaHeight);
                visibleMediaWidth += secondMediaWidth + componentMargin;
            } else if (numVisualPlayers == 3) {
                secondVisualComp = visualPlayers[1].visualComponent;
                secondAR = visualPlayers[1].player.getAspectRatio();
                Component thirdVisualComp = visualPlayers[2].visualComponent;
                float thirdAR = visualPlayers[2].player.getAspectRatio();
                int heightPerPlayer = (visibleMediaHeight - componentMargin) / 2;
                int secondWidth = (int)(secondAR * (float)heightPerPlayer);
                int thirdWidth = (int)(thirdAR * (float)heightPerPlayer);
                int widthPerPlayer = Math.max(secondWidth, thirdWidth);
                if (this.mediaInCentre) {
                    visibleMediaX = (containerWidth - (visibleMediaWidth + widthPerPlayer)) / 2;
                }
                visualPlayers[0].visualComponent.setBounds(visibleMediaX, visibleMediaY, firstMediaWidth, (int)((float)firstMediaWidth / visualPlayers[0].player.getAspectRatio()));
                secondVisualComp.setBounds(visibleMediaX + visibleMediaWidth + (widthPerPlayer - secondWidth) / 2, visibleMediaY, secondWidth, heightPerPlayer);
                thirdVisualComp.setBounds(visibleMediaX + visibleMediaWidth + (widthPerPlayer - thirdWidth) / 2, visibleMediaY + heightPerPlayer + componentMargin, thirdWidth, heightPerPlayer);
                visibleMediaWidth += widthPerPlayer + componentMargin;
            } else if (numVisualPlayers >= 4) {
                secondVisualComp = visualPlayers[1].visualComponent;
                secondAR = visualPlayers[1].player.getAspectRatio();
                Component thirdVisualComp = visualPlayers[2].visualComponent;
                float thirdAR = visualPlayers[2].player.getAspectRatio();
                Component fourthVisualComp = visualPlayers[3].visualComponent;
                float fourthAR = visualPlayers[3].player.getAspectRatio();
                int heightPerPlayer = (visibleMediaHeight - 2 * componentMargin) / 3;
                int secondWidth = (int)(secondAR * (float)heightPerPlayer);
                int thirdWidth = (int)(thirdAR * (float)heightPerPlayer);
                int fourthWidth = (int)(fourthAR * (float)heightPerPlayer);
                int widthPerPlayer = Math.max(secondWidth, thirdWidth);
                widthPerPlayer = Math.max(widthPerPlayer, fourthWidth);
                if (this.mediaInCentre) {
                    visibleMediaX = (containerWidth - (visibleMediaWidth + widthPerPlayer)) / 2;
                }
                visualPlayers[0].visualComponent.setBounds(visibleMediaX, visibleMediaY, firstMediaWidth, (int)((float)firstMediaWidth / visualPlayers[0].player.getAspectRatio()));
                secondVisualComp.setBounds(visibleMediaX + visibleMediaWidth + (widthPerPlayer - secondWidth) / 2, visibleMediaY, secondWidth, heightPerPlayer);
                thirdVisualComp.setBounds(visibleMediaX + visibleMediaWidth + (widthPerPlayer - thirdWidth) / 2, visibleMediaY + heightPerPlayer + componentMargin, thirdWidth, heightPerPlayer);
                fourthVisualComp.setBounds(visibleMediaX + visibleMediaWidth + (widthPerPlayer - fourthWidth) / 2, visibleMediaY + 2 * heightPerPlayer + 2 * componentMargin, fourthWidth, heightPerPlayer);
                visibleMediaWidth += widthPerPlayer + componentMargin;
            }
        }
        int tabPaneX = visibleMediaX + visibleMediaWidth;
        int tabPaneY = visibleMediaY;
        int tabPaneWidth = containerWidth - tabPaneX;
        int tabPaneHeight = visibleMediaHeight;
        if (this.mediaInCentre) {
            tabPaneX -= containerMargin;
        }
        if (this.mediaInCentre && numVisualPlayers > 0) {
            tabPaneWidth = visibleMediaX;
            this.getLeftTabPane().setBounds(containerMargin, containerMargin, tabPaneWidth, tabPaneHeight);
        } else {
            this.destroyLeftPane();
        }
        if (this.tabPane != null) {
            this.tabPane.setBounds(tabPaneX, tabPaneY, tabPaneWidth, tabPaneHeight);
            if (this.mediaPlayerController != null && this.controlPanel != null) {
                this.controlPanel.setSize(tabPaneWidth, tabPaneHeight);
            }
        }
        if (this.numOfPlayers != numVisualPlayers && this.numOfPlayers == 0) {
            this.preferenceChanged = true;
        }
        if (this.preferenceChanged || numVisualPlayers == 0) {
            this.reArrangeViewers();
            this.preferenceChanged = false;
        }
        int timePanelX = 0;
        int timePanelY = visibleMediaY + visibleMediaHeight + 2;
        int timePanelWidth = 0;
        int timePanelHeight = 0;
        if (this.mediaPlayerController != null) {
            timePanelWidth = this.mediaPlayerController.getTimePanel().getPreferredSize().width;
            timePanelHeight = this.mediaPlayerController.getTimePanel().getPreferredSize().height;
            timePanelX = numVisualPlayers == 0 ? containerMargin : (this.mediaInCentre ? visibleMediaX + firstMediaWidth / 2 - timePanelWidth / 2 : containerMargin + firstMediaWidth / 2 - timePanelWidth / 2);
            this.mediaPlayerController.getTimePanel().setBounds(timePanelX, timePanelY, timePanelWidth, timePanelHeight);
        }
        int playButtonsX = 3;
        int playButtonsY = timePanelY + timePanelHeight + 4;
        int playButtonsWidth = 0;
        int playButtonsHeight = 0;
        if (this.mediaPlayerController != null) {
            playButtonsWidth = this.mediaPlayerController.getPlayButtonsPanel().getPreferredSize().width;
            playButtonsHeight = this.mediaPlayerController.getPlayButtonsPanel().getPreferredSize().height;
            if (numVisualPlayers > 0) {
                if (this.mediaInCentre) {
                    playButtonsX = visibleMediaX;
                } else {
                    playButtonsX = containerMargin + firstMediaWidth / 2 - playButtonsWidth / 2;
                    if (playButtonsX < 3) {
                        playButtonsX = 3;
                    }
                }
            }
            this.mediaPlayerController.getPlayButtonsPanel().setBounds(playButtonsX, playButtonsY, playButtonsWidth, playButtonsHeight);
        }
        int selectionPanelX = playButtonsX + playButtonsWidth + 20;
        int selectionPanelY = visibleMediaY + visibleMediaHeight + 2;
        int selectionPanelWidth = 0;
        int selectionPanelHeight = 0;
        if (this.mediaPlayerController != null) {
            selectionPanelWidth = 100 + this.mediaPlayerController.getSelectionPanel().getPreferredSize().width;
            selectionPanelHeight = this.mediaPlayerController.getSelectionPanel().getPreferredSize().height;
            this.mediaPlayerController.getSelectionPanel().setBounds(selectionPanelX, selectionPanelY, selectionPanelWidth, selectionPanelHeight);
        }
        int selectionButtonsX = selectionPanelX;
        int selectionButtonsY = selectionPanelY + selectionPanelHeight + 4;
        int selectionButtonsWidth = 0;
        int selectionButtonsHeight = 0;
        if (this.mediaPlayerController != null) {
            selectionButtonsWidth = this.mediaPlayerController.getSelectionButtonsPanel().getPreferredSize().width;
            selectionButtonsHeight = this.mediaPlayerController.getSelectionButtonsPanel().getPreferredSize().height;
            this.mediaPlayerController.getSelectionButtonsPanel().setBounds(selectionButtonsX, selectionButtonsY, selectionButtonsWidth, selectionButtonsHeight);
        }
        int annotationButtonsX = selectionButtonsX + selectionButtonsWidth + 15;
        int annotationButtonsY = selectionPanelY + selectionPanelHeight + 4;
        int annotationButtonsWidth = 0;
        int annotationButtonsHeight = 0;
        if (this.mediaPlayerController != null) {
            annotationButtonsWidth = this.mediaPlayerController.getAnnotationNavigationPanel().getPreferredSize().width;
            annotationButtonsHeight = this.mediaPlayerController.getAnnotationNavigationPanel().getPreferredSize().height;
            this.mediaPlayerController.getAnnotationNavigationPanel().setBounds(annotationButtonsX, annotationButtonsY, annotationButtonsWidth, annotationButtonsHeight);
        }
        int modePanelX = annotationButtonsX + annotationButtonsWidth + 10;
        int modePanelY = annotationButtonsY;
        int modePanelWidth = 0;
        int modePanelHeight = 0;
        if (this.mediaPlayerController != null) {
            modePanelWidth = this.mediaPlayerController.getModePanel().getPreferredSize().width;
            modePanelHeight = this.mediaPlayerController.getModePanel().getPreferredSize().height;
            if (modePanelHeight > annotationButtonsHeight && annotationButtonsHeight > 0) {
                modePanelY -= (modePanelHeight - annotationButtonsHeight) / 2;
            }
            this.mediaPlayerController.getModePanel().setBounds(modePanelX, modePanelY, modePanelWidth, modePanelHeight);
        }
        int butVolumeX = modePanelX + modePanelWidth + 10;
        int butVolumeY = annotationButtonsY;
        int butVolumeWidth = 0;
        int butVolumeHeight = 0;
        if (this.mediaPlayerController != null) {
            butVolumeWidth = this.mediaPlayerController.getButtonSize().width;
            butVolumeHeight = this.mediaPlayerController.getButtonSize().height;
            this.mediaPlayerController.getVolumeIconPanel().setBounds(butVolumeX, butVolumeY, butVolumeWidth, butVolumeHeight);
        }
        if (butVolumeX + butVolumeWidth > containerWidth && this.mediaPlayerController != null) {
            timePanelX = numVisualPlayers == 0 ? containerMargin : containerMargin + firstMediaWidth / 2 - timePanelWidth / 2;
            this.mediaPlayerController.getTimePanel().setBounds(timePanelX, timePanelY, timePanelWidth, timePanelHeight);
            playButtonsX = containerMargin + firstMediaWidth / 2 - playButtonsWidth / 2;
            if (playButtonsX < 3) {
                playButtonsX = 3;
            }
            this.mediaPlayerController.getPlayButtonsPanel().setBounds(playButtonsX, playButtonsY, playButtonsWidth, playButtonsHeight);
            selectionPanelX = playButtonsX + playButtonsWidth + 20;
            this.mediaPlayerController.getSelectionPanel().setBounds(selectionPanelX, selectionPanelY, selectionPanelWidth, selectionPanelHeight);
            selectionButtonsX = selectionPanelX;
            this.mediaPlayerController.getSelectionButtonsPanel().setBounds(selectionButtonsX, selectionButtonsY, selectionButtonsWidth, selectionButtonsHeight);
            annotationButtonsX = selectionButtonsX + selectionButtonsWidth + 15;
            this.mediaPlayerController.getAnnotationNavigationPanel().setBounds(annotationButtonsX, annotationButtonsY, annotationButtonsWidth, annotationButtonsHeight);
            modePanelX = annotationButtonsX + annotationButtonsWidth + 10;
            this.mediaPlayerController.getModePanel().setBounds(modePanelX, modePanelY, modePanelWidth, modePanelHeight);
            butVolumeX = modePanelX + modePanelWidth;
            this.mediaPlayerController.getVolumeIconPanel().setBounds(butVolumeX, butVolumeY, butVolumeWidth, butVolumeHeight);
        }
        int divX = containerWidth - containerMargin - componentMargin - this.vertMediaResizer.getPreferredSize().width;
        int divY = annotationButtonsY + annotationButtonsHeight / 2 - this.vertMediaResizer.getPreferredSize().height / 2;
        this.vertMediaResizer.setBounds(divX, divY, this.vertMediaResizer.getPreferredSize().width, this.vertMediaResizer.getPreferredSize().height);
        int sliderPanelX = 3;
        int sliderPanelY = playButtonsY + playButtonsHeight;
        int sliderPanelWidth = 0;
        int sliderPanelHeight = 0;
        if (this.mediaPlayerController != null) {
            sliderPanelWidth = containerWidth - 6;
            sliderPanelHeight = this.mediaPlayerController.getSliderPanel().getPreferredSize().height;
            this.mediaPlayerController.getSliderPanel().setBounds(sliderPanelX, sliderPanelY, sliderPanelWidth, sliderPanelHeight);
        }
        int densityPanelX = 3;
        int densityPanelY = sliderPanelY + componentMargin;
        int densityPanelWidth = sliderPanelWidth;
        int densityPanelHeight = 0;
        if (this.mediaPlayerController != null) {
            densityPanelHeight = this.mediaPlayerController.getAnnotationDensityViewer().getPreferredSize().height;
            this.mediaPlayerController.getAnnotationDensityViewer().setBounds(densityPanelX, densityPanelY, densityPanelWidth, densityPanelHeight);
        }
        int timeLineSplitPaneX = 3;
        int timeLineSplitPaneY = densityPanelY + densityPanelHeight + 4;
        int timeLineSplitPaneWidth = 0;
        int timeLineSplitPaneHeight = 0;
        if (this.timeLineSplitPane != null) {
            timeLineSplitPaneWidth = containerWidth - 6;
            timeLineSplitPaneHeight = containerHeight - timeLineSplitPaneY;
            this.timeLineSplitPane.setBounds(timeLineSplitPaneX, timeLineSplitPaneY, timeLineSplitPaneWidth, timeLineSplitPaneHeight);
        }
        int multiTierControlX = 0;
        int multiTierControlY = 0;
        int multiTierControlWidth = 0;
        int multiTierControlHeight = 0;
        int timeLineX = 0;
        int timeLineY = 0;
        int timeLineWidth = 0;
        int timeLineHeight = 0;
        int interlinearX = 0;
        int interlinearY = 0;
        int interlinearWidth = 0;
        int interlinearHeight = 0;
        if (this.timeLineComponent != null) {
            int bottomHeight = this.timeLineSplitPane.getHeight() - this.timeLineSplitPane.getDividerLocation() - this.timeLineSplitPane.getDividerSize();
            Insets insets = this.timeLineSplitPane.getInsets();
            this.timeLineComponent.setSize(this.timeLineSplitPane.getWidth() - insets.left - insets.top, bottomHeight - insets.bottom);
            this.timeLineComponent.setPreferredSize(this.timeLineComponent.getSize());
            multiTierControlWidth = this.layoutManager.getMultiTierControlPanelWidth();
            multiTierControlHeight = bottomHeight;
            this.multiTierControlPanel.setSize(multiTierControlWidth, multiTierControlHeight);
            this.multiTierControlPanel.setBounds(multiTierControlX, multiTierControlY, multiTierControlWidth, multiTierControlHeight);
            if (this.showTimeLineViewer) {
                timeLineX = multiTierControlWidth;
                timeLineWidth = this.timeLineSplitPane.getWidth() - multiTierControlWidth;
                timeLineHeight = bottomHeight;
            } else {
                interlinearX = multiTierControlWidth;
                interlinearWidth = this.timeLineSplitPane.getWidth() - multiTierControlWidth;
                interlinearHeight = bottomHeight;
            }
            if (this.timeLineViewer != null) {
                this.timeLineViewer.setBounds(timeLineX, timeLineY, timeLineWidth, timeLineHeight);
                this.timeLineViewer.setPreferredSize(new Dimension(timeLineWidth, timeLineHeight));
                this.timeLineViewer.componentResized(null);
            }
            if (this.interlinearViewer != null) {
                this.interlinearViewer.setBounds(interlinearX, interlinearY, interlinearWidth, interlinearHeight);
                this.interlinearViewer.setPreferredSize(new Dimension(interlinearWidth, interlinearHeight));
                this.interlinearViewer.componentResized(null);
            }
        }
        int signalX = multiTierControlWidth;
        int signalY = 0;
        int signalWidth = 0;
        int signalHeight = 0;
        if (this.wav_tsSplitPane != null && this.signalComponent != null && this.timeseriesComponent != null) {
            int topHeight = this.wav_tsSplitPane.getDividerLocation();
            int rMargin2 = 0;
            if (this.timeLineViewer != null) {
                rMargin2 = this.timeLineViewer.getRightMargin();
            }
            signalWidth = this.timeLineSplitPane.getWidth() - multiTierControlWidth - rMargin2;
            signalHeight = this.wav_tsSplitPane.getHeight() - this.wav_tsSplitPane.getDividerSize() - topHeight;
            this.signalViewer.setBounds(signalX, signalY, signalWidth, signalHeight);
            this.signalComponent.setPreferredSize(new Dimension(signalWidth, signalHeight));
            int tsWidth = 0;
            this.timeseriesViewer.setRightMargin(rMargin2);
            this.timeseriesViewer.setVerticalRulerWidth(multiTierControlWidth);
            tsWidth = this.timeLineSplitPane.getWidth();
            this.timeseriesViewer.setBounds(0, signalY, tsWidth, topHeight);
            this.timeseriesComponent.setPreferredSize(new Dimension(tsWidth, topHeight));
        } else if (this.signalComponent != null && this.signalViewer != null) {
            rMargin = 0;
            if (this.timeLineViewer != null) {
                rMargin = this.timeLineViewer.getRightMargin();
            }
            signalWidth = this.timeLineSplitPane.getWidth() - multiTierControlWidth - rMargin;
            signalHeight = this.signalComponent.getHeight();
            this.signalViewer.setBounds(signalX, signalY, signalWidth, signalHeight);
            this.signalComponent.setPreferredSize(new Dimension(signalWidth, signalHeight));
        } else if (this.timeseriesComponent != null && this.timeseriesViewer != null) {
            rMargin = 0;
            int tsWidth = 0;
            if (this.timeLineViewer != null) {
                rMargin = this.timeLineViewer.getRightMargin();
                this.timeseriesViewer.setRightMargin(rMargin);
            }
            this.timeseriesViewer.setVerticalRulerWidth(multiTierControlWidth);
            tsWidth = this.timeLineSplitPane.getWidth();
            signalHeight = this.timeseriesComponent.getHeight();
            this.timeseriesViewer.setBounds(0, signalY, tsWidth, signalHeight);
            this.timeseriesComponent.setPreferredSize(new Dimension(tsWidth, signalHeight));
        }
        if (this.timeLineSplitPane != null) {
            this.timeLineSplitPane.resetToPreferredSizes();
        }
        if (this.mediaInCentre && (selIndex = (Integer)Preferences.get("LayoutManager.SelectedLeftTabIndex", this.viewerManager.getTranscription())) != null) {
            int index = selIndex;
            if (index >= 0 && index < this.getLeftTabPane().getTabCount()) {
                this.getLeftTabPane().setSelectedIndex(index);
            } else if (this.getLeftTabPane().getTabCount() > 0) {
                this.getLeftTabPane().setSelectedIndex(0);
            }
        }
        this.numOfPlayers = numVisualPlayers;
        this.container.validate();
    }

    public void updateLocale() {
        if (this.tabPane != null) {
            int nTabs = this.tabPane.getTabCount();
            for (int i = 0; i < nTabs; ++i) {
                Component component = this.tabPane.getComponentAt(i);
                if (component == this.gridPanel) {
                    this.tabPane.setTitleAt(i, ElanLocale.getString("Tab.Grid"));
                    continue;
                }
                if (component == this.textPanel) {
                    this.tabPane.setTitleAt(i, ElanLocale.getString("Tab.Text"));
                    continue;
                }
                if (component == this.subtitlePanel) {
                    this.tabPane.setTitleAt(i, ElanLocale.getString("Tab.Subtitles"));
                    continue;
                }
                if (component == this.controlPanel) {
                    this.tabPane.setTitleAt(i, ElanLocale.getString("Tab.Controls"));
                    continue;
                }
                if (component == this.audioRecognizerPanel) {
                    this.tabPane.setTitleAt(i, ElanLocale.getString("Tab.AudioRecognizer"));
                    continue;
                }
                if (component == this.videoRecognizerPanel) {
                    this.tabPane.setTitleAt(i, ElanLocale.getString("Tab.VideoRecognizer"));
                    continue;
                }
                if (component != this.metadataPanel) continue;
                this.tabPane.setTitleAt(i, ElanLocale.getString("Tab.Metadata"));
            }
        }
    }

    public void clearLayout() {
        if (this.layoutManager.containsComponent(this.getTabPane())) {
            this.container.remove(this.getTabPane());
        }
        if (this.layoutManager.containsComponent(this.getLeftTabPane())) {
            this.container.remove(this.getLeftTabPane());
        }
        this.container.remove(this.mediaPlayerController.getPlayButtonsPanel());
        this.container.remove(this.mediaPlayerController.getTimePanel());
        this.container.remove(this.mediaPlayerController.getModePanel());
        this.container.remove(this.mediaPlayerController.getSelectionPanel());
        this.container.remove(this.mediaPlayerController.getSelectionButtonsPanel());
        this.container.remove(this.mediaPlayerController.getAnnotationNavigationPanel());
        this.container.remove(this.mediaPlayerController.getSliderPanel());
        this.container.remove(this.mediaPlayerController.getAnnotationDensityViewer());
        this.container.remove(this.mediaPlayerController.getVolumeIconPanel());
        this.mediaPlayerController.getSliderPanel().removeMouseListener(this.mediaPlayerController.getAnnotationDensityViewer());
        this.viewerManager.destroyAnnotationDensityViewer();
        this.viewerManager.destroyMediaPlayerControlSlider();
        if (this.layoutManager.containsComponent(this.timeLineSplitPane)) {
            this.container.remove(this.timeLineSplitPane);
        }
        if (this.layoutManager.containsComponent(this.vertMediaResizer)) {
            this.container.remove(this.vertMediaResizer);
        }
        if (this.interlinearViewer != null) {
            this.destroyViewer(this.interlinearViewer);
            this.viewerManager.destroyInterlinearViewer();
        }
        if (this.viewerManager.getGridViewer() != null) {
            this.destroyViewer(this.viewerManager.getGridViewer());
            this.viewerManager.destroyGridViewer();
        }
        if (this.viewerManager.getTextViewer() != null) {
            this.destroyViewer(this.viewerManager.getTextViewer());
            this.viewerManager.destroyTextViewer();
        }
        if (this.viewerManager.getSubtitleViewers() != null) {
            if (this.viewerManager.getSubtitleViewers().size() > 0) {
                this.destroyViewer(this.viewerManager.getSubtitleViewers().elementAt(0));
            }
            this.viewerManager.destroySubtitleViewers();
        }
        if (this.viewerManager.getLexiconViewer() != null) {
            this.destroyViewer(this.viewerManager.getLexiconViewer());
            this.viewerManager.destroyLexiconViewer();
        }
        if (this.viewerManager.getSignalViewer() != null) {
            // empty if block
        }
        if (this.viewerManager.getAudioRecognizerPanel() != null) {
            this.destroyViewer(this.viewerManager.getAudioRecognizerPanel());
            this.viewerManager.destroyPanel(this.viewerManager.getAudioRecognizerPanel());
        }
        if (this.viewerManager.getVideoRecognizerPanel() != null) {
            this.destroyViewer(this.viewerManager.getVideoRecognizerPanel());
            this.viewerManager.destroyPanel(this.viewerManager.getVideoRecognizerPanel());
        }
        if (this.viewerManager.getMetadataViewer() != null) {
            this.destroyViewer(this.viewerManager.getMetadataViewer());
            this.viewerManager.destroyMetaDataViewer();
        }
        this.timeseriesViewer = null;
        if (this.timeLineComponent != null) {
            this.timeLineComponent.removeAll();
        }
        this.multiTierControlPanel = null;
        this.destroyViewer(this.timeLineViewer);
        this.viewerManager.destroyTimeLineViewer();
        this.viewerManager.destroyMultiTierControlPanel();
    }

    private void createSubtitleViewer() {
        int numSubtitles = 4;
        Object val = Preferences.get("NumberOfSubtitleViewers", null);
        if (val instanceof Integer) {
            numSubtitles = (Integer)val;
        }
        for (int i = 0; i < numSubtitles; ++i) {
            SubtitleViewer subtitleViewer = this.viewerManager.createSubtitleViewer();
            subtitleViewer.setViewerIndex(i + 1);
            this.add(subtitleViewer);
        }
    }

    public void initComponents() {
        Object val = Preferences.get("Media.VideosCentre", null);
        if (val instanceof Boolean) {
            this.mediaInCentre = (Boolean)val;
        }
        this.viewerManager.getMultiTierControlPanel().preferencesChanged();
        this.layoutManager.add(this.viewerManager.getMediaPlayerController());
        TimeLineViewer timeLineViewer = this.viewerManager.createTimeLineViewer();
        this.add(timeLineViewer);
        val = Preferences.get("Menu.View.Viewers.InterLinear", null);
        if (val instanceof Boolean) {
            if (((Boolean)val).booleanValue()) {
                InterlinearViewer interlinearViewer = this.viewerManager.createInterlinearViewer();
                this.add(interlinearViewer);
                this.viewerManager.getMultiTierControlPanel().disableShowInterlinearViewer(false);
                String conViewerName = (String)Preferences.get("LayoutManager.VisibleMultiTierViewer", this.viewerManager.getTranscription());
                if (conViewerName != null && conViewerName.equals(TimeLineViewer.class.getName())) {
                    if (timeLineViewer != null) {
                        this.showTimeLineViewer();
                        this.getMultiTierControlPanel().setViewer(timeLineViewer);
                    }
                } else if (conViewerName != null && conViewerName.equals(InterlinearViewer.class.getName())) {
                    if (interlinearViewer != null) {
                        this.showInterlinearViewer();
                        this.getMultiTierControlPanel().setViewer(interlinearViewer);
                    }
                } else {
                    this.showTimeLineViewer();
                    this.viewerManager.getMultiTierControlPanel().disableShowInterlinearViewer(true);
                }
            } else {
                this.showTimeLineViewer();
                this.viewerManager.getMultiTierControlPanel().disableShowInterlinearViewer(true);
            }
        }
        if (((val = Preferences.get("Menu.View.Viewers.Grid", null)) == null || val instanceof Boolean) && (val == null || ((Boolean)val).booleanValue())) {
            GridViewer gridViewer = this.viewerManager.createGridViewer();
            this.add(gridViewer);
        }
        if (((val = Preferences.get("Menu.View.Viewers.Text", null)) == null || val instanceof Boolean) && (val == null || ((Boolean)val).booleanValue())) {
            TextViewer textViewer = this.viewerManager.createTextViewer();
            this.add(textViewer);
        }
        if (((val = Preferences.get("Menu.View.Viewers.Subtitles", null)) == null || val instanceof Boolean) && (val == null || ((Boolean)val).booleanValue())) {
            this.createSubtitleViewer();
        }
        if (((val = Preferences.get("LexiconEntryViewer.Lexicon", null)) == null || val instanceof Boolean) && (val == null || ((Boolean)val).booleanValue())) {
            LexiconEntryViewer lexiconEntryViewer = this.viewerManager.createLexiconEntryViewer();
            this.add(lexiconEntryViewer);
        }
        if ((val = Preferences.get("Menu.View.Viewers.Signal", null)) == null || val instanceof Boolean) {
            if (val == null || ((Boolean)val).booleanValue()) {
                if (this.layoutManager.getSignalViewer() != null) {
                    this.add(this.layoutManager.getSignalViewer());
                    this.viewerManager.enableViewer(this.signalViewer);
                    this.signalViewer.setOffset(this.viewerManager.getSignalViewerOffset());
                } else if (this.viewerManager.getSignalMediaURL() != null) {
                    this.layoutManager.add(this.viewerManager.createSignalViewer(this.viewerManager.getSignalMediaURL()));
                }
            } else if (this.layoutManager.getSignalViewer() != null) {
                this.layoutManager.destroyViewer(this.layoutManager.getSignalViewer());
                this.viewerManager.destroySignalViewer();
            }
        }
        if (((val = Preferences.get("Menu.View.Viewers.Audio", null)) == null || val instanceof Boolean) && (val == null || ((Boolean)val).booleanValue()) && this.viewerManager.getAudioPaths() != null && this.viewerManager.getAudioPaths().size() > 0) {
            this.add(this.viewerManager.createAudioRecognizerPanel(this.viewerManager.getAudioPaths()));
        }
        if (((val = Preferences.get("Menu.View.Viewers.Video", null)) == null || val instanceof Boolean) && (val == null || ((Boolean)val).booleanValue()) && this.viewerManager.getVideoPaths() != null && this.viewerManager.getVideoPaths().size() > 0) {
            this.add(this.viewerManager.createVideoRecognizerPanel(this.viewerManager.getVideoPaths()));
        }
        if (((val = Preferences.get("Menu.View.Viewers.MetaData", null)) == null || val instanceof Boolean) && (val == null || ((Boolean)val).booleanValue())) {
            MetadataViewer metadataViewer = this.viewerManager.createMetadataViewer();
            this.add(metadataViewer);
        }
        this.layoutManager.add(this.layoutManager.getTimeSeriesViewer());
        timeLineViewer.requestFocus();
        this.preferencesChanged();
    }

    public void preferencesChanged() {
        Object val;
        Boolean sameSize;
        Integer sigHeight;
        String conViewerName;
        Integer selIndex = (Integer)Preferences.get("LayoutManager.SelectedTabIndex", this.viewerManager.getTranscription());
        if (selIndex != null) {
            int index = selIndex;
            if (index >= 0 && index < this.tabPane.getTabCount()) {
                this.tabPane.setSelectedIndex(index);
            } else {
                this.tabPane.setSelectedIndex(0);
            }
        }
        if ((conViewerName = (String)Preferences.get("LayoutManager.VisibleMultiTierViewer", this.viewerManager.getTranscription())) != null && conViewerName.equals(TimeLineViewer.class.getName())) {
            if (this.timeLineViewer != null) {
                this.showTimeLineViewer();
                this.getMultiTierControlPanel().setViewer(this.timeLineViewer);
            }
        } else if (conViewerName != null && conViewerName.equals(InterlinearViewer.class.getName()) && this.interlinearViewer != null) {
            this.showInterlinearViewer();
            this.getMultiTierControlPanel().setViewer(this.interlinearViewer);
        }
        if ((sigHeight = (Integer)Preferences.get("LayoutManager.SplitPaneDividerLocation", this.viewerManager.getTranscription())) != null && sigHeight > 70 && (this.signalViewer != null || this.timeseriesViewer != null) && this.timeLineSplitPane != null) {
            this.timeLineSplitPane.setDividerLocation(sigHeight);
        }
        if ((sigHeight = (Integer)Preferences.get("LayoutManager.TSWavSplitPaneDividerLocation", this.viewerManager.getTranscription())) != null && this.wav_tsSplitPane != null) {
            this.wav_tsSplitPane.setDividerLocation(sigHeight);
        }
        if (this.tabPane != null) {
            for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
                String tierName;
                SingleTierViewerPanel panel;
                JComponent comp = (JComponent)this.tabPane.getComponent(i);
                if (comp instanceof SingleTierViewerPanel) {
                    String tierName2;
                    panel = (SingleTierViewerPanel)comp;
                    if (panel.getViewer() instanceof GridViewer) {
                        Boolean multiGrid = (Boolean)Preferences.get("GridViewer.MultiTierMode", this.viewerManager.getTranscription());
                        if (multiGrid != null) {
                            panel.setMultiTierMode(multiGrid);
                        }
                        if ((tierName = (String)Preferences.get("GridViewer.TierName", this.viewerManager.getTranscription())) == null) continue;
                        panel.selectTier(tierName);
                        continue;
                    }
                    if (!(panel.getViewer() instanceof TextViewer) || (tierName2 = (String)Preferences.get("TextViewer.TierName", this.viewerManager.getTranscription())) == null) continue;
                    panel.selectTier(tierName2);
                    continue;
                }
                if (comp != this.subtitlePanel) continue;
                Component[] subComps = comp.getComponents();
                int index = 0;
                for (int j = 0; j < subComps.length; ++j) {
                    if (!(subComps[j] instanceof SingleTierViewerPanel) || !((panel = (SingleTierViewerPanel)subComps[j]).getViewer() instanceof SubtitleViewer)) continue;
                    index = ((SubtitleViewer)panel.getViewer()).getViewerIndex();
                    tierName = (String)Preferences.get("SubTitleViewer.TierName-" + index, this.viewerManager.getTranscription());
                    if (tierName == null) continue;
                    panel.selectTier(tierName);
                }
            }
        }
        if ((sameSize = (Boolean)Preferences.get("Media.VideosSameSize", null)) != null) {
            this.oneRowForVisuals = sameSize;
        }
        if ((val = Preferences.get("PreferencesDialog.Viewer.SortOrder", null)) instanceof List) {
            this.viewerSortOrder = (List)val;
        }
        if ((val = Preferences.get("Media.VideosCentre", null)) instanceof Boolean) {
            this.mediaInCentre = (Boolean)val;
        }
        if (this.mediaInCentre) {
            val = Preferences.get("PreferencesDialog.Viewer.Grid.Right", null);
            if (val instanceof Boolean) {
                boolean bl = this.gridViewerLeft = (Boolean)val == false;
            }
            if ((val = Preferences.get("PreferencesDialog.Viewer.Text.Right", null)) instanceof Boolean) {
                boolean bl = this.textViewerLeft = (Boolean)val == false;
            }
            if ((val = Preferences.get("PreferencesDialog.Viewer.Subtitle.Right", null)) instanceof Boolean) {
                boolean bl = this.subtitleViewerLeft = (Boolean)val == false;
            }
            if ((val = Preferences.get("PreferencesDialog.Viewer.Lexicon.Right", null)) instanceof Boolean) {
                boolean bl = this.lexiconViewerLeft = (Boolean)val == false;
            }
            if ((val = Preferences.get("PreferencesDialog.Viewer.Audio.Right", null)) instanceof Boolean) {
                boolean bl = this.audioRecognizerLeft = (Boolean)val == false;
            }
            if ((val = Preferences.get("PreferencesDialog.Viewer.Video.Right", null)) instanceof Boolean) {
                boolean bl = this.videoRecognizerLeft = (Boolean)val == false;
            }
            if ((val = Preferences.get("PreferencesDialog.Viewer.MetaData.Right", null)) instanceof Boolean) {
                this.metaDataLeft = (Boolean)val == false;
            }
        }
        this.preferenceChanged = true;
    }

    public void enableOrDisableMenus(boolean enabled) {
    }

    public void cleanUpOnClose() {
        if (this.timeLineSplitPane != null) {
            this.layoutManager.setPreference("LayoutManager.SplitPaneDividerLocation", this.timeLineSplitPane.getDividerLocation(), this.viewerManager.getTranscription());
        }
        if (this.wav_tsSplitPane != null) {
            this.layoutManager.setPreference("LayoutManager.TSWavSplitPaneDividerLocation", this.wav_tsSplitPane.getDividerLocation(), this.viewerManager.getTranscription());
        }
        this.layoutManager.setPreference("LayoutManager.SelectedTabIndex", this.getTabPane().getSelectedIndex(), this.viewerManager.getTranscription());
        if (this.mediaInCentre && this.getLeftTabPane().getSelectedIndex() >= 0) {
            this.layoutManager.setPreference("LayoutManager.SelectedLeftTabIndex", this.getLeftTabPane().getSelectedIndex(), this.viewerManager.getTranscription());
        }
    }
}

