/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ElanMediaPlayerController;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.VolumeIconPanel;
import mpi.eudico.client.annotator.gui.ResizeComponent;
import mpi.eudico.client.annotator.gui.SegmentationPanel;
import mpi.eudico.client.annotator.layout.ModeLayoutManager;
import mpi.eudico.client.annotator.layout.PlayerLayoutModel;
import mpi.eudico.client.annotator.viewer.SegmentationControlPanel;
import mpi.eudico.client.annotator.viewer.SegmentationViewer2;
import mpi.eudico.client.annotator.viewer.SignalViewer;

public class SegmentationManager
implements ModeLayoutManager {
    private ViewerManager2 viewerManager;
    private ElanLayoutManager layoutManager;
    private Container container;
    private ElanMediaPlayerController mediaPlayerController;
    private SignalViewer signalViewer;
    private JComponent signalComponent;
    private SegmentationViewer2 segmentationViewer;
    private JComponent segmentationComponent;
    private SegmentationPanel segmentationPanel;
    private JScrollPane segmentationPanelScroll;
    private SegmentationControlPanel segmentationControlPanel;
    private JSplitPane timeLineSplitPane;
    private JTabbedPane tabPane;
    private JTabbedPane leftTabPane;
    private JPanel controlPanel;
    private ResizeComponent vertMediaResizer;
    private VolumeIconPanel volumePanel;
    private boolean mediaInCentre = false;
    private boolean oneRowForVisuals = false;
    private boolean preferenceChanged = false;
    private int minTabWidth = 150;
    private int numOfPlayers;
    private int tabIndex = 0;

    public SegmentationManager(ViewerManager2 viewerManager, ElanLayoutManager elanLayoutManager) {
        this.viewerManager = viewerManager;
        this.layoutManager = elanLayoutManager;
        this.controlPanel = new JPanel();
        this.controlPanel.setName(ElanLocale.getString("Tab.Controls"));
        this.controlPanel.setLayout(new GridLayout(2, 1, 10, 10));
        this.controlPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.container = this.layoutManager.getContainer();
        this.vertMediaResizer = new ResizeComponent(this.layoutManager, 1);
        this.container.add(this.vertMediaResizer);
    }

    public void add(Object object) {
        if (object instanceof ElanMediaPlayerController) {
            this.setMediaPlayerController((ElanMediaPlayerController)object);
        } else if (object instanceof SignalViewer) {
            this.setSignalViewer((SignalViewer)object);
        } else if (object instanceof SegmentationViewer2) {
            this.setSegmentationViewer((SegmentationViewer2)object);
        }
    }

    public void remove(Object object) {
        if (object instanceof SignalViewer && object == this.signalViewer) {
            this.signalComponent.remove(this.signalViewer);
            this.timeLineSplitPane.remove(this.signalComponent);
            this.signalViewer = null;
            if (this.segmentationViewer != null) {
                this.segmentationViewer.setTimeScaleConnected(false);
            }
            if (this.layoutManager.isIntialized()) {
                this.doLayout();
            }
        }
    }

    private void setMediaPlayerController(ElanMediaPlayerController mediaPlayerController) {
        this.mediaPlayerController = mediaPlayerController;
        this.container.add(mediaPlayerController.getPlayButtonsPanel());
        this.container.add(mediaPlayerController.getTimePanel());
        this.container.add(mediaPlayerController.getSelectionPanel());
        this.container.add(mediaPlayerController.getSelectionButtonsPanel());
        this.container.add(mediaPlayerController.getSliderPanel());
        this.container.add(mediaPlayerController.getAnnotationDensityViewer());
        mediaPlayerController.getStepAndRepeatPanel().showEnableCheckBox(false);
        this.container.add(mediaPlayerController.getStepAndRepeatPanel());
        this.volumePanel = mediaPlayerController.getVolumeIconPanel();
        this.container.add(this.volumePanel);
        this.controlPanel.add(mediaPlayerController.getVolumePanel());
        this.controlPanel.add(mediaPlayerController.getRatePanel());
        this.addToTabPane(ElanLocale.getString("Tab.Controls"), this.controlPanel);
    }

    private void addToTabPane(String tabName, Component component) {
        this.getTabPane().insertTab(tabName, null, component, tabName, this.tabIndex++);
    }

    private void setSegmentationViewer(SegmentationViewer2 segmentationViewer) {
        this.segmentationViewer = segmentationViewer;
        if (this.segmentationComponent == null) {
            this.segmentationComponent = new JPanel();
            this.segmentationComponent.setLayout(null);
        }
        this.segmentationComponent.add(segmentationViewer);
        if (this.segmentationControlPanel == null) {
            this.segmentationControlPanel = new SegmentationControlPanel(this.viewerManager.getTranscription());
            this.segmentationControlPanel.setSize(120, 120);
            ResizeComponent mcpResize = new ResizeComponent(this.layoutManager, 0, 1);
            mcpResize.setSize(8, 16);
            this.segmentationControlPanel.setResizeComponent(mcpResize);
            this.segmentationControlPanel.setTierOrderObject(this.viewerManager.getTierOrder());
            this.segmentationComponent.add(this.segmentationControlPanel);
            segmentationViewer.setSegmentationControlPanel(this.segmentationControlPanel);
            this.segmentationControlPanel.setViewer(segmentationViewer);
        }
        this.getTimeLineSplitPane().setBottomComponent(this.segmentationComponent);
        if (this.signalViewer != null) {
            Integer sigHeight = (Integer)Preferences.get("LayoutManager.SplitPaneDividerLocation", this.viewerManager.getTranscription());
            if (sigHeight != null && sigHeight > 70) {
                this.timeLineSplitPane.setDividerLocation(sigHeight);
            } else {
                this.timeLineSplitPane.setDividerLocation(70);
            }
            segmentationViewer.setTimeScaleConnected(true);
        }
    }

    private void setSignalViewer(SignalViewer signalViewer) {
        this.signalViewer = signalViewer;
        if (this.signalComponent == null) {
            this.signalComponent = new JPanel();
            this.signalComponent.setLayout(null);
        }
        this.signalComponent.add(signalViewer);
        this.getTimeLineSplitPane().setTopComponent(this.signalComponent);
        if (this.segmentationViewer != null) {
            Integer sigHeight = (Integer)Preferences.get("LayoutManager.SplitPaneDividerLocation", this.viewerManager.getTranscription());
            if (sigHeight != null && sigHeight > 70) {
                this.timeLineSplitPane.setDividerLocation(sigHeight);
            } else {
                this.timeLineSplitPane.setDividerLocation(70);
            }
            this.segmentationViewer.setTimeScaleConnected(true);
        }
        if (this.layoutManager.isIntialized()) {
            this.doLayout();
        }
    }

    private JSplitPane getTimeLineSplitPane() {
        if (this.timeLineSplitPane == null) {
            this.timeLineSplitPane = new JSplitPane(0);
            this.timeLineSplitPane.setOneTouchExpandable(true);
            this.timeLineSplitPane.setDividerLocation(0);
            this.timeLineSplitPane.setContinuousLayout(true);
            this.container.add(this.timeLineSplitPane);
        }
        return this.timeLineSplitPane;
    }

    public void doLayout() {
        if (!this.layoutManager.isIntialized()) {
            return;
        }
        int containerWidth = this.container.getWidth();
        int containerHeight = this.container.getHeight();
        int containerMargin = 3;
        int componentMargin = 5;
        PlayerLayoutModel[] visualPlayers = this.layoutManager.getAttachedVisualPlayers();
        int numVisualPlayers = visualPlayers.length;
        int mediaAreaHeight = this.layoutManager.getMediaAreaHeight();
        int visibleMediaX = containerMargin;
        int visibleMediaY = containerMargin;
        int visibleMediaWidth = 0;
        int visibleMediaHeight = mediaAreaHeight;
        int firstMediaWidth = visibleMediaWidth;
        if (this.oneRowForVisuals) {
            if (numVisualPlayers >= 1) {
                int maxPerMedia = (containerWidth - this.minTabWidth) / numVisualPlayers;
                int maxUsedHeight = 0;
                for (int i = 0; i < numVisualPlayers && i < 4; ++i) {
                    Component visComp = visualPlayers[i].visualComponent;
                    float aspectRatio = visualPlayers[i].player.getAspectRatio();
                    int curWidth = 0;
                    int curHeight = 0;
                    if ((float)mediaAreaHeight * aspectRatio > (float)maxPerMedia) {
                        curWidth = maxPerMedia;
                        curHeight = (int)((float)maxPerMedia / aspectRatio);
                        maxUsedHeight = curHeight > maxUsedHeight ? curHeight : maxUsedHeight;
                    } else {
                        curWidth = (int)((float)mediaAreaHeight * aspectRatio);
                        curHeight = mediaAreaHeight;
                    }
                    if (i == 0) {
                        visibleMediaWidth = visibleMediaX + curWidth + componentMargin;
                        if (this.mediaInCentre) {
                            visibleMediaX = (containerWidth - visibleMediaWidth * numVisualPlayers) / 2;
                        }
                        visComp.setBounds(visibleMediaX, visibleMediaY, curWidth, curHeight);
                        firstMediaWidth = curWidth;
                        continue;
                    }
                    visComp.setBounds(visibleMediaX + visibleMediaWidth, visibleMediaY, curWidth, curHeight);
                    visibleMediaWidth = visibleMediaWidth + curWidth + componentMargin;
                }
            }
        } else {
            float secondAR;
            Component secondVisualComp;
            float aspectRatio;
            if (numVisualPlayers >= 1) {
                Component firstVisualComp = visualPlayers[0].visualComponent;
                aspectRatio = visualPlayers[0].player.getAspectRatio();
                int firstMediaHeight = mediaAreaHeight;
                firstMediaWidth = 352;
                if (visualPlayers[0].player.getSourceWidth() > 704 && mediaAreaHeight == 250) {
                    firstMediaWidth = visualPlayers[0].player.getSourceWidth() / 2;
                    firstMediaHeight = (int)((float)firstMediaWidth / aspectRatio);
                } else {
                    firstMediaWidth = (int)((float)firstMediaHeight * aspectRatio);
                }
                visibleMediaWidth = firstMediaWidth + componentMargin;
                visibleMediaHeight = firstMediaHeight;
                if (numVisualPlayers == 1) {
                    if (this.mediaInCentre) {
                        visibleMediaX = (containerWidth - visibleMediaWidth) / 2;
                    }
                    firstVisualComp.setBounds(containerMargin + visibleMediaX, visibleMediaY, firstMediaWidth, firstMediaHeight);
                }
            }
            if (numVisualPlayers == 2) {
                secondVisualComp = visualPlayers[1].visualComponent;
                aspectRatio = visualPlayers[1].player.getAspectRatio();
                int secondMediaWidth = (int)((float)visibleMediaHeight * aspectRatio);
                int secondMediaHeight = visibleMediaHeight;
                if (this.mediaInCentre) {
                    visibleMediaX = (containerWidth - (visibleMediaWidth + secondMediaWidth)) / 2;
                }
                visualPlayers[0].visualComponent.setBounds(containerMargin + visibleMediaX, visibleMediaY, firstMediaWidth, visibleMediaHeight);
                if (visualPlayers[1].player.getSourceWidth() > 704 && visualPlayers[1].player.getSourceWidth() > visualPlayers[0].player.getSourceWidth() && (secondMediaHeight = (int)((float)(secondMediaWidth = visualPlayers[1].player.getSourceWidth() / 2) / aspectRatio)) > visibleMediaHeight) {
                    visibleMediaHeight = secondMediaHeight;
                }
                secondVisualComp.setBounds(visibleMediaX + visibleMediaWidth, visibleMediaY, secondMediaWidth, secondMediaHeight);
                visibleMediaWidth += secondMediaWidth + componentMargin;
            } else if (numVisualPlayers == 3) {
                secondVisualComp = visualPlayers[1].visualComponent;
                secondAR = visualPlayers[1].player.getAspectRatio();
                Component thirdVisualComp = visualPlayers[2].visualComponent;
                float thirdAR = visualPlayers[2].player.getAspectRatio();
                int heightPerPlayer = (visibleMediaHeight - componentMargin) / 2;
                int secondWidth = (int)(secondAR * (float)heightPerPlayer);
                int thirdWidth = (int)(thirdAR * (float)heightPerPlayer);
                int widthPerPlayer = Math.max(secondWidth, thirdWidth);
                if (this.mediaInCentre) {
                    visibleMediaX = (containerWidth - (visibleMediaWidth + widthPerPlayer)) / 2;
                }
                visualPlayers[0].visualComponent.setBounds(visibleMediaX, visibleMediaY, firstMediaWidth, (int)((float)firstMediaWidth / visualPlayers[0].player.getAspectRatio()));
                secondVisualComp.setBounds(visibleMediaX + visibleMediaWidth + (widthPerPlayer - secondWidth) / 2, visibleMediaY, secondWidth, heightPerPlayer);
                thirdVisualComp.setBounds(visibleMediaX + visibleMediaWidth + (widthPerPlayer - thirdWidth) / 2, visibleMediaY + heightPerPlayer + componentMargin, thirdWidth, heightPerPlayer);
                visibleMediaWidth += widthPerPlayer + componentMargin;
            } else if (numVisualPlayers >= 4) {
                secondVisualComp = visualPlayers[1].visualComponent;
                secondAR = visualPlayers[1].player.getAspectRatio();
                Component thirdVisualComp = visualPlayers[2].visualComponent;
                float thirdAR = visualPlayers[2].player.getAspectRatio();
                Component fourthVisualComp = visualPlayers[3].visualComponent;
                float fourthAR = visualPlayers[3].player.getAspectRatio();
                int heightPerPlayer = (visibleMediaHeight - 2 * componentMargin) / 3;
                int secondWidth = (int)(secondAR * (float)heightPerPlayer);
                int thirdWidth = (int)(thirdAR * (float)heightPerPlayer);
                int fourthWidth = (int)(fourthAR * (float)heightPerPlayer);
                int widthPerPlayer = Math.max(secondWidth, thirdWidth);
                widthPerPlayer = Math.max(widthPerPlayer, fourthWidth);
                if (this.mediaInCentre) {
                    visibleMediaX = (containerWidth - (visibleMediaWidth + widthPerPlayer)) / 2;
                }
                visualPlayers[0].visualComponent.setBounds(visibleMediaX, visibleMediaY, firstMediaWidth, (int)((float)firstMediaWidth / visualPlayers[0].player.getAspectRatio()));
                secondVisualComp.setBounds(visibleMediaX + visibleMediaWidth + (widthPerPlayer - secondWidth) / 2, visibleMediaY, secondWidth, heightPerPlayer);
                thirdVisualComp.setBounds(visibleMediaX + visibleMediaWidth + (widthPerPlayer - thirdWidth) / 2, visibleMediaY + heightPerPlayer + componentMargin, thirdWidth, heightPerPlayer);
                fourthVisualComp.setBounds(visibleMediaX + visibleMediaWidth + (widthPerPlayer - fourthWidth) / 2, visibleMediaY + 2 * heightPerPlayer + 2 * componentMargin, fourthWidth, heightPerPlayer);
                visibleMediaWidth += widthPerPlayer + componentMargin;
            }
        }
        int tabPaneX = visibleMediaX + visibleMediaWidth;
        int tabPaneY = visibleMediaY;
        int tabPaneWidth = containerWidth - tabPaneX;
        int tabPaneHeight = visibleMediaHeight;
        if (this.mediaInCentre) {
            tabPaneX -= containerMargin;
        }
        if (this.mediaInCentre && numVisualPlayers > 0) {
            tabPaneWidth = visibleMediaX;
            this.getLeftTabPane().setBounds(containerMargin, containerMargin, tabPaneWidth, tabPaneHeight);
        } else {
            this.destroyLeftPane();
        }
        if (this.tabPane != null) {
            this.tabPane.setBounds(tabPaneX, tabPaneY, tabPaneWidth, tabPaneHeight);
            if (this.mediaPlayerController != null && this.controlPanel != null) {
                this.controlPanel.setSize(tabPaneWidth, tabPaneHeight);
            }
        }
        if (this.numOfPlayers != numVisualPlayers && this.numOfPlayers == 0) {
            this.preferenceChanged = true;
        }
        if (this.preferenceChanged || numVisualPlayers == 0) {
            this.preferenceChanged = false;
        }
        int timePanelX = 0;
        int timePanelY = visibleMediaY + visibleMediaHeight + 2;
        int timePanelWidth = 0;
        int timePanelHeight = 0;
        if (this.mediaPlayerController != null) {
            timePanelWidth = this.mediaPlayerController.getTimePanel().getPreferredSize().width;
            timePanelHeight = this.mediaPlayerController.getTimePanel().getPreferredSize().height;
            timePanelX = numVisualPlayers == 0 ? containerMargin : (this.mediaInCentre ? visibleMediaX + firstMediaWidth / 2 - timePanelWidth / 2 : containerMargin + firstMediaWidth / 2 - timePanelWidth / 2);
            this.mediaPlayerController.getTimePanel().setBounds(timePanelX, timePanelY, timePanelWidth, timePanelHeight);
        }
        int playButtonsX = 3;
        int playButtonsY = timePanelY + timePanelHeight + 4;
        int playButtonsWidth = 0;
        int playButtonsHeight = 0;
        if (this.mediaPlayerController != null) {
            playButtonsWidth = this.mediaPlayerController.getPlayButtonsPanel().getPreferredSize().width;
            playButtonsHeight = this.mediaPlayerController.getPlayButtonsPanel().getPreferredSize().height;
            if (numVisualPlayers > 0) {
                if (this.mediaInCentre) {
                    playButtonsX = visibleMediaX;
                } else {
                    playButtonsX = containerMargin + firstMediaWidth / 2 - playButtonsWidth / 2;
                    if (playButtonsX < 3) {
                        playButtonsX = 3;
                    }
                }
            }
            this.mediaPlayerController.getPlayButtonsPanel().setBounds(playButtonsX, playButtonsY, playButtonsWidth, playButtonsHeight);
        }
        int selectionPanelX = playButtonsX + playButtonsWidth + 20;
        int selectionPanelY = visibleMediaY + visibleMediaHeight + 2;
        int selectionPanelWidth = 0;
        int selectionPanelHeight = 0;
        if (this.mediaPlayerController != null) {
            selectionPanelWidth = 100 + this.mediaPlayerController.getSelectionPanel().getPreferredSize().width;
            selectionPanelHeight = this.mediaPlayerController.getSelectionPanel().getPreferredSize().height;
            this.mediaPlayerController.getSelectionPanel().setBounds(selectionPanelX, selectionPanelY, selectionPanelWidth, selectionPanelHeight);
        }
        int selectionButtonsX = selectionPanelX;
        int selectionButtonsY = selectionPanelY + selectionPanelHeight + 4;
        int selectionButtonsWidth = 0;
        int selectionButtonsHeight = 0;
        if (this.mediaPlayerController != null) {
            selectionButtonsWidth = this.mediaPlayerController.getSelectionButtonsPanel().getPreferredSize().width;
            selectionButtonsHeight = this.mediaPlayerController.getSelectionButtonsPanel().getPreferredSize().height;
            this.mediaPlayerController.getSelectionButtonsPanel().setBounds(selectionButtonsX, selectionButtonsY, selectionButtonsWidth, selectionButtonsHeight);
            int stepAndRepeatX = selectionButtonsX + selectionButtonsWidth + 20;
            int stepAndRepeatY = selectionButtonsY;
            int stepAndRepeatW = this.mediaPlayerController.getStepAndRepeatPanel().getPreferredSize().width;
            int stepAndRepeatH = this.mediaPlayerController.getStepAndRepeatPanel().getPreferredSize().height;
            this.mediaPlayerController.getStepAndRepeatPanel().setBounds(stepAndRepeatX, stepAndRepeatY, stepAndRepeatW, stepAndRepeatH);
            int volumePanelX = stepAndRepeatX + stepAndRepeatW + 8;
            int volumePanelY = selectionButtonsY;
            int volumePanelW = this.volumePanel.getPreferredSize().width;
            int volumePanelH = this.volumePanel.getPreferredSize().height;
            this.volumePanel.setBounds(volumePanelX, volumePanelY, volumePanelW, volumePanelH);
        }
        int divX = containerWidth - containerMargin - componentMargin - this.vertMediaResizer.getPreferredSize().width;
        int divY = selectionButtonsY + selectionButtonsHeight / 2 - this.vertMediaResizer.getPreferredSize().height / 2;
        this.vertMediaResizer.setBounds(divX, divY, this.vertMediaResizer.getPreferredSize().width, this.vertMediaResizer.getPreferredSize().height);
        int sliderPanelX = 3;
        int sliderPanelY = playButtonsY + playButtonsHeight;
        int sliderPanelWidth = 0;
        int sliderPanelHeight = 0;
        if (this.mediaPlayerController != null) {
            sliderPanelWidth = containerWidth - 6;
            sliderPanelHeight = this.mediaPlayerController.getSliderPanel().getPreferredSize().height;
            this.mediaPlayerController.getSliderPanel().setBounds(sliderPanelX, sliderPanelY, sliderPanelWidth, sliderPanelHeight);
        }
        int densityPanelX = 3;
        int densityPanelY = sliderPanelY + componentMargin;
        int densityPanelWidth = sliderPanelWidth;
        int densityPanelHeight = 0;
        if (this.mediaPlayerController != null) {
            densityPanelHeight = this.mediaPlayerController.getAnnotationDensityViewer().getPreferredSize().height;
            this.mediaPlayerController.getAnnotationDensityViewer().setBounds(densityPanelX, densityPanelY, densityPanelWidth, densityPanelHeight);
        }
        int splitPaneX = 3;
        int splitPaneXPaneY = densityPanelY + densityPanelHeight + 4;
        int splitPaneXPaneWidth = 0;
        int splitPaneXPaneHeight = 0;
        if (this.timeLineSplitPane != null) {
            splitPaneXPaneWidth = containerWidth - 6;
            splitPaneXPaneHeight = containerHeight - splitPaneXPaneY;
            this.timeLineSplitPane.setBounds(splitPaneX, splitPaneXPaneY, splitPaneXPaneWidth, splitPaneXPaneHeight);
        }
        int multiTierControlX = 0;
        int multiTierControlY = 0;
        int multiTierControlWidth = 0;
        int multiTierControlHeight = 0;
        int timeLineX = 0;
        int timeLineY = 0;
        int timeLineWidth = 0;
        int timeLineHeight = 0;
        if (this.segmentationComponent != null) {
            int bottomHeight = this.timeLineSplitPane.getHeight() - this.timeLineSplitPane.getDividerLocation() - this.timeLineSplitPane.getDividerSize();
            Insets insets = this.timeLineSplitPane.getInsets();
            this.segmentationComponent.setSize(this.timeLineSplitPane.getWidth() - insets.left - insets.top, bottomHeight - insets.bottom);
            this.segmentationComponent.setPreferredSize(this.segmentationComponent.getSize());
            multiTierControlWidth = this.layoutManager.getMultiTierControlPanelWidth();
            multiTierControlHeight = bottomHeight;
            this.segmentationControlPanel.setSize(multiTierControlWidth, multiTierControlHeight);
            this.segmentationControlPanel.setBounds(multiTierControlX, multiTierControlY, multiTierControlWidth, multiTierControlHeight);
            timeLineX = multiTierControlWidth;
            timeLineWidth = this.timeLineSplitPane.getWidth() - multiTierControlWidth;
            timeLineHeight = bottomHeight;
            this.segmentationViewer.setBounds(timeLineX, timeLineY, timeLineWidth, timeLineHeight);
            this.segmentationViewer.setPreferredSize(new Dimension(timeLineWidth, timeLineHeight));
            this.segmentationViewer.componentResized(null);
        }
        int signalX = multiTierControlWidth;
        int signalY = 0;
        int signalWidth = 0;
        int signalHeight = 0;
        if (this.signalComponent != null && this.signalViewer != null) {
            int rMargin = 0;
            if (this.segmentationViewer != null) {
                rMargin = this.segmentationViewer.getRightMargin();
            }
            signalWidth = this.timeLineSplitPane.getWidth() - multiTierControlWidth - rMargin;
            signalHeight = this.signalComponent.getHeight();
            this.signalViewer.setBounds(signalX, signalY, signalWidth, signalHeight);
            Insets insets = this.timeLineSplitPane.getInsets();
            this.signalComponent.setSize(this.timeLineSplitPane.getWidth() - insets.left - insets.top, signalHeight - insets.top);
            this.signalComponent.setPreferredSize(this.signalComponent.getSize());
        }
        this.container.validate();
    }

    public void updateLocale() {
        if (this.tabPane != null) {
            int nTabs = this.tabPane.getTabCount();
            for (int i = 0; i < nTabs; ++i) {
                Component component = this.tabPane.getComponentAt(i);
                if (component == this.segmentationPanel) {
                    this.tabPane.setTitleAt(i, ElanLocale.getString("SegmentationDialog.Title"));
                    continue;
                }
                if (component != this.controlPanel) continue;
                this.tabPane.setTitleAt(i, ElanLocale.getString("Tab.Controls"));
            }
        }
        if (this.segmentationPanel != null) {
            this.segmentationPanel.updateLocale();
        }
    }

    public void clearLayout() {
        this.segmentationViewer.setTimeScaleConnected(false);
        this.viewerManager.destroyViewer(this.segmentationViewer);
        this.segmentationViewer.setSegmentationControlPanel(null);
        this.segmentationComponent.remove(this.segmentationViewer);
        this.segmentationComponent.remove(this.segmentationControlPanel);
        if (this.timeLineSplitPane != null) {
            this.timeLineSplitPane.remove(this.segmentationComponent);
        }
        if (this.signalViewer != null) {
            this.signalComponent.remove(this.signalViewer);
            this.timeLineSplitPane.remove(this.signalComponent);
        }
        if (this.timeLineSplitPane != null) {
            this.container.remove(this.timeLineSplitPane);
        }
        if (this.tabPane != null) {
            this.tabPane.removeAll();
            this.container.remove(this.tabPane);
        }
        if (this.leftTabPane != null) {
            this.leftTabPane.removeAll();
            this.container.remove(this.leftTabPane);
        }
        this.container.remove(this.mediaPlayerController.getPlayButtonsPanel());
        this.container.remove(this.mediaPlayerController.getTimePanel());
        this.container.remove(this.mediaPlayerController.getSelectionPanel());
        this.container.remove(this.mediaPlayerController.getSelectionButtonsPanel());
        this.container.remove(this.mediaPlayerController.getSliderPanel());
        this.container.remove(this.mediaPlayerController.getAnnotationDensityViewer());
        this.container.remove(this.volumePanel);
        this.container.remove(this.mediaPlayerController.getStepAndRepeatPanel());
        this.container.remove(this.vertMediaResizer);
        this.container.repaint();
    }

    public void initComponents() {
        this.add(this.viewerManager.createSegmentationViewer());
        this.segmentationPanel = new SegmentationPanel(this.segmentationViewer);
        this.segmentationPanelScroll = new JScrollPane(this.segmentationPanel);
        this.addToTabPane(ElanLocale.getString("SegmentationDialog.Title"), this.segmentationPanelScroll);
        if (this.viewerManager.getSignalViewer() != null) {
            if (this.layoutManager.getSignalViewer() == null) {
                this.layoutManager.add(this.viewerManager.getSignalViewer());
            }
            this.add(this.viewerManager.getSignalViewer());
        }
        this.segmentationViewer.setTimeScaleConnected(true);
        this.add(this.layoutManager.getViewerManager().getMediaPlayerController());
        this.viewerManager.getActiveAnnotation().setAnnotation(null);
        if (this.signalComponent != null) {
            this.signalComponent.addComponentListener(this.layoutManager.new ElanLayoutManager.SignalSplitPaneListener());
        } else {
            this.signalComponent = new JPanel();
            this.signalComponent.setLayout(null);
            this.signalComponent.addComponentListener(this.layoutManager.new ElanLayoutManager.SignalSplitPaneListener());
        }
        this.container.repaint();
        this.doLayout();
        this.container.transferFocusUpCycle();
    }

    private JTabbedPane getTabPane() {
        if (this.tabPane == null) {
            this.tabPane = new JTabbedPane();
            this.container.add(this.tabPane);
        }
        return this.tabPane;
    }

    private JTabbedPane getLeftTabPane() {
        if (this.leftTabPane == null) {
            this.leftTabPane = new JTabbedPane();
            this.container.add(this.leftTabPane);
        }
        return this.leftTabPane;
    }

    private void destroyLeftPane() {
        if (this.leftTabPane != null) {
            this.container.remove(this.leftTabPane);
            this.leftTabPane = null;
        }
    }

    public void attach(Object object) {
    }

    public void detach(Object object) {
    }

    public void preferencesChanged() {
        Boolean sameSize;
        Integer sigHeight = (Integer)Preferences.get("LayoutManager.SplitPaneDividerLocation", this.viewerManager.getTranscription());
        if (sigHeight != null && sigHeight > 70 && this.signalViewer != null && this.timeLineSplitPane != null) {
            this.timeLineSplitPane.setDividerLocation(sigHeight);
        }
        if ((sameSize = (Boolean)Preferences.get("Media.VideosSameSize", null)) != null) {
            this.oneRowForVisuals = sameSize;
        }
        Object val = Preferences.get("Media.VideosCentre", null);
        boolean oldInCentre = this.mediaInCentre;
        if (val instanceof Boolean) {
            this.mediaInCentre = (Boolean)val;
            if (oldInCentre != this.mediaInCentre) {
                if (this.mediaInCentre) {
                    this.getTabPane().remove(this.segmentationPanelScroll);
                    this.getLeftTabPane().addTab(ElanLocale.getString("SegmentationDialog.Title"), null, this.segmentationPanelScroll, ElanLocale.getString("SegmentationDialog.Title"));
                } else {
                    this.getLeftTabPane().remove(this.segmentationPanelScroll);
                    this.destroyLeftPane();
                    this.getTabPane().insertTab(ElanLocale.getString("SegmentationDialog.Title"), null, this.segmentationPanelScroll, ElanLocale.getString("SegmentationDialog.Title"), 0);
                }
            }
        }
    }

    public void enableOrDisableMenus(boolean enabled) {
        ((ElanFrame2)this.layoutManager.getElanFrame()).enableOrDisableMenus(null, 200, enabled);
        ArrayList<String> actions = new ArrayList<String>(8);
        actions.add("CommandActions.NextActiveTier");
        actions.add("CommandActions.PreviousActiveTier");
        actions.add("CommandActions.NextAnnotation");
        actions.add("CommandActions.NextAnnotationEdit");
        actions.add("CommandActions.PreviousAnnotation");
        actions.add("CommandActions.PreviousAnnotationEdit");
        actions.add("CommandActions.AnnotationUp");
        actions.add("CommandActions.AnnotationDown");
        this.layoutManager.enableOrDisableActions(actions, enabled);
    }

    public void cleanUpOnClose() {
        int location;
        if (this.signalViewer != null && this.timeLineSplitPane != null && (location = this.timeLineSplitPane.getDividerLocation()) != 70) {
            this.layoutManager.setPreference("LayoutManager.SplitPaneDividerLocation", new Integer(location), this.viewerManager.getTranscription());
        }
    }
}

