/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.border.SoftBevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ElanMediaPlayerController;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.SelectionPanel;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.ResizeComponent;
import mpi.eudico.client.annotator.layout.ModeLayoutManager;
import mpi.eudico.client.annotator.layout.PlayerLayoutModel;
import mpi.eudico.client.annotator.player.EmptyMediaPlayer;
import mpi.eudico.client.annotator.transcriptionMode.TranscriptionModeSettingsDlg;
import mpi.eudico.client.annotator.transcriptionMode.TranscriptionViewer;
import mpi.eudico.client.annotator.viewer.SignalViewer;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranscriptionManager
implements ModeLayoutManager,
ActionListener,
ChangeListener {
    private ElanLayoutManager layoutManager;
    private Container container;
    private ViewerManager2 viewerManager;
    private Transcription transcription;
    private SignalViewer signalViewer;
    private ResizeComponent horMediaResizer;
    private ElanMediaPlayerController mediaPlayerController;
    private TranscriptionViewer transViewer;
    private JPanel volRatePanel;
    private JLabel volNameLabel;
    private JLabel volValueLabel;
    private JLabel rateNameLabel;
    private JLabel rateValueLabel;
    private JSlider volSlider;
    private JSlider rateSlider;
    private JScrollPane settingsScrollPane;
    private JCheckBox autoPlayBackCB;
    private JCheckBox showTierNamesCB;
    private JCheckBox showColorOnlyOnNoColumnCB;
    private JCheckBox moveViaColumnCB;
    private JCheckBox showActiveCellInCenterCB;
    private JButton changeTypesButton;
    private JSplitPane tableSplitPane;
    private JButton butPlay;
    private JButton butAlignVideoToRight;
    private JCheckBox loopModeCB;
    private Icon playIcon;
    private Icon pauseIcon;
    private Icon alignLeftIcon;
    private Icon alignRightIcon;
    private final String toopTipAlignLeft = ElanLocale.getString("TranscriptionManager.AlignVideoLeft");
    private final String toopTipAlignRight = ElanLocale.getString("TranscriptionManager.AlignVideoRight");
    private boolean videoInRight = false;
    private boolean initialized = false;
    private int numVisualPlayers;
    private static int DEF_SIGNAL_HEIGHT = 200;
    private static final Dimension BUTTON_SIZE = new Dimension(30, 20);
    public static final String COMBOBOX_DEFAULT_STRING = ElanLocale.getString("TranscriptionManager.ComboBoxDefaultString");
    private float zoomLevelSignalViewer = -1.0f;
    private float zoomLevelTimeLineViewer = -1.0f;

    public TranscriptionManager(ViewerManager2 viewerManager, ElanLayoutManager elanLayoutManager) {
        this.viewerManager = viewerManager;
        this.layoutManager = elanLayoutManager;
        this.transcription = viewerManager.getTranscription();
        if (viewerManager.getMasterMediaPlayer() != null) {
            viewerManager.getMasterMediaPlayer().setMediaTime(0L);
        }
        this.container = this.layoutManager.getContainer();
        this.horMediaResizer = new ResizeComponent(this.layoutManager, 0);
        this.horMediaResizer.setBorder(new SoftBevelBorder(0));
        this.horMediaResizer.setPreferredSize(new Dimension(8, this.container.getHeight()));
        Component n = this.horMediaResizer.getComponent(0);
        this.horMediaResizer.remove(n);
        this.horMediaResizer.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 20;
        gbc.weighty = 1.0;
        this.horMediaResizer.add(n, gbc);
        this.container.add(this.horMediaResizer);
    }

    @Override
    public void add(Object object) {
        if (object instanceof SignalViewer) {
            this.setSignalViewer((SignalViewer)object);
        } else if (object instanceof ElanMediaPlayerController) {
            this.setMediaPlayerController((ElanMediaPlayerController)object);
        }
    }

    private void setSignalViewer(SignalViewer signalViewer) {
        this.signalViewer = signalViewer;
        signalViewer.setEnabled(false);
        signalViewer.setMediaTime(0L);
        signalViewer.setSelection(0L, 0L);
        this.container.add(signalViewer);
        signalViewer.setBorder(new SoftBevelBorder(1));
        if (this.initialized) {
            this.doLayout();
            this.transViewer.updateSignalViewer(signalViewer);
        }
    }

    private void setMediaPlayerController(ElanMediaPlayerController mediaPlayerController) {
        this.mediaPlayerController = mediaPlayerController;
        this.container.add(mediaPlayerController.getSelectionPanel());
        ((SelectionPanel)mediaPlayerController.getSelectionPanel()).setNameLabel(ElanLocale.getString("TranscriptionManager.TimeInterval"));
        JComponent timePanel = mediaPlayerController.getTimePanel();
        MouseListener[] listeners = timePanel.getMouseListeners();
        if (listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                timePanel.removeMouseListener(listeners[i]);
            }
        }
        this.container.add(mediaPlayerController.getTimePanel());
        Component[] s = mediaPlayerController.getSelectionButtonsPanel().getComponents();
        for (int i = 0; i < s.length; ++i) {
            s[i].setEnabled(false);
            if (((JButton)s[i]).getAction() != ELANCommandFactory.getCommandAction(this.transcription, "Menu.Play.ToggleCrosshairInSelection")) continue;
            ((JButton)s[i]).setVisible(false);
        }
        this.container.add(mediaPlayerController.getSelectionButtonsPanel());
    }

    @Override
    public void remove(Object object) {
        if (object instanceof SignalViewer) {
            this.container.remove(this.signalViewer);
            this.signalViewer = null;
            this.doLayout();
        }
    }

    @Override
    public void doLayout() {
        float secondAR;
        Component secondVisualComp;
        float aspectRatio;
        int containerWidth = this.container.getWidth();
        int containerHeight = this.container.getHeight();
        int containerMargin = 3;
        int componentMargin = 5;
        int mediaAreaWidth = this.layoutManager.getMediaAreaWidth();
        int visibleMediaX = containerMargin;
        int visibleMediaY = containerMargin;
        int visibleMediaWidth = mediaAreaWidth;
        int visibleMediaHeight = 0;
        int firstMediaWidth = mediaAreaWidth;
        PlayerLayoutModel[] visualPlayers = this.layoutManager.getAttachedVisualPlayers();
        this.numVisualPlayers = visualPlayers.length;
        if (this.numVisualPlayers == 0 && this.videoInRight) {
            visibleMediaX = containerWidth - (visibleMediaWidth + containerMargin);
        }
        if (this.numVisualPlayers >= 1) {
            Component firstVisualComp = visualPlayers[0].visualComponent;
            aspectRatio = visualPlayers[0].player.getAspectRatio();
            if (this.numVisualPlayers >= 2) {
                firstMediaWidth = mediaAreaWidth / 2;
            }
            int firstMediaHeight = (int)((float)firstMediaWidth / aspectRatio);
            visibleMediaWidth = firstMediaWidth;
            visibleMediaHeight = firstMediaHeight;
            if (this.videoInRight) {
                visibleMediaX = containerWidth - (visibleMediaWidth + containerMargin);
            }
            firstVisualComp.setBounds(visibleMediaX, visibleMediaY, firstMediaWidth, firstMediaHeight);
            if (this.numVisualPlayers > 1) {
                visibleMediaWidth += componentMargin;
            }
        }
        if (this.numVisualPlayers == 2) {
            secondVisualComp = visualPlayers[1].visualComponent;
            aspectRatio = visualPlayers[1].player.getAspectRatio();
            int secondMediaWidth = (int)((float)visibleMediaHeight * aspectRatio);
            int secondMediaHeight = visibleMediaHeight;
            if (this.videoInRight) {
                visibleMediaX = containerWidth - (visibleMediaWidth + secondMediaWidth + containerMargin);
                visualPlayers[0].visualComponent.setBounds(visibleMediaX, visibleMediaY, firstMediaWidth, visibleMediaHeight);
            }
            secondVisualComp.setBounds(visibleMediaX + visibleMediaWidth, visibleMediaY, secondMediaWidth, secondMediaHeight);
            visibleMediaWidth += secondMediaWidth;
        } else if (this.numVisualPlayers == 3) {
            secondVisualComp = visualPlayers[1].visualComponent;
            secondAR = visualPlayers[1].player.getAspectRatio();
            Component thirdVisualComp = visualPlayers[2].visualComponent;
            float thirdAR = visualPlayers[2].player.getAspectRatio();
            int heightPerPlayer = (visibleMediaHeight - componentMargin) / 2;
            int secondWidth = (int)(secondAR * (float)heightPerPlayer);
            int thirdWidth = (int)(thirdAR * (float)heightPerPlayer);
            int widthPerPlayer = Math.max(secondWidth, thirdWidth);
            if (this.videoInRight) {
                visibleMediaX = containerWidth - (visibleMediaWidth + widthPerPlayer + containerMargin);
                visualPlayers[0].visualComponent.setBounds(visibleMediaX, visibleMediaY, firstMediaWidth, visibleMediaHeight);
            }
            secondVisualComp.setBounds(visibleMediaX + visibleMediaWidth + (widthPerPlayer - secondWidth) / 2, visibleMediaY, secondWidth, heightPerPlayer);
            thirdVisualComp.setBounds(visibleMediaX + visibleMediaWidth + (widthPerPlayer - thirdWidth) / 2, visibleMediaY + heightPerPlayer + componentMargin, thirdWidth, heightPerPlayer);
            visibleMediaWidth += widthPerPlayer;
        } else if (this.numVisualPlayers >= 4) {
            secondVisualComp = visualPlayers[1].visualComponent;
            secondAR = visualPlayers[1].player.getAspectRatio();
            Component thirdVisualComp = visualPlayers[2].visualComponent;
            float thirdAR = visualPlayers[2].player.getAspectRatio();
            Component fourthVisualComp = visualPlayers[3].visualComponent;
            float fourthAR = visualPlayers[3].player.getAspectRatio();
            int heightPerPlayer = (visibleMediaHeight - 2 * componentMargin) / 3;
            int secondWidth = (int)(secondAR * (float)heightPerPlayer);
            int thirdWidth = (int)(thirdAR * (float)heightPerPlayer);
            int fourthWidth = (int)(fourthAR * (float)heightPerPlayer);
            int widthPerPlayer = Math.max(secondWidth, thirdWidth);
            widthPerPlayer = Math.max(widthPerPlayer, fourthWidth);
            if (this.videoInRight) {
                visibleMediaX = containerWidth - (visibleMediaWidth + widthPerPlayer + containerMargin);
                visualPlayers[0].visualComponent.setBounds(visibleMediaX, visibleMediaY, firstMediaWidth, visibleMediaHeight);
            }
            secondVisualComp.setBounds(visibleMediaX + visibleMediaWidth + (widthPerPlayer - secondWidth) / 2, visibleMediaY, secondWidth, heightPerPlayer);
            thirdVisualComp.setBounds(visibleMediaX + visibleMediaWidth + (widthPerPlayer - thirdWidth) / 2, visibleMediaY + heightPerPlayer + componentMargin, thirdWidth, heightPerPlayer);
            fourthVisualComp.setBounds(visibleMediaX + visibleMediaWidth + (widthPerPlayer - fourthWidth) / 2, visibleMediaY + 2 * heightPerPlayer + 2 * componentMargin, fourthWidth, heightPerPlayer);
            visibleMediaWidth += widthPerPlayer + componentMargin;
        }
        int timePanelX = visibleMediaX;
        int timePanelY = visibleMediaY + visibleMediaHeight + 2;
        int timePanelWidth = 0;
        int timePanelHeight = 0;
        if (this.mediaPlayerController != null) {
            timePanelWidth = this.mediaPlayerController.getTimePanel().getPreferredSize().width;
            timePanelHeight = this.mediaPlayerController.getTimePanel().getPreferredSize().height;
            if (this.numVisualPlayers > 0) {
                timePanelX = visibleMediaX + firstMediaWidth / 2 - timePanelWidth / 2;
            }
            this.mediaPlayerController.getTimePanel().setBounds(timePanelX, timePanelY, timePanelWidth, timePanelHeight);
        }
        int butAlignVideoX = visibleMediaX;
        int butAlignVideoY = timePanelY + timePanelHeight + 4;
        int butAlignVideoWidth = this.butAlignVideoToRight.getPreferredSize().width;
        int butAlignVideoHeight = this.butAlignVideoToRight.getPreferredSize().height;
        this.butAlignVideoToRight.setBounds(butAlignVideoX, butAlignVideoY, butAlignVideoWidth, butAlignVideoHeight);
        int playButtonX = butAlignVideoX + butAlignVideoWidth;
        int playButtonY = butAlignVideoY;
        int playButtonWidth = this.butPlay.getPreferredSize().width;
        int playButtonHeight = this.butPlay.getPreferredSize().height;
        if (this.numVisualPlayers > 0) {
            playButtonX = visibleMediaX + firstMediaWidth / 2 - playButtonWidth * 4 / 2;
        }
        if (playButtonX < butAlignVideoX + butAlignVideoWidth) {
            playButtonX = butAlignVideoX + butAlignVideoWidth;
        }
        this.butPlay.setBounds(playButtonX, playButtonY, playButtonWidth, playButtonHeight);
        int selButtonPanelX = playButtonX + playButtonWidth;
        int selButtonPanelY = playButtonY;
        int selButtonPanelWidth = 0;
        int selButtonPanelHeight = 0;
        if (this.mediaPlayerController != null) {
            selButtonPanelWidth = this.mediaPlayerController.getSelectionButtonsPanel().getPreferredSize().width;
            selButtonPanelHeight = this.mediaPlayerController.getSelectionButtonsPanel().getPreferredSize().height;
            this.mediaPlayerController.getSelectionButtonsPanel().setBounds(selButtonPanelX, selButtonPanelY, selButtonPanelWidth, selButtonPanelHeight);
        }
        int loopModeCBX = selButtonPanelX + selButtonPanelWidth;
        int loopModeCBY = selButtonPanelY;
        int loopModeCBWidth = this.loopModeCB.getPreferredSize().width;
        int loopModeCBHeight = this.loopModeCB.getPreferredSize().height;
        if (this.numVisualPlayers > 0 || this.signalViewer != null) {
            loopModeCBX = visibleMediaX + visibleMediaWidth - loopModeCBWidth;
        }
        if (loopModeCBX < selButtonPanelX + selButtonPanelHeight) {
            loopModeCBX = visibleMediaX;
            loopModeCBY = selButtonPanelY + selButtonPanelHeight + 5;
        }
        this.loopModeCB.setBounds(loopModeCBX, loopModeCBY, loopModeCBWidth, loopModeCBHeight);
        int selPanelX = visibleMediaX;
        int selPanelY = loopModeCBY + loopModeCBHeight + 10;
        int selPanelWidth = 0;
        int selPanelHeight = 0;
        if (this.mediaPlayerController != null) {
            selPanelWidth = this.mediaPlayerController.getSelectionPanel().getPreferredSize().width;
            selPanelHeight = this.mediaPlayerController.getSelectionPanel().getPreferredSize().height;
            if (this.signalViewer != null) {
                selPanelX = visibleMediaX + visibleMediaWidth / 2 - selPanelWidth / 2;
            }
            this.mediaPlayerController.getSelectionPanel().setBounds(selPanelX, selPanelY, selPanelWidth, selPanelHeight);
        }
        int signalX = visibleMediaX;
        int signalY = selPanelY + selPanelHeight + 10;
        int signalWidth = visibleMediaWidth;
        int signalHeight = 0;
        if (this.signalViewer != null) {
            signalHeight = DEF_SIGNAL_HEIGHT / 2;
            this.signalViewer.setBounds(signalX, signalY, signalWidth, signalHeight);
        }
        int volX = visibleMediaX;
        int volY = signalY + signalHeight + 10;
        int volWidth = visibleMediaWidth;
        int volHeight = DEF_SIGNAL_HEIGHT / 2;
        this.getVolumeRatePanel().setBounds(volX, volY, volWidth, volHeight);
        int settingsPanelX = visibleMediaX;
        int settingsPanelY = volY + volHeight + 10;
        int settingsPanelWidth = visibleMediaWidth;
        int settingsPanelHeight = this.getSettingsScrollPane().getPreferredSize().height + this.getSettingsScrollPane().getHorizontalScrollBar().getPreferredSize().height;
        int availableSpace = containerHeight - containerMargin - settingsPanelY;
        if (settingsPanelHeight > availableSpace) {
            settingsPanelHeight = availableSpace;
        }
        this.getSettingsScrollPane().setBounds(settingsPanelX, settingsPanelY, settingsPanelWidth, settingsPanelHeight);
        int divX = visibleMediaX + visibleMediaWidth + containerMargin;
        int divY = containerHeight - this.horMediaResizer.getPreferredSize().height;
        if (this.videoInRight) {
            divX = visibleMediaX - containerMargin - this.horMediaResizer.getPreferredSize().width;
        }
        this.horMediaResizer.setBounds(divX, divY, this.horMediaResizer.getPreferredSize().width, this.horMediaResizer.getPreferredSize().height);
        if (this.viewerManager.getMasterMediaPlayer() instanceof EmptyMediaPlayer && this.signalViewer == null) {
            if (this.mediaPlayerController.getTimePanel() != null) {
                this.mediaPlayerController.getTimePanel().setBounds(0, 0, 0, 0);
            }
            this.butPlay.setBounds(0, 0, 0, 0);
            if (this.mediaPlayerController.getSelectionButtonsPanel() != null) {
                this.mediaPlayerController.getSelectionButtonsPanel().setBounds(0, 0, 0, 0);
            }
            this.loopModeCB.setBounds(0, 0, 0, 0);
            if (this.mediaPlayerController.getSelectionPanel() != null) {
                this.mediaPlayerController.getSelectionPanel().setBounds(0, 0, 0, 0);
            }
            this.getVolumeRatePanel().setBounds(0, 0, 0, 0);
            settingsPanelY = butAlignVideoY + butAlignVideoHeight + 4;
            this.getSettingsScrollPane().setBounds(settingsPanelX, settingsPanelY, settingsPanelWidth, settingsPanelHeight);
        }
        int transPanelX = divX + this.horMediaResizer.getPreferredSize().width + containerMargin;
        int transPanelY = containerMargin;
        int transPanelWidth = containerWidth - transPanelX - containerMargin;
        int transPanelHeight = containerHeight - transPanelY - containerMargin;
        if (this.videoInRight) {
            transPanelX = containerMargin;
            transPanelWidth = containerWidth - visibleMediaWidth - 3 * containerMargin - this.horMediaResizer.getPreferredSize().width;
        }
        this.transViewer.setBounds(transPanelX, transPanelY, transPanelWidth, transPanelHeight);
        this.transViewer.setScrollerSize(transPanelWidth, transPanelHeight);
        this.container.validate();
    }

    @Override
    public void detach(Object object) {
        this.transViewer.focusTable();
    }

    @Override
    public void attach(Object object) {
        this.transViewer.focusTable();
    }

    @Override
    public void updateLocale() {
        if (this.settingsScrollPane != null) {
            this.changeTypesButton.setText(ElanLocale.getString("TranscriptionManager.ChangeSettings"));
            this.autoPlayBackCB.setText(ElanLocale.getString("TranscriptionManager.AutoPlayBack"));
            this.showActiveCellInCenterCB.setText(ElanLocale.getString("TranscriptionManager.ShowActiveCellInCenter"));
            this.showTierNamesCB.setText(ElanLocale.getString("TranscriptionManager.ShowTierNames"));
            this.showColorOnlyOnNoColumnCB.setText(ElanLocale.getString("TranscriptionManager.ShowColorOnlyOnNoColumn"));
            this.moveViaColumnCB.setText(ElanLocale.getString("TranscriptionManager.MoveViaColumn"));
        }
        if (this.volRatePanel != null) {
            this.volNameLabel.setText(ElanLocale.getString("MediaPlayerControlPanel.ElanSlider.Volume"));
            this.rateNameLabel.setText(ElanLocale.getString("MediaPlayerControlPanel.ElanSlider.Rate"));
        }
        if (this.mediaPlayerController != null) {
            ((SelectionPanel)this.mediaPlayerController.getSelectionPanel()).setNameLabel(ElanLocale.getString("TranscriptionManager.TimeInterval"));
        }
    }

    @Override
    public void clearLayout() {
        if (this.mediaPlayerController.getLoopMode()) {
            this.mediaPlayerController.setLoopMode(false);
        }
        this.viewerManager.getMasterMediaPlayer().stop();
        this.transViewer.storePreferences();
        this.transViewer.setActiveAnnotation();
        this.container.remove(this.horMediaResizer);
        this.container.remove(this.transViewer);
        this.container.remove(this.butPlay);
        this.container.remove(this.butAlignVideoToRight);
        this.container.remove(this.loopModeCB);
        this.container.remove(this.getVolumeRatePanel());
        this.container.remove(this.getSettingsScrollPane());
        this.container.remove(this.mediaPlayerController.getTimePanel());
        this.container.remove(this.mediaPlayerController.getSelectionPanel());
        ((SelectionPanel)this.mediaPlayerController.getSelectionPanel()).updateLocale();
        Component[] s = this.mediaPlayerController.getSelectionButtonsPanel().getComponents();
        for (int i = 0; i < s.length; ++i) {
            s[i].setEnabled(true);
            if (((JButton)s[i]).getAction() != ELANCommandFactory.getCommandAction(this.transcription, "Menu.Play.ToggleCrosshairInSelection")) continue;
            ((JButton)s[i]).setVisible(true);
        }
        this.viewerManager.destroyTimePanel();
        this.viewerManager.destroyTranscriptionViewer();
        this.transViewer = null;
        if (this.signalViewer != null) {
            this.signalViewer.setBorder(null);
            this.signalViewer.updateInterval(0L, this.viewerManager.getMasterMediaPlayer().getMediaDuration());
            this.signalViewer.setEnabled(true);
            if (this.zoomLevelSignalViewer > -1.0f) {
                this.setPreference("SignalViewer.ZoomLevel", Float.valueOf(this.zoomLevelSignalViewer), this.transcription);
            } else if (this.zoomLevelTimeLineViewer > -1.0f) {
                this.setPreference("SignalViewer.ZoomLevel", Float.valueOf(this.zoomLevelTimeLineViewer), this.transcription);
            } else {
                this.setPreference("SignalViewer.ZoomLevel", new Float(100.0f), this.transcription);
            }
            this.signalViewer.preferencesChanged();
            this.container.remove(this.signalViewer);
        } else if (this.zoomLevelSignalViewer > -1.0f) {
            this.setPreference("TimeLineViewer.ZoomLevel", Float.valueOf(this.zoomLevelTimeLineViewer), this.transcription);
        } else {
            this.setPreference("TimeLineViewer.ZoomLevel", new Float(100.0f), this.transcription);
        }
    }

    @Override
    public void initComponents() {
        Object zoom = Preferences.get("SignalViewer.ZoomLevel", this.transcription);
        this.zoomLevelSignalViewer = zoom instanceof Float ? ((Float)zoom).floatValue() : -1.0f;
        zoom = Preferences.get("TimeLineViewer.ZoomLevel", this.transcription);
        this.zoomLevelTimeLineViewer = zoom instanceof Float ? ((Float)zoom).floatValue() : -1.0f;
        this.transViewer = this.viewerManager.createTranscriptionViewer();
        this.transViewer.intializeViewer(this);
        this.container.add(this.transViewer);
        this.container.add(this.getVolumeRatePanel());
        this.container.add(this.getSettingsScrollPane());
        this.playIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/PlayButton.gif"));
        this.pauseIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/PauseButton.gif"));
        this.butPlay = new JButton(this.playIcon);
        this.butPlay.setPreferredSize(BUTTON_SIZE);
        this.butPlay.setEnabled(false);
        this.butPlay.addActionListener(this);
        this.container.add(this.butPlay);
        this.alignLeftIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/AlignLeft16.gif"));
        this.alignRightIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/AlignRight16.gif"));
        this.butAlignVideoToRight = new JButton();
        this.butAlignVideoToRight.setIcon(this.alignRightIcon);
        this.butAlignVideoToRight.setPreferredSize(BUTTON_SIZE);
        this.butAlignVideoToRight.addActionListener(this);
        this.butAlignVideoToRight.setToolTipText(this.toopTipAlignRight);
        this.container.add(this.butAlignVideoToRight);
        this.loopModeCB = new JCheckBox(ElanLocale.getString("CommandActions.LoopMode"));
        this.loopModeCB.setFont(Constants.SMALLFONT);
        this.loopModeCB.addActionListener(this);
        this.container.add(this.loopModeCB);
        this.layoutManager.add(this.viewerManager.getMediaPlayerController());
        Object val = Preferences.get("Menu.View.Viewers.Signal", null);
        if (val == null || val instanceof Boolean) {
            if (val == null || ((Boolean)val).booleanValue()) {
                if (this.layoutManager.getSignalViewer() != null) {
                    this.add(this.layoutManager.getSignalViewer());
                    this.viewerManager.enableViewer(this.signalViewer);
                    this.signalViewer.setOffset(this.viewerManager.getSignalViewerOffset());
                } else if (this.viewerManager.getSignalMediaURL() != null) {
                    this.layoutManager.add(this.viewerManager.createSignalViewer(this.viewerManager.getSignalMediaURL()));
                }
            } else if (this.layoutManager.getSignalViewer() != null) {
                this.layoutManager.destroyViewer(this.layoutManager.getSignalViewer());
                this.viewerManager.destroySignalViewer();
            }
        }
        if ((val = Preferences.get("TranscriptionManager.PlaceVideoInRight", this.transcription)) != null && ((Boolean)val).booleanValue()) {
            this.alignVideo();
        }
        this.doLayout();
        this.loadPreferences();
        this.initialized = true;
    }

    public ElanLayoutManager getElanLayoutManager() {
        return this.layoutManager;
    }

    private JSplitPane getTableSplitPane() {
        if (this.tableSplitPane == null) {
            this.tableSplitPane = new JSplitPane(0);
            this.tableSplitPane.setOneTouchExpandable(true);
            this.tableSplitPane.setDividerLocation(0);
            this.tableSplitPane.setContinuousLayout(true);
            this.container.add(this.tableSplitPane);
        }
        return this.tableSplitPane;
    }

    private JScrollPane getSettingsScrollPane() {
        if (this.settingsScrollPane != null) {
            return this.settingsScrollPane;
        }
        JPanel settingsPanel = new JPanel(new GridBagLayout());
        this.changeTypesButton = new JButton(ElanLocale.getString("TranscriptionManager.ChangeSettings"));
        this.changeTypesButton.addActionListener(this);
        this.autoPlayBackCB = new JCheckBox(ElanLocale.getString("TranscriptionManager.AutoPlayBack"));
        this.autoPlayBackCB.setSelected(true);
        this.autoPlayBackCB.addActionListener(this);
        this.showActiveCellInCenterCB = new JCheckBox(ElanLocale.getString("TranscriptionManager.ShowActiveCellInCenter"));
        this.showActiveCellInCenterCB.setSelected(false);
        this.showActiveCellInCenterCB.addActionListener(this);
        this.showTierNamesCB = new JCheckBox(ElanLocale.getString("TranscriptionManager.ShowTierNames"));
        this.showTierNamesCB.setSelected(true);
        this.showTierNamesCB.addActionListener(this);
        this.showColorOnlyOnNoColumnCB = new JCheckBox(ElanLocale.getString("TranscriptionManager.ShowColorOnlyOnNoColumn"));
        this.showColorOnlyOnNoColumnCB.setSelected(false);
        this.showColorOnlyOnNoColumnCB.setEnabled(false);
        this.showColorOnlyOnNoColumnCB.addActionListener(this);
        this.moveViaColumnCB = new JCheckBox(ElanLocale.getString("TranscriptionManager.MoveViaColumn"));
        this.moveViaColumnCB.addActionListener(this);
        Insets insets = new Insets(1, 1, 1, 1);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 0;
        settingsPanel.add((Component)this.autoPlayBackCB, gbc);
        gbc.gridy = 1;
        settingsPanel.add((Component)this.showTierNamesCB, gbc);
        gbc.gridy = 2;
        gbc.insets = new Insets(1, 22, 1, 1);
        settingsPanel.add((Component)this.showColorOnlyOnNoColumnCB, gbc);
        gbc.gridy = 3;
        gbc.insets = insets;
        settingsPanel.add((Component)this.moveViaColumnCB, gbc);
        gbc.gridy = 4;
        settingsPanel.add((Component)this.showActiveCellInCenterCB, gbc);
        gbc.gridy = 5;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        settingsPanel.add((Component)this.changeTypesButton, gbc);
        settingsPanel.setBorder(null);
        this.settingsScrollPane = new JScrollPane(settingsPanel);
        this.settingsScrollPane.setBorder(new TitledBorder(ElanLocale.getString("TranscriptionManager.ChangeSettingsDlg.Title")));
        this.settingsScrollPane.setBackground(settingsPanel.getBackground());
        return this.settingsScrollPane;
    }

    private JPanel getVolumeRatePanel() {
        Insets insets;
        if (this.volRatePanel != null) {
            return this.volRatePanel;
        }
        this.volRatePanel = new JPanel(new GridBagLayout());
        this.volNameLabel = new JLabel(ElanLocale.getString("MediaPlayerControlPanel.ElanSlider.Volume"));
        int volume = (int)(this.viewerManager.getMasterMediaPlayer().getVolume() * 100.0f);
        this.volValueLabel = new JLabel(String.valueOf(volume));
        this.volValueLabel.setFont(this.volValueLabel.getFont().deriveFont(0, 10.0f));
        this.volSlider = new JSlider(0, 100, volume);
        this.volSlider.addChangeListener(this);
        this.rateNameLabel = new JLabel(ElanLocale.getString("MediaPlayerControlPanel.ElanSlider.Rate"));
        int rate = (int)(this.viewerManager.getMasterMediaPlayer().getRate() * 100.0f);
        this.rateValueLabel = new JLabel(String.valueOf(rate));
        this.rateValueLabel.setFont(this.rateValueLabel.getFont().deriveFont(0, 10.0f));
        this.rateSlider = new JSlider(0, 200, rate);
        this.rateSlider.addChangeListener(this);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets = new Insets(1, 1, 1, 1);
        gbc.anchor = 16;
        this.volRatePanel.add((Component)this.volNameLabel, gbc);
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.insets = new Insets(1, 1, 1, 1);
        this.volRatePanel.add((Component)this.rateNameLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = new Insets(1, 6, 1, 1);
        gbc.weighty = 0.5;
        this.volRatePanel.add((Component)this.volValueLabel, gbc);
        gbc.gridy = 2;
        this.volRatePanel.add((Component)this.rateValueLabel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.insets = insets;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.volRatePanel.add((Component)this.volSlider, gbc);
        gbc.gridy = 3;
        this.volRatePanel.add((Component)this.rateSlider, gbc);
        this.volRatePanel.setBorder(new TitledBorder(""));
        return this.volRatePanel;
    }

    private void loadPreferences() {
        this.transViewer.loadPreferences();
        Object val = Preferences.get("TranscriptionManager.MoveViaColumn", null);
        if (val != null) {
            this.moveViaColumnCB.setSelected((Boolean)val);
            this.transViewer.moveViaColumn((Boolean)val);
        }
        if ((val = Preferences.get("TranscriptionManager.AutoPlayBack", null)) != null) {
            this.autoPlayBackCB.setSelected((Boolean)val);
            this.transViewer.setAutoPlayBack((Boolean)val);
        }
        if ((val = Preferences.get("TranscriptionManager.LoopMode", null)) != null) {
            this.loopModeCB.setSelected((Boolean)val);
            if (this.loopModeCB.isSelected()) {
                this.changeLoopMode();
            }
        }
        if ((val = Preferences.get("TranscriptionManager.ScrollToCenter", null)) != null) {
            this.showActiveCellInCenterCB.setSelected((Boolean)val);
            this.transViewer.scrollActiveCellInCenter((Boolean)val);
        }
        if ((val = Preferences.get("TranscriptionManager.ShowTierNames", null)) != null) {
            this.showTierNamesCB.setSelected((Boolean)val);
            this.transViewer.showTierNames((Boolean)val);
            if (this.showTierNamesCB.isSelected()) {
                this.showColorOnlyOnNoColumnCB.setEnabled(false);
            } else {
                this.showColorOnlyOnNoColumnCB.setEnabled(true);
            }
        }
        if ((val = Preferences.get("TranscriptionManager.ShowColorOnlyOnNoColumn", null)) != null) {
            this.showColorOnlyOnNoColumnCB.setSelected((Boolean)val);
            this.transViewer.showColorOnlyOnNoColumn((Boolean)val);
        }
        if ((val = Preferences.get("TranscriptionTable.ColumnTypes", this.transcription)) instanceof List) {
            int i;
            List types = (List)val;
            ArrayList<String> linTypeNames = new ArrayList<String>();
            Vector linTypes = this.transcription.getLinguisticTypes();
            for (i = 0; i < linTypes.size(); ++i) {
                linTypeNames.add(((LinguisticType)linTypes.get(i)).getLinguisticTypeName());
            }
            for (i = 0; i < ((List)val).size(); ++i) {
                if (linTypeNames.contains(((List)val).get(i))) continue;
                types.remove(((List)val).get(i));
            }
            val = Preferences.get("TranscriptionTable.FontSize", null);
            if (types.size() <= 0) {
                TranscriptionModeSettingsDlg settingsDialog = new TranscriptionModeSettingsDlg(this.layoutManager, null, this.transViewer.getTierMap(), this.transViewer.getHiddenTiers(), (Integer)val);
                settingsDialog.setVisible(true);
                this.applyChanges(settingsDialog.getTierMap(), settingsDialog.getHiddenTiersList(), settingsDialog.getColumnTypeList(), settingsDialog.getFontSize(), settingsDialog.isValueChanged());
            } else {
                this.applyChanges(null, null, types, (Integer)val, true);
                this.transViewer.updateTable();
            }
        } else {
            ArrayList<String> colTypes = new ArrayList<String>();
            val = Preferences.get("TranscriptionTable.Column1Type", this.transcription);
            if (val != null) {
                colTypes.add(val.toString());
                val = Preferences.get("TranscriptionTable.Column2Type", this.transcription);
                if (val != null) {
                    colTypes.add(val.toString());
                    val = Preferences.get("TranscriptionTable.Column3Type", this.transcription);
                    if (val != null) {
                        colTypes.add(val.toString());
                    }
                }
            }
            val = Preferences.get("TranscriptionTable.FontSize", null);
            if (colTypes.size() <= 0) {
                TranscriptionModeSettingsDlg settingsDialog = new TranscriptionModeSettingsDlg(this.layoutManager, null, this.transViewer.getTierMap(), this.transViewer.getHiddenTiers(), (Integer)val);
                settingsDialog.setVisible(true);
                this.applyChanges(settingsDialog.getTierMap(), settingsDialog.getHiddenTiersList(), settingsDialog.getColumnTypeList(), settingsDialog.getFontSize(), settingsDialog.isValueChanged());
            } else {
                this.applyChanges(null, null, colTypes, (Integer)val, true);
                this.transViewer.updateTable();
            }
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void editInAnnotationMode() {
        ((ElanFrame2)this.layoutManager.getElanFrame()).setMenuSelected(ElanLocale.getString("Menu.Options.AnnotationMode"), 700);
        this.layoutManager.changeMode(1);
    }

    public void setPreference(String key, Object value, Object document) {
        if (document instanceof Transcription) {
            Preferences.set(key, value, (Transcription)document, false, false);
        } else {
            Preferences.set(key, value, null, false, false);
        }
    }

    private void applyChanges(HashMap<TierImpl, List<TierImpl>> hashMap, List<String> hiddenTiers, List<String> types, Integer size, boolean valueChanged) {
        if (types == null) {
            this.transViewer.focusTable();
            return;
        }
        if (valueChanged) {
            this.transViewer.setColumnTypeList(types);
            this.setPreference("TranscriptionTable.ColumnTypes", types, this.transcription);
            if (hashMap != null) {
                this.transViewer.setTierMap(hashMap);
            }
        }
        if (hiddenTiers != null) {
            this.transViewer.setHiddenTiersList(hiddenTiers);
        }
        if (size != null) {
            if (size != this.transViewer.getFontSize()) {
                this.transViewer.setFontSize(size);
            }
            this.setPreference("TranscriptionTable.FontSize", this.transViewer.getFontSize(), null);
        }
        if (valueChanged) {
            this.transViewer.loadTable();
            this.transViewer.checkForMerge();
        }
        this.transViewer.reValidateTable();
        this.transViewer.focusTable();
    }

    @Override
    public void preferencesChanged() {
    }

    @Override
    public void enableOrDisableMenus(boolean enabled) {
        ((ElanFrame2)this.layoutManager.getElanFrame()).enableOrDisableMenus(null, 200, enabled);
        ArrayList<String> searchMenu = new ArrayList<String>();
        searchMenu.add(ElanLocale.getString("Menu.Search.Find"));
        ((ElanFrame2)this.layoutManager.getElanFrame()).enableOrDisableMenus(searchMenu, 500, enabled);
        ArrayList<String> viewMenu = new ArrayList<String>();
        viewMenu.add(ElanLocale.getString("Menu.View.Shortcuts"));
        ((ElanFrame2)this.layoutManager.getElanFrame()).enableOrDisableMenus(viewMenu, 600, enabled);
    }

    public void setPlayPauseButton(boolean play) {
        if (play) {
            this.butPlay.setIcon(this.playIcon);
        } else {
            this.butPlay.setIcon(this.pauseIcon);
        }
        this.transViewer.focusTable();
    }

    public void enablePlayButton(boolean b) {
        this.butPlay.setEnabled(b);
        Component[] c = this.mediaPlayerController.getSelectionButtonsPanel().getComponents();
        if (c != null) {
            for (int i = 0; i < c.length; ++i) {
                c[i].setEnabled(b);
            }
        }
    }

    public void toggleLoopMode() {
        this.loopModeCB.setSelected(!this.loopModeCB.isSelected());
        this.changeLoopMode();
    }

    private void changeLoopMode() {
        Object[] args = new Object[]{this.mediaPlayerController, this.viewerManager.getMasterMediaPlayer()};
        Command c = ELANCommandFactory.createCommand(this.transcription, "CommandActions.LoopMode");
        c.execute(null, args);
        this.transViewer.focusTable();
        this.setPreference("TranscriptionManager.LoopMode", this.loopModeCB.isSelected(), null);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.volSlider) {
            int volume = this.volSlider.getValue();
            this.volValueLabel.setText(String.valueOf(volume));
            this.viewerManager.getMasterMediaPlayer().setVolume((float)volume / 100.0f);
        } else if (e.getSource() == this.rateSlider) {
            int rate = this.rateSlider.getValue();
            this.rateValueLabel.setText(String.valueOf(rate));
            this.viewerManager.getMasterMediaPlayer().setRate((float)rate / 100.0f);
        }
        this.transViewer.focusTable();
    }

    private void alignVideo() {
        this.videoInRight = !this.videoInRight;
        this.horMediaResizer.changeBehaviourToDecrease(this.videoInRight);
        if (this.videoInRight) {
            this.butAlignVideoToRight.setToolTipText(this.toopTipAlignLeft);
            this.butAlignVideoToRight.setIcon(this.alignLeftIcon);
        } else {
            this.butAlignVideoToRight.setToolTipText(this.toopTipAlignRight);
            this.butAlignVideoToRight.setIcon(this.alignRightIcon);
        }
        this.doLayout();
        this.setPreference("TranscriptionManager.PlaceVideoInRight", this.videoInRight, this.transcription);
        this.transViewer.focusTable();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.butPlay) {
            this.transViewer.playMedia(false);
        } else if (e.getSource() == this.loopModeCB) {
            this.changeLoopMode();
        } else if (e.getSource() == this.butAlignVideoToRight) {
            this.alignVideo();
        } else if (e.getSource() == this.changeTypesButton) {
            this.viewerManager.getMasterMediaPlayer().stop();
            TranscriptionModeSettingsDlg settingsDialog = new TranscriptionModeSettingsDlg(this.layoutManager, this.transViewer.getColumnTypes(), this.transViewer.getTierMap(), this.transViewer.getHiddenTiers(), this.transViewer.getFontSize());
            settingsDialog.setVisible(true);
            this.applyChanges(settingsDialog.getTierMap(), settingsDialog.getHiddenTiersList(), settingsDialog.getColumnTypeList(), settingsDialog.getFontSize(), settingsDialog.isValueChanged());
        } else {
            if (this.viewerManager.getMasterMediaPlayer().isPlaying()) {
                this.viewerManager.getMasterMediaPlayer().start();
            }
            if (e.getSource() == this.showTierNamesCB) {
                this.transViewer.showTierNames(this.showTierNamesCB.isSelected());
                this.setPreference("TranscriptionManager.ShowTierNames", this.showTierNamesCB.isSelected(), null);
                if (this.showTierNamesCB.isSelected()) {
                    this.showColorOnlyOnNoColumnCB.setEnabled(false);
                } else {
                    this.showColorOnlyOnNoColumnCB.setEnabled(true);
                }
            } else if (e.getSource() == this.showColorOnlyOnNoColumnCB) {
                this.transViewer.showColorOnlyOnNoColumn(this.showColorOnlyOnNoColumnCB.isSelected());
                this.setPreference("TranscriptionManager.ShowColorOnlyOnNoColumn", this.showColorOnlyOnNoColumnCB.isSelected(), null);
            } else if (e.getSource() == this.moveViaColumnCB) {
                this.transViewer.moveViaColumn(this.moveViaColumnCB.isSelected());
                this.setPreference("TranscriptionManager.MoveViaColumn", this.moveViaColumnCB.isSelected(), null);
            } else if (e.getSource() == this.autoPlayBackCB) {
                this.transViewer.setAutoPlayBack(this.autoPlayBackCB.isSelected());
                this.setPreference("TranscriptionManager.AutoPlayBack", this.autoPlayBackCB.isSelected(), null);
            } else if (e.getSource() == this.showActiveCellInCenterCB) {
                this.transViewer.scrollActiveCellInCenter(this.showActiveCellInCenterCB.isSelected());
                this.setPreference("TranscriptionManager.ScrollToCenter", this.showActiveCellInCenterCB.isSelected(), null);
            }
            this.transViewer.focusTable();
        }
    }

    @Override
    public void cleanUpOnClose() {
    }
}

