/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.lexicon;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.lexicon.LexiconConfigIO;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.lexicon.LexiconQueryBundle2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LexiconSrvCacheDialog
extends ClosableDialog
implements ActionListener,
ListSelectionListener {
    private List<LexiconQueryBundle2> cacheBundles;
    private DefaultListModel model;
    private JList lexServiceList;
    private JButton applyButton;
    private JButton removeButton;
    private List<LexiconQueryBundle2> results = null;

    public LexiconSrvCacheDialog(Frame owner, boolean modal, List<LexiconQueryBundle2> cacheBundles) throws HeadlessException {
        super(owner, modal);
        this.cacheBundles = cacheBundles;
        this.initComponents();
    }

    public LexiconSrvCacheDialog(Dialog owner, boolean modal, List<LexiconQueryBundle2> cacheBundles) throws HeadlessException {
        super(owner, modal);
        this.cacheBundles = cacheBundles;
        this.initComponents();
    }

    public List<LexiconQueryBundle2> getSelectedBundles() {
        return this.results;
    }

    protected void postInit() {
        this.pack();
        int w = 280;
        int h = 450;
        this.setSize(this.getSize().width < w ? w : this.getSize().width, this.getSize().height < h ? h : this.getSize().height);
        this.setLocationRelativeTo(this.getParent());
    }

    private void initComponents() {
        this.setTitle(ElanLocale.getString("EditLexSrvcDialog.Label.DefinedServices"));
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        JPanel servicesPanel = new JPanel(new GridBagLayout());
        servicesPanel.setBorder(new TitledBorder(ElanLocale.getString("EditLexSrvcDialog.Label.Servicename")));
        this.model = new DefaultListModel();
        if (this.cacheBundles != null) {
            for (int i = 0; i < this.cacheBundles.size(); ++i) {
                this.model.addElement(this.cacheBundles.get(i));
            }
        }
        this.lexServiceList = new JList(this.model);
        this.lexServiceList.addListSelectionListener(this);
        this.applyButton = new JButton(ElanLocale.getString("Button.Import"));
        this.applyButton.addActionListener(this);
        this.applyButton.setEnabled(false);
        this.removeButton = new JButton(ElanLocale.getString("Button.Delete"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(this);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = insets;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        servicesPanel.add((Component)new JScrollPane(this.lexServiceList), gbc);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 6, 0));
        buttonPanel.add(this.removeButton);
        buttonPanel.add(this.applyButton);
        gbc = new GridBagConstraints();
        gbc.anchor = 11;
        gbc.insets = insets;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridy = 1;
        servicesPanel.add((Component)buttonPanel, gbc);
        this.setContentPane(servicesPanel);
        this.postInit();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int[] selIndices;
        if (e.getSource() == this.applyButton) {
            Object[] sels = this.lexServiceList.getSelectedValues();
            if (sels != null && sels.length > 0) {
                this.results = new ArrayList<LexiconQueryBundle2>(sels.length);
                for (int i = 0; i < sels.length; ++i) {
                    this.results.add((LexiconQueryBundle2)sels[i]);
                }
            }
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.removeButton && (selIndices = this.lexServiceList.getSelectedIndices()) != null && selIndices.length > 0) {
            int option = JOptionPane.showConfirmDialog(this, ElanLocale.getString("EditLexSrvcDialog.Message.Confirmdelete"), ElanLocale.getString("Message.Warning"), 0);
            if (option != 0) {
                return;
            }
            this.lexServiceList.removeListSelectionListener(this);
            for (int i = selIndices.length - 1; i >= 0; --i) {
                int index = selIndices[i];
                this.model.removeElementAt(index);
                this.cacheBundles.remove(index);
            }
            this.lexServiceList.clearSelection();
            this.lexServiceList.addListSelectionListener(this);
            this.applyButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            LexiconConfigIO lexIO = new LexiconConfigIO();
            try {
                lexIO.writeLexConfigs(this.cacheBundles);
            }
            catch (Exception ex) {
                ClientLogger.LOG.warning("Error while writing the file: " + ex.getMessage());
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.lexServiceList) {
            boolean sel = this.lexServiceList.getSelectedIndices().length > 0;
            this.applyButton.setEnabled(sel);
            this.removeButton.setEnabled(sel);
        }
    }
}

