/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.md.imdi;

import java.awt.Component;
import java.awt.FontMetrics;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class ImdiKeyRenderer
extends DefaultTableCellRenderer {
    private FontMetrics metrics;
    private final String PREP = "...";

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value instanceof String) {
            String text = (String)value;
            int index = -1;
            if (text.length() > 0) {
                if (text.startsWith("(") && (index = text.indexOf(")")) > -1 && index < text.length() - 1) {
                    text = text.substring(index + 1);
                }
                if ((index = text.indexOf("METATRANSCRIPT")) > -1 && text.length() > "METATRANSCRIPT".length()) {
                    text = text.substring("METATRANSCRIPT".length() + 1);
                }
                if ((index = text.indexOf("MDGroup")) > -1 && text.length() > index + "MDGroup".length() + 1) {
                    text = text.replace("MDGroup.", "");
                }
            }
            this.setText(this.getTruncatedString(text, table.getCellRect((int)row, (int)column, (boolean)false).width));
        }
        return this;
    }

    private String getTruncatedString(String text, int maxWidth) {
        this.metrics = this.getFontMetrics(this.getFont());
        int tw = this.metrics.stringWidth(text);
        if (tw < maxWidth - 5) {
            return text;
        }
        String loopText = text;
        while (tw >= maxWidth - 5) {
            int index = text.indexOf(46);
            if (index == -1) {
                return text;
            }
            text = text.substring(index + 1);
            loopText = "..." + text;
            tw = this.metrics.stringWidth(loopText);
        }
        return loopText;
    }
}

