/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.md.imdi;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.md.DefaultMDViewerComponent;
import mpi.eudico.client.annotator.md.imdi.ImdiFileServiceProvider;
import mpi.eudico.client.annotator.md.imdi.ImdiKeyRenderer;
import mpi.eudico.client.annotator.md.spi.MDServiceProvider;

public class ImdiMDViewerPanel
extends DefaultMDViewerComponent
implements ActionListener,
MouseListener {
    protected JTree tree;
    private final int TABLE = 0;
    private final int TREE = 1;
    private int mode;
    private JPopupMenu popup;
    private JRadioButtonMenuItem tableMI;
    private JRadioButtonMenuItem treeMI;

    private ImdiMDViewerPanel() {
    }

    public ImdiMDViewerPanel(MDServiceProvider provider) {
        super(provider);
    }

    protected void initComponents() {
        this.mode = 0;
        Object val = Preferences.get("Metadata.IMDI.ViewMode", null);
        if (val instanceof String && "Tree".equals(val)) {
            this.mode = 1;
        }
        this.scrollPane = new JScrollPane();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        this.add((Component)this.scrollPane, gbc);
        if (this.mode == 0) {
            this.model = new DefaultTableModel(0, 2);
            this.model.setColumnIdentifiers(new String[]{this.keyColumn, this.valColumn});
            this.mdTable = new JTable(this.model);
            this.mdTable.setEnabled(false);
            this.mdTable.getColumn(this.keyColumn).setCellRenderer(new ImdiKeyRenderer());
            this.mdTable.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
            this.scrollPane.setViewportView(this.mdTable);
            this.mdTable.addMouseListener(this);
        } else {
            this.tree = new JTree(new DefaultMutableTreeNode("Session"));
            ((DefaultTreeCellRenderer)this.tree.getCellRenderer()).setOpenIcon(null);
            ((DefaultTreeCellRenderer)this.tree.getCellRenderer()).setClosedIcon(null);
            ((DefaultTreeCellRenderer)this.tree.getCellRenderer()).setLeafIcon(null);
            ((DefaultTreeCellRenderer)this.tree.getCellRenderer()).setTextNonSelectionColor(Color.BLACK);
            ((DefaultTreeCellRenderer)this.tree.getCellRenderer()).setTextSelectionColor(Color.BLACK);
            this.scrollPane.setViewportView(this.tree);
            this.tree.addMouseListener(this);
        }
    }

    public void setSelectedKeysAndValues(Map keysAndValuesMap) {
        if (this.mode == 1) {
            ((DefaultTreeModel)this.tree.getModel()).setRoot(((ImdiFileServiceProvider)this.provider).getSelectedAsTree());
            this.expandAllRows(this.tree);
        } else {
            super.setSelectedKeysAndValues(keysAndValuesMap);
        }
    }

    private void expandAllRows(JTree tree) {
        for (int i = 0; i < tree.getRowCount(); ++i) {
            tree.expandRow(i);
        }
    }

    private void createPopupMenu() {
        this.popup = new JPopupMenu("Popup");
        ButtonGroup group = new ButtonGroup();
        this.tableMI = new JRadioButtonMenuItem();
        this.tableMI.setSelected(this.mode == 0);
        group.add(this.tableMI);
        this.tableMI.addActionListener(this);
        this.popup.add(this.tableMI);
        this.treeMI = new JRadioButtonMenuItem();
        this.treeMI.setSelected(this.mode == 1);
        group.add(this.treeMI);
        this.treeMI.addActionListener(this);
        this.popup.add(this.treeMI);
        if (this.bundle != null) {
            String text = this.bundle.getString("MetadataViewer.TableView");
            if (text != null) {
                this.tableMI.setText(text);
            } else {
                this.tableMI.setText("Table View");
            }
            text = this.bundle.getString("MetadataViewer.TreeView");
            if (text != null) {
                this.treeMI.setText(text);
            } else {
                this.treeMI.setText("Tree View");
            }
        } else {
            this.tableMI.setText("Table View");
            this.treeMI.setText("Tree View");
        }
    }

    public void setResourceBundle(ResourceBundle bundle) {
        super.setResourceBundle(bundle);
        if (this.popup != null) {
            String text = bundle.getString("MetadataViewer.TableView");
            if (text != null) {
                this.tableMI.setText(text);
            } else {
                this.tableMI.setText("Table View");
            }
            text = bundle.getString("MetadataViewer.TreeView");
            if (text != null) {
                this.treeMI.setText(text);
            } else {
                this.treeMI.setText("Tree View");
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.tableMI) {
            this.mode = 0;
            if (this.tree != null) {
                this.tree.removeMouseListener(this);
            }
            this.model = new DefaultTableModel(0, 2);
            this.model.setColumnIdentifiers(new String[]{this.keyColumn, this.valColumn});
            this.mdTable = new JTable(this.model);
            this.mdTable.setEnabled(false);
            this.mdTable.getColumn(this.keyColumn).setCellRenderer(new ImdiKeyRenderer());
            this.mdTable.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
            this.scrollPane.setViewportView(this.mdTable);
            this.mdTable.addMouseListener(this);
            this.setSelectedKeysAndValues(this.provider.getSelectedKeysAndValues());
            this.tree = null;
            Preferences.set("Metadata.IMDI.ViewMode", "Table", null, false, false);
        } else if (e.getSource() == this.treeMI) {
            this.mode = 1;
            if (this.mdTable != null) {
                this.mdTable.removeMouseListener(this);
            }
            this.tree = new JTree(new DefaultMutableTreeNode("Session"));
            ((DefaultTreeCellRenderer)this.tree.getCellRenderer()).setOpenIcon(null);
            ((DefaultTreeCellRenderer)this.tree.getCellRenderer()).setClosedIcon(null);
            ((DefaultTreeCellRenderer)this.tree.getCellRenderer()).setLeafIcon(null);
            ((DefaultTreeCellRenderer)this.tree.getCellRenderer()).setTextNonSelectionColor(Color.BLACK);
            ((DefaultTreeCellRenderer)this.tree.getCellRenderer()).setTextSelectionColor(Color.BLACK);
            this.scrollPane.setViewportView(this.tree);
            this.tree.addMouseListener(this);
            this.setSelectedKeysAndValues(null);
            this.mdTable = null;
            Preferences.set("Metadata.IMDI.ViewMode", "Tree", null, false, false);
        }
    }

    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e) && e.getButton() == 1 ^ e.isMetaDown() || e.isPopupTrigger()) {
            if (this.popup == null) {
                this.createPopupMenu();
            }
            Point pp = e.getPoint();
            if (this.popup.getWidth() == 0 || this.popup.getHeight() == 0) {
                this.popup.show(this, pp.x, pp.y);
            } else {
                this.popup.show(this, pp.x, pp.y);
                SwingUtilities.convertPointToScreen(pp, this);
                Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
                Window w = SwingUtilities.windowForComponent(this);
                if (pp.x + this.popup.getWidth() > d.width) {
                    pp.x -= this.popup.getWidth();
                }
                if (pp.y + this.popup.getHeight() > d.height) {
                    pp.y -= this.popup.getHeight();
                }
                if (pp.y + this.popup.getHeight() > w.getLocationOnScreen().y + w.getHeight()) {
                    pp.y -= this.popup.getHeight();
                }
                this.popup.setLocation(pp);
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }
}

