/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.multiplefilesedit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.multiplefilesedit.InconsistentChildrenException;
import mpi.eudico.client.annotator.multiplefilesedit.InconsistentTypeException;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MFEModel {
    public static final int TIER_NAMECOLUMN = 0;
    public static final int TIER_TYPECOLUMN = 1;
    public static final int TIER_ANNOTATORCOLUMN = 2;
    public static final int TIER_PARTICIPANTCOLUMN = 3;
    public static final int TIER_CHILDRENCOLUMN = 4;
    public static final int TYPE_NAMECOLUMN = 0;
    public static final int TYPE_DATACATEGORYCOLUMN = 1;
    public static final int TYPE_TIMEALIGNABLECOLUMN = 2;
    public static final int TYPE_STEREO = 3;
    private List<String> type_headers = new ArrayList<String>();
    private List<String> tier_headers = new ArrayList<String>();
    private List<TierImpl> original_tier_data = new ArrayList<TierImpl>();
    private List<LinguisticType> original_type_data = new ArrayList<LinguisticType>();
    private Map<String, List<String>> tier_children = new HashMap<String, List<String>>();
    private Map<TierImpl, TierImpl> orig_to_changed_tierMap = new HashMap<TierImpl, TierImpl>();
    private Map<TierImpl, Changes> tier_to_changesMap = new HashMap<TierImpl, Changes>();
    private List<TierImpl> tier_data = new ArrayList<TierImpl>();
    private List<LinguisticType> type_data = new ArrayList<LinguisticType>();
    private List<Changes> tier_changes = new ArrayList<Changes>();
    private List<Changes> type_changes = new ArrayList<Changes>();
    private List<Boolean> flagged_tiers = new ArrayList<Boolean>();
    private List<Boolean> type_consistency;
    private List<Boolean> tier_type_consistency = new ArrayList<Boolean>();
    private boolean removable_tiers = true;

    public MFEModel() {
        this.type_consistency = new ArrayList<Boolean>();
        this.setLocale();
    }

    public int getTierColumnCount() {
        return this.tier_headers.size();
    }

    public int getTierRowCount() {
        return this.tier_data.size();
    }

    public String getTierColumnName(int col) {
        return this.tier_headers.get(col);
    }

    public Object getTierValueAt(int row, int col) {
        String val = "";
        if (this.withinTierBounds(row, col)) {
            TierImpl tier = this.tier_data.get(row);
            switch (col) {
                case 0: {
                    val = tier.getName();
                    break;
                }
                case 1: {
                    LinguisticType type = tier.getLinguisticType();
                    if (type != null) {
                        val = type.getLinguisticTypeName();
                        break;
                    }
                    val = "";
                    break;
                }
                case 2: {
                    val = tier.getAnnotator();
                    break;
                }
                case 3: {
                    val = tier.getParticipant();
                    break;
                }
                case 4: {
                    String tier_name = this.getTierName(row);
                    String children = "";
                    List<String> _children = this.tier_children.get(tier_name);
                    if (_children != null) {
                        for (String child : _children) {
                            children = children + child + " ";
                        }
                    }
                    val = children;
                }
            }
        }
        return val;
    }

    public TierImpl getTierByName(String name) {
        for (TierImpl tier : this.tier_data) {
            if (!tier.getName().equals(name)) continue;
            return tier;
        }
        return null;
    }

    public String getTierName(int row) {
        return this.tier_data.get(row).getName();
    }

    public int[] getTiersWithTypesByIndex(List<LinguisticType> types) {
        ArrayList<Integer> tiers_with_types = new ArrayList<Integer>();
        for (TierImpl tier : this.tier_data) {
            if (!types.contains(tier.getLinguisticType())) continue;
            tiers_with_types.add(this.tier_data.indexOf(tier));
        }
        int[] tiers_with_types_indeces = new int[tiers_with_types.size()];
        int i = 0;
        for (Integer index : tiers_with_types) {
            tiers_with_types_indeces[i++] = index;
        }
        return tiers_with_types_indeces;
    }

    public void changeTierValueAt(Object value, int row, int col) {
        TierImpl tier = this.tier_data.get(row);
        switch (col) {
            case 0: {
                tier.setName((String)value);
                break;
            }
            case 1: {
                String name = (String)value;
                if (name.equals(ElanLocale.getString("MFE.Multiple"))) break;
                LinguisticType type = this.getLinguisticType(name);
                tier.setLinguisticType(type);
                break;
            }
            case 2: {
                String annotator1 = tier.getAnnotator();
                String annotator2 = (String)value;
                if (annotator2.contains(",")) break;
                if (annotator1.contains(",")) {
                    int n = JOptionPane.showConfirmDialog(null, ElanLocale.getString("MFE.OverrideAnnotatorDiag"), ElanLocale.getString("MFE.OverrideAnnotatorDiagTitle"), 0, 2);
                    if (n != 0) break;
                    tier.setAnnotator(annotator2);
                    break;
                }
                tier.setAnnotator(annotator2);
                break;
            }
            case 3: {
                String participant1 = tier.getAnnotator();
                String participant2 = (String)value;
                if (participant2.contains(",")) break;
                if (participant1.contains(",")) {
                    int n = JOptionPane.showConfirmDialog(null, ElanLocale.getString("MFE.OverrideParticipantDiag"), ElanLocale.getString("MFE.OverrideParticipantDiagTitle"), 0, 2);
                    if (n != 0) break;
                    tier.setAnnotator(participant2);
                    break;
                }
                tier.setAnnotator(participant2);
            }
        }
        Changes curChange = this.tier_to_changesMap.get(tier);
        if (curChange == Changes.NEW || curChange == Changes.NEW_MODIFIED) {
            this.tier_to_changesMap.put(tier, Changes.NEW_MODIFIED);
        } else {
            this.tier_to_changesMap.put(tier, Changes.MODIFIED);
        }
    }

    private int getTierIndex(String name) {
        for (int i = 0; i < this.tier_data.size(); ++i) {
            if (!this.tier_data.get(i).getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    public void flagTier(int row) {
        String name = this.getTierName(row);
        this.flagDependingTiers(name);
        this.flagged_tiers.set(row, true);
    }

    private void flagDependingTiers(String tierName) {
        List<String> children = this.tier_children.get(tierName);
        if (children != null) {
            for (String child : children) {
                int i = this.getTierIndex(child);
                if (i == -1) {
                    System.out.println("Child not found in tier data...." + child);
                } else {
                    this.flagged_tiers.set(i, true);
                }
                this.flagDependingTiers(child);
            }
        }
    }

    public void removeFlaggedTiers() {
        for (int i = this.flagged_tiers.size() - 1; i >= 0; --i) {
            if (!this.flagged_tiers.get(i).booleanValue()) continue;
            TierImpl tier = this.tier_data.remove(i);
            this.flagged_tiers.remove(i);
            this.tier_changes.set(i, Changes.REMOVED);
            if (tier == null) continue;
            this.tier_to_changesMap.put(tier, Changes.REMOVED);
        }
    }

    private boolean withinTierBounds(int row, int col) {
        return row >= 0 && row < this.tier_data.size() && this.tier_data.size() > 0 && col >= 0 && col < this.tier_headers.size() && this.tier_headers.size() > 0;
    }

    public Changes getTierChangeByOriginalName(String name) {
        TierImpl o_tier = null;
        for (TierImpl _o_tier : this.original_tier_data) {
            if (!_o_tier.getName().equals(name)) continue;
            o_tier = _o_tier;
            break;
        }
        if (o_tier != null) {
            return this.tier_to_changesMap.get(this.orig_to_changed_tierMap.get(o_tier));
        }
        return null;
    }

    public List<String> getChildrenOfTier(String name) {
        return this.tier_children.get(name);
    }

    public TierImpl getTierByOriginalName(String o_name) {
        int o_index = -1;
        TierImpl tier = null;
        for (int i = 0; i < this.original_tier_data.size(); ++i) {
            TierImpl o_tier = this.original_tier_data.get(i);
            if (!o_tier.getName().equals(o_name)) continue;
            o_index = i;
            tier = o_tier;
            break;
        }
        if (tier != null) {
            return this.orig_to_changed_tierMap.get(tier);
        }
        return null;
    }

    public int addOriginalTier(String name, String type, String annotator, String participant, String parent) throws InconsistentChildrenException {
        TierImpl o_tier = this.tierAllreadyAdded(name);
        int o_index = this.original_tier_data.indexOf(o_tier);
        if (o_tier != null) {
            String _participant;
            String _annotator;
            TierImpl tier = this.getTierByName(name);
            String _type = o_tier.getLinguisticType().getLinguisticTypeName();
            if (!_type.equals(type)) {
                LinguisticType multi = new LinguisticType(ElanLocale.getString("MFE.Multiple"));
                o_tier.setLinguisticType(multi);
                tier.setLinguisticType(multi);
            }
            if (this.tier_type_consistency.get(o_index).booleanValue()) {
                this.tier_type_consistency.set(o_index, this.isConsistentType(this.type_data.indexOf(this.getLinguisticType(type))));
            }
            if (!(_annotator = o_tier.getAnnotator()).contains(annotator) && annotator != "") {
                if (annotator != "") {
                    o_tier.setAnnotator(_annotator + ", " + annotator);
                    tier.setAnnotator(_annotator + ", " + annotator);
                } else if (!_annotator.startsWith(", ") || _annotator == "") {
                    o_tier.setAnnotator(", " + _annotator);
                    tier.setAnnotator(", " + _annotator);
                }
            }
            if (!(_participant = o_tier.getParticipant()).contains(participant) && participant != "") {
                if (participant != "") {
                    o_tier.setParticipant(_participant + ", " + participant);
                    tier.setParticipant(_participant + ", " + participant);
                } else if (!_participant.startsWith(", ") || _participant == "") {
                    o_tier.setParticipant(", " + _participant);
                    tier.setParticipant(", " + _participant);
                }
            }
            if (parent != null && !parent.equals("")) {
                String parentOfTierInModel = "";
                Iterator<String> it = this.tier_children.keySet().iterator();
                while (it.hasNext()) {
                    String loadedParent = it.next().toString();
                    if (!this.tier_children.get(loadedParent).contains(name)) continue;
                    parentOfTierInModel = loadedParent;
                }
                if (parentOfTierInModel.equals("")) {
                    throw new InconsistentChildrenException(parent, name, null);
                }
                if (!parentOfTierInModel.equals(parent)) {
                    throw new InconsistentChildrenException(parent, name, parentOfTierInModel);
                }
            } else {
                boolean consistent = true;
                String loadedParents = "";
                Iterator<String> it = this.tier_children.keySet().iterator();
                while (it.hasNext()) {
                    String loadedParent = it.next().toString();
                    if (!this.tier_children.get(loadedParent).contains(name)) continue;
                    loadedParents = loadedParents + loadedParent + " ";
                    consistent = false;
                }
                if (!consistent) {
                    throw new InconsistentChildrenException(null, name, loadedParents);
                }
            }
            return this.tier_data.indexOf(tier);
        }
        LinguisticType _type = this.getLinguisticType(type);
        o_tier = new TierImpl(name, participant, null, _type);
        o_tier.setAnnotator(annotator);
        TierImpl tier = new TierImpl(name, participant, null, _type);
        tier.setAnnotator(annotator);
        if (parent != null && !parent.equals("")) {
            List<String> children = this.tier_children.get(parent);
            if (children != null) {
                children.add(name);
            } else {
                children = new ArrayList<String>();
                children.add(name);
                this.tier_children.put(parent, children);
            }
        }
        this.original_tier_data.add(o_tier);
        this.tier_data.add(tier);
        this.orig_to_changed_tierMap.put(o_tier, tier);
        this.tier_to_changesMap.put(tier, Changes.NONE);
        this.tier_changes.add(Changes.NONE);
        this.flagged_tiers.add(false);
        this.tier_type_consistency.add(this.isConsistentType(this.type_data.indexOf(_type)));
        return this.tier_data.indexOf(tier);
    }

    private TierImpl tierAllreadyAdded(String name) {
        for (TierImpl tier : this.original_tier_data) {
            if (!tier.getName().equals(name)) continue;
            return tier;
        }
        return null;
    }

    public int addTier(String name, String type, String annotator, String participant) {
        LinguisticType _type = this.getLinguisticType(type);
        TierImpl tier = new TierImpl(name, participant, null, _type);
        tier.setAnnotator(annotator);
        this.tier_data.add(tier);
        this.tier_changes.add(Changes.NEW);
        this.tier_to_changesMap.put(tier, Changes.NEW);
        this.flagged_tiers.add(false);
        this.tier_type_consistency.add(true);
        return this.tier_data.indexOf(tier);
    }

    public boolean isTypeConsistentTier(int tier_row) {
        return this.tier_type_consistency.get(tier_row);
    }

    public List<TierImpl> getTiers() {
        return this.tier_data;
    }

    public Changes getTierChange(int i) {
        return this.tier_changes.get(i);
    }

    public String[] getLinguisticTypeNames() {
        String[] types = new String[this.type_data.size()];
        for (int i = 0; i < this.type_data.size(); ++i) {
            types[i] = this.type_data.get(i).getLinguisticTypeName();
        }
        return types;
    }

    public String[] getLinguisticTypeNamesByTier(int row) {
        int i;
        TierImpl tier = this.tier_data.get(row);
        ArrayList<String> type_names = new ArrayList<String>();
        type_names.add(ElanLocale.getString("MFE.Multiple"));
        boolean onlyTimeAlignable = false;
        int stereotype = -1;
        if (tier.getLinguisticType().getConstraints() == null) {
            onlyTimeAlignable = true;
        } else {
            stereotype = tier.getLinguisticType().getConstraints().getStereoType();
        }
        if (onlyTimeAlignable) {
            for (i = 0; i < this.type_data.size(); ++i) {
                if (this.type_data.get(i).getConstraints() != null) continue;
                type_names.add(this.type_data.get(i).getLinguisticTypeName());
            }
        } else if (stereotype >= 0) {
            for (i = 0; i < this.type_data.size(); ++i) {
                Constraint cs = this.type_data.get(i).getConstraints();
                if (cs == null || cs.getStereoType() != stereotype) continue;
                type_names.add(this.type_data.get(i).getLinguisticTypeName());
            }
        }
        String[] filtered_type_names = new String[type_names.size()];
        for (int i2 = 0; i2 < type_names.size(); ++i2) {
            filtered_type_names[i2] = (String)type_names.get(i2);
        }
        return filtered_type_names;
    }

    public String[] getConsistentLinguisticTypeNames() {
        ArrayList<String> consistent_types = new ArrayList<String>();
        for (int i = 0; i < this.type_data.size(); ++i) {
            if (!this.type_consistency.get(i).booleanValue()) continue;
            consistent_types.add(this.type_data.get(i).getLinguisticTypeName());
        }
        String[] types = new String[consistent_types.size()];
        for (int i = 0; i < consistent_types.size(); ++i) {
            types[i] = (String)consistent_types.get(i);
        }
        return types;
    }

    public int getTypeColumnCount() {
        return this.type_headers.size();
    }

    public int getTypeRowCount() {
        return this.type_data.size();
    }

    public String getTypeColumnName(int col) {
        return this.type_headers.get(col);
    }

    public Object getTypeValueAt(int row, int col) {
        Object val = "";
        if (this.withinTypeBounds(row, col)) {
            LinguisticType type = this.type_data.get(row);
            switch (col) {
                case 0: {
                    val = type.getLinguisticTypeName();
                    break;
                }
                case 3: {
                    if (type.getConstraints() != null) {
                        String[] publicStereoTypes = Constraint.publicStereoTypes;
                        val = type.getConstraints();
                        break;
                    }
                    val = "";
                    break;
                }
                case 1: {
                    val = type.getDataCategory();
                    val = val == null ? "" : val;
                    break;
                }
                case 2: {
                    val = type.isTimeAlignable();
                }
            }
        }
        return val;
    }

    public void changeTypeValueAt(Object value, int row, int col) {
        LinguisticType type = this.type_data.get(row);
        switch (col) {
            case 0: {
                String name = (String)value;
                if (this.getLinguisticType(name) != null || name == "") break;
                String old_type_name = this.type_data.get(row).getLinguisticTypeName();
                for (TierImpl tier : this.tier_data) {
                    String type_name;
                    LinguisticType old_type = tier.getLinguisticType();
                    if (old_type == null || (type_name = old_type.getLinguisticTypeName()) == null || !type_name.equals(old_type_name)) continue;
                    old_type.setLinguisticTypeName((String)value);
                }
                type.setLinguisticTypeName((String)value);
                if (this.type_changes.get(row) == Changes.NEW || this.type_changes.get(row) == Changes.NEW_MODIFIED) {
                    this.type_changes.set(row, Changes.NEW_MODIFIED);
                    break;
                }
                this.type_changes.set(row, Changes.MODIFIED);
                break;
            }
        }
    }

    public void removeTypeRow(int row) {
        this.type_data.remove(row);
    }

    private boolean withinTypeBounds(int row, int col) {
        return row >= 0 && row < this.type_data.size() && this.type_data.size() > 0 && col >= 0 && col < this.type_headers.size() && this.type_headers.size() > 0;
    }

    public Changes getTypeChangeByOriginalName(String o_name) {
        LinguisticType o_type = null;
        for (LinguisticType _o_type : this.original_type_data) {
            if (!_o_type.getLinguisticTypeName().equals(o_name)) continue;
            o_type = _o_type;
            break;
        }
        if (o_type != null) {
            int index = this.original_type_data.indexOf(o_type);
            return this.type_changes.get(index);
        }
        return null;
    }

    public LinguisticType getTypeByOriginalName(String o_name) {
        int o_index = -1;
        for (int i = 0; i < this.original_type_data.size(); ++i) {
            LinguisticType o_type = this.original_type_data.get(i);
            if (!o_type.getLinguisticTypeName().equals(o_name)) continue;
            o_index = i;
            break;
        }
        if (o_index >= 0) {
            int nr_removed_types = 0;
            for (int i = 0; i < this.type_changes.size() || i <= o_index; ++i) {
                nr_removed_types += this.type_changes.get(i) == Changes.REMOVED ? 1 : 0;
            }
            return this.type_data.get(o_index -= nr_removed_types);
        }
        return null;
    }

    public LinguisticType getLinguisticType(String name) {
        LinguisticType type = null;
        for (LinguisticType t : this.type_data) {
            if (!t.getLinguisticTypeName().equals(name)) continue;
            type = t;
        }
        return type;
    }

    public int addOriginalType(LinguisticType o_type) throws InconsistentTypeException {
        boolean contains = false;
        LinguisticType existing_type = null;
        for (LinguisticType type : this.original_type_data) {
            if (!(contains |= o_type.getLinguisticTypeName().equals(type.getLinguisticTypeName()))) continue;
            existing_type = type;
            break;
        }
        if (contains) {
            String type_datac;
            int existing_index = this.original_type_data.indexOf(existing_type);
            String existing_datac = existing_type.getDataCategory();
            if (existing_datac != (type_datac = o_type.getDataCategory()) || existing_type.isTimeAlignable() != o_type.isTimeAlignable()) {
                this.type_consistency.set(existing_index, false);
                throw new InconsistentTypeException(o_type);
            }
        } else {
            this.type_consistency.add(true);
            this.original_type_data.add(o_type);
            LinguisticType type = new LinguisticType(new String(o_type.getLinguisticTypeName()));
            type.addConstraint(o_type.getConstraints());
            type.setDataCategory(o_type.getDataCategory());
            type.setTimeAlignable(o_type.isTimeAlignable());
            this.type_data.add(type);
            this.type_changes.add(Changes.NONE);
        }
        return this.type_data.indexOf(o_type);
    }

    public boolean isConsistentType(int type_row) {
        return this.type_consistency.get(type_row);
    }

    public int addType(String name, String dataCategory, boolean timeAlignable, Constraint constraint) {
        LinguisticType type = new LinguisticType(name);
        type.setDataCategory(dataCategory);
        type.addConstraint(constraint);
        type.setTimeAlignable(timeAlignable);
        this.type_data.add(type);
        this.type_changes.add(Changes.NEW);
        this.type_consistency.add(true);
        return this.type_data.indexOf(type);
    }

    public void clear() {
        this.type_headers.clear();
        this.tier_headers.clear();
        this.original_tier_data.clear();
        this.original_type_data.clear();
        this.tier_children.clear();
        this.tier_data.clear();
        this.type_data.clear();
        this.tier_changes.clear();
        this.type_changes.clear();
        this.flagged_tiers.clear();
        this.orig_to_changed_tierMap.clear();
        this.tier_to_changesMap.clear();
        this.tier_type_consistency.clear();
        this.type_consistency.clear();
        this.setRemovableTiers(true);
        this.setLocale();
    }

    public void setRemovableTiers(boolean b) {
        this.removable_tiers = b;
    }

    public boolean areTiersRemovable() {
        return this.removable_tiers;
    }

    public List<LinguisticType> getTypes() {
        return this.type_data;
    }

    public Changes getTypeChange(int i) {
        return this.type_changes.get(i);
    }

    private void setLocale() {
        this.type_headers.add(ElanLocale.getString("EditTypeDialog.Label.Type"));
        this.type_headers.add(ElanLocale.getString("MFE.TypeHeader.DataCategory"));
        this.type_headers.add(ElanLocale.getString("EditTypeDialog.Label.TimeAlignable"));
        this.tier_headers.add(ElanLocale.getString("MFE.TierHeader.Name"));
        this.tier_headers.add(ElanLocale.getString("MFE.TierHeader.LinguisticType"));
        this.tier_headers.add(ElanLocale.getString("MFE.TierHeader.Annotator"));
        this.tier_headers.add(ElanLocale.getString("MFE.TierHeader.Participant"));
        this.tier_headers.add(ElanLocale.getString("MFE.TierHeader.Children"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Changes {
        NONE,
        MODIFIED,
        REMOVED,
        NEW,
        NEW_MODIFIED;

    }
}

