/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.multiplefilesedit;

import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.multiplefilesedit.MFEModel;
import mpi.eudico.client.annotator.multiplefilesedit.MFETable;
import mpi.eudico.client.annotator.multiplefilesedit.RowModel;
import mpi.eudico.client.annotator.multiplefilesedit.TableByTierModel;

public class MFETierTable
extends MFETable {
    private static final long serialVersionUID = -3438987131220519500L;
    private RowModel rm;

    public MFETierTable(MFEModel model) {
        super(model);
        this.setModel(new TableByTierModel(model));
        this.setRowEditorModel(new RowModel());
    }

    public void initCombobox() {
        int row_count = this.getModel().getRowCount();
        for (int i = 0; i < row_count; ++i) {
            String[] linguistic_types = this.model.getLinguisticTypeNamesByTier(i);
            this.rm.addEditorForRow(i, new MyComboBoxEditor(linguistic_types));
            this.rm.addRendererForRow(i, new MyComboBoxRenderer(linguistic_types));
        }
        this.repaint();
    }

    public void newRow(int new_row) {
        String[] linguistic_types = this.model.getLinguisticTypeNamesByTier(new_row);
        this.rm.addEditorForRow(new_row, new MyComboBoxEditor(linguistic_types));
        this.rm.addRendererForRow(new_row, new MyComboBoxRenderer(linguistic_types));
    }

    public void setRowEditorModel(RowModel rm) {
        this.rm = rm;
    }

    public RowModel getRowEditorModel() {
        return this.rm;
    }

    public TableCellEditor getCellEditor(int row, int col) {
        if (col == 1) {
            TableCellEditor tmpEditor = null;
            if (this.rm != null) {
                tmpEditor = this.rm.getEditor(row);
            }
            if (tmpEditor != null) {
                return tmpEditor;
            }
        }
        return super.getCellEditor(row, col);
    }

    public TableCellRenderer getCellRenderer(int row, int col) {
        if (col == 1) {
            TableCellRenderer tmpRenderer = null;
            if (this.rm != null) {
                tmpRenderer = this.rm.getRenderer(row);
            }
            if (tmpRenderer != null) {
                return tmpRenderer;
            }
        }
        return super.getCellRenderer(row, col);
    }

    private class MyComboBoxEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 7602794950936468795L;

        public MyComboBoxEditor(String[] items) {
            super(new JComboBox<String>(items));
        }
    }

    private class MyComboBoxRenderer
    extends JComboBox
    implements TableCellRenderer {
        private static final long serialVersionUID = 7619116878007010125L;

        public MyComboBoxRenderer(String[] items) {
            super(items);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            if (!MFETierTable.this.model.isTypeConsistentTier(row)) {
                this.setSelectedItem(ElanLocale.getString("MFE.Multiple"));
                this.setEnabled(false);
            } else {
                this.setSelectedItem(value);
                this.setEnabled(true);
            }
            return this;
        }
    }
}

