/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.multiplefilesedit.create;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.util.ElanFileFilter;

public class CreateTranscriptionsDialog
extends ClosableDialog
implements ActionListener,
ChangeListener {
    private JButton sourceButton;
    private JButton templateButton;
    private JRadioButton sameFolderRB;
    private JRadioButton otherFolderRB;
    private JButton destFolderButton;
    private JCheckBox combineVideoCB;
    private JRadioButton suffixRB;
    private JRadioButton prefixRB;
    private JButton startButton;
    private JButton closeButton;
    private JTextField sourceTF;
    private JTextField templateTF;
    private JTextField destFolderTF;

    public CreateTranscriptionsDialog(Frame owner) throws HeadlessException {
        super(owner);
        this.initComponents();
    }

    public CreateTranscriptionsDialog(Frame owner, boolean modal) throws HeadlessException {
        super(owner, modal);
        this.initComponents();
        this.postInit();
    }

    private void postInit() {
        this.pack();
        this.setSize(this.getWidth() + 200, this.getHeight());
        this.setLocationRelativeTo(this.getParent());
    }

    private void initComponents() {
        this.setTitle(ElanLocale.getString("Menu.File.MultiEAFCreationToolTip"));
        this.getContentPane().setLayout(new GridBagLayout());
        JPanel pane = new JPanel();
        pane.setLayout(new GridBagLayout());
        pane.setBorder(new TitledBorder(ElanLocale.getString("TokenizeDialog.Label.Options")));
        Insets insets = new Insets(4, 6, 0, 6);
        Insets indent = new Insets(4, 26, 0, 6);
        JLabel sourceLabel = new JLabel("Select folder containing media files");
        this.sourceTF = new JTextField();
        this.sourceTF.setEnabled(false);
        this.sourceButton = new JButton("Browse");
        JLabel templateLabel = new JLabel("Select template");
        this.templateTF = new JTextField();
        this.templateTF.setEnabled(false);
        this.templateButton = new JButton("Browse");
        JLabel transLocationLabel = new JLabel("Store eaf files");
        this.sameFolderRB = new JRadioButton("in same folder as media");
        this.sameFolderRB.setSelected(true);
        this.otherFolderRB = new JRadioButton("in folder:");
        ButtonGroup fGroup = new ButtonGroup();
        fGroup.add(this.sameFolderRB);
        fGroup.add(this.otherFolderRB);
        this.destFolderButton = new JButton("Browse");
        this.destFolderButton.setEnabled(false);
        this.destFolderTF = new JTextField();
        this.destFolderTF.setEnabled(false);
        this.destFolderTF.setEditable(false);
        this.combineVideoCB = new JCheckBox("Combine videos based on");
        this.suffixRB = new JRadioButton("different suffix");
        this.suffixRB.setSelected(true);
        this.suffixRB.setEnabled(false);
        this.prefixRB = new JRadioButton("different prefix");
        this.prefixRB.setEnabled(false);
        ButtonGroup combGroup = new ButtonGroup();
        combGroup.add(this.suffixRB);
        combGroup.add(this.prefixRB);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 1, 6, 2));
        this.startButton = new JButton("Start");
        this.closeButton = new JButton("Close");
        buttonPanel.add(this.startButton);
        buttonPanel.add(this.closeButton);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        pane.add((Component)sourceLabel, gbc);
        gbc.gridwidth = 1;
        gbc.gridy = 1;
        pane.add((Component)this.sourceTF, gbc);
        gbc.gridx = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        pane.add((Component)this.sourceButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        pane.add((Component)templateLabel, gbc);
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        pane.add((Component)this.templateTF, gbc);
        gbc.gridx = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        pane.add((Component)this.templateButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        pane.add((Component)transLocationLabel, gbc);
        gbc.gridy = 5;
        gbc.insets = indent;
        pane.add((Component)this.sameFolderRB, gbc);
        gbc.gridy = 6;
        pane.add((Component)this.otherFolderRB, gbc);
        gbc.gridy = 7;
        gbc.gridwidth = 1;
        pane.add((Component)this.destFolderTF, gbc);
        gbc.gridx = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.insets = insets;
        pane.add((Component)this.destFolderButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 8;
        gbc.gridwidth = 1;
        gbc.insets = insets;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        pane.add((Component)this.combineVideoCB, gbc);
        gbc.gridy = 9;
        gbc.insets = indent;
        pane.add((Component)this.suffixRB, gbc);
        gbc.gridy = 10;
        pane.add((Component)this.prefixRB, gbc);
        gbc = new GridBagConstraints();
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)pane, gbc);
        gbc.gridy = 1;
        gbc.anchor = 11;
        gbc.fill = 0;
        gbc.insets = new Insets(2, 6, 2, 6);
        this.getContentPane().add((Component)buttonPanel, gbc);
        this.loadPreferences();
        this.sourceButton.addActionListener(this);
        this.templateButton.addActionListener(this);
        this.destFolderButton.addActionListener(this);
        this.startButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.combineVideoCB.addChangeListener(this);
        this.sameFolderRB.addChangeListener(this);
        this.otherFolderRB.addChangeListener(this);
    }

    private void loadPreferences() {
    }

    private void savePreferences() {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.sourceButton) {
            this.getSourceFolder();
        } else if (e.getSource() == this.templateButton) {
            this.getTemplate();
        } else if (e.getSource() == this.destFolderButton) {
            this.getDestinationFolder();
        } else if (e.getSource() == this.startButton) {
            this.create();
        } else if (e.getSource() == this.closeButton) {
            this.setVisible(false);
            this.dispose();
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.combineVideoCB) {
            boolean enable = this.combineVideoCB.isSelected();
            this.suffixRB.setEnabled(enable);
            this.prefixRB.setEnabled(enable);
        } else if (e.getSource() == this.sameFolderRB) {
            this.destFolderButton.setEnabled(false);
            this.destFolderTF.setEnabled(false);
        } else if (e.getSource() == this.otherFolderRB) {
            this.destFolderButton.setEnabled(true);
            this.destFolderTF.setEnabled(true);
        }
    }

    private void getSourceFolder() {
        File selDir;
        String dir = (String)Preferences.get("MediaDir", null);
        JFileChooser chooser = new JFileChooser();
        if (dir != null) {
            File f = new File(dir);
            try {
                if (f.exists()) {
                    chooser.setCurrentDirectory(f);
                }
            }
            catch (Exception fnfe) {
                // empty catch block
            }
        }
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle("Select folder containing media files");
        int option = chooser.showOpenDialog(this);
        if (option == 0 && (selDir = chooser.getCurrentDirectory()) != null) {
            Preferences.set("MediaDir", selDir.getAbsolutePath(), null);
            this.sourceTF.setText(selDir.getAbsolutePath());
        }
    }

    private void getTemplate() {
        File selFile;
        String templateDir = (String)Preferences.get("TemplateDir", null);
        JFileChooser chooser = new JFileChooser();
        if (templateDir != null) {
            File f = new File(templateDir);
            try {
                if (f.exists()) {
                    chooser.setCurrentDirectory(f);
                }
            }
            catch (Exception fnfe) {
                // empty catch block
            }
        }
        FileFilter templateFilter = ElanFileFilter.createFileFilter(4);
        chooser.addChoosableFileFilter(templateFilter);
        chooser.setFileFilter(templateFilter);
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle("Select a template file");
        int option = chooser.showOpenDialog(this);
        if (option == 0 && (selFile = chooser.getSelectedFile()) != null) {
            this.templateTF.setText(selFile.getAbsolutePath());
            File selDir = chooser.getCurrentDirectory();
            if (selDir != null) {
                Preferences.set("TemplateDir", selDir.getAbsolutePath(), null);
            }
        }
    }

    private void getDestinationFolder() {
        File selDir;
        String dir = (String)Preferences.get("LastUsedEAFDir", null);
        JFileChooser chooser = new JFileChooser();
        if (dir != null) {
            File f = new File(dir);
            try {
                if (f.exists()) {
                    chooser.setCurrentDirectory(f);
                }
            }
            catch (Exception fnfe) {
                // empty catch block
            }
        }
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle("Select destination folder for the transcription files");
        int option = chooser.showOpenDialog(this);
        if (option == 0 && (selDir = chooser.getCurrentDirectory()) != null) {
            Preferences.set("LastUsedEAFDir", selDir.getAbsolutePath(), null);
            this.destFolderTF.setText(selDir.getAbsolutePath());
        }
    }

    private boolean create() {
        String sourceFol = this.sourceTF.getText();
        if (sourceFol == null || sourceFol.length() == 0) {
            this.showWarning("No source folder selected");
            return false;
        }
        File f = new File(sourceFol);
        try {
            if (!f.exists() || !f.isDirectory()) {
                this.showWarning("The source is not an existing folder");
                return false;
            }
        }
        catch (SecurityException ex) {
            this.showWarning("Cannot access the source folder");
            return false;
        }
        String templateFol = this.templateTF.getText();
        String destFol = null;
        if (this.otherFolderRB.isSelected()) {
            destFol = this.destFolderTF.getText();
            if (destFol == null || destFol.length() == 0) {
                this.showWarning("No destination folder has been selected");
                return false;
            }
            File f2 = new File(destFol);
            try {
                if (!f2.exists() || !f2.isDirectory()) {
                    this.showWarning("The destination is not an existing folder");
                    return false;
                }
            }
            catch (SecurityException se) {
                this.showWarning("Cannot access the destination folder");
                return false;
            }
        }
        boolean combineVideos = this.combineVideoCB.isSelected();
        boolean prefixBased = this.prefixRB.isSelected();
        return true;
    }

    private void showWarning(String message) {
        JOptionPane.showMessageDialog(this, message, ElanLocale.getString("Message.Warning"), 2);
    }
}

