/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.multiplefilesedit.scrub;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.ProgressListener;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.TranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.ACMTranscriptionStore;
import mpi.eudico.server.corpora.util.ProcessReport;
import mpi.eudico.server.corpora.util.ProcessReporter;
import mpi.eudico.server.corpora.util.SimpleReport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranscriptionScrubber
implements ClientLogger,
ProcessReporter {
    private ArrayList<ProgressListener> listeners;
    private ProcessReport report;
    private boolean isCanceled = false;
    public final char SP = (char)32;
    public final char TAB = (char)9;
    public final char NL = (char)10;

    public void scrubAndSave(List<File> files, Map<Character, boolean[]> filters) {
        if (files == null || files.size() == 0) {
            LOG.info("No (valid) files supplied.");
            return;
        }
        new MultiFileScrubber(files, filters).start();
    }

    public void interrupt() {
        this.isCanceled = true;
    }

    public synchronized void addProgressListener(ProgressListener pl) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(2);
        }
        this.listeners.add(pl);
    }

    public synchronized void removeProgressListener(ProgressListener pl) {
        if (pl != null && this.listeners != null) {
            this.listeners.remove(pl);
        }
    }

    private void progressUpdate(int percent, String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).progressUpdated(this, percent, message);
            }
        }
    }

    private void progressComplete(String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).progressCompleted(this, message);
            }
        }
    }

    private void progressInterrupt(String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).progressInterrupted(this, message);
            }
        }
    }

    @Override
    public ProcessReport getProcessReport() {
        return this.report;
    }

    @Override
    public void report(String message) {
        if (this.report == null) {
            this.report = new SimpleReport();
        }
        this.report.append(message);
    }

    @Override
    public void setProcessReport(ProcessReport report) {
        this.report = report;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MultiFileScrubber
    extends Thread {
        private List<File> files;
        private Map<Character, boolean[]> filters;

        public MultiFileScrubber(List<File> files, Map<Character, boolean[]> filters) {
            this.files = files;
            this.filters = filters;
        }

        public MultiFileScrubber(String name, List<File> files, Map<Character, boolean[]> filters) {
            super(name);
            this.files = files;
            this.filters = filters;
        }

        @Override
        public void run() {
            boolean[][] flags;
            char[] chars;
            if (this.files == null || this.files.size() == 0) {
                ClientLogger.LOG.info("No files supplied to the thread.");
                TranscriptionScrubber.this.report("No files supplied to the thread.");
                return;
            }
            if (this.filters != null) {
                chars = new char[this.filters.size()];
                flags = new boolean[chars.length][3];
                int count = 0;
                TranscriptionScrubber.this.report("Characters to remove:");
                for (Character key : this.filters.keySet()) {
                    chars[count] = key.charValue();
                    boolean[] vals = this.filters.get(key);
                    switch (key.charValue()) {
                        case '\n': {
                            TranscriptionScrubber.this.report("Key: NEW_LINE");
                            break;
                        }
                        case '\t': {
                            TranscriptionScrubber.this.report("Key: TAB");
                            break;
                        }
                        case ' ': {
                            TranscriptionScrubber.this.report("Key: WHITESPACE");
                            break;
                        }
                        default: {
                            TranscriptionScrubber.this.report("Key: " + key.toString());
                        }
                    }
                    TranscriptionScrubber.this.report("\tleading " + vals[0] + "\ttrailing " + vals[1] + "\tall " + vals[2]);
                    flags[count] = vals;
                    ++count;
                }
            } else {
                TranscriptionScrubber.this.report("No characters to remove, stopping clean up.");
                TranscriptionScrubber.this.progressInterrupt("No characters to remove");
                return;
            }
            TranscriptionScrubber.this.report("\n");
            int numFiles = this.files.size();
            TranscriptionScrubber.this.report("Number of files to process: " + numFiles);
            TranscriptionStore eafTranscriptionStore = ACMTranscriptionStore.getCurrentTranscriptionStore();
            StringBuilder builder = null;
            float perFile = 95.0f / (float)numFiles;
            int numProcessed = 0;
            int numFailed = 0;
            int numChanged = 0;
            for (int i = 0; i < numFiles; ++i) {
                File file = this.files.get(i);
                if (file == null) {
                    ClientLogger.LOG.warning("File is null (index = " + i + ")");
                    TranscriptionScrubber.this.report("File is null (index = " + i + ")");
                    ++numFailed;
                    continue;
                }
                try {
                    TranscriptionImpl trans = new TranscriptionImpl(file.getAbsolutePath());
                    trans.setNotifying(false);
                    boolean changed = false;
                    boolean annChanged = false;
                    Vector tiers = trans.getTiers();
                    for (int j = 0; j < tiers.size(); ++j) {
                        TierImpl tier = (TierImpl)tiers.get(j);
                        if (tier == null) {
                            ClientLogger.LOG.warning("Tier is null (index = " + j + ")");
                            continue;
                        }
                        Vector annotations = tier.getAnnotations();
                        int numAnnos = tier.getNumberOfAnnotations();
                        for (int k = 0; k < numAnnos; ++k) {
                            Annotation ann = (Annotation)annotations.get(k);
                            String val = ann.getValue();
                            annChanged = false;
                            if (val != null && val.length() > 0) {
                                char[] annChars;
                                boolean nonSpaceChanged = false;
                                for (int z = 0; z < chars.length; ++z) {
                                    if (chars[z] == ' ' || !flags[z][0] && !flags[z][1] && !flags[z][2]) continue;
                                    builder = new StringBuilder(val.length());
                                    annChars = val.toCharArray();
                                    int lastCopied = 32;
                                    nonSpaceChanged = false;
                                    if (flags[z][2]) {
                                        for (int y = 0; y < annChars.length; ++y) {
                                            if (annChars[y] != chars[z]) {
                                                builder.append(annChars[y]);
                                                lastCopied = annChars[y];
                                                continue;
                                            }
                                            annChanged = true;
                                            nonSpaceChanged = true;
                                            if (y <= 0 || lastCopied == 32 || y >= annChars.length - 1 || annChars[y + 1] == ' ') continue;
                                            builder.append(' ');
                                            lastCopied = 32;
                                        }
                                    } else {
                                        int y;
                                        int bi = 0;
                                        int ei = annChars.length - 1;
                                        if (flags[z][0]) {
                                            for (y = 0; y < annChars.length && annChars[y] == chars[z]; ++y) {
                                                ++bi;
                                            }
                                        }
                                        if (flags[z][1]) {
                                            for (y = annChars.length - 1; y >= 0 && annChars[y] == chars[z]; --y) {
                                                --ei;
                                            }
                                        }
                                        if (bi != 0 || ei != annChars.length - 1) {
                                            annChanged = true;
                                            nonSpaceChanged = true;
                                            builder.append(annChars, bi, ei - bi + 1);
                                        }
                                    }
                                    if (!nonSpaceChanged) continue;
                                    val = builder.toString();
                                }
                                int lastCopied = 32;
                                boolean spaceChanged = false;
                                for (int z = 0; z < chars.length; ++z) {
                                    if (chars[z] != ' ') continue;
                                    if (!flags[z][0] && !flags[z][1] && !flags[z][2]) break;
                                    builder = new StringBuilder(val.length());
                                    annChars = val.toCharArray();
                                    spaceChanged = false;
                                    if (flags[z][2]) {
                                        for (int y = 0; y < annChars.length; ++y) {
                                            if (annChars[y] != ' ') {
                                                builder.append(annChars[y]);
                                                lastCopied = annChars[y];
                                                continue;
                                            }
                                            if (y > 0 && lastCopied != 32 && y < annChars.length - 1 && annChars[y + 1] != ' ') {
                                                builder.append(' ');
                                                lastCopied = 32;
                                                continue;
                                            }
                                            spaceChanged = true;
                                            annChanged = true;
                                        }
                                    } else {
                                        int y;
                                        int bi = 0;
                                        int ei = annChars.length - 1;
                                        if (flags[z][0]) {
                                            for (y = 0; y < annChars.length && annChars[y] == ' '; ++y) {
                                                ++bi;
                                            }
                                        }
                                        if (flags[z][1]) {
                                            for (y = annChars.length - 1; y >= 0 && annChars[y] == ' '; --y) {
                                                --ei;
                                            }
                                        }
                                        if (bi != 0 || ei != annChars.length - 1) {
                                            annChanged = true;
                                            spaceChanged = true;
                                            builder.append(annChars, bi, ei - bi + 1);
                                        }
                                    }
                                    if (!spaceChanged) continue;
                                    val = builder.toString();
                                }
                            }
                            if (!annChanged) continue;
                            changed = true;
                            ann.setValue(val);
                        }
                    }
                    if (changed) {
                        ++numChanged;
                        try {
                            eafTranscriptionStore.storeTranscription(trans, null, trans.getTiers(), 0);
                            ClientLogger.LOG.info("Scrubbed and saved file: " + file.getName());
                            TranscriptionScrubber.this.report("Scrubbed and saved file: " + file.getName());
                        }
                        catch (IOException ioe) {
                            ClientLogger.LOG.severe("Error while saving eaf file! The file could have been damaged!");
                            TranscriptionScrubber.this.report("Error while saving eaf file! The file could have been damaged: " + file.getAbsolutePath());
                        }
                    }
                }
                catch (Exception ex) {
                    ++numFailed;
                    ClientLogger.LOG.warning("Could not handle file: " + file.getAbsolutePath());
                    TranscriptionScrubber.this.report("Could not handle file: " + file.getAbsolutePath());
                }
                ++numProcessed;
                TranscriptionScrubber.this.progressUpdate((int)((float)i * perFile), null);
                if (!TranscriptionScrubber.this.isCanceled) continue;
                ClientLogger.LOG.warning("Scrubbing canceled after " + i + " files.");
                TranscriptionScrubber.this.report.append("Scrubbing canceled after " + i + " files.");
                TranscriptionScrubber.this.progressInterrupt("Scrubbing interrupted");
                break;
            }
            TranscriptionScrubber.this.report("Number of files processed: \t" + numProcessed);
            TranscriptionScrubber.this.report("Number of files changed: \t" + numChanged);
            TranscriptionScrubber.this.report("Number of files failed: \t" + numFailed);
            TranscriptionScrubber.this.progressComplete("Scrubbing completed...");
        }
    }
}

