/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.multiplefilesedit.statistics;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import mpi.eudico.client.annotator.multiplefilesedit.statistics.AnnotatorStats;
import mpi.eudico.client.annotator.multiplefilesedit.statistics.ParticipantStats;
import mpi.eudico.client.annotator.multiplefilesedit.statistics.StatisticsAnnotationsMF;
import mpi.eudico.client.annotator.multiplefilesedit.statistics.TierStats;
import mpi.eudico.client.annotator.multiplefilesedit.statistics.TypeStats;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticsCollectionMF {
    public static final String UNSPECIFIED = "unspecified";
    public static final int NUM_TIER_COL = 9;
    public static final int NUM_TYPE_COL = 10;
    public static final int NUM_PART_COL = 10;
    private DecimalFormat format = new DecimalFormat("#0.######", new DecimalFormatSymbols(Locale.US));
    private DecimalFormat format2 = new DecimalFormat("#0.###", new DecimalFormatSymbols(Locale.US));
    private List<TierStats> tierStatsMF = new ArrayList<TierStats>();
    private List<TypeStats> typeStatsMF = new ArrayList<TypeStats>();
    private List<ParticipantStats> partStatsMF = new ArrayList<ParticipantStats>();
    private List<AnnotatorStats> annotatorStatsMF = new ArrayList<AnnotatorStats>();
    private Map<String, StatisticsAnnotationsMF> annotationsStatsMF = new TreeMap<String, StatisticsAnnotationsMF>();

    public void addTier(String file, TierImpl tier, int numAnnotations, long minDur, long maxDur, long totalDur, long latency, List<Long> curDurations) {
        if (tier == null) {
            return;
        }
        boolean tierFound = false;
        for (TierStats ts : this.tierStatsMF) {
            if (!ts.getTierName().equals(tier.getName())) continue;
            tierFound = true;
            ++ts.numFiles;
            ts.numAnnotations += numAnnotations;
            ts.durations.addAll(curDurations);
            ts.totalDur += totalDur;
            if (minDur < ts.minDur) {
                ts.minDur = minDur;
            }
            if (maxDur > ts.maxDur) {
                ts.maxDur = maxDur;
            }
            if (latency >= ts.latency) break;
            ts.latency = latency;
            break;
        }
        if (!tierFound) {
            TierStats ts = new TierStats(tier.getName());
            ts.numFiles = 1;
            ts.numAnnotations = numAnnotations;
            ts.durations.addAll(curDurations);
            ts.minDur = minDur;
            ts.maxDur = maxDur;
            ts.totalDur = totalDur;
            ts.latency = latency;
            this.tierStatsMF.add(ts);
        }
        boolean typeFound = false;
        String typeName = tier.getLinguisticType().getLinguisticTypeName();
        for (TypeStats tys : this.typeStatsMF) {
            if (!tys.getTypeName().equals(typeName)) continue;
            typeFound = true;
            ++tys.numTiers;
            tys.addFileName(file);
            tys.addTierName(tier.getName());
            tys.numAnnotations += numAnnotations;
            tys.durations.addAll(curDurations);
            tys.totalDur += totalDur;
            if (minDur < tys.minDur) {
                tys.minDur = minDur;
            }
            if (maxDur > tys.maxDur) {
                tys.maxDur = maxDur;
            }
            if (latency >= tys.latency) break;
            tys.latency = latency;
            break;
        }
        if (!typeFound) {
            TypeStats tys = new TypeStats(typeName);
            tys.numTiers = 1;
            tys.addFileName(file);
            tys.addTierName(tier.getName());
            tys.numAnnotations = numAnnotations;
            tys.durations.addAll(curDurations);
            tys.minDur = minDur;
            tys.maxDur = maxDur;
            tys.totalDur = totalDur;
            tys.latency = latency;
            this.typeStatsMF.add(tys);
        }
        boolean partFound = false;
        String partName = tier.getParticipant();
        if (partName == null || partName.length() == 0) {
            partName = UNSPECIFIED;
        }
        for (ParticipantStats ps : this.partStatsMF) {
            if (!ps.getPartName().equals(partName)) continue;
            partFound = true;
            ++ps.numTiers;
            ps.addFileName(file);
            ps.addTierName(tier.getName());
            ps.numAnnotations += numAnnotations;
            ps.durations.addAll(curDurations);
            ps.totalDur += totalDur;
            if (minDur < ps.minDur) {
                ps.minDur = minDur;
            }
            if (maxDur > ps.maxDur) {
                ps.maxDur = maxDur;
            }
            if (latency >= ps.latency) break;
            ps.latency = latency;
            break;
        }
        if (!partFound) {
            ParticipantStats ps = new ParticipantStats(partName);
            ps.numTiers = 1;
            ps.addFileName(file);
            ps.addTierName(tier.getName());
            ps.numAnnotations = numAnnotations;
            ps.durations.addAll(curDurations);
            ps.minDur = minDur;
            ps.maxDur = maxDur;
            ps.totalDur = totalDur;
            ps.latency = latency;
            this.partStatsMF.add(ps);
        }
        boolean annotFound = false;
        String annotName = tier.getAnnotator();
        if (annotName == null || annotName.length() == 0) {
            annotName = UNSPECIFIED;
        }
        for (AnnotatorStats as : this.annotatorStatsMF) {
            if (!as.getAnnotatorName().equals(annotName)) continue;
            annotFound = true;
            ++as.numTiers;
            as.addFileName(file);
            as.addTierName(tier.getName());
            as.numAnnotations += numAnnotations;
            as.durations.addAll(curDurations);
            as.totalDur += totalDur;
            if (minDur < as.minDur) {
                as.minDur = minDur;
            }
            if (maxDur > as.maxDur) {
                as.maxDur = maxDur;
            }
            if (latency >= as.latency) break;
            as.latency = latency;
            break;
        }
        if (!annotFound) {
            AnnotatorStats as = new AnnotatorStats(annotName);
            as.numTiers = 1;
            as.addFileName(file);
            as.addTierName(tier.getName());
            as.numAnnotations = numAnnotations;
            as.durations.addAll(curDurations);
            as.minDur = minDur;
            as.maxDur = maxDur;
            as.totalDur = totalDur;
            as.latency = latency;
            this.annotatorStatsMF.add(as);
        }
    }

    public void addEmptyLinguisticType(String file, String typeName) {
        if (typeName == null) {
            return;
        }
        boolean typeFound = false;
        for (TypeStats tys : this.typeStatsMF) {
            if (!tys.getTypeName().equals(typeName)) continue;
            typeFound = true;
            tys.addFileName(file);
            break;
        }
        if (!typeFound) {
            TypeStats tys = new TypeStats(typeName);
            tys.numTiers = 0;
            tys.addFileName(file);
            tys.numAnnotations = 0;
            tys.minDur = 0L;
            tys.maxDur = 0L;
            tys.totalDur = 0L;
            tys.latency = 0L;
            this.typeStatsMF.add(tys);
        }
    }

    public void addAnnotations(String file, String tierName, StatisticsAnnotationsMF annotationStatistics) {
        if (!this.annotationsStatsMF.containsKey(tierName)) {
            this.annotationsStatsMF.put(tierName, annotationStatistics);
        }
    }

    public StatisticsAnnotationsMF getAnnotationStats(String tierName) {
        return this.annotationsStatsMF.get(tierName);
    }

    public List<String[]> getAllAnnotationStatistics() {
        if (this.annotationsStatsMF.size() == 0) {
            String[] row = new String[9];
            for (int i = 0; i < row.length; ++i) {
                row[i] = "-";
            }
            ArrayList<String[]> ansList = new ArrayList<String[]>(1);
            ansList.add(row);
            return ansList;
        }
        ArrayList<String[]> annsList = new ArrayList<String[]>();
        Iterator<String> keyIt = this.annotationsStatsMF.keySet().iterator();
        while (keyIt.hasNext()) {
            StatisticsAnnotationsMF stats = this.annotationsStatsMF.get(keyIt.next());
            annsList.addAll(stats.getAnnotationStastitics());
        }
        return annsList;
    }

    public List<String[]> getTierStatistics() {
        if (this.tierStatsMF.size() == 0) {
            String[] row = new String[9];
            for (int i = 0; i < 9; ++i) {
                row[i] = "-";
            }
            ArrayList<String[]> tsList = new ArrayList<String[]>(1);
            tsList.add(row);
            return tsList;
        }
        ArrayList<String[]> tierList = new ArrayList<String[]>(this.tierStatsMF.size());
        float mill = 1000.0f;
        for (TierStats stats : this.tierStatsMF) {
            String[] row = new String[9];
            block13: for (int i = 0; i < 9; ++i) {
                switch (i) {
                    case 0: {
                        row[i] = stats.getTierName();
                        continue block13;
                    }
                    case 1: {
                        row[i] = String.valueOf(stats.numFiles);
                        continue block13;
                    }
                    case 2: {
                        row[i] = String.valueOf(stats.numAnnotations);
                        continue block13;
                    }
                    case 3: {
                        if (stats.minDur == Long.MAX_VALUE) {
                            row[i] = this.format2.format(0L);
                            continue block13;
                        }
                        row[i] = this.format2.format((float)stats.minDur / mill);
                        continue block13;
                    }
                    case 4: {
                        row[i] = this.format2.format((float)stats.maxDur / mill);
                        continue block13;
                    }
                    case 5: {
                        if (stats.numAnnotations == 0) {
                            row[i] = "0";
                            continue block13;
                        }
                        float avg = (float)stats.totalDur / (float)stats.numAnnotations;
                        row[i] = this.format2.format(avg / mill);
                        continue block13;
                    }
                    case 6: {
                        float median = 0.0f;
                        int numDurs = stats.durations.size();
                        if (numDurs == 0) {
                            median = 0.0f;
                        } else if (numDurs == 1) {
                            median = stats.durations.get(0).longValue();
                        } else {
                            Collections.sort(stats.durations);
                            if (numDurs % 2 != 0) {
                                median = stats.durations.get(numDurs / 2).longValue();
                            } else {
                                long h = stats.durations.get(numDurs / 2);
                                long l = stats.durations.get(numDurs / 2 - 1);
                                median = (h + l) / 2L;
                            }
                        }
                        row[i] = this.format2.format(median / mill);
                        continue block13;
                    }
                    case 7: {
                        row[i] = this.format2.format((float)stats.totalDur / mill);
                        continue block13;
                    }
                    case 8: {
                        if (stats.latency == Long.MAX_VALUE) {
                            row[i] = this.format2.format(0L);
                            continue block13;
                        }
                        row[i] = this.format2.format((float)stats.latency / mill);
                        continue block13;
                    }
                    default: {
                        row[i] = "-";
                    }
                }
            }
            tierList.add(row);
        }
        return tierList;
    }

    public List<String[]> getTypeStatistics() {
        if (this.typeStatsMF.size() == 0) {
            String[] row = new String[10];
            for (int i = 0; i < 10; ++i) {
                row[i] = "-";
            }
            ArrayList<String[]> typeList = new ArrayList<String[]>(1);
            typeList.add(row);
            return typeList;
        }
        ArrayList<String[]> typeList = new ArrayList<String[]>(this.typeStatsMF.size());
        float mill = 1000.0f;
        for (TypeStats stats : this.typeStatsMF) {
            String[] row = new String[10];
            block14: for (int i = 0; i < 10; ++i) {
                switch (i) {
                    case 0: {
                        row[i] = stats.getTypeName();
                        continue block14;
                    }
                    case 1: {
                        row[i] = String.valueOf(stats.getNumFiles());
                        continue block14;
                    }
                    case 2: {
                        row[i] = String.valueOf(stats.numTiers);
                        continue block14;
                    }
                    case 3: {
                        row[i] = String.valueOf(stats.numAnnotations);
                        continue block14;
                    }
                    case 4: {
                        if (stats.minDur == Long.MAX_VALUE) {
                            row[i] = this.format2.format(0L);
                            continue block14;
                        }
                        row[i] = this.format2.format((float)stats.minDur / mill);
                        continue block14;
                    }
                    case 5: {
                        row[i] = this.format2.format((float)stats.maxDur / mill);
                        continue block14;
                    }
                    case 6: {
                        if (stats.numAnnotations == 0) {
                            row[i] = "0";
                            continue block14;
                        }
                        float avg = (float)stats.totalDur / (float)stats.numAnnotations;
                        row[i] = this.format2.format(avg / mill);
                        continue block14;
                    }
                    case 7: {
                        float median = 0.0f;
                        int numDurs = stats.durations.size();
                        if (numDurs == 0) {
                            median = 0.0f;
                        } else if (numDurs == 1) {
                            median = stats.durations.get(0).longValue();
                        } else {
                            Collections.sort(stats.durations);
                            if (numDurs % 2 != 0) {
                                median = stats.durations.get(numDurs / 2).longValue();
                            } else {
                                long h = stats.durations.get(numDurs / 2);
                                long l = stats.durations.get(numDurs / 2 - 1);
                                median = (h + l) / 2L;
                            }
                        }
                        row[i] = this.format2.format(median / mill);
                        continue block14;
                    }
                    case 8: {
                        row[i] = this.format2.format((float)stats.totalDur / mill);
                        continue block14;
                    }
                    case 9: {
                        if (stats.latency == Long.MAX_VALUE) {
                            row[i] = this.format2.format(0L);
                            continue block14;
                        }
                        row[i] = this.format2.format((float)stats.latency / mill);
                        continue block14;
                    }
                    default: {
                        row[i] = "-";
                    }
                }
            }
            typeList.add(row);
        }
        return typeList;
    }

    public List<String[]> getPartStatistics() {
        if (this.partStatsMF.size() == 0) {
            String[] row = new String[10];
            for (int i = 0; i < 10; ++i) {
                row[i] = "-";
            }
            ArrayList<String[]> partList = new ArrayList<String[]>(1);
            partList.add(row);
            return partList;
        }
        ArrayList<String[]> partList = new ArrayList<String[]>(this.partStatsMF.size());
        float mill = 1000.0f;
        for (ParticipantStats stats : this.partStatsMF) {
            String[] row = new String[10];
            block14: for (int i = 0; i < 10; ++i) {
                switch (i) {
                    case 0: {
                        row[i] = stats.getPartName();
                        continue block14;
                    }
                    case 1: {
                        row[i] = String.valueOf(stats.getNumFiles());
                        continue block14;
                    }
                    case 2: {
                        row[i] = String.valueOf(stats.numTiers);
                        continue block14;
                    }
                    case 3: {
                        row[i] = String.valueOf(stats.numAnnotations);
                        continue block14;
                    }
                    case 4: {
                        if (stats.minDur == Long.MAX_VALUE) {
                            row[i] = this.format2.format(0L);
                            continue block14;
                        }
                        row[i] = this.format2.format((float)stats.minDur / mill);
                        continue block14;
                    }
                    case 5: {
                        row[i] = this.format2.format((float)stats.maxDur / mill);
                        continue block14;
                    }
                    case 6: {
                        if (stats.numAnnotations == 0) {
                            row[i] = "0";
                            continue block14;
                        }
                        float avg = (float)stats.totalDur / (float)stats.numAnnotations;
                        row[i] = this.format2.format(avg / mill);
                        continue block14;
                    }
                    case 7: {
                        float median = 0.0f;
                        int numDurs = stats.durations.size();
                        if (numDurs != 0) {
                            if (numDurs == 1) {
                                median = stats.durations.get(0).longValue();
                            } else {
                                Collections.sort(stats.durations);
                                if (numDurs % 2 != 0) {
                                    median = stats.durations.get(numDurs / 2).longValue();
                                } else {
                                    long h = stats.durations.get(numDurs / 2);
                                    long l = stats.durations.get(numDurs / 2 - 1);
                                    median = (h + l) / 2L;
                                }
                            }
                        }
                        row[i] = this.format2.format(median / mill);
                        continue block14;
                    }
                    case 8: {
                        row[i] = this.format2.format((float)stats.totalDur / mill);
                        continue block14;
                    }
                    case 9: {
                        if (stats.latency == Long.MAX_VALUE) {
                            row[i] = this.format2.format(0L);
                            continue block14;
                        }
                        row[i] = this.format2.format((float)stats.latency / mill);
                        continue block14;
                    }
                    default: {
                        row[i] = "-";
                    }
                }
            }
            partList.add(row);
        }
        return partList;
    }

    public List<String[]> getAnnotatorStatistics() {
        if (this.annotatorStatsMF.size() == 0) {
            String[] row = new String[10];
            for (int i = 0; i < 10; ++i) {
                row[i] = "-";
            }
            ArrayList<String[]> annotList = new ArrayList<String[]>(1);
            annotList.add(row);
            return annotList;
        }
        ArrayList<String[]> annotList = new ArrayList<String[]>(this.annotatorStatsMF.size());
        float mill = 1000.0f;
        for (AnnotatorStats stats : this.annotatorStatsMF) {
            String[] row = new String[10];
            block14: for (int i = 0; i < 10; ++i) {
                switch (i) {
                    case 0: {
                        row[i] = stats.getAnnotatorName();
                        continue block14;
                    }
                    case 1: {
                        row[i] = String.valueOf(stats.getNumFiles());
                        continue block14;
                    }
                    case 2: {
                        row[i] = String.valueOf(stats.numTiers);
                        continue block14;
                    }
                    case 3: {
                        row[i] = String.valueOf(stats.numAnnotations);
                        continue block14;
                    }
                    case 4: {
                        if (stats.minDur == Long.MAX_VALUE) {
                            row[i] = this.format2.format(0L);
                            continue block14;
                        }
                        row[i] = this.format2.format((float)stats.minDur / mill);
                        continue block14;
                    }
                    case 5: {
                        row[i] = this.format2.format((float)stats.maxDur / mill);
                        continue block14;
                    }
                    case 6: {
                        if (stats.numAnnotations == 0) {
                            row[i] = "0";
                            continue block14;
                        }
                        float avg = (float)stats.totalDur / (float)stats.numAnnotations;
                        row[i] = this.format2.format(avg / mill);
                        continue block14;
                    }
                    case 7: {
                        float median = 0.0f;
                        int numDurs = stats.durations.size();
                        if (numDurs == 0) {
                            median = 0.0f;
                        } else if (numDurs == 1) {
                            median = stats.durations.get(0).longValue();
                        } else {
                            Collections.sort(stats.durations);
                            if (numDurs % 2 != 0) {
                                median = stats.durations.get(numDurs / 2).longValue();
                            } else {
                                long h = stats.durations.get(numDurs / 2);
                                long l = stats.durations.get(numDurs / 2 - 1);
                                median = (h + l) / 2L;
                            }
                        }
                        row[i] = this.format2.format(median / mill);
                        continue block14;
                    }
                    case 8: {
                        row[i] = this.format2.format((float)stats.totalDur / mill);
                        continue block14;
                    }
                    case 9: {
                        if (stats.latency == Long.MAX_VALUE) {
                            row[i] = this.format2.format(0L);
                            continue block14;
                        }
                        row[i] = this.format2.format((float)stats.latency / mill);
                        continue block14;
                    }
                    default: {
                        row[i] = "-";
                    }
                }
            }
            annotList.add(row);
        }
        return annotList;
    }
}

