/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.player;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;

public class DetectMediaFrameworks {
    public static String FRAMEWORK = "mediaframework";
    public static int JMF_AUDIO = 1;
    public static int JMF_VIDEO = 2;
    public static int QT_VIDEOAUDIO = 4;
    public static String STR_JMF_AUDIO = "JMF Audio Only";
    public static String STR_JMF_VIDEO = "JMF Video and Audio";
    public static String STR_QT_VIDEOAUDIO = "Quicktime Video and Audio";
    private static String defaultFramework = STR_JMF_VIDEO;
    private static String[] QUICKTIMELIB = new String[]{"QuickTime.cpl", "QuickTime.qts", "QuickTime\\QuickTimeMPEG.qtx", "QuickTime\\QuickTimeMPEG4.qtx"};

    public static String getDefaultFramework() {
        return defaultFramework;
    }

    public static void setDefaultFramework(String fw) throws Exception {
        if (fw.equals(STR_JMF_AUDIO) | fw.equals(STR_JMF_VIDEO) | fw.equals(STR_QT_VIDEOAUDIO)) {
            defaultFramework = fw;
            return;
        }
        throw new Exception("Invalid Framework name");
    }

    public static ArrayList getMediaFrameworkNames() {
        ArrayList<String> al = new ArrayList<String>(3);
        al.add(STR_JMF_AUDIO);
        al.add(STR_JMF_VIDEO);
        al.add(STR_QT_VIDEOAUDIO);
        return al;
    }

    public static int getSupportedMediaFrameworksBitmap() {
        int detected = JMF_AUDIO;
        try {
            System.loadLibrary("jmutil");
            detected |= JMF_VIDEO;
        }
        catch (UnsatisfiedLinkError e) {
        }
        catch (SecurityException e) {
            // empty catch block
        }
        try {
            System.loadLibrary("jmvfw");
            System.loadLibrary("jmam");
            detected |= JMF_VIDEO;
        }
        catch (UnsatisfiedLinkError e) {
        }
        catch (SecurityException e) {
            // empty catch block
        }
        try {
            String s = System.getProperty("os.name");
            if (s.regionMatches(false, 0, "Darwin", 0, 6) || s.regionMatches(false, 0, "Mac OS X", 0, 8)) {
                ClassLoader cl = ClassLoader.getSystemClassLoader();
                cl.loadClass("quicktime.QTSession");
                detected |= QT_VIDEOAUDIO;
            } else if (s.regionMatches(false, 0, "Win", 0, 3)) {
                if (!DetectMediaFrameworks.verifySystem32Libs(QUICKTIMELIB)) {
                    throw new Exception("Invalid QT Libs");
                }
                detected |= QT_VIDEOAUDIO;
            }
        }
        catch (UnsatisfiedLinkError e) {
        }
        catch (SecurityException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return detected;
    }

    public static ArrayList getSupportedMediaFrameworksNames() {
        int detected = 0;
        detected = DetectMediaFrameworks.getSupportedMediaFrameworksBitmap();
        ArrayList<String> al = new ArrayList<String>(1);
        boolean ct = false;
        if ((detected & JMF_AUDIO) != 0) {
            al.add(STR_JMF_AUDIO);
        }
        if ((detected & JMF_VIDEO) != 0) {
            al.add(STR_JMF_VIDEO);
        }
        if ((detected & QT_VIDEOAUDIO) != 0) {
            al.add(STR_QT_VIDEOAUDIO);
        }
        return al;
    }

    public static boolean verifySystem32Libs(String[] arylibs) {
        String windir = "";
        if (null == arylibs) {
            return false;
        }
        if (0 == arylibs.length) {
            return false;
        }
        windir = DetectMediaFrameworks.getEnv("SYSTEMROOT");
        if (windir == null) {
            System.err.println("NO SYSTEM ROOT");
            return false;
        }
        if (!new File(windir + "\\system32").isDirectory()) {
            if (!new File(windir + "\\system").isDirectory()) {
                System.err.println("Failed to locate " + windir + "/System dir");
                return false;
            }
            windir = windir + "\\system\\";
        } else {
            windir = windir + "\\system32\\";
        }
        for (int i = 0; i < arylibs.length; ++i) {
            if (new File(windir + arylibs[i]).exists()) continue;
            return false;
        }
        return true;
    }

    public static String getEnv(String name) {
        String cmd = "cmd /c echo";
        String s = System.getProperty("os.name");
        if (!s.regionMatches(false, 0, "Win", 0, 3)) {
            return null;
        }
        s = "";
        try {
            int b;
            Runtime rt = Runtime.getRuntime();
            cmd = cmd + " %" + name + "%";
            Process p = rt.exec(cmd);
            InputStream is = p.getInputStream();
            while ((b = is.read()) >= 0) {
                if (b <= 13) continue;
                s = s + (char)b;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        s.trim();
        if (s.length() == 0) {
            return null;
        }
        return s;
    }
}

