/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.player;

import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.URL;
import java.text.DecimalFormat;
import javax.media.Control;
import javax.media.ControllerListener;
import javax.media.EndOfMediaEvent;
import javax.media.GainControl;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.Player;
import javax.media.StopAtTimeEvent;
import javax.media.Time;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.FormattedMessageDlg;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.player.JMFClassLoader;
import mpi.eudico.client.annotator.player.NoPlayerException;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.client.mediacontrol.ControllerManager;
import mpi.eudico.client.mediacontrol.PeriodicUpdateController;
import mpi.eudico.client.mediacontrol.TimeEvent;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.util.TimeFormatter;

public class JMFMediaPlayer
extends ControllerManager
implements ElanMediaPlayer,
mpi.eudico.client.mediacontrol.ControllerListener,
ControllerListener,
ActionListener {
    protected Player player;
    protected float shouldBeRate;
    protected long intervalStopTime;
    protected long frozenMediaTime;
    protected long offset;
    protected long milliSecondsPerSample;
    protected boolean playingInterval;
    protected PeriodicUpdateController periodicController;
    protected float systemVolumeLevel;
    protected JPopupMenu popup;
    protected MediaDescriptor mediaDescriptor;
    protected ElanLayoutManager layoutManager;
    protected boolean detached;
    protected JMenuItem durationItem;
    protected JMenuItem detachItem;
    private JMenuItem infoItem;
    private JMenuItem ratio_4_3_Item;
    private JMenuItem ratio_3_2_Item;
    private JMenuItem ratio_16_9_Item;
    private JMenuItem ratio_185_1_Item;
    private JMenuItem ratio_235_1_Item;
    protected NoMouseComponent noMouseComponent;
    private boolean frameStepsToFrameBegin = false;
    private float aspectRatio = 0.0f;

    public JMFMediaPlayer(MediaDescriptor mediaDescriptor) throws NoPlayerException {
        this.mediaDescriptor = mediaDescriptor;
        JMFClassLoader.initJMFJNI();
        String URLString = mediaDescriptor.mediaURL;
        this.player = null;
        try {
            System.out.println("mediaURL = " + URLString);
            if (URLString.startsWith("rtsp")) {
                System.out.println("stream");
                MediaLocator ml = new MediaLocator(URLString);
                this.player = Manager.createPlayer((MediaLocator)ml);
            } else {
                URL mediaURL = new URL(URLString);
                this.player = Manager.createPlayer((URL)mediaURL);
            }
        }
        catch (javax.media.NoPlayerException e) {
            System.out.println("javax.media.NoPlayerException while creating JMF player");
            e.printStackTrace();
            throw new NoPlayerException("javax.media.NoPlayerException");
        }
        catch (IOException e) {
            System.out.println("IO exception while creating JMF player");
            e.printStackTrace();
            throw new NoPlayerException("IO exception, problem to connect to data source");
        }
        catch (Exception e) {
            System.out.println("Unknown exception while creating JMF player");
            e.printStackTrace();
            throw new NoPlayerException("Exception, problem to connect to data source");
        }
        this.offset = mediaDescriptor.timeOrigin;
        this.shouldBeRate = 1.0f;
        this.frozenMediaTime = -1L;
        this.milliSecondsPerSample = 40L;
        long timeout = System.currentTimeMillis() + 5000L;
        this.player.realize();
        while (this.getState() != 300) {
            try {
                Thread.sleep(50L);
                if (System.currentTimeMillis() <= timeout) continue;
                this.player.close();
                throw new NoPlayerException("Could not realize the jmf player");
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        GainControl gain = this.player.getGainControl();
        float level = 1.0f;
        if (gain != null) {
            level = gain.getLevel();
            gain.setLevel(0.0f);
        }
        this.systemVolumeLevel = level;
        this.start();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.stop();
        this.setMediaTime(0L);
        if (gain != null) {
            gain.setLevel(level);
        }
        this.player.addControllerListener((ControllerListener)this);
        if (this.player.getVisualComponent() != null) {
            this.player.getVisualComponent().addMouseListener(new MouseHandler());
        }
        this.popup = new JPopupMenu();
        this.durationItem = new JMenuItem(ElanLocale.getString("Player.duration") + ":  " + TimeFormatter.toString(this.getMediaDuration()));
        this.durationItem.setEnabled(false);
        this.infoItem = new JMenuItem(ElanLocale.getString("Player.Info"));
        this.infoItem.addActionListener(this);
        this.ratio_4_3_Item = new JMenuItem("4:3");
        this.ratio_4_3_Item.addActionListener(this);
        this.ratio_3_2_Item = new JMenuItem("3:2");
        this.ratio_3_2_Item.addActionListener(this);
        this.ratio_16_9_Item = new JMenuItem("16:9");
        this.ratio_16_9_Item.addActionListener(this);
        this.ratio_185_1_Item = new JMenuItem("1.85:1");
        this.ratio_185_1_Item.addActionListener(this);
        this.ratio_235_1_Item = new JMenuItem("2.35:1");
        this.ratio_235_1_Item.addActionListener(this);
        JMenu arMenu = new JMenu(ElanLocale.getString("Player.ForceAspectRatio"));
        arMenu.add(this.ratio_4_3_Item);
        arMenu.add(this.ratio_3_2_Item);
        arMenu.add(this.ratio_16_9_Item);
        arMenu.add(this.ratio_185_1_Item);
        arMenu.add(this.ratio_235_1_Item);
        this.popup.addSeparator();
        this.popup.add(this.infoItem);
        this.popup.add(arMenu);
        this.popup.add(this.durationItem);
    }

    public MediaDescriptor getMediaDescriptor() {
        return this.mediaDescriptor;
    }

    public String getFrameworkDescription() {
        return "Java Media Framework " + Manager.getVersion();
    }

    public void finalize() {
        GainControl gain;
        if (this.player.getState() >= 300 && (gain = this.player.getGainControl()) != null) {
            gain.setLevel(this.systemVolumeLevel);
        }
    }

    public void controllerUpdate(javax.media.ControllerEvent event) {
        if (event instanceof EndOfMediaEvent) {
            this.stop();
        } else if (event instanceof StopAtTimeEvent) {
            System.out.println("stopped by jmf itself");
            this.frozenMediaTime = this.intervalStopTime;
            this.stop();
        }
    }

    public synchronized void controllerUpdate(ControllerEvent event) {
        if (event instanceof TimeEvent && this.periodicController != null && this.getMediaTime() >= this.intervalStopTime) {
            this.frozenMediaTime = this.intervalStopTime;
            float volume = this.getVolume();
            this.setVolume(0.0f);
            this.stop();
            this.setVolume(volume);
        }
    }

    public synchronized void playInterval(long startTime, long stopTime) {
        if (this.player == null || this.playingInterval || stopTime <= startTime) {
            return;
        }
        this.periodicController = new PeriodicUpdateController(25L);
        this.periodicController.addControllerListener(this);
        this.addController(this.periodicController);
        this.intervalStopTime = stopTime + this.offset;
        this.setMediaTime(startTime);
        this.playingInterval = true;
        this.start();
    }

    public void setStopTime(long stopTime) {
    }

    private void stopPlayingInterval() {
        if (this.periodicController != null) {
            this.periodicController.removeControllerListener(this);
            this.removeController(this.periodicController);
            this.periodicController = null;
        }
        this.playingInterval = false;
    }

    public Component getVisualComponent() {
        if (this.player == null) {
            return null;
        }
        return this.player.getVisualComponent();
    }

    public int getSourceHeight() {
        if (this.getVisualComponent() != null) {
            return (int)this.getVisualComponent().getPreferredSize().getHeight();
        }
        return 0;
    }

    public int getSourceWidth() {
        if (this.getVisualComponent() != null) {
            return (int)this.getVisualComponent().getPreferredSize().getWidth();
        }
        return 0;
    }

    public Component getControlPanelComponent() {
        if (this.player == null) {
            return null;
        }
        return this.player.getControlPanelComponent();
    }

    public float getAspectRatio() {
        if (this.player == null || this.getVisualComponent() == null) {
            return 0.0f;
        }
        if (this.aspectRatio == 0.0f) {
            this.aspectRatio = (float)(this.getVisualComponent().getPreferredSize().getWidth() / this.getVisualComponent().getPreferredSize().getHeight());
        }
        return this.aspectRatio;
    }

    public void setAspectRatio(float aspectRatio) {
        this.aspectRatio = aspectRatio;
    }

    public synchronized void start() {
        if (this.player == null || this.getState() == 600) {
            return;
        }
        if (this.getMediaDuration() - this.getMediaTime() < 40L) {
            this.setMediaTime(0L);
        }
        this.player.start();
        while (this.getState() != 600) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.startControllers();
    }

    public synchronized void stop() {
        if (this.player == null) {
            return;
        }
        if (this.frozenMediaTime < 0L) {
            this.frozenMediaTime = this.getMediaTime();
        }
        this.stopControllers();
        this.player.stop();
        while (this.player.getState() == 600) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this.playingInterval) {
            this.stopPlayingInterval();
        }
        this.setMediaTime(this.frozenMediaTime);
        this.frozenMediaTime = -1L;
        this.player.setRate(0.995f * this.shouldBeRate);
        this.player.setRate(this.shouldBeRate);
    }

    public boolean isPlaying() {
        if (this.player == null) {
            return false;
        }
        return this.getState() == 600;
    }

    public long getMilliSecondsPerSample() {
        return this.milliSecondsPerSample;
    }

    public void setMilliSecondsPerSample(long milliSeconds) {
        this.milliSecondsPerSample = milliSeconds;
    }

    private int getState() {
        if (this.player == null) {
            return 500;
        }
        return this.player.getState();
    }

    public float getVolume() {
        if (this.player.getGainControl() == null) {
            return 0.0f;
        }
        return this.player.getGainControl().getLevel();
    }

    public void setVolume(float level) {
        if (this.player.getGainControl() == null) {
            return;
        }
        try {
            this.player.getGainControl().setLevel(level);
        }
        catch (IllegalArgumentException iae) {
            System.out.println("Illegal volume level: " + level);
        }
    }

    public void setOffset(long offset) {
        this.offset = offset;
        this.mediaDescriptor.timeOrigin = offset;
    }

    public long getOffset() {
        return this.offset;
    }

    public synchronized void setMediaTime(long time) {
        if (this.player == null) {
            return;
        }
        if (this.isPlaying()) {
            this.stop();
        }
        this.player.setMediaTime(new Time((time += this.offset) * 1000000L));
        this.setControllersMediaTime(time - this.offset);
    }

    public void nextFrame() {
        if (this.frameStepsToFrameBegin) {
            long curFrame = this.getMediaTime() / this.milliSecondsPerSample;
            this.setMediaTime((curFrame + 1L) * this.milliSecondsPerSample);
        } else {
            this.setMediaTime(this.getMediaTime() + this.getMilliSecondsPerSample());
        }
    }

    public void previousFrame() {
        if (this.frameStepsToFrameBegin) {
            long curFrame = this.getMediaTime() / this.milliSecondsPerSample;
            if (curFrame > 0L) {
                this.setMediaTime((curFrame - 1L) * this.milliSecondsPerSample);
            } else {
                this.setMediaTime(0L);
            }
        } else {
            this.setMediaTime(this.getMediaTime() - this.getMilliSecondsPerSample());
        }
    }

    public void setFrameStepsToFrameBegin(boolean stepsToFrameBegin) {
        this.frameStepsToFrameBegin = stepsToFrameBegin;
    }

    public long getMediaTime() {
        if (this.player == null) {
            return 0L;
        }
        if (this.frozenMediaTime >= 0L) {
            return this.frozenMediaTime;
        }
        return (long)(1000.0 * this.player.getMediaTime().getSeconds()) - this.offset;
    }

    public float getRate() {
        if (this.player == null) {
            return 0.0f;
        }
        return this.player.getRate();
    }

    public synchronized void setRate(float rate) {
        if (this.player == null) {
            return;
        }
        if (this.isPlaying()) {
            this.stop();
        }
        this.setControllersRate(rate);
        this.shouldBeRate = rate;
        this.player.setRate(rate);
    }

    public boolean isFrameRateAutoDetected() {
        return false;
    }

    public long getMediaDuration() {
        if (this.player == null) {
            return 0L;
        }
        return (long)(1000.0 * this.player.getDuration().getSeconds()) - this.offset;
    }

    public void setLayoutManager(ElanLayoutManager layoutManager) {
        if (this.layoutManager == null) {
            this.detachItem = new JMenuItem(ElanLocale.getString("Detachable.detach"));
            this.detachItem.addActionListener(this);
            this.popup.insert(this.detachItem, 0);
        }
        this.layoutManager = layoutManager;
    }

    public void updateLocale() {
        this.infoItem.setText(ElanLocale.getString("Player.Info"));
        this.durationItem.setText(ElanLocale.getString("Player.duration") + ":  " + TimeFormatter.toString(this.getMediaDuration()));
        if (this.detachItem != null) {
            if (this.detached) {
                this.detachItem.setText(ElanLocale.getString("Detachable.attach"));
            } else {
                this.detachItem.setText(ElanLocale.getString("Detachable.detach"));
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.detachItem) && this.layoutManager != null) {
            if (this.detached) {
                this.layoutManager.attach(this.getVisualComponent());
                this.detachItem.setText(ElanLocale.getString("Detachable.detach"));
                this.detached = false;
            } else {
                this.layoutManager.detach(this.getVisualComponent());
                this.detachItem.setText(ElanLocale.getString("Detachable.attach"));
                this.detached = true;
            }
        } else if (e.getSource() == this.infoItem) {
            new FormattedMessageDlg(this);
        } else if (e.getSource() == this.ratio_4_3_Item) {
            this.aspectRatio = 1.33f;
            this.layoutManager.doLayout();
            this.layoutManager.setPreference("AspectRatio(" + this.mediaDescriptor.mediaURL + ")", new Float(this.aspectRatio), this.layoutManager.getViewerManager().getTranscription());
        } else if (e.getSource() == this.ratio_3_2_Item) {
            this.aspectRatio = 1.66f;
            this.layoutManager.doLayout();
            this.layoutManager.setPreference("AspectRatio(" + this.mediaDescriptor.mediaURL + ")", new Float(this.aspectRatio), this.layoutManager.getViewerManager().getTranscription());
        } else if (e.getSource() == this.ratio_16_9_Item) {
            this.aspectRatio = 1.78f;
            this.layoutManager.doLayout();
            this.layoutManager.setPreference("AspectRatio(" + this.mediaDescriptor.mediaURL + ")", new Float(this.aspectRatio), this.layoutManager.getViewerManager().getTranscription());
        } else if (e.getSource() == this.ratio_185_1_Item) {
            this.aspectRatio = 1.85f;
            this.layoutManager.doLayout();
            this.layoutManager.setPreference("AspectRatio(" + this.mediaDescriptor.mediaURL + ")", new Float(this.aspectRatio), this.layoutManager.getViewerManager().getTranscription());
        } else if (e.getSource() == this.ratio_235_1_Item) {
            this.aspectRatio = 2.35f;
            this.layoutManager.doLayout();
            this.layoutManager.setPreference("AspectRatio(" + this.mediaDescriptor.mediaURL + ")", new Float(this.aspectRatio), this.layoutManager.getViewerManager().getTranscription());
        }
    }

    private void copyToClipboard(String text) {
        if (text == null) {
            return;
        }
        if (System.getSecurityManager() != null) {
            try {
                System.getSecurityManager().checkSystemClipboardAccess();
                StringSelection ssVal = new StringSelection(text);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ssVal, null);
            }
            catch (SecurityException se) {
            }
            catch (IllegalStateException ise) {}
        } else {
            try {
                StringSelection ssVal = new StringSelection(text);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ssVal, null);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    void printControls(Player player) {
        System.out.println("Player info: " + player);
        Control[] controls = player.getControls();
        for (int i = 0; i < controls.length; ++i) {
            System.out.print("\t" + i + ": ");
            System.out.println(controls[i].getClass());
        }
    }

    public void cleanUpOnClose() {
    }

    protected class MouseHandler
    extends MouseAdapter {
        private final DecimalFormat format = new DecimalFormat("#.###");

        protected MouseHandler() {
        }

        public void mousePressed(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
                if (JMFMediaPlayer.this.detachItem != null && JMFMediaPlayer.this.layoutManager != null && JMFMediaPlayer.this.layoutManager.isAttached(JMFMediaPlayer.this) && JMFMediaPlayer.this.detached) {
                    JMFMediaPlayer.this.detached = false;
                    JMFMediaPlayer.this.detachItem.setText(ElanLocale.getString("Detachable.detach"));
                }
                JMFMediaPlayer.this.popup.show(JMFMediaPlayer.this.player.getVisualComponent(), e.getPoint().x, e.getPoint().y);
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() >= 2) {
                if (JMFMediaPlayer.this.layoutManager != null) {
                    JMFMediaPlayer.this.layoutManager.setFirstPlayer(JMFMediaPlayer.this);
                }
                return;
            }
            if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
                return;
            }
            try {
                if (e.isAltDown()) {
                    JMFMediaPlayer.this.copyToClipboard(this.format.format((float)e.getX() / (float)JMFMediaPlayer.this.getVisualComponent().getWidth()) + "," + this.format.format((float)e.getY() / (float)JMFMediaPlayer.this.getVisualComponent().getHeight()));
                } else if (e.isShiftDown()) {
                    JMFMediaPlayer.this.copyToClipboard("" + (int)(JMFMediaPlayer.this.getVisualComponent().getPreferredSize().getWidth() / (double)JMFMediaPlayer.this.getVisualComponent().getWidth() * (double)e.getX()) + "," + (int)(JMFMediaPlayer.this.getVisualComponent().getPreferredSize().getHeight() / (double)JMFMediaPlayer.this.getVisualComponent().getHeight() * (double)e.getY()));
                } else {
                    JMFMediaPlayer.this.copyToClipboard("" + (int)(JMFMediaPlayer.this.getVisualComponent().getPreferredSize().getWidth() / (double)JMFMediaPlayer.this.getVisualComponent().getWidth() * (double)e.getX()) + "," + (int)(JMFMediaPlayer.this.getVisualComponent().getPreferredSize().getHeight() / (double)JMFMediaPlayer.this.getVisualComponent().getHeight() * (double)e.getY()) + " [" + (int)JMFMediaPlayer.this.getVisualComponent().getPreferredSize().getWidth() + "," + (int)JMFMediaPlayer.this.getVisualComponent().getPreferredSize().getHeight() + "]");
                }
            }
            catch (Exception exep) {
                exep.printStackTrace();
            }
        }
    }

    private class NoMouseComponent
    extends Container {
        private NoMouseComponent() {
        }

        public void addMouseListener(MouseListener ml) {
        }
    }
}

