/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.prefs.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.prefs.PreferenceEditor;

public class EditingPanel
extends JPanel
implements PreferenceEditor,
ChangeListener {
    private JCheckBox deselectCB;
    private JCheckBox enterCommitsCB;
    private JCheckBox clearSelectionCB;
    private JCheckBox createDependAnnCB;
    private JCheckBox snapAnnCB;
    private JLabel snapAnnLabel;
    private JCheckBox stickToFramesCB;
    private JTextField snapAnnTextField;
    private JCheckBox suggestEntryContainsCB;
    private JCheckBox suggestSearchDescCB;
    private JCheckBox suggestIgnoreCaseCB;
    private boolean origDeselectFlag = false;
    private boolean origEnterFlag = false;
    private boolean origClearSelFlag = false;
    private boolean oriCreateDependAnnFlag = false;
    private boolean oriSnapAnnotationsFlag = false;
    private boolean oriStickToFramesFlag = false;
    private long oriSnapValue = 100L;
    private long newSnapValue;
    private boolean oriSuggestSearchMethodFlag = false;
    private boolean oriSuggestSearchInDescFlag = false;
    private boolean oriSuggestIgnoreCaseFlag = false;

    public EditingPanel() {
        this.readPrefs();
        this.initComponents();
    }

    private void readPrefs() {
        Object val = Preferences.get("InlineEdit.DeselectCommits", null);
        if (val instanceof Boolean) {
            this.origDeselectFlag = (Boolean)val;
        }
        if ((val = Preferences.get("InlineEdit.EnterCommits", null)) instanceof Boolean) {
            this.origEnterFlag = (Boolean)val;
        }
        if ((val = Preferences.get("ClearSelectionAfterCreation", null)) instanceof Boolean) {
            this.origClearSelFlag = (Boolean)val;
        }
        if ((val = Preferences.get("CreateDependingAnnotations", null)) instanceof Boolean) {
            this.oriCreateDependAnnFlag = (Boolean)val;
        }
        if ((val = Preferences.get("SnapAnnotations", null)) instanceof Boolean) {
            this.oriSnapAnnotationsFlag = (Boolean)val;
        }
        if ((val = Preferences.get("SnapAnnotationsValue", null)) instanceof Long) {
            this.oriSnapValue = (Long)val;
        }
        if ((val = Preferences.get("StickAnnotationsWithVideoFrames", null)) instanceof Boolean) {
            this.oriStickToFramesFlag = (Boolean)val;
        }
        if ((val = Preferences.get("SuggestPanel.EntryContains", null)) instanceof Boolean) {
            this.oriSuggestSearchMethodFlag = (Boolean)val;
        }
        if ((val = Preferences.get("SuggestPanel.SearchDescription", null)) instanceof Boolean) {
            this.oriSuggestSearchInDescFlag = (Boolean)val;
        }
        if ((val = Preferences.get("SuggestPanel.IgnoreCase", null)) instanceof Boolean) {
            this.oriSuggestIgnoreCaseFlag = (Boolean)val;
        }
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 0, 2, 0);
        this.deselectCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Edit.Deselect"), this.origDeselectFlag);
        this.enterCommitsCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Edit.EnterCommits"), this.origEnterFlag);
        this.clearSelectionCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Edit.ClearSelection"), this.origClearSelFlag);
        this.createDependAnnCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Edit.CreateDependAnn"), this.oriCreateDependAnnFlag);
        this.snapAnnCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Edit.SnapAnnotations"), this.oriSnapAnnotationsFlag);
        this.snapAnnCB.addChangeListener(this);
        this.snapAnnLabel = new JLabel(ElanLocale.getString("PreferencesDialog.Edit.SnapAnnotations.Label"));
        this.snapAnnTextField = new JTextField(Long.toString(this.oriSnapValue));
        this.snapAnnTextField.setEnabled(this.oriSnapAnnotationsFlag);
        this.stickToFramesCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Edit.StickToVideoFrames"), this.oriStickToFramesFlag);
        this.deselectCB.setFont(this.deselectCB.getFont().deriveFont(0));
        this.enterCommitsCB.setFont(this.deselectCB.getFont());
        this.clearSelectionCB.setFont(this.deselectCB.getFont());
        this.createDependAnnCB.setFont(this.deselectCB.getFont());
        this.snapAnnCB.setFont(this.deselectCB.getFont());
        this.snapAnnLabel.setFont(this.deselectCB.getFont());
        this.snapAnnTextField.setFont(this.deselectCB.getFont());
        this.stickToFramesCB.setFont(this.deselectCB.getFont());
        this.suggestEntryContainsCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Edit.SuggestEntryContains"), this.oriSuggestSearchMethodFlag);
        this.suggestSearchDescCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Edit.SuggestSearchDesc"), this.oriSuggestSearchInDescFlag);
        this.suggestIgnoreCaseCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Edit.SuggestIgnoreCase"), this.oriSuggestIgnoreCaseFlag);
        this.suggestEntryContainsCB.setFont(this.deselectCB.getFont());
        this.suggestSearchDescCB.setFont(this.deselectCB.getFont());
        this.suggestIgnoreCaseCB.setFont(this.deselectCB.getFont());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.insets = insets;
        this.add((Component)new JLabel(ElanLocale.getString("PreferencesDialog.Category.Edit")), gbc);
        gbc.gridy = 1;
        this.add((Component)this.deselectCB, gbc);
        gbc.gridy = 2;
        this.add((Component)this.enterCommitsCB, gbc);
        gbc.gridy = 3;
        this.add((Component)this.clearSelectionCB, gbc);
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        this.add((Component)this.createDependAnnCB, gbc);
        gbc.gridy = 5;
        this.add((Component)this.stickToFramesCB, gbc);
        gbc.gridy = 6;
        gbc.gridwidth = 1;
        this.add((Component)this.snapAnnCB, gbc);
        gbc.gridy = 7;
        gbc.insets = new Insets(2, 40, 2, 6);
        this.add((Component)this.snapAnnLabel, gbc);
        gbc.gridx = 1;
        gbc.insets = insets;
        this.add((Component)this.snapAnnTextField, gbc);
        gbc.insets = new Insets(12, 0, 2, 0);
        gbc.gridwidth = 2;
        gbc.gridx = 0;
        gbc.gridy = 8;
        this.add((Component)new JLabel(ElanLocale.getString("PreferencesDialog.Edit.SuggestPanel")), gbc);
        gbc.insets = insets;
        gbc.gridy = 9;
        this.add((Component)this.suggestEntryContainsCB, gbc);
        gbc.gridy = 10;
        this.add((Component)this.suggestSearchDescCB, gbc);
        gbc.gridy = 11;
        this.add((Component)this.suggestIgnoreCaseCB, gbc);
        gbc.gridy = 12;
        gbc.gridx = 0;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        this.add((Component)new JPanel(), gbc);
    }

    public Map getChangedPreferences() {
        if (this.isChanged()) {
            HashMap<String, Comparable<Boolean>> chMap = new HashMap<String, Comparable<Boolean>>(3);
            if (this.deselectCB.isSelected() != this.origDeselectFlag) {
                chMap.put("InlineEdit.DeselectCommits", new Boolean(this.deselectCB.isSelected()));
            }
            if (this.enterCommitsCB.isSelected() != this.origEnterFlag) {
                chMap.put("InlineEdit.EnterCommits", new Boolean(this.enterCommitsCB.isSelected()));
            }
            if (this.clearSelectionCB.isSelected() != this.origClearSelFlag) {
                chMap.put("ClearSelectionAfterCreation", new Boolean(this.clearSelectionCB.isSelected()));
            }
            if (this.createDependAnnCB.isSelected() != this.oriCreateDependAnnFlag) {
                chMap.put("CreateDependingAnnotations", new Boolean(this.createDependAnnCB.isSelected()));
            }
            if (this.snapAnnCB.isSelected() != this.oriSnapAnnotationsFlag) {
                chMap.put("SnapAnnotations", new Boolean(this.snapAnnCB.isSelected()));
            }
            if (this.snapAnnCB.isSelected()) {
                chMap.put("SnapAnnotationsValue", new Long(this.newSnapValue));
            }
            if (this.stickToFramesCB.isSelected() != this.oriStickToFramesFlag) {
                chMap.put("StickAnnotationsWithVideoFrames", new Boolean(this.stickToFramesCB.isSelected()));
            }
            if (this.suggestEntryContainsCB.isSelected() != this.oriSuggestSearchMethodFlag) {
                chMap.put("SuggestPanel.EntryContains", new Boolean(this.suggestEntryContainsCB.isSelected()));
            }
            if (this.suggestSearchDescCB.isSelected() != this.oriSuggestSearchInDescFlag) {
                chMap.put("SuggestPanel.SearchDescription", new Boolean(this.suggestSearchDescCB.isSelected()));
            }
            if (this.suggestIgnoreCaseCB.isSelected() != this.oriSuggestIgnoreCaseFlag) {
                chMap.put("SuggestPanel.IgnoreCase", new Boolean(this.suggestIgnoreCaseCB.isSelected()));
            }
            return chMap;
        }
        return null;
    }

    public boolean isChanged() {
        return this.deselectCB.isSelected() != this.origDeselectFlag || this.enterCommitsCB.isSelected() != this.origEnterFlag || this.clearSelectionCB.isSelected() != this.origClearSelFlag || this.createDependAnnCB.isSelected() != this.oriCreateDependAnnFlag || this.snapAnnCB.isSelected() != this.oriSnapAnnotationsFlag || this.newSnapValue != this.oriSnapValue || this.stickToFramesCB.isSelected() != this.oriStickToFramesFlag || this.suggestEntryContainsCB.isSelected() != this.oriSuggestSearchMethodFlag || this.suggestSearchDescCB.isSelected() != this.oriSuggestSearchInDescFlag || this.suggestIgnoreCaseCB.isSelected() != this.oriSuggestIgnoreCaseFlag;
    }

    public boolean checkSnapValue() {
        if (this.snapAnnCB.isSelected() && this.snapAnnTextField.getText() != null) {
            try {
                this.newSnapValue = Long.parseLong(this.snapAnnTextField.getText().trim());
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    public void focusSnapValue() {
        this.snapAnnTextField.requestFocus();
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.snapAnnCB) {
            this.snapAnnTextField.setEnabled(this.snapAnnCB.isSelected());
            if (this.snapAnnCB.isSelected()) {
                this.snapAnnTextField.requestFocus();
            }
        }
    }
}

