/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.recognizer.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import mpi.eudico.client.annotator.recognizer.api.LocalRecognizer;
import mpi.eudico.client.annotator.recognizer.api.Recognizer;
import mpi.eudico.client.annotator.recognizer.api.SharedRecognizer;
import mpi.eudico.client.annotator.recognizer.data.FileParam;
import mpi.eudico.client.annotator.recognizer.data.Param;
import mpi.eudico.client.annotator.recognizer.load.RecognizerBundle;
import mpi.eudico.client.annotator.recognizer.load.RecognizerLoader;
import mpi.eudico.client.annotator.recognizer.load.RecognizerParser;
import mpi.eudico.client.annotator.recognizer.silence.SilenceRecognizer;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.util.ExtClassLoader;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvailabilityDetector {
    private static Map<String, RecognizerBundle> audioRecognizerBundles = new HashMap<String, RecognizerBundle>(6);
    private static Map<String, RecognizerBundle> videoRecognizerBundles = new HashMap<String, RecognizerBundle>(6);
    private static RecognizerLoader recognizerLoader;

    private AvailabilityDetector() {
    }

    public static HashMap<String, Recognizer> getAudioRecognizers(ArrayList<String> filePaths) {
        HashMap<String, Recognizer> audioRecs = new HashMap<String, Recognizer>(6);
        SilenceRecognizer sr = new SilenceRecognizer();
        audioRecs.put(sr.getName(), sr);
        for (String key : audioRecognizerBundles.keySet()) {
            RecognizerBundle bundle = audioRecognizerBundles.get(key);
            if (bundle.getRecExecutionType().equals("local")) {
                LocalRecognizer localRecognizer = new LocalRecognizer(bundle.getRecognizerClass());
                localRecognizer.setParamList(bundle.getParamList());
                localRecognizer.setName(bundle.getName());
                localRecognizer.setRecognizerType(0);
                localRecognizer.setBaseDir(bundle.getBaseDir());
                if (videoRecognizerBundles.containsKey(key)) {
                    localRecognizer.setRecognizerType(2);
                }
                audioRecs.put(key, localRecognizer);
                continue;
            }
            if (bundle.getRecExecutionType().equals("shared")) {
                SharedRecognizer sharedRecognizer = new SharedRecognizer(bundle.getRecognizerClass());
                sharedRecognizer.setParamList(bundle.getParamList());
                sharedRecognizer.setName(bundle.getName());
                sharedRecognizer.setRecognizerType(1);
                sharedRecognizer.setBaseDir(bundle.getBaseDir());
                if (videoRecognizerBundles.containsKey(key)) {
                    sharedRecognizer.setRecognizerType(2);
                }
                audioRecs.put(key, sharedRecognizer);
                continue;
            }
            if (bundle.getJavaLibs() != null) {
                if (recognizerLoader == null) {
                    recognizerLoader = new RecognizerLoader(bundle.getJavaLibs(), bundle.getNativeLibs());
                } else {
                    recognizerLoader.addLibs(bundle.getJavaLibs());
                    recognizerLoader.addNativeLibs(bundle.getNativeLibs());
                }
                try {
                    Recognizer rec = (Recognizer)Class.forName(bundle.getRecognizerClass(), true, recognizerLoader).newInstance();
                    rec.setName(bundle.getName());
                    audioRecs.put(key, rec);
                }
                catch (ClassNotFoundException cnfe) {
                    ClientLogger.LOG.severe("Cannot load the recognizer class: " + bundle.getRecognizerClass() + " - Class not found");
                }
                catch (InstantiationException ie) {
                    ClientLogger.LOG.severe("Cannot instantiate the recognizer class: " + bundle.getRecognizerClass());
                }
                catch (IllegalAccessException iae) {
                    ClientLogger.LOG.severe("Cannot access the recognizer class: " + bundle.getRecognizerClass());
                }
                catch (Exception ex) {
                    ClientLogger.LOG.severe("Cannot load the recognizer: " + bundle.getRecognizerClass() + " - " + ex.getMessage());
                }
                continue;
            }
            ClientLogger.LOG.severe("Cannot load the recognizer: no Java library has been found: " + bundle.getName());
        }
        return audioRecs;
    }

    public static HashMap<String, Recognizer> getVideoRecognizers(ArrayList<String> filePaths) {
        HashMap<String, Recognizer> videoRecs = new HashMap<String, Recognizer>(6);
        for (String key : videoRecognizerBundles.keySet()) {
            RecognizerBundle bundle = videoRecognizerBundles.get(key);
            if (bundle.getRecExecutionType().equals("local")) {
                LocalRecognizer localRecognizer = new LocalRecognizer(bundle.getRecognizerClass());
                localRecognizer.setParamList(bundle.getParamList());
                localRecognizer.setName(bundle.getName());
                localRecognizer.setRecognizerType(1);
                localRecognizer.setBaseDir(bundle.getBaseDir());
                if (audioRecognizerBundles.containsKey(key)) {
                    localRecognizer.setRecognizerType(2);
                }
                videoRecs.put(key, localRecognizer);
                continue;
            }
            if (bundle.getRecExecutionType().equals("shared")) {
                SharedRecognizer sharedRecognizer = new SharedRecognizer(bundle.getRecognizerClass());
                sharedRecognizer.setParamList(bundle.getParamList());
                sharedRecognizer.setName(bundle.getName());
                sharedRecognizer.setRecognizerType(1);
                sharedRecognizer.setBaseDir(bundle.getBaseDir());
                if (audioRecognizerBundles.containsKey(key)) {
                    sharedRecognizer.setRecognizerType(2);
                }
                videoRecs.put(key, sharedRecognizer);
                continue;
            }
            if (bundle.getJavaLibs() != null) {
                if (recognizerLoader == null) {
                    recognizerLoader = new RecognizerLoader(bundle.getJavaLibs(), bundle.getNativeLibs());
                } else {
                    recognizerLoader.addLibs(bundle.getJavaLibs());
                    recognizerLoader.addNativeLibs(bundle.getNativeLibs());
                }
                try {
                    Recognizer rec = (Recognizer)Class.forName(bundle.getRecognizerClass(), true, recognizerLoader).newInstance();
                    rec.setName(bundle.getName());
                    videoRecs.put(key, rec);
                }
                catch (ClassNotFoundException cnfe) {
                    ClientLogger.LOG.severe("Cannot load the recognizer class: " + bundle.getRecognizerClass() + " - Class not found");
                }
                catch (InstantiationException ie) {
                    ClientLogger.LOG.severe("Cannot instantiate the recognizer class: " + bundle.getRecognizerClass());
                }
                catch (IllegalAccessException iae) {
                    ClientLogger.LOG.severe("Cannot access the recognizer class: " + bundle.getRecognizerClass());
                }
                catch (Exception ex) {
                    ClientLogger.LOG.severe("Cannot load the recognizer: " + bundle.getRecognizerClass() + " - " + ex.getMessage());
                }
                continue;
            }
            ClientLogger.LOG.severe("Cannot load the recognizer: no Java library has been found ");
        }
        return videoRecs;
    }

    public static List<Param> getParamList(String recognizerName) {
        if (recognizerName != null) {
            RecognizerBundle bundle = audioRecognizerBundles.get(recognizerName);
            List<Param> params = null;
            if (bundle != null) {
                params = bundle.getParamList();
            } else {
                bundle = videoRecognizerBundles.get(recognizerName);
                if (bundle != null) {
                    params = bundle.getParamList();
                }
            }
            if (params != null) {
                ArrayList<Param> copyList = new ArrayList<Param>(params.size());
                for (Param p : params) {
                    if (p == null) continue;
                    try {
                        copyList.add((Param)p.clone());
                    }
                    catch (CloneNotSupportedException cnse) {
                        ClientLogger.LOG.warning("Cannot clone a parameter: " + p.id);
                    }
                }
                return copyList;
            }
        }
        return null;
    }

    private static void init() {
        File[] files;
        File extFile = new File(ExtClassLoader.EXTENSIONS_DIR);
        if (!extFile.exists()) {
            ClientLogger.LOG.warning("The extension folder could not be found (" + ExtClassLoader.EXTENSIONS_DIR + ").");
            return;
        }
        if (!extFile.isDirectory()) {
            ClientLogger.LOG.warning("The extension 'folder' is not a folder (" + ExtClassLoader.EXTENSIONS_DIR + ").");
            return;
        }
        if (!extFile.canRead()) {
            ClientLogger.LOG.warning("The extension folder is not accessible (" + ExtClassLoader.EXTENSIONS_DIR + ").");
            return;
        }
        for (File f : files = extFile.listFiles()) {
            if (f.isDirectory()) {
                AvailabilityDetector.detectRecognizer(f);
                continue;
            }
            String name = f.getName().toLowerCase();
            if (name.endsWith("jar")) {
                AvailabilityDetector.detectRecognizerFromJar(f);
                continue;
            }
            if (!name.endsWith("zip")) continue;
            AvailabilityDetector.detectRecognizerFromZip(f);
        }
    }

    private static void detectRecognizerFromJar(File file) {
        try {
            JarFile jFile = new JarFile(file);
            JarEntry je = jFile.getJarEntry("recognizer.cmdi");
            if (je == null) {
                ClientLogger.LOG.warning("No plug-in metadata file (recognizer.cmdi) found in " + file.getName());
                return;
            }
            try {
                URL jarUrl = file.toURL();
                URL[] libUrls = new URL[]{jarUrl};
                InputStream mdStream = jFile.getInputStream(je);
                AvailabilityDetector.createBundle(mdStream, libUrls, null, file.getParentFile());
            }
            catch (MalformedURLException mue) {
                ClientLogger.LOG.severe("Cannot create URL for file: " + file.getName());
            }
            catch (IOException ioe) {
                ClientLogger.LOG.warning("Cannot read the cmdi file from the jar file: " + file.getName());
            }
        }
        catch (IOException ioe) {
            ClientLogger.LOG.warning("Cannot read the jar file: " + file.getName());
        }
    }

    private static void detectRecognizerFromZip(File file) {
        try {
            ZipFile zFile = new ZipFile(file);
            ZipEntry ze = zFile.getEntry("recognizer.cmdi");
            if (ze == null) {
                ClientLogger.LOG.warning("No plug-in metadata file (recognizer.cmdi) found in " + file.getName());
                return;
            }
            try {
                URL zipUrl = file.toURL();
                URL[] libUrls = new URL[]{zipUrl};
                InputStream mdStream = zFile.getInputStream(ze);
                AvailabilityDetector.createBundle(mdStream, libUrls, null, file.getParentFile());
            }
            catch (MalformedURLException mue) {
                ClientLogger.LOG.severe("Cannot create URL for file: " + file.getName());
            }
            catch (IOException ioe) {
                ClientLogger.LOG.warning("Cannot read the cmdi file from the zip file: " + file.getName());
            }
        }
        catch (IOException ioe) {
            ClientLogger.LOG.warning("Cannot read the zip file: " + file.getName());
        }
    }

    private static void detectRecognizer(File file) {
        File[] files = file.listFiles();
        File mdFile = null;
        for (File f : files) {
            if (!f.getName().toLowerCase().equals("recognizer.cmdi")) continue;
            mdFile = f;
            break;
        }
        if (mdFile != null) {
            ArrayList<URL> libs = new ArrayList<URL>();
            ArrayList<URL> natLibs = new ArrayList<URL>();
            AvailabilityDetector.addLibs(file, libs, natLibs);
            try {
                FileInputStream mdStream = new FileInputStream(mdFile);
                URL[] libUrls = null;
                if (libs.size() > 0) {
                    libUrls = libs.toArray(new URL[0]);
                }
                URL[] natLibUrls = null;
                if (natLibs.size() > 0) {
                    natLibUrls = natLibs.toArray(new URL[0]);
                }
                AvailabilityDetector.createBundle(mdStream, libUrls, natLibUrls, file);
            }
            catch (FileNotFoundException fnfe) {
                ClientLogger.LOG.severe("Cannot parse metadata file: " + fnfe.getMessage());
            }
        } else {
            ClientLogger.LOG.severe("No cmdi metadata file found in: " + file.getName());
        }
    }

    private static void createBundle(InputStream mdStream, URL[] libs, URL[] natLibs, File baseDir) {
        boolean isDetector = false;
        String binaryName = null;
        RecognizerBundle bundle = null;
        RecognizerParser parser = null;
        try {
            parser = new RecognizerParser(mdStream);
            parser.parse();
            if (parser.recognizerType == null || !parser.recognizerType.equals("direct") && !parser.recognizerType.equals("local") && !parser.recognizerType.equals("shared")) {
                ClientLogger.LOG.warning("Unsupported recognizer type, should be 'direct', 'local' or 'shared': " + parser.recognizerType);
                return;
            }
            if (!parser.curOsSupported) {
                ClientLogger.LOG.warning("Recognizer does not support this Operating System: " + parser.recognizerName);
                return;
            }
            if (parser.implementor == null) {
                ClientLogger.LOG.warning("The implementing class name has not been specified.");
                return;
            }
            isDetector = true;
            binaryName = parser.implementor;
        }
        catch (SAXException sax) {
            ClientLogger.LOG.severe("Cannot parse metadata file: " + sax.getMessage());
        }
        if (isDetector) {
            boolean audio = false;
            boolean video = false;
            if (parser.paramList != null) {
                for (Param par : parser.paramList) {
                    if (!(par instanceof FileParam) || ((FileParam)par).ioType != 'i') continue;
                    if (((FileParam)par).contentType == 0) {
                        audio = true;
                        continue;
                    }
                    if (((FileParam)par).contentType != 1) continue;
                    video = true;
                }
            }
            if (parser.recognizerType.equals("direct")) {
                RecognizerLoader loader = new RecognizerLoader(libs, natLibs);
                if (binaryName != null) {
                    try {
                        Class<?> c = loader.loadClass(binaryName);
                        bundle = new RecognizerBundle();
                        bundle.setId(parser.recognizerName);
                        bundle.setName(parser.description);
                        bundle.setParamList(parser.paramList);
                        bundle.setRecognizerClass(binaryName);
                        bundle.setRecExecutionType(parser.recognizerType);
                        bundle.setJavaLibs(libs);
                        bundle.setNativeLibs(natLibs);
                        bundle.setBaseDir(baseDir);
                        if (audio) {
                            audioRecognizerBundles.put(bundle.getName(), bundle);
                        }
                        if (video) {
                            videoRecognizerBundles.put(bundle.getName(), bundle);
                        }
                    }
                    catch (ClassNotFoundException cne) {
                        ClientLogger.LOG.severe("Cannot load the recognizer class: " + binaryName + " - Class not found");
                    }
                } else {
                    ClientLogger.LOG.warning("Cannot load the recognizer class: Class not found");
                }
            } else if (parser.recognizerType.equals("local") || parser.recognizerType.equals("shared")) {
                bundle = new RecognizerBundle();
                bundle.setId(parser.recognizerName);
                bundle.setName(parser.description);
                bundle.setParamList(parser.paramList);
                bundle.setRecognizerClass(binaryName);
                bundle.setRecExecutionType(parser.recognizerType);
                bundle.setBaseDir(baseDir);
                if (audio) {
                    audioRecognizerBundles.put(bundle.getName(), bundle);
                }
                if (video) {
                    videoRecognizerBundles.put(bundle.getName(), bundle);
                }
            }
        }
    }

    private static void addLibs(File file, List<URL> libs, List<URL> natLibs) {
        File[] files;
        for (File f : files = file.listFiles()) {
            try {
                if (f.isDirectory()) {
                    AvailabilityDetector.addLibs(f, libs, natLibs);
                    continue;
                }
                String name = f.getName().toLowerCase();
                if (name.endsWith("jar") || name.endsWith("zip")) {
                    try {
                        libs.add(f.toURL());
                    }
                    catch (MalformedURLException mue) {
                        ClientLogger.LOG.severe("Cannot create URL for file: " + f.getName());
                    }
                    continue;
                }
                if (!name.endsWith("dll") && !name.endsWith("so") && !name.endsWith("jnilib")) continue;
                try {
                    natLibs.add(f.toURL());
                }
                catch (MalformedURLException mue) {
                    ClientLogger.LOG.severe("Cannot create URL for file: " + f.getName());
                }
            }
            catch (SecurityException se) {
                ClientLogger.LOG.warning("Cannot read file: " + f.getName());
            }
        }
    }

    static {
        AvailabilityDetector.init();
    }
}

