/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.recognizer.api;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.JPanel;
import mpi.eudico.client.annotator.linkedmedia.MediaDescriptorUtil;
import mpi.eudico.client.annotator.recognizer.api.Recognizer;
import mpi.eudico.client.annotator.recognizer.api.RecognizerHost;
import mpi.eudico.client.annotator.recognizer.data.FileParam;
import mpi.eudico.client.annotator.recognizer.data.NumParam;
import mpi.eudico.client.annotator.recognizer.data.Param;
import mpi.eudico.client.annotator.recognizer.data.Segmentation;
import mpi.eudico.client.annotator.recognizer.data.TextParam;
import mpi.eudico.client.annotator.recognizer.io.CsvTierIO;
import mpi.eudico.client.annotator.recognizer.io.XmlTierIO;
import mpi.eudico.client.annotator.util.ClientLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalRecognizer
implements Recognizer {
    protected RecognizerHost host;
    protected String runCommand;
    protected List<Param> paramList;
    protected List<String> mediaPaths;
    protected String name;
    protected int recognizerType;
    protected File baseDir;
    protected Process process;
    protected OutputStream outStream;
    protected InputStream inStream;
    protected BufferedReader reader;
    protected StringBuilder reportBuilder;
    protected boolean isRunning = false;
    protected long lastStartTime = 0L;

    public LocalRecognizer() {
    }

    public LocalRecognizer(String runCommand) {
        this.runCommand = runCommand;
    }

    public void setParamList(List<Param> paramList) {
        this.paramList = paramList;
    }

    @Override
    public boolean canCombineMultipleFiles() {
        if (this.paramList == null || this.paramList.isEmpty()) {
            return false;
        }
        int numAudio = 0;
        int numVideo = 0;
        for (Param p : this.paramList) {
            if (!(p instanceof FileParam)) continue;
            FileParam fp = (FileParam)p;
            if (fp.ioType == 'i' && fp.contentType == 0) {
                ++numAudio;
                continue;
            }
            if (fp.ioType != 'i' || fp.contentType != 1) continue;
            ++numVideo;
        }
        return numAudio + numVideo > 1;
    }

    @Override
    public boolean canHandleMedia(String mediaFilePath) {
        if (mediaFilePath == null || mediaFilePath.length() == 0) {
            return false;
        }
        int index = mediaFilePath.lastIndexOf(46);
        String ext = null;
        if (index > -1 && index < mediaFilePath.length() - 1) {
            ext = mediaFilePath.substring(index + 1);
        }
        if (ext == null || ext.length() == 0) {
            return false;
        }
        String mime = MediaDescriptorUtil.mimeTypeForExtension(ext);
        if (this.paramList != null && !this.paramList.isEmpty()) {
            for (Param p : this.paramList) {
                if (!(p instanceof FileParam)) continue;
                FileParam fp = (FileParam)p;
                if (fp.ioType != 'i') continue;
                if (fp.mimeTypes != null) {
                    if (fp.mimeTypes.contains(mime)) {
                        return true;
                    }
                    if (fp.contentType == 0 && fp.mimeTypes.contains("audio")) {
                        return true;
                    }
                    if (fp.contentType != 1 || !fp.mimeTypes.contains("video")) continue;
                    return true;
                }
                if (fp.contentType == 0) {
                    return true;
                }
                if (fp.contentType != 1) continue;
                return mime != "audio/*" && mime != "audio/x-wav";
            }
            return false;
        }
        return true;
    }

    @Override
    public void dispose() {
        this.reportBuilder = null;
    }

    @Override
    public JPanel getControlPanel() {
        return null;
    }

    @Override
    public int getExamplesSupport() {
        if (this.paramList != null && !this.paramList.isEmpty()) {
            for (Param p : this.paramList) {
                if (!(p instanceof FileParam)) continue;
                FileParam fp = (FileParam)p;
                if (fp.ioType != 'i' || fp.contentType != 2 && fp.contentType != 3) continue;
                if (fp.optional) {
                    return 0;
                }
                return 1;
            }
        }
        return 2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getParameterValue(String param) {
        if (param == null) {
            return null;
        }
        if (this.paramList != null && !this.paramList.isEmpty()) {
            for (Param p : this.paramList) {
                if (p.id == null || !p.id.equals(param)) continue;
                if (p instanceof NumParam) {
                    if (((NumParam)p).current > Float.MIN_VALUE) {
                        return new Float(((NumParam)p).current);
                    }
                    return new Float(((NumParam)p).def);
                }
                if (p instanceof TextParam) {
                    String val = ((TextParam)p).curValue;
                    if (val == null) {
                        return ((TextParam)p).defValue;
                    }
                    return val;
                }
                if (!(p instanceof FileParam)) continue;
                return ((FileParam)p).filePath;
            }
        }
        return null;
    }

    @Override
    public int getRecognizerType() {
        return this.recognizerType;
    }

    public void setRecognizerType(int type) {
        this.recognizerType = type;
    }

    @Override
    public String getReport() {
        if (this.reportBuilder != null) {
            return this.reportBuilder.toString();
        }
        return null;
    }

    public boolean needsExamples() {
        return false;
    }

    @Override
    public boolean setMedia(List<String> mediaFilePaths) {
        this.mediaPaths = mediaFilePaths;
        if (mediaFilePaths != null) {
            block0: for (String mediaPath : mediaFilePaths) {
                if (mediaPath == null || mediaPath.length() <= 0) continue;
                int index = mediaPath.lastIndexOf(46);
                String ext = null;
                if (index > -1 && index < mediaPath.length() - 1) {
                    ext = mediaPath.substring(index + 1);
                }
                String mime = null;
                if (ext != null && ext.length() > 0) {
                    mime = MediaDescriptorUtil.mimeTypeForExtension(ext);
                }
                if (this.paramList == null || this.paramList.isEmpty()) continue;
                for (Param p : this.paramList) {
                    if (!(p instanceof FileParam)) continue;
                    FileParam fp = (FileParam)p;
                    if (fp.filePath != null || fp.ioType != 'i') continue;
                    if (fp.mimeTypes != null) {
                        if (fp.mimeTypes.contains(mime)) {
                            fp.filePath = mediaPath;
                            continue block0;
                        }
                        if (fp.contentType == 0 && fp.mimeTypes.contains("audio")) {
                            fp.filePath = mediaPath;
                            continue block0;
                        }
                        if (fp.contentType != 1 || !fp.mimeTypes.contains("video")) continue;
                        fp.filePath = mediaPath;
                        continue block0;
                    }
                    if (fp.contentType == 0) {
                        fp.filePath = mediaPath;
                        continue block0;
                    }
                    if (fp.contentType != 1) continue;
                    if (mime != null) {
                        if (mime == "audio/*" || mime == "audio/x-wav") continue;
                        fp.filePath = mediaPath;
                        continue block0;
                    }
                    fp.filePath = mediaPath;
                    continue block0;
                }
            }
        }
        return true;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setParameterValue(String param, String value) {
        if (this.paramList != null && !this.paramList.isEmpty()) {
            for (Param p : this.paramList) {
                if (p.id == null || !p.id.equals(param)) continue;
                if (p instanceof TextParam) {
                    ((TextParam)p).curValue = value;
                    break;
                }
                if (!(p instanceof FileParam)) break;
                ((FileParam)p).filePath = value;
                break;
            }
        }
    }

    @Override
    public void setParameterValue(String param, float value) {
        if (this.paramList != null && !this.paramList.isEmpty()) {
            for (Param p : this.paramList) {
                if (p.id == null || !p.id.equals(param)) continue;
                if (!(p instanceof NumParam)) break;
                ((NumParam)p).current = value;
                break;
            }
        }
    }

    @Override
    public void setRecognizerHost(RecognizerHost host) {
        this.host = host;
    }

    @Override
    public void start() {
        if (this.runCommand == null || this.runCommand.length() == 0) {
            if (this.host != null) {
                ClientLogger.LOG.severe("No run command found");
                this.host.errorOccurred("No run command found");
            }
            return;
        }
        try {
            this.isRunning = true;
            this.host.setProgress(-1.0f);
            this.reportBuilder = new StringBuilder();
            this.lastStartTime = System.currentTimeMillis();
            StringTokenizer tokenizer = new StringTokenizer(this.runCommand);
            ArrayList<String> cmds = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                cmds.add(tokenizer.nextToken());
            }
            ProcessBuilder pBuilder = new ProcessBuilder(cmds);
            pBuilder.redirectErrorStream(true);
            pBuilder.directory(this.baseDir);
            this.process = pBuilder.start();
            ClientLogger.LOG.info("Created process..." + this.runCommand);
            this.reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            new ReaderThread().start();
            PrintWriter writer = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(this.process.getOutputStream())), true);
            if (this.paramList != null && this.paramList.size() > 0) {
                writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                writer.println("<PARAM xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"file:avatech-call.xsd\">");
                for (Param p : this.paramList) {
                    writer.print("<param name=\"" + p.id + "\">");
                    if (p instanceof NumParam) {
                        writer.print(((NumParam)p).current);
                    } else if (p instanceof TextParam) {
                        writer.print(((TextParam)p).curValue);
                    } else if (p instanceof FileParam) {
                        String path = ((FileParam)p).filePath;
                        if (path.startsWith("file:")) {
                            path = path.substring(5);
                        }
                        writer.print(path);
                    }
                    writer.println("</param>");
                }
                writer.println("</PARAM>");
            }
            writer.close();
        }
        catch (IOException ioe) {
            ClientLogger.LOG.severe("Could not run the recognizer: " + ioe.getMessage());
            this.reportBuilder.append("Could not run the recognizer: " + ioe.getMessage());
            this.reportBuilder.append("\n");
            this.host.errorOccurred("Could not run the recognizer: " + ioe.getMessage());
        }
    }

    @Override
    public void stop() {
        if (this.isRunning && this.process != null) {
            ClientLogger.LOG.info("Stopping recognizer...");
            this.process.destroy();
            this.isRunning = false;
            this.convertTiers();
        }
    }

    protected void convertTiers() {
        if (this.paramList != null && this.paramList.size() > 0) {
            for (Param p : this.paramList) {
                XmlTierIO xio;
                File xmlFile;
                List<Segmentation> segm;
                if (!(p instanceof FileParam)) continue;
                FileParam fileParam = (FileParam)p;
                if (fileParam.ioType != 'o') continue;
                if (fileParam.contentType == 3) {
                    CsvTierIO cio;
                    File csvFile = new File(fileParam.filePath);
                    if (!csvFile.exists() || !csvFile.canRead() || csvFile.lastModified() <= this.lastStartTime || (segm = (cio = new CsvTierIO()).read(csvFile)) == null || segm.size() <= 0) continue;
                    for (Segmentation s : segm) {
                        this.host.addSegmentation(s);
                    }
                    continue;
                }
                if (fileParam.contentType != 2 || !(xmlFile = new File(fileParam.filePath)).exists() || !xmlFile.canRead() || xmlFile.lastModified() <= this.lastStartTime || (segm = (xio = new XmlTierIO(xmlFile)).parse()) == null || segm.size() <= 0) continue;
                for (Segmentation s : segm) {
                    this.host.addSegmentation(s);
                }
            }
        }
    }

    @Override
    public void updateLocale(Locale locale) {
    }

    public String getRunCommand() {
        return this.runCommand;
    }

    public void setRunCommand(String runCommand) {
        this.runCommand = runCommand;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    class ReaderThread
    extends Thread {
        private final String DONE = "RESULT: DONE.";
        private final String FAIL = "RESULT: FAILED.";
        private final String PROG = "PROGRESS:";
        private final String INFO = "INFO:";
        private final String RESULT = "RESULT:";
        private float lastProg = -1.0f;

        ReaderThread() {
        }

        public void run() {
            while (LocalRecognizer.this.isRunning && LocalRecognizer.this.reader != null) {
                block28: {
                    try {
                        if (!LocalRecognizer.this.reader.ready()) break block28;
                        String line = LocalRecognizer.this.reader.readLine();
                        if (line != null) {
                            if (LocalRecognizer.this.reportBuilder != null) {
                                LocalRecognizer.this.reportBuilder.append(line);
                                LocalRecognizer.this.reportBuilder.append('\n');
                            }
                            if (line.equals("RESULT: DONE.")) {
                                LocalRecognizer.this.convertTiers();
                                LocalRecognizer.this.host.setProgress(1.0f);
                                break;
                            }
                            if (line.equals("RESULT: FAILED.")) {
                                ClientLogger.LOG.warning("Recognizer failed...");
                                LocalRecognizer.this.host.errorOccurred("Recognizer failed.");
                                break;
                            }
                            if (line.startsWith("PROGRESS:")) {
                                int colIndex = line.indexOf(58);
                                if (colIndex >= line.length() - 2) break block28;
                                String remains = line.substring(colIndex + 1).trim();
                                int space = remains.indexOf(32);
                                float prog = -1.0f;
                                String message = null;
                                if (space > -1) {
                                    try {
                                        prog = Float.parseFloat(remains.substring(0, space));
                                        if (space < remains.length() - 1) {
                                            message = remains.substring(space).trim();
                                        }
                                    }
                                    catch (NumberFormatException nfe) {}
                                } else {
                                    try {
                                        prog = Float.parseFloat(remains);
                                    }
                                    catch (NumberFormatException nfe) {
                                        // empty catch block
                                    }
                                }
                                this.lastProg = prog;
                                if (message == null) {
                                    LocalRecognizer.this.host.setProgress(prog);
                                } else {
                                    LocalRecognizer.this.host.setProgress(prog, message);
                                }
                                break block28;
                            }
                            if (line.length() != 1) break block28;
                            if (line.charAt(0) == '\u0004') {
                                ClientLogger.LOG.warning("Recognizer failed... end of transmission");
                                LocalRecognizer.this.host.errorOccurred("Recognizer failed, end of transmission.");
                                if (LocalRecognizer.this.reportBuilder == null) break;
                                LocalRecognizer.this.reportBuilder.append("Recognizer failed, end of transmission.");
                                LocalRecognizer.this.reportBuilder.append('\n');
                                break;
                            }
                            try {
                                int eof = Integer.parseInt(line);
                                if (eof == -1) {
                                    ClientLogger.LOG.warning("Recognizer failed... end of transmission");
                                    LocalRecognizer.this.host.errorOccurred("Recognizer failed, end of transmission.");
                                    if (LocalRecognizer.this.reportBuilder == null) break;
                                    LocalRecognizer.this.reportBuilder.append("Recognizer failed, end of transmission.");
                                    LocalRecognizer.this.reportBuilder.append('\n');
                                    break;
                                }
                                if (eof == 0) {
                                    ClientLogger.LOG.info("Recognizer terminated successfully, but did not send the corresponding RESULT code");
                                    if (LocalRecognizer.this.reportBuilder != null) {
                                        LocalRecognizer.this.reportBuilder.append("Recognizer terminated successfully...");
                                        LocalRecognizer.this.reportBuilder.append('\n');
                                    }
                                    LocalRecognizer.this.host.setProgress(1.0f);
                                    break;
                                }
                                break block28;
                            }
                            catch (NumberFormatException numberFormatException) {
                                break block28;
                            }
                        }
                        ClientLogger.LOG.info("No line read from recognizer");
                    }
                    catch (IOException ioe) {
                        ClientLogger.LOG.info("Exception while reading the recognizer output: " + ioe.getMessage());
                    }
                }
                try {
                    Thread.sleep(40L);
                }
                catch (InterruptedException ie) {}
            }
            if (LocalRecognizer.this.reader != null) {
                try {
                    LocalRecognizer.this.reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            LocalRecognizer.this.isRunning = false;
        }
    }
}

