/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.recognizer.api;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mpi.eudico.client.annotator.recognizer.api.LocalRecognizer;
import mpi.eudico.client.annotator.recognizer.data.FileParam;
import mpi.eudico.client.annotator.recognizer.data.NumParam;
import mpi.eudico.client.annotator.recognizer.data.Param;
import mpi.eudico.client.annotator.recognizer.data.TextParam;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.SystemReporting;

public class SharedRecognizer
extends LocalRecognizer {
    private final int TELNET = 0;
    private final int HTTP = 1;
    private int shareMode = 1;
    private HttpURLConnection httpConn;
    private Socket socket;
    private URLConnection urlConn;
    private List<String> shareMappings = new ArrayList<String>(10);
    private Map<String, String> localToShareMap = new HashMap<String, String>(10);

    public SharedRecognizer() {
    }

    public SharedRecognizer(String runCommand) {
        super(runCommand);
        if (runCommand != null && runCommand.startsWith("telnet")) {
            this.shareMode = 0;
        }
    }

    public void dispose() {
        super.dispose();
        if (this.httpConn != null) {
            this.httpConn.disconnect();
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void start() {
        if (this.runCommand == null || this.runCommand.length() == 0) {
            if (this.host != null) {
                ClientLogger.LOG.severe("No run command found");
                this.host.errorOccurred("No run command found");
            }
            return;
        }
        this.readShares();
        switch (this.shareMode) {
            case 0: {
                this.startTelnet();
                break;
            }
            case 1: {
                this.startHTTP();
                break;
            }
        }
    }

    private void startTelnet() {
        try {
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException ioe) {
                    ClientLogger.LOG.warning("Closing socket failed: " + ioe.getMessage());
                }
            }
            this.isRunning = true;
            this.host.setProgress(-1.0f);
            this.reportBuilder = new StringBuilder();
            this.lastStartTime = System.currentTimeMillis();
            ClientLogger.LOG.info("Creating socket..." + this.runCommand);
            StringBuilder command = new StringBuilder(this.runCommand);
            if (this.runCommand.startsWith("telnet://")) {
                command.delete(0, 9);
            } else if (this.runCommand.startsWith("telnet:")) {
                command.delete(0, 7);
            }
            int index = command.lastIndexOf(":");
            int port = -1;
            if (index > -1 && index < command.length() - 1) {
                String portString = command.substring(index + 1);
                try {
                    port = Integer.parseInt(portString);
                }
                catch (NumberFormatException nfe) {
                    ClientLogger.LOG.warning("Error parsing the port number.");
                }
                command.delete(index, command.length());
            }
            String com = command.toString();
            this.reportBuilder.append("Running command : " + com + " using port: " + port + "\n");
            ClientLogger.LOG.info("Running command : " + com + " using port: " + port);
            this.socket = new Socket(com, port);
            this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            new LocalRecognizer.ReaderThread().start();
            PrintWriter writer = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream())), true);
            if (this.paramList != null && this.paramList.size() > 0) {
                writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                writer.println("<PARAM xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"file:avatech-call.xsd\">");
                for (Param p : this.paramList) {
                    String path;
                    if (p instanceof NumParam) {
                        writer.print("<param name=\"" + p.id + "\">");
                        writer.print(((NumParam)p).current);
                        writer.println("</param>");
                        continue;
                    }
                    if (p instanceof TextParam) {
                        writer.print("<param name=\"" + p.id + "\">");
                        writer.print(((TextParam)p).curValue);
                        writer.println("</param>");
                        continue;
                    }
                    if (!(p instanceof FileParam) || (path = ((FileParam)p).filePath) == null || path.length() <= 0) continue;
                    writer.print("<param name=\"" + p.id + "\">");
                    if (path.startsWith("file:")) {
                        path = path.substring(5);
                    }
                    String uncPath = this.toUNC(path);
                    writer.print(uncPath);
                    writer.println("</param>");
                }
                writer.println("</PARAM>");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void startHTTP() {
        try {
            this.isRunning = true;
            this.host.setProgress(-1.0f);
            this.reportBuilder = new StringBuilder();
            this.lastStartTime = System.currentTimeMillis();
            StringBuilder command = new StringBuilder(this.runCommand);
            if (this.paramList != null && this.paramList.size() > 0) {
                command.append("?");
                Param p = null;
                String utf8 = "UTF-8";
                boolean firstParamAdded = false;
                for (int i = 0; i < this.paramList.size(); ++i) {
                    String path;
                    p = (Param)this.paramList.get(i);
                    if (p instanceof NumParam) {
                        if (firstParamAdded) {
                            command.append("&");
                        }
                        command.append(URLEncoder.encode(p.id, "UTF-8"));
                        command.append("=");
                        command.append(((NumParam)p).current);
                        firstParamAdded = true;
                        continue;
                    }
                    if (p instanceof TextParam) {
                        if (firstParamAdded) {
                            command.append("&");
                        }
                        command.append(URLEncoder.encode(p.id, "UTF-8"));
                        command.append("=");
                        command.append(URLEncoder.encode(((TextParam)p).curValue, "UTF-8"));
                        firstParamAdded = true;
                        continue;
                    }
                    if (!(p instanceof FileParam) || (path = ((FileParam)p).filePath) == null || path.length() <= 0) continue;
                    if (path.startsWith("file:")) {
                        path = path.substring(5);
                    }
                    if (firstParamAdded) {
                        command.append("&");
                    }
                    command.append(URLEncoder.encode(p.id, "UTF-8"));
                    command.append("=");
                    String uncPath = this.toUNC(path);
                    command.append(URLEncoder.encode(uncPath, "UTF-8"));
                    firstParamAdded = true;
                }
            }
            URL url = new URL(command.toString());
            if (this.httpConn != null) {
                this.httpConn.disconnect();
            }
            this.httpConn = (HttpURLConnection)url.openConnection();
            this.httpConn.setDefaultUseCaches(true);
            this.httpConn.setRequestMethod("GET");
            this.httpConn.connect();
            int respCode = this.httpConn.getResponseCode();
            if (respCode != 200) {
                ClientLogger.LOG.severe("Error while accessing server: " + this.runCommand + " : " + respCode);
                this.reportBuilder.append("Error while accessing server: " + this.runCommand + " : " + respCode);
                this.reportBuilder.append("\n");
                this.host.errorOccurred("Error while accessing server: " + this.runCommand + " : " + respCode);
                this.httpConn.disconnect();
                return;
            }
            Object cont = this.httpConn.getContent();
            if (cont instanceof InputStream) {
                InputStream is = (InputStream)cont;
                this.reader = new BufferedReader(new InputStreamReader(is));
                new LocalRecognizer.ReaderThread().start();
            } else {
                ClientLogger.LOG.severe("Unknown content from server: " + cont);
                this.reportBuilder.append("Unknown content from server: " + cont);
                this.reportBuilder.append("\n");
                this.host.errorOccurred("Unknown content from server: " + cont);
            }
        }
        catch (UnsupportedEncodingException uee) {
            ClientLogger.LOG.severe("Could not run the recognizer: " + uee.getMessage());
            this.reportBuilder.append("Could not run the recognizer: " + uee.getMessage());
            this.reportBuilder.append("\n");
            this.host.errorOccurred("Could not run the recognizer: " + uee.getMessage());
        }
        catch (MalformedURLException mue) {
            ClientLogger.LOG.severe("Could not run the recognizer: " + mue.getMessage());
            this.reportBuilder.append("Could not run the recognizer: " + mue.getMessage());
            this.reportBuilder.append("\n");
            this.host.errorOccurred("Could not run the recognizer: " + mue.getMessage());
        }
        catch (IOException ioe) {
            ClientLogger.LOG.severe("Could not run the recognizer: " + ioe.getMessage());
            this.reportBuilder.append("Could not run the recognizer: " + ioe.getMessage());
            this.reportBuilder.append("\n");
            this.host.errorOccurred("Could not run the recognizer: " + ioe.getMessage());
        }
    }

    public void stop() {
        if (this.isRunning) {
            this.isRunning = false;
            this.convertTiers();
            if (this.httpConn != null) {
                this.httpConn.disconnect();
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private void readShares() {
        block25: {
            block24: {
                this.shareMappings.clear();
                this.localToShareMap.clear();
                if (!SystemReporting.isWindows()) break block24;
                ArrayList<String> coms = new ArrayList<String>(2);
                int[] colIndexes = new int[4];
                coms.add("net");
                coms.add("use");
                ProcessBuilder pb = new ProcessBuilder(coms);
                pb.redirectErrorStream(true);
                try {
                    Process proc = pb.start();
                    BufferedReader procReader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    String line = null;
                    while ((line = procReader.readLine()) != null) {
                        if (line.length() == 0) continue;
                        if (line.startsWith("Status")) {
                            colIndexes[0] = 0;
                            colIndexes[1] = line.indexOf("Local");
                            colIndexes[2] = line.indexOf("Remote");
                            colIndexes[3] = line.indexOf("Network");
                        }
                        if (!line.startsWith("OK") && !line.startsWith("Dis") && !line.startsWith("  ") && !line.startsWith("Una")) continue;
                        this.shareMappings.add(line);
                    }
                    procReader.close();
                }
                catch (IOException ioe) {
                    ClientLogger.LOG.warning("Could not read the network shares mappings");
                }
                for (String s : this.shareMappings) {
                    String local = null;
                    String share = null;
                    if (colIndexes[1] > -1 && colIndexes[2] > colIndexes[1] && colIndexes[2] < s.length()) {
                        local = s.substring(colIndexes[1], colIndexes[2]).trim();
                        share = colIndexes[3] > colIndexes[2] && colIndexes[3] < s.length() ? s.substring(colIndexes[2], colIndexes[3]).trim() : s.substring(colIndexes[2], s.indexOf(" ", colIndexes[2])).trim();
                    } else {
                        int colon = s.indexOf(58);
                        if (colon > 1 && colon < s.length() - 1) {
                            local = s.substring(colon - 1, colon + 1);
                            int slash = s.indexOf(92, colon);
                            if (slash > -1 && slash < s.length() - 1) {
                                share = s.substring(slash, s.indexOf(32, slash)).trim();
                            }
                        }
                    }
                    if (local == null || local.length() <= 0 || share == null) continue;
                    this.localToShareMap.put(local, share.replace("\\", "/"));
                }
                break block25;
            }
            if (!SystemReporting.isMacOS()) break block25;
            ArrayList<String> coms = new ArrayList<String>(2);
            coms.add("mount");
            ProcessBuilder pb = new ProcessBuilder(coms);
            pb.redirectErrorStream(true);
            try {
                Process proc = pb.start();
                BufferedReader procReader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                String line = null;
                while ((line = procReader.readLine()) != null) {
                    if (!line.startsWith("//") || line.indexOf("/Volumes") <= -1) continue;
                    this.shareMappings.add(line);
                }
                procReader.close();
            }
            catch (IOException ioe) {
                ClientLogger.LOG.warning("Could not read the network shares mappings");
            }
            for (String s : this.shareMappings) {
                int slash;
                String host;
                StringBuilder builder = new StringBuilder("//");
                int atPos = s.indexOf("@");
                int firstSp = s.indexOf(" on ");
                if (atPos > -1) {
                    if (firstSp > atPos + 1) {
                        host = s.substring(atPos + 1, firstSp);
                        int colon = host.indexOf(":");
                        if (colon > -1) {
                            builder.append(host.substring(0, colon));
                            slash = host.indexOf("/", colon);
                            if (slash > -1) {
                                builder.append(host.substring(slash));
                            }
                        } else {
                            builder.append(host);
                        }
                    }
                } else if (firstSp > -1) {
                    host = s.substring(2, firstSp);
                    int colon = host.indexOf(":");
                    if (colon > -1) {
                        builder.append(host.substring(0, colon));
                        slash = host.indexOf("/", colon);
                        if (slash > -1) {
                            builder.append(host.substring(slash));
                        }
                    } else {
                        builder.append(host);
                    }
                }
                String share = builder.toString();
                String local = null;
                int volIndex = 0;
                if (firstSp > -1 && (volIndex = s.indexOf("/Volumes", firstSp)) > -1) {
                    int brackIndex = s.indexOf(" (", volIndex);
                    local = brackIndex > -1 ? s.substring(volIndex, brackIndex) : s.substring(volIndex).trim();
                }
                if (share == null || local == null) continue;
                this.localToShareMap.put(local, share);
            }
        }
    }

    private String toUNC(String path) {
        if (path == null || this.localToShareMap.size() == 0) {
            return path;
        }
        if (path.startsWith("///")) {
            if (SystemReporting.isMacOS() || SystemReporting.isLinux()) {
                path = path.substring(2);
            } else if (SystemReporting.isWindows()) {
                path = path.substring(3);
            }
        }
        for (String local : this.localToShareMap.keySet()) {
            if (!path.startsWith(local)) continue;
            return path.replaceFirst(local, this.localToShareMap.get(local)).replace('/', '\\');
        }
        return path;
    }
}

