/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.recognizer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ElanLocaleListener;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.SegmentsToTiersCommand;
import mpi.eudico.client.annotator.recognizer.api.AvailabilityDetector;
import mpi.eudico.client.annotator.recognizer.api.ParamPreferences;
import mpi.eudico.client.annotator.recognizer.api.Recognizer;
import mpi.eudico.client.annotator.recognizer.api.RecognizerHost;
import mpi.eudico.client.annotator.recognizer.api.SharedRecognizer;
import mpi.eudico.client.annotator.recognizer.data.Param;
import mpi.eudico.client.annotator.recognizer.data.RSelection;
import mpi.eudico.client.annotator.recognizer.data.Segment;
import mpi.eudico.client.annotator.recognizer.data.Segmentation;
import mpi.eudico.client.annotator.recognizer.gui.AbstractParamPanel;
import mpi.eudico.client.annotator.recognizer.gui.FileParamPanel;
import mpi.eudico.client.annotator.recognizer.gui.LoadOutputPane;
import mpi.eudico.client.annotator.recognizer.gui.ParamDialog;
import mpi.eudico.client.annotator.recognizer.gui.ParamPanelContainer;
import mpi.eudico.client.annotator.recognizer.gui.SegmentationPanel;
import mpi.eudico.client.annotator.recognizer.gui.SelectionPanel;
import mpi.eudico.client.annotator.recognizer.io.CsvTierIO;
import mpi.eudico.client.annotator.recognizer.io.CsvTimeSeriesIO;
import mpi.eudico.client.annotator.recognizer.io.ParamIO;
import mpi.eudico.client.annotator.recognizer.io.RecTierWriter;
import mpi.eudico.client.annotator.recognizer.io.XmlTierIO;
import mpi.eudico.client.annotator.recognizer.io.XmlTimeSeriesReader;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.ElanFileFilter;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.client.annotator.util.SystemReporting;
import mpi.eudico.client.util.CheckBoxBListCellRenderer;
import mpi.eudico.client.util.SelectEnableObject;
import mpi.eudico.client.util.SelectableObject;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRecognizerPanel
extends JComponent
implements ActionListener,
Runnable,
RecognizerHost,
ElanLocaleListener,
ItemListener {
    protected ViewerManager2 viewerManager;
    protected JPanel controlPanel;
    protected JPanel progressPanel;
    protected JPanel recognizerAndFilesPanel;
    protected JPanel paramPanel;
    protected JScrollPane jsp;
    protected JButton detachButton;
    protected ArrayList<String> mediaFilePaths;
    protected ArrayList<String> supportedFiles;
    protected SelectionPanel selectionPanel;
    protected SegmentationPanel segmentationPanel;
    protected JLabel recognizerLabel;
    protected JComboBox recognizerList;
    protected JPanel filesSelector;
    protected JLabel filesLabel;
    protected JComboBox filesList;
    protected HashMap<String, Recognizer> recognizers;
    protected Recognizer currentRecognizer;
    protected HashMap<String, Segmentation> segmentations;
    protected JProgressBar progressBar;
    protected JButton startStopButton;
    protected JButton reportButton;
    protected JPanel paramButtonPanel;
    protected JButton saveParamsButton;
    protected JButton loadParamsButton;
    protected boolean isRunning;
    protected int mode = 0;
    protected boolean notMono;
    protected boolean reduceFilePrompts = true;
    protected long lastStartTime = 0L;

    public AbstractRecognizerPanel(ViewerManager2 viewerManager, ArrayList<String> mediaFilePaths) {
        this.viewerManager = viewerManager;
        this.mediaFilePaths = mediaFilePaths;
        if (mediaFilePaths != null) {
            this.supportedFiles = new ArrayList(mediaFilePaths.size());
        } else {
            mediaFilePaths = new ArrayList(0);
            this.supportedFiles = new ArrayList(0);
        }
        this.segmentations = new HashMap();
        this.initComponents();
        this.initRecognizers();
    }

    protected void initComponents() {
        ImageIcon icon;
        this.setLayout(new GridBagLayout());
        this.recognizerLabel = new JLabel();
        this.recognizerList = new JComboBox();
        this.recognizerAndFilesPanel = new JPanel(new GridBagLayout());
        this.filesLabel = new JLabel();
        this.filesList = new JComboBox();
        for (int i = 0; i < this.mediaFilePaths.size(); ++i) {
            this.filesList.addItem(new SelectEnableObject(this.fileNameFromPath(this.mediaFilePaths.get(i)), true, true));
        }
        if (this.filesList.getItemCount() > 0) {
            this.filesList.setRenderer(new CheckBoxBListCellRenderer());
        } else {
            this.filesList.setRenderer(new JComboBox().getRenderer());
        }
        this.filesList.addActionListener(this);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 2, 0, 0);
        gbc.anchor = 17;
        this.recognizerAndFilesPanel.add((Component)this.recognizerLabel, gbc);
        gbc.gridx = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.recognizerAndFilesPanel.add((Component)this.recognizerList, gbc);
        gbc.gridx = 2;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        this.recognizerAndFilesPanel.add((Component)this.filesLabel, gbc);
        gbc.gridx = 3;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.recognizerAndFilesPanel.add((Component)this.filesList, gbc);
        this.selectionPanel = new SelectionPanel(this.mode, this.notMono, this.viewerManager);
        this.segmentationPanel = new SegmentationPanel(this, this.viewerManager);
        this.segmentationPanel.setEnabled(false);
        this.progressPanel = new JPanel();
        this.progressPanel.setLayout(new BoxLayout(this.progressPanel, 0));
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(true);
        this.progressPanel.add(Box.createHorizontalStrut(10));
        this.progressPanel.add(this.progressBar);
        this.progressPanel.add(Box.createHorizontalStrut(10));
        this.startStopButton = new JButton(ElanLocale.getString("Recognizer.RecognizerPanel.Start"));
        this.startStopButton.addActionListener(this);
        this.progressPanel.add(this.startStopButton);
        this.reportButton = new JButton();
        this.reportButton.addActionListener(this);
        this.reportButton.setEnabled(false);
        this.progressPanel.add(Box.createHorizontalStrut(15));
        this.progressPanel.add(this.reportButton);
        this.paramPanel = new JPanel(new GridBagLayout());
        this.paramButtonPanel = new JPanel(new GridBagLayout());
        this.saveParamsButton = new JButton();
        this.saveParamsButton.addActionListener(this);
        try {
            icon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/SaveAs16.gif"));
            this.saveParamsButton.setIcon(icon);
        }
        catch (Exception ex) {
            this.saveParamsButton.setText("S");
        }
        this.loadParamsButton = new JButton();
        this.loadParamsButton.addActionListener(this);
        try {
            ImageIcon openIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Open16.gif"));
            this.loadParamsButton.setIcon(openIcon);
        }
        catch (Exception ex) {
            this.loadParamsButton.setText("O");
        }
        gbc = new GridBagConstraints();
        gbc.anchor = 12;
        this.paramButtonPanel.add((Component)this.loadParamsButton, gbc);
        gbc.gridx = 1;
        gbc.insets = new Insets(0, 2, 0, 2);
        this.paramButtonPanel.add((Component)this.saveParamsButton, gbc);
        this.detachButton = new JButton();
        this.detachButton.addActionListener(this);
        try {
            icon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Detach.gif"));
            this.detachButton.setIcon(icon);
        }
        catch (Exception ex) {
            this.detachButton.setText("D");
        }
        gbc.gridx = 2;
        gbc.insets = new Insets(0, 10, 0, 2);
        this.paramButtonPanel.add((Component)this.detachButton, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        this.add((Component)this.recognizerAndFilesPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 3;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        this.add((Component)this.selectionPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.add((Component)this.segmentationPanel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this.paramPanel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.fill = 2;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.add((Component)this.progressPanel, gbc);
    }

    protected void initRecognizers() {
        this.recognizers = this.getAvailableRecognizers();
        if (this.currentRecognizer != null) {
            this.paramPanel.removeAll();
            this.currentRecognizer = null;
        }
        this.recognizerList.removeItemListener(this);
        this.recognizerList.removeAllItems();
        Set<String> names = this.recognizers.keySet();
        Iterator<String> iter = names.iterator();
        while (iter.hasNext()) {
            this.recognizerList.addItem(iter.next());
        }
        if (this.recognizerList.getItemCount() == 0) {
            this.recognizerList.addItem(ElanLocale.getString("Recognizer.RecognizerPanel.No.Recognizers"));
            this.jsp = new JScrollPane(this.getParamPanel(null));
            this.jsp.setBackground(this.getBackground());
            this.jsp.getViewport().setBackground(this.getBackground());
            this.jsp.getVerticalScrollBar().setUnitIncrement(20);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            this.paramPanel.add((Component)this.jsp, gbc);
            this.startStopButton.setEnabled(false);
            this.recognizerList.setEnabled(false);
            this.selectionPanel.setEnabled(false);
            this.segmentationPanel.setEnabled(false);
            this.paramButtonPanel.setVisible(false);
        } else {
            this.recognizerList.setSelectedIndex(0);
            this.setRecognizer((String)this.recognizerList.getSelectedItem());
            this.recognizerList.setEnabled(true);
            this.selectionPanel.setEnabled(true);
        }
        this.recognizerList.addItemListener(this);
    }

    protected abstract HashMap<String, Recognizer> getAvailableRecognizers();

    protected void setRecognizer(String name) {
        GridBagConstraints gbc;
        Object prefs;
        if (this.currentRecognizer != null) {
            if (this.controlPanel instanceof ParamPreferences && (prefs = ((ParamPreferences)((Object)this.controlPanel)).getParamPreferences()) != null) {
                Preferences.set(this.currentRecognizer.getName(), ((ParamPreferences)((Object)this.controlPanel)).getParamPreferences(), null);
            }
            this.currentRecognizer.dispose();
            this.paramPanel.removeAll();
            this.segmentations.clear();
            this.segmentationPanel.setEnabled(false);
            this.reportButton.setEnabled(false);
        }
        this.currentRecognizer = this.recognizers.get(name);
        this.currentRecognizer.setRecognizerHost(this);
        this.controlPanel = this.currentRecognizer.getControlPanel();
        if (this.controlPanel != null) {
            this.jsp = new JScrollPane(this.controlPanel);
            this.jsp.getVerticalScrollBar().setUnitIncrement(20);
            gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            this.paramPanel.add((Component)this.jsp, gbc);
            gbc.gridy = 1;
            gbc.anchor = 12;
            gbc.fill = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            this.paramPanel.add((Component)this.paramButtonPanel, gbc);
        } else {
            this.controlPanel = this.getParamPanel(this.currentRecognizer);
            if (this.controlPanel != null) {
                this.jsp = new JScrollPane(this.controlPanel);
                this.jsp.getVerticalScrollBar().setUnitIncrement(20);
                gbc = new GridBagConstraints();
                gbc.anchor = 18;
                gbc.fill = 1;
                gbc.gridy = 0;
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                this.paramPanel.add((Component)this.jsp, gbc);
                gbc.gridy = 1;
                gbc.anchor = 12;
                gbc.fill = 0;
                gbc.weightx = 0.0;
                gbc.weighty = 0.0;
                this.paramPanel.add((Component)this.paramButtonPanel, gbc);
            } else {
                this.jsp = null;
                this.paramPanel.add((Component)new JLabel(ElanLocale.getString("Recognizer.RecognizerPanel.No.Parameters")), new GridBagConstraints());
                this.paramPanel.repaint();
            }
        }
        if (this.controlPanel instanceof ParamPreferences) {
            prefs = Preferences.get(this.currentRecognizer.getName(), null);
            if (prefs instanceof Map) {
                ((ParamPreferences)((Object)this.controlPanel)).setParamPreferences((HashMap)prefs);
            }
            this.loadParamsButton.setEnabled(true);
            this.saveParamsButton.setEnabled(true);
        } else {
            this.loadParamsButton.setEnabled(false);
            this.saveParamsButton.setEnabled(false);
        }
        this.startStopButton.setEnabled(true);
        this.progressBar.setString("");
        this.progressBar.setValue(0);
        this.supportedFiles.clear();
        for (int i = 0; i < this.mediaFilePaths.size(); ++i) {
            String fp = this.mediaFilePaths.get(i);
            SelectEnableObject seo = (SelectEnableObject)this.filesList.getItemAt(i);
            if (this.currentRecognizer.canHandleMedia(fp)) {
                this.supportedFiles.add(fp);
                seo.setEnabled(true);
                seo.setSelected(true);
                continue;
            }
            seo.setEnabled(false);
            seo.setSelected(false);
        }
        this.updateSelectionPanel();
        this.startStopButton.setEnabled(this.supportedFiles.size() > 0);
        if (this.currentRecognizer.getExamplesSupport() == 2) {
            this.selectionPanel.setEnabled(false);
            this.selectionPanel.clearSelections();
        } else {
            this.selectionPanel.setEnabled(true);
        }
        this.validate();
    }

    protected JPanel getParamPanel(Recognizer recognizer) {
        List<Param> params;
        if (recognizer != null && (params = AvailabilityDetector.getParamList(recognizer.getName())) != null) {
            ParamPanelContainer ppc = new ParamPanelContainer(recognizer.getName(), params);
            ppc.validate();
            return ppc;
        }
        return null;
    }

    protected void updateFileList() {
        this.filesList.removeAllItems();
        for (int i = 0; i < this.mediaFilePaths.size(); ++i) {
            this.filesList.addItem(new SelectEnableObject(this.fileNameFromPath(this.mediaFilePaths.get(i)), true, true));
        }
        if (this.filesList.getItemCount() < 1) {
            JComboBox temp = new JComboBox();
            this.filesList.setRenderer(temp.getRenderer());
        } else if (!(this.filesList.getRenderer() instanceof CheckBoxBListCellRenderer)) {
            this.filesList.setRenderer(new CheckBoxBListCellRenderer());
        }
    }

    String fileNameFromPath(String path) {
        if (path == null) {
            return "Unknown";
        }
        int index = path.lastIndexOf(47);
        if (index > -1 && index < path.length() - 1) {
            return path.substring(index + 1);
        }
        return path;
    }

    List<String> getCurrentFileSelection() {
        ArrayList<String> curFiles = new ArrayList<String>(4);
        for (int i = 0; i < this.filesList.getModel().getSize(); ++i) {
            SelectEnableObject seo;
            Object iter = this.filesList.getModel().getElementAt(i);
            if (!(iter instanceof SelectEnableObject) || !(seo = (SelectEnableObject)iter).isSelected()) continue;
            if (SystemReporting.isWindows()) {
                String path = this.mediaFilePaths.get(i);
                if (path.startsWith("///")) {
                    path = path.substring(3);
                }
                path = path.replace('/', '\\');
                curFiles.add(path);
                continue;
            }
            curFiles.add(this.mediaFilePaths.get(i));
        }
        return curFiles;
    }

    private void updateSelectionPanel() {
        if (this.mode == 1) {
            this.selectionPanel.setMediaFilePaths(this.getCurrentFileSelection());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.recognizerList && e.getStateChange() == 1) {
            if (this.currentRecognizer != null && this.isBusy()) {
                JOptionPane.showMessageDialog(this, this.currentRecognizer.getName() + ": " + ElanLocale.getString("Recognizer.RecognizerPanel.Warning.Busy"), this.currentRecognizer.getName() + " " + ElanLocale.getString("Recognizer.RecognizerPanel.Warning.Busy2"), -1);
                this.recognizerList.setSelectedItem(this.currentRecognizer.getName());
                return;
            }
            this.segmentations.clear();
            this.paramPanel.removeAll();
            this.setRecognizer((String)this.recognizerList.getSelectedItem());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source.equals(this.startStopButton)) {
            if (this.currentRecognizer == null) {
                return;
            }
            if (this.isRunning) {
                this.startStopButton.setText(ElanLocale.getString("Recognizer.RecognizerPanel.Start"));
                this.currentRecognizer.stop();
                this.isRunning = false;
                if (this.progressBar.isIndeterminate()) {
                    this.progressBar.setIndeterminate(false);
                }
                this.progressBar.setString(ElanLocale.getString("Recognizer.RecognizerPanel.Canceled"));
                this.reportButton.setEnabled(true);
            } else {
                this.startRecognizer();
            }
        } else if (source == this.filesList) {
            SelectEnableObject seo;
            Object item = this.filesList.getSelectedItem();
            if (item instanceof SelectEnableObject && (seo = (SelectEnableObject)item).isEnabled()) {
                boolean old = ((SelectableObject)item).isSelected();
                ((SelectableObject)item).setSelected(!old);
            }
            int numsel = 0;
            for (int i = 0; i < this.filesList.getModel().getSize(); ++i) {
                Object iter = this.filesList.getModel().getElementAt(i);
                if (!(iter instanceof SelectEnableObject) || !(seo = (SelectEnableObject)iter).isSelected()) continue;
                this.filesList.setSelectedIndex(i);
                ++numsel;
                break;
            }
            this.startStopButton.setEnabled(numsel > 0);
            this.updateSelectionPanel();
        } else if (source == this.reportButton) {
            if (this.currentRecognizer != null) {
                this.showReport(this.currentRecognizer.getReport());
            }
        } else if (source == this.saveParamsButton) {
            this.saveParameterFile();
        } else if (source == this.loadParamsButton) {
            this.loadParameterFile();
        } else if (source == this.detachButton) {
            this.detachParamPanel();
        }
    }

    protected void startRecognizer() {
        Map<String, Object> prefs;
        if (this.isRunning) {
            return;
        }
        List<String> selMediaFiles = this.getCurrentFileSelection();
        if (this.currentRecognizer.getExamplesSupport() == 1 || this.currentRecognizer.getExamplesSupport() == 0) {
            int i;
            boolean selectionsExist = this.selectionPanel.hasSelections();
            ArrayList<FileParamPanel> ffps = new ArrayList<FileParamPanel>(4);
            if (this.controlPanel instanceof ParamPanelContainer) {
                ParamPanelContainer ppc = (ParamPanelContainer)this.controlPanel;
                int numPanels = ppc.getNumPanels();
                for (i = 0; i < numPanels; ++i) {
                    FileParamPanel fpp;
                    AbstractParamPanel app = ppc.getParamPanel(i);
                    if (!(app instanceof FileParamPanel) || !(fpp = (FileParamPanel)app).isInputType() || fpp.getContentType() != 2 && fpp.getContentType() != 3) continue;
                    ffps.add(fpp);
                }
            }
            int numNotFilled = 0;
            boolean[] filled = new boolean[ffps.size()];
            int count = 0;
            for (FileParamPanel panel : ffps) {
                Object filePath = panel.getParamValue();
                if (filePath instanceof String) {
                    if (((String)filePath).length() == 0) {
                        ++numNotFilled;
                        filled[count] = false;
                    } else {
                        filled[count] = true;
                    }
                } else {
                    ++numNotFilled;
                    filled[count] = false;
                }
                ++count;
            }
            if (!selectionsExist || !ffps.isEmpty()) {
                if (selectionsExist) {
                    if (numNotFilled == 1) {
                        FileParamPanel targetFfp = null;
                        for (i = 0; i < filled.length; ++i) {
                            if (filled[i]) continue;
                            targetFfp = (FileParamPanel)ffps.get(i);
                            break;
                        }
                        if (targetFfp != null) {
                            int contentType = targetFfp.getContentType();
                            String filepath = null;
                            filepath = this.reduceFilePrompts ? this.autoCreateOutputFile(this.mediaFilePaths, targetFfp.getParamName(), contentType) : this.promptForTierFile(contentType, (String)targetFfp.getParamValue());
                            if (filepath == null) {
                                return;
                            }
                            File tf = new File(filepath);
                            try {
                                int answer;
                                if (tf.exists() && !this.reduceFilePrompts && (answer = JOptionPane.showConfirmDialog(this, ElanLocale.getString("Message.Overwrite"), ElanLocale.getString("SaveDialog.Message.Title"), 0, 2)) != 0) {
                                    return;
                                }
                            }
                            catch (Exception ex) {
                                return;
                            }
                            targetFfp.setParamValue(filepath);
                            try {
                                this.writeTierFile(filepath, contentType);
                            }
                            catch (IOException ioe) {
                                JOptionPane.showMessageDialog(this, ElanLocale.getString("Recognizer.RecognizerPanel.Warning.SaveFailed") + ioe.getMessage(), ElanLocale.getString("Message.Warning"), 0);
                                return;
                            }
                        }
                    } else {
                        int i2;
                        ArrayList<String> paramList = new ArrayList<String>(ffps.size());
                        FileParamPanel targetFfp = null;
                        for (i2 = 0; i2 < filled.length; ++i2) {
                            if (filled[i2]) continue;
                            targetFfp = (FileParamPanel)ffps.get(i2);
                            paramList.add(targetFfp.paramName);
                        }
                        for (i2 = 0; i2 < filled.length; ++i2) {
                            if (!filled[i2]) continue;
                            targetFfp = (FileParamPanel)ffps.get(i2);
                            paramList.add(targetFfp.paramName);
                        }
                        targetFfp = null;
                        Object[] options = paramList.toArray(new String[0]);
                        Object selected = JOptionPane.showInputDialog(this, ElanLocale.getString("Recognizer.SelectionsPanel.SaveSelections") + "\n" + ElanLocale.getString("Recognizer.SelectionsPanel.SaveSelections2"), ElanLocale.getString("Recognizer.SelectionsPanel.Title"), -1, null, options, options[0]);
                        if (selected != null) {
                            for (FileParamPanel fp : ffps) {
                                if (!fp.paramName.equals(selected)) continue;
                                targetFfp = fp;
                                break;
                            }
                            int contentType = targetFfp.getContentType();
                            String filepath = null;
                            filepath = this.reduceFilePrompts ? this.autoCreateOutputFile(this.mediaFilePaths, targetFfp.getParamName(), contentType) : this.promptForTierFile(contentType, (String)targetFfp.getParamValue());
                            if (filepath == null) {
                                return;
                            }
                            File tf = new File(filepath);
                            try {
                                int answer;
                                if (tf.exists() && !this.reduceFilePrompts && (answer = JOptionPane.showConfirmDialog(this, ElanLocale.getString("Message.Overwrite"), ElanLocale.getString("SaveDialog.Message.Title"), 0, 2)) != 0) {
                                    return;
                                }
                            }
                            catch (Exception ex) {
                                return;
                            }
                            targetFfp.setParamValue(filepath);
                            try {
                                this.writeTierFile(filepath, contentType);
                            }
                            catch (IOException ioe) {
                                JOptionPane.showMessageDialog(this, ElanLocale.getString("Recognizer.RecognizerPanel.Warning.SaveFailed") + ioe.getMessage(), ElanLocale.getString("Message.Warning"), 0);
                                return;
                            }
                        }
                    }
                } else if (!selectionsExist) {
                    if (this.currentRecognizer.getExamplesSupport() == 1 && !ffps.isEmpty() && numNotFilled > 0) {
                        JOptionPane.showMessageDialog(this, ElanLocale.getString("Recognizer.RecognizerPanel.Warning.Selection3"), this.currentRecognizer.getName(), -1);
                        return;
                    }
                    if (this.currentRecognizer.getExamplesSupport() == 1 && ffps.isEmpty()) {
                        JOptionPane.showMessageDialog(this, ElanLocale.getString("Recognizer.RecognizerPanel.Warning.Selection"), this.currentRecognizer.getName() + " " + ElanLocale.getString("Recognizer.RecognizerPanel.Warning.Selection2"), -1);
                        return;
                    }
                }
            }
        }
        if (this.controlPanel instanceof ParamPanelContainer) {
            ParamPanelContainer ppc = (ParamPanelContainer)this.controlPanel;
            int numPanels = ppc.getNumPanels();
            for (int i = 0; i < numPanels; ++i) {
                AbstractParamPanel app = ppc.getParamPanel(i);
                if (!(app instanceof FileParamPanel) || ((FileParamPanel)app).isInputType() || ((FileParamPanel)app).isOptional()) continue;
                String val = (String)((FileParamPanel)app).getParamValue();
                if (val == null || val.length() == 0) {
                    String filePath;
                    if (this.reduceFilePrompts && (filePath = this.autoCreateOutputFile(this.mediaFilePaths, ((FileParamPanel)app).getParamName(), ((FileParamPanel)app).getContentType())) != null) {
                        ((FileParamPanel)app).setParamValue(filePath);
                        val = filePath;
                    }
                    if (val != null && val.length() != 0) continue;
                    JOptionPane.showMessageDialog(this, ElanLocale.getString("Recognizer.RecognizerPanel.Warning.EmptyParam") + " \"" + app.description + "\" " + ElanLocale.getString("Recognizer.RecognizerPanel.Warning.EmptyParam2"), ElanLocale.getString("Recognizer.RecognizerPanel.Warning.EmptyParam"), 0);
                    return;
                }
                this.createOutputFile(val);
            }
        }
        this.progressBar.setValue(0);
        this.progressBar.setString("");
        if (this.controlPanel instanceof ParamPanelContainer) {
            ParamPanelContainer ppc = (ParamPanelContainer)this.controlPanel;
            int numPanels = ppc.getNumPanels();
            for (int i = 0; i < numPanels; ++i) {
                AbstractParamPanel app = ppc.getParamPanel(i);
                Object value = app.getParamValue();
                if (value instanceof Float) {
                    this.currentRecognizer.setParameterValue(app.paramName, ((Float)value).floatValue());
                }
                if (value instanceof Double) {
                    this.currentRecognizer.setParameterValue(app.paramName, ((Double)value).floatValue());
                    continue;
                }
                if (!(value instanceof String)) continue;
                this.currentRecognizer.setParameterValue(app.paramName, (String)value);
            }
        }
        if (this.controlPanel instanceof ParamPreferences && (prefs = ((ParamPreferences)((Object)this.controlPanel)).getParamPreferences()) != null) {
            Preferences.set(this.currentRecognizer.getName(), ((ParamPreferences)((Object)this.controlPanel)).getParamPreferences(), null);
        }
        this.segmentations.clear();
        this.currentRecognizer.setMedia(selMediaFiles);
        this.startStopButton.setText(ElanLocale.getString("Button.Cancel"));
        this.reportButton.setEnabled(false);
        this.isRunning = true;
        this.progressBar.setString(ElanLocale.getString("Recognizer.RecognizerPanel.Recognizing"));
        new Thread(this).start();
    }

    private String promptForTierFile(int contentType, String startingPoint) {
        String prefPath = null;
        if (startingPoint != null && startingPoint.length() > 0) {
            prefPath = startingPoint;
        } else {
            Object val = Preferences.get("Recognizer.Path", null);
            if (val instanceof String) {
                prefPath = (String)val;
            }
        }
        JFileChooser chooser = null;
        chooser = prefPath != null ? new JFileChooser(prefPath) : new JFileChooser();
        FileFilter ff = null;
        ff = contentType == 3 ? ElanFileFilter.createFileFilter(20) : ElanFileFilter.createFileFilter(23);
        chooser.addChoosableFileFilter(ff);
        chooser.setFileFilter(ff);
        if (chooser.showSaveDialog(this) == 0) {
            File f = chooser.getSelectedFile();
            File par = f.getParentFile();
            if (par != null && par.isDirectory()) {
                Preferences.set("Recognizer.Path", par.getAbsolutePath(), null);
            }
            if (contentType == 3) {
                String lower = f.getAbsolutePath().toLowerCase();
                boolean valid = false;
                for (int i = 0; i < FileExtension.CSV_EXT.length; ++i) {
                    if (!lower.endsWith(FileExtension.CSV_EXT[i])) continue;
                    valid = true;
                    break;
                }
                if (!valid) {
                    f = new File(f.getAbsolutePath() + "." + FileExtension.CSV_EXT[0]);
                }
            } else if (!f.getAbsolutePath().toLowerCase().endsWith("xml")) {
                f = new File(f.getAbsolutePath() + ".xml");
            }
            return f.getAbsolutePath();
        }
        return null;
    }

    private String autoCreateOutputFile(List<String> mediaFiles, String paramName, int contentType) {
        if (mediaFiles != null && mediaFiles.size() > 0) {
            int index;
            String firstMed = mediaFiles.get(0);
            int dirIndex = firstMed.lastIndexOf(File.separator);
            StringBuilder dirPath = null;
            dirPath = dirIndex > -1 && dirIndex < firstMed.length() - 1 ? new StringBuilder(firstMed.substring(0, dirIndex + 1)) : ((index = firstMed.lastIndexOf(46)) > -1 && index < firstMed.length() - 1 ? new StringBuilder(firstMed.substring(0, index + 1)) : new StringBuilder(firstMed));
            if (dirPath != null) {
                dirPath.append(paramName.replace(' ', '_'));
                if (contentType == 3 || contentType == 5) {
                    dirPath.append(".csv");
                } else if (contentType == 2 || contentType == 4) {
                    dirPath.append(".xml");
                }
                try {
                    File out = new File(dirPath.toString());
                    if (!out.exists()) {
                        out.createNewFile();
                        if (this.currentRecognizer instanceof SharedRecognizer) {
                            try {
                                this.changeFileAccess(out);
                            }
                            catch (Exception ex) {
                                ClientLogger.LOG.warning("Cannot change the file permissions: " + ex.getMessage());
                            }
                        }
                    }
                }
                catch (IOException ioe) {
                    ClientLogger.LOG.warning("Cannot create the file: " + ioe.getMessage());
                }
                catch (SecurityException se) {
                    ClientLogger.LOG.warning("Cannot create the file: " + se.getMessage());
                }
                return dirPath.toString();
            }
        }
        return null;
    }

    private void createOutputFile(String path) {
        if (path == null) {
            return;
        }
        try {
            File out = new File(path);
            if (!out.exists()) {
                out.createNewFile();
                if (this.currentRecognizer instanceof SharedRecognizer) {
                    try {
                        this.changeFileAccess(out);
                    }
                    catch (Exception ex) {
                        ClientLogger.LOG.warning("Cannot change the file permissions: " + ex.getMessage());
                    }
                }
            }
        }
        catch (IOException ioe) {
            ClientLogger.LOG.warning("Cannot create the file: " + ioe.getMessage());
        }
        catch (SecurityException se) {
            ClientLogger.LOG.warning("Cannot create the file: " + se.getMessage());
        }
    }

    private void changeFileAccess(File f) {
        if (f == null) {
            return;
        }
        ArrayList<String> coms = new ArrayList<String>(5);
        if (SystemReporting.isWindows()) {
            coms.add("CACLS");
            coms.add("\"" + f.getAbsolutePath() + "\"");
            coms.add("/E");
            coms.add("/G");
            coms.add("Everyone:f");
        } else {
            coms.add("chmod");
            coms.add("a+rwx");
            coms.add("\"" + f.getAbsolutePath() + "\"");
        }
        ProcessBuilder pb = new ProcessBuilder(coms);
        pb.redirectErrorStream(true);
        try {
            Process proc = pb.start();
            int exit = proc.exitValue();
            if (exit != 0) {
                ClientLogger.LOG.warning("Could not set the file access attributes via using native tool, error: " + exit);
            }
        }
        catch (IOException ioe) {
            ClientLogger.LOG.warning("Cannot set the file access attributes via native tool");
        }
    }

    private void checkOutput() {
        if (this.isRunning) {
            return;
        }
        boolean loadTS = false;
        boolean loadTiers = false;
        boolean tsAvailable = false;
        boolean tierFileAvailable = false;
        if (this.controlPanel instanceof ParamPanelContainer) {
            File f3;
            Object file;
            ArrayList<File> csvFiles;
            LoadOutputPane lop;
            int option;
            Object pref;
            boolean tiersAvailable;
            FileParamPanel fpp;
            AbstractParamPanel app;
            ParamPanelContainer ppc = (ParamPanelContainer)this.controlPanel;
            int numPanels = ppc.getNumPanels();
            for (int i = 0; i < numPanels; ++i) {
                File f2;
                Object file2;
                app = ppc.getParamPanel(i);
                if (!(app instanceof FileParamPanel)) continue;
                fpp = (FileParamPanel)app;
                if (!(fpp.isInputType() || fpp.getContentType() != 5 && fpp.getContentType() != 4)) {
                    file2 = fpp.getParamValue();
                    if (!(file2 instanceof String) || !(f2 = new File((String)file2)).exists() || !f2.canRead() || f2.lastModified() <= this.lastStartTime) continue;
                    tsAvailable = true;
                    continue;
                }
                if (fpp.isInputType() || fpp.getContentType() != 2 && fpp.getContentType() != 3 || !((file2 = fpp.getParamValue()) instanceof String) || !(f2 = new File((String)file2)).exists() || !f2.canRead() || f2.lastModified() <= this.lastStartTime) continue;
                tierFileAvailable = true;
            }
            boolean bl = tiersAvailable = this.segmentations.size() > 0;
            if (!(tiersAvailable || tsAvailable || tierFileAvailable)) {
                return;
            }
            ArrayList<SelectableObject> resources = new ArrayList<SelectableObject>(4);
            if (tiersAvailable || tierFileAvailable) {
                boolean sel = true;
                pref = Preferences.get("Recognizer.RecognizerPanel.Tiers", null);
                if (pref instanceof Boolean) {
                    sel = (Boolean)pref;
                }
                resources.add(new SelectableObject(ElanLocale.getString("Recognizer.RecognizerPanel.Tiers"), sel));
            }
            if (tsAvailable) {
                boolean sel = true;
                pref = Preferences.get("Recognizer.RecognizerPanel.TimeSeries", null);
                if (pref instanceof Boolean) {
                    sel = (Boolean)pref;
                }
                resources.add(new SelectableObject(ElanLocale.getString("Recognizer.RecognizerPanel.TimeSeries"), sel));
            }
            if ((option = JOptionPane.showConfirmDialog(this, lop = new LoadOutputPane(resources), "", 0, 3)) != 0) {
                return;
            }
            for (int i = 0; i < resources.size(); ++i) {
                SelectableObject selObj = (SelectableObject)resources.get(i);
                if (selObj.getValue().equals(ElanLocale.getString("Recognizer.RecognizerPanel.Tiers"))) {
                    loadTiers = selObj.isSelected();
                    Preferences.set("Recognizer.RecognizerPanel.Tiers", new Boolean(loadTiers), null, false, false);
                    continue;
                }
                if (!selObj.getValue().equals(ElanLocale.getString("Recognizer.RecognizerPanel.TimeSeries"))) continue;
                loadTS = selObj.isSelected();
                Preferences.set("Recognizer.RecognizerPanel.TimeSeries", new Boolean(loadTS), null, false, false);
            }
            if (loadTiers) {
                if (tierFileAvailable && !tiersAvailable) {
                    List<Segmentation> segm;
                    csvFiles = new ArrayList(4);
                    ArrayList<File> xmlFiles = new ArrayList<File>(4);
                    for (int i = 0; i < numPanels; ++i) {
                        app = ppc.getParamPanel(i);
                        if (!(app instanceof FileParamPanel) || (fpp = (FileParamPanel)app).isInputType() || fpp.getContentType() != 3 && fpp.getContentType() != 2 || !((file = fpp.getParamValue()) instanceof String) || !(f3 = new File((String)file)).exists() || !f3.canRead() || f3.lastModified() <= this.lastStartTime) continue;
                        if (fpp.getContentType() == 3) {
                            csvFiles.add(f3);
                            continue;
                        }
                        xmlFiles.add(f3);
                    }
                    for (File csvFile : csvFiles) {
                        CsvTierIO cio;
                        if (!csvFile.exists() || !csvFile.canRead() || csvFile.lastModified() <= this.lastStartTime || (segm = (cio = new CsvTierIO()).read(csvFile)) == null || segm.size() <= 0) continue;
                        for (Segmentation s : segm) {
                            this.addSegmentation(s);
                        }
                    }
                    for (File xmlFile : xmlFiles) {
                        XmlTierIO xio;
                        if (!xmlFile.exists() || !xmlFile.canRead() || xmlFile.lastModified() <= this.lastStartTime || (segm = (xio = new XmlTierIO(xmlFile)).parse()) == null || segm.size() <= 0) continue;
                        for (Segmentation s : segm) {
                            this.addSegmentation(s);
                        }
                    }
                }
                HashMap segmentationMap = new HashMap();
                ArrayList<RSelection> segments = null;
                ArrayList<AnnotationDataRecord> records = null;
                ArrayList<Segmentation> segs = this.getSegmentations();
                for (int i = 0; i < segs.size(); ++i) {
                    Segmentation seg = segs.get(i);
                    if (seg == null) continue;
                    segments = seg.getSegments();
                    records = new ArrayList<AnnotationDataRecord>();
                    for (int j = 0; j < segments.size(); ++j) {
                        Segment segment = (Segment)segments.get(j);
                        records.add(new AnnotationDataRecord("", segment.label, segment.beginTime, segment.endTime));
                    }
                    segmentationMap.put(seg.getName(), records);
                }
                SegmentsToTiersCommand com = (SegmentsToTiersCommand)ELANCommandFactory.createCommand(this.viewerManager.getTranscription(), "CommandActions.SegmentsToTiers");
                com.execute(this.viewerManager.getTranscription(), new Object[]{segmentationMap});
            }
            if (loadTS) {
                List<Object> result;
                csvFiles = new ArrayList<File>(4);
                ArrayList<File> xmlFiles = new ArrayList<File>(4);
                for (int i = 0; i < numPanels; ++i) {
                    app = ppc.getParamPanel(i);
                    if (!(app instanceof FileParamPanel) || (fpp = (FileParamPanel)app).isInputType() || fpp.getContentType() != 5 && fpp.getContentType() != 4 || !((file = fpp.getParamValue()) instanceof String) || !(f3 = new File((String)file)).exists() || !f3.canRead() || f3.lastModified() <= this.lastStartTime) continue;
                    if (fpp.getContentType() == 5) {
                        csvFiles.add(f3);
                        continue;
                    }
                    xmlFiles.add(f3);
                }
                ArrayList<Object> tracks = new ArrayList<Object>(10);
                for (File f3 : csvFiles) {
                    CsvTimeSeriesIO csvIO = new CsvTimeSeriesIO(f3);
                    result = csvIO.getAllTracks();
                    if (result == null) continue;
                    tracks.addAll(result);
                }
                for (File f3 : xmlFiles) {
                    XmlTimeSeriesReader xmlIO = new XmlTimeSeriesReader(f3);
                    try {
                        result = xmlIO.parse();
                        if (result == null) continue;
                        tracks.addAll(result);
                    }
                    catch (IOException ioe) {
                        JOptionPane.showMessageDialog(this, ElanLocale.getString("Recognizer.RecognizerPanel.Warning.LoadFailed") + "\n" + ioe.getMessage(), ElanLocale.getString("Message.Error"), 0);
                    }
                    catch (SAXException sax) {
                        JOptionPane.showMessageDialog(this, ElanLocale.getString("Recognizer.RecognizerPanel.Warning.LoadFailed") + "\n" + sax.getMessage(), ElanLocale.getString("Message.Error"), 0);
                    }
                }
                Command com = ELANCommandFactory.createCommand(this.viewerManager.getTranscription(), "AddTSTrackAndPanel");
                com.execute(this.viewerManager, new Object[]{tracks});
            }
        }
    }

    @Override
    public void run() {
        if (this.currentRecognizer != null) {
            this.currentRecognizer.start();
            this.lastStartTime = System.currentTimeMillis();
        }
    }

    public void stopRecognizers() {
        if (this.currentRecognizer != null) {
            this.currentRecognizer.stop();
            this.isRunning = false;
        }
    }

    @Override
    public boolean isBusy() {
        return this.isRunning;
    }

    @Override
    public void updateLocale() {
        this.selectionPanel.updateLocale();
        this.segmentationPanel.updateLocale();
        if (this.currentRecognizer != null) {
            this.currentRecognizer.updateLocale(ElanLocale.getLocale());
        }
        this.startStopButton.setText(ElanLocale.getString("Recognizer.RecognizerPanel.Start"));
        this.reportButton.setText(ElanLocale.getString("Recognizer.RecognizerPanel.Report"));
        this.recognizerLabel.setText(ElanLocale.getString("Recognizer.RecognizerPanel.Recognizer"));
        this.filesLabel.setText(ElanLocale.getString("Recognizer.RecognizerPanel.Files"));
        this.progressPanel.setBorder(new TitledBorder(ElanLocale.getString("Recognizer.RecognizerPanel.Progress")));
        this.paramPanel.setBorder(new TitledBorder(ElanLocale.getString("Recognizer.RecognizerPanel.Parameters")));
        this.detachButton.setToolTipText(ElanLocale.getString("Detachable.detach"));
        this.saveParamsButton.setToolTipText(ElanLocale.getString("Recognizer.RecognizerPanel.SaveParameters"));
        this.loadParamsButton.setToolTipText(ElanLocale.getString("Recognizer.RecognizerPanel.LoadParameters"));
    }

    @Override
    public void addSegmentation(Segmentation segmentation) {
        this.segmentations.put(segmentation.getName(), segmentation);
        this.segmentationPanel.setEnabled(true);
    }

    @Override
    public ArrayList<Segmentation> getSegmentations() {
        return new ArrayList<Segmentation>(this.segmentations.values());
    }

    @Override
    public void setProgress(float progress) {
        if (progress < 0.0f) {
            if (!this.progressBar.isIndeterminate()) {
                this.progressBar.setIndeterminate(true);
            }
        } else {
            if (this.progressBar.isIndeterminate()) {
                this.progressBar.setIndeterminate(false);
            }
            this.progressBar.setValue((int)(100.0f * progress));
            if (progress >= 1.0f) {
                this.progressBar.setString(ElanLocale.getString("Recognizer.RecognizerPanel.Ready"));
                this.startStopButton.setText(ElanLocale.getString("Recognizer.RecognizerPanel.Start"));
                this.isRunning = false;
                this.reportButton.setEnabled(true);
                this.checkOutput();
            }
        }
    }

    @Override
    public void setProgress(float progress, String message) {
        this.setProgress(progress);
        if (this.isRunning) {
            if (message != null) {
                this.progressBar.setString(message);
            } else {
                this.progressBar.setString("");
            }
        }
    }

    @Override
    public ArrayList<RSelection> getSelections() {
        return this.selectionPanel.getSelections();
    }

    @Override
    public void errorOccurred(String message) {
        JOptionPane.showMessageDialog(this, ElanLocale.getString("Recognizer.RecognizerPanel.Error") + "\n" + message, ElanLocale.getString("Message.Error"), 0);
        if (this.isRunning) {
            this.currentRecognizer.stop();
        }
        this.setProgress(1.0f);
    }

    public void attachParamPanel(JComponent paramComp) {
        if (paramComp == this.jsp) {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            this.paramPanel.add((Component)this.jsp, gbc);
            this.paramButtonPanel.setVisible(true);
        }
    }

    public void detachParamPanel() {
        this.paramPanel.remove(this.jsp);
        this.paramPanel.repaint();
        this.paramButtonPanel.setVisible(false);
        ParamDialog dialog = new ParamDialog(ELANCommandFactory.getRootFrame(this.viewerManager.getTranscription()), this, this.jsp);
        dialog.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle curRect = dialog.getBounds();
        dialog.setBounds(screen.width / 2, 10, Math.min(screen.width / 2 - 20, curRect.width + 30), Math.min(screen.height - 30, curRect.height));
        dialog.setVisible(true);
    }

    protected void loadParameterFile() {
        File selFile;
        if (this.currentRecognizer == null || this.controlPanel == null || !(this.controlPanel instanceof ParamPreferences)) {
            return;
        }
        String prefPath = null;
        Object val = Preferences.get("Recognizer.Path", null);
        if (val instanceof String) {
            prefPath = (String)val;
        }
        JFileChooser chooser = null;
        chooser = prefPath != null ? new JFileChooser(prefPath) : new JFileChooser();
        FileFilter ff = ElanFileFilter.createFileFilter(23);
        chooser.addChoosableFileFilter(ff);
        chooser.setFileFilter(ff);
        if (chooser.showOpenDialog(this) == 0 && (selFile = chooser.getSelectedFile()) != null && selFile.exists() && selFile.canRead()) {
            try {
                ParamIO pio = new ParamIO();
                Map<String, Object> parMap = pio.read(selFile);
                ((ParamPreferences)((Object)this.controlPanel)).setParamPreferences(parMap);
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("Recognizer.RecognizerPanel.Warning.LoadFailed") + ioe.getMessage(), ElanLocale.getString("Message.Warning"), 0);
            }
        }
    }

    protected void saveParameterFile() {
        if (this.currentRecognizer == null || this.controlPanel == null || !(this.controlPanel instanceof ParamPreferences)) {
            return;
        }
        String prefPath = null;
        Object val = Preferences.get("Recognizer.Path", null);
        if (val instanceof String) {
            prefPath = (String)val;
        }
        JFileChooser chooser = null;
        chooser = prefPath != null ? new JFileChooser(prefPath) : new JFileChooser();
        FileFilter ff = ElanFileFilter.createFileFilter(23);
        chooser.addChoosableFileFilter(ff);
        chooser.setFileFilter(ff);
        if (chooser.showSaveDialog(this) == 0) {
            File f = chooser.getSelectedFile();
            File par = f.getParentFile();
            if (par != null && par.isDirectory()) {
                Preferences.set("Recognizer.Path", par.getAbsolutePath(), null);
            }
            if (!f.getAbsolutePath().toLowerCase().endsWith("xml")) {
                f = new File(f.getAbsolutePath() + ".xml");
            }
            ParamIO pio = new ParamIO();
            Map<String, Object> paramMap = ((ParamPreferences)((Object)this.controlPanel)).getParamPreferences();
            try {
                pio.write(paramMap, f);
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("Recognizer.RecognizerPanel.Warning.SaveFailed") + ioe.getMessage(), ElanLocale.getString("Message.Warning"), 0);
            }
        }
    }

    protected void writeTierFile(String filepath, int contentType) throws IOException {
        RecTierWriter xTierWriter = new RecTierWriter();
        File f = new File(filepath);
        xTierWriter.write(f, this.selectionPanel.getTiersAndSelections(), true);
    }

    protected void showReport(String report) {
        if (report != null) {
            JDialog rD = new JDialog((Frame)ELANCommandFactory.getRootFrame(this.viewerManager.getTranscription()), true);
            JTextArea ta = new JTextArea(report);
            ta.setLineWrap(true);
            ta.setWrapStyleWord(true);
            ta.setEditable(false);
            rD.getContentPane().setLayout(new BorderLayout());
            rD.getContentPane().add((Component)new JScrollPane(ta), "Center");
            rD.pack();
            rD.setSize(Math.max(rD.getWidth(), 400), Math.max(rD.getHeight(), 300));
            rD.setSize(Math.min(rD.getWidth(), 800), Math.min(rD.getHeight(), 600));
            rD.setLocationRelativeTo(this);
            rD.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("Recognizer.RecognizerPanel.No.Report"), ElanLocale.getString("Message.Warning"), 1);
        }
    }

    protected void finalize() throws Throwable {
        if (this.currentRecognizer != null) {
            if (this.isRunning) {
                this.currentRecognizer.stop();
                this.currentRecognizer.dispose();
            }
            this.currentRecognizer = null;
        }
        super.finalize();
    }
}

