/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.recognizer.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import mpi.eudico.client.annotator.recognizer.data.FileParam;
import mpi.eudico.client.annotator.recognizer.gui.AbstractParamPanel;
import mpi.eudico.client.annotator.util.ElanFileFilter;

public class FileParamPanel
extends AbstractParamPanel
implements ActionListener {
    private boolean inputType;
    private int contentType;
    private boolean optional;
    private String initialPath;
    private JTextField fileField;
    private JButton browseButton;

    public FileParamPanel(String paramName, String description, boolean inputType, int contentType, boolean optional) {
        super(paramName, description);
        this.inputType = inputType;
        this.contentType = contentType;
        this.optional = optional;
        this.initComponents();
    }

    public FileParamPanel(FileParam param) {
        super(param);
        if (param != null) {
            this.inputType = param.ioType == 'i';
            this.optional = param.optional;
            this.contentType = param.contentType;
            this.initComponents();
        }
    }

    protected void initComponents() {
        super.initComponents();
        ImageIcon icon = null;
        try {
            icon = this.inputType ? new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Open16.gif")) : new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Save16.gif"));
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.fileField = new JTextField();
        this.fileField.setEditable(true);
        this.browseButton = new JButton();
        if (icon != null) {
            this.browseButton.setIcon(icon);
        } else {
            this.browseButton.setText("...");
        }
        this.browseButton.addActionListener(this);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 2;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(1, 1, 4, 1);
        this.add((Component)this.fileField, gbc);
        gbc.gridx = 2;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        this.add((Component)this.browseButton, gbc);
        StringBuilder builder = new StringBuilder("<html><table><tr>");
        if (this.inputType) {
            if (!this.optional) {
                builder.append("<td style=\"color:red\">IN ");
            } else {
                builder.append("<td style=\"color:green\">IN ");
            }
        } else if (!this.optional) {
            builder.append("<td style=\"color:red\">OUT ");
        } else {
            builder.append("<td style=\"color:green\">OUT ");
        }
        if (this.contentType == 3 || this.contentType == 5) {
            builder.append("<small>[csv]</small>: </td><td>");
        } else if (this.contentType == 2 || this.contentType == 4) {
            builder.append("<small>[xml]</small>: </td><td>");
        } else {
            builder.append("<small>[aux]</small>: </td><td>");
        }
        builder.append(this.description);
        builder.append(" <i>[" + this.paramName + "]</i>");
        builder.append("</td><tr></table></html>");
        this.descLabel.setText(builder.toString());
    }

    protected Object getParamValue() {
        return this.fileField.getText();
    }

    protected void setParamValue(Object value) {
        if (this.fileField != null && value instanceof String) {
            this.initialPath = (String)value;
            this.fileField.setText(this.initialPath);
        }
    }

    public boolean isOptional() {
        return this.optional;
    }

    public int getContentType() {
        return this.contentType;
    }

    public boolean isInputType() {
        return this.inputType;
    }

    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = null;
        chooser = this.initialPath != null ? new JFileChooser(this.initialPath) : new JFileChooser();
        FileFilter ff = null;
        if (this.contentType == 3 || this.contentType == 5) {
            ff = ElanFileFilter.createFileFilter(20);
        } else if (this.contentType == 2 || this.contentType == 4) {
            ff = ElanFileFilter.createFileFilter(23);
        }
        if (ff != null) {
            chooser.addChoosableFileFilter(ff);
            chooser.setFileFilter(ff);
        }
        if (this.inputType) {
            if (chooser.showOpenDialog(this) == 0) {
                File f = chooser.getSelectedFile();
                this.initialPath = f.getAbsolutePath();
                this.fileField.setText(this.initialPath);
            }
        } else if (chooser.showSaveDialog(this) == 0) {
            File f = chooser.getSelectedFile();
            this.initialPath = f.getAbsolutePath();
            this.fileField.setText(this.initialPath);
        }
    }
}

