/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.recognizer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.Selection;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.TierSelectionDialog;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.player.VideoFrameGrabber;
import mpi.eudico.client.annotator.recognizer.data.AudioSegment;
import mpi.eudico.client.annotator.recognizer.data.RSelection;
import mpi.eudico.client.annotator.recognizer.data.Segment;
import mpi.eudico.client.annotator.recognizer.data.Segmentation;
import mpi.eudico.client.annotator.recognizer.data.SelectionComparator;
import mpi.eudico.client.annotator.recognizer.data.VideoSegment;
import mpi.eudico.client.annotator.recognizer.gui.SelectionListRenderer;
import mpi.eudico.client.annotator.recognizer.io.RecTierWriter;
import mpi.eudico.client.annotator.svg.Graphics2DEditor;
import mpi.eudico.client.annotator.util.ElanFileFilter;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionPanel
extends JPanel
implements ActionListener {
    private Selection selection;
    private ViewerManager2 viewerManager;
    private TitledBorder border;
    private JPanel buttonPanel;
    private JButton addSelection;
    private JButton addSelection1;
    private JButton addSelection2;
    private JButton removeSelection;
    private JPanel buttonPanel2;
    private JButton addFromTier;
    private JButton addFromTier2;
    private JList selectionList;
    private DefaultListModel selectionModel;
    public static final int AUDIO_MODE = 0;
    public static final int VIDEO_MODE = 1;
    private int avMode = 0;
    private boolean stereoMode = true;
    private List<String> mediaFiles;

    public SelectionPanel(int mode, boolean stereoMode, ViewerManager2 viewerManager) {
        this.avMode = mode;
        this.stereoMode = stereoMode;
        this.viewerManager = viewerManager;
        this.selection = viewerManager.getSelection();
        this.border = new TitledBorder(ElanLocale.getString("Recognizer.SelectionsPanel.Title"));
        this.setBorder(this.border);
        this.setLayout(new BorderLayout());
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridLayout(1, 3));
        this.addSelection = new JButton(ElanLocale.getString("Recognizer.SelectionsPanel.Add"));
        this.addSelection.addActionListener(this);
        this.addSelection1 = new JButton(ElanLocale.getString("Recognizer.SelectionsPanel.Add.Channel1"));
        this.addSelection1.addActionListener(this);
        this.addSelection2 = new JButton(ElanLocale.getString("Recognizer.SelectionsPanel.Add.Channel2"));
        this.addSelection2.addActionListener(this);
        this.removeSelection = new JButton(ElanLocale.getString("Recognizer.SelectionsPanel.Remove"));
        this.removeSelection.addActionListener(this);
        if (stereoMode) {
            this.buttonPanel.add(this.addSelection1);
            this.buttonPanel.add(this.addSelection2);
            this.buttonPanel.add(this.removeSelection);
        } else {
            this.buttonPanel.add(this.addSelection);
            this.buttonPanel.add(this.removeSelection);
        }
        this.buttonPanel2 = new JPanel();
        this.buttonPanel2.setLayout(new GridLayout(1, 2));
        this.addFromTier = new JButton(ElanLocale.getString("Recognizer.SelectionsPanel.Add.FromTier"));
        this.addFromTier.addActionListener(this);
        this.buttonPanel2.add(this.addFromTier);
        if (stereoMode) {
            this.addFromTier.setText(ElanLocale.getString("Recognizer.SelectionsPanel.Add.FromTier1"));
            this.addFromTier2 = new JButton(ElanLocale.getString("Recognizer.SelectionsPanel.Add.FromTier2"));
            this.addFromTier2.addActionListener(this);
            this.buttonPanel2.add(this.addFromTier2);
        }
        JPanel compPanel = new JPanel();
        compPanel.setLayout(new BoxLayout(compPanel, 1));
        compPanel.add(this.buttonPanel);
        compPanel.add(this.buttonPanel2);
        this.add((Component)compPanel, "North");
        this.selectionModel = new DefaultListModel();
        this.selectionList = new JList(this.selectionModel);
        this.selectionList.setCellRenderer(new SelectionListRenderer());
        this.selectionList.addMouseListener(new MouseHandler());
        this.selectionList.setBackground(this.getBackground());
        JScrollPane scrollPane = new JScrollPane(this.selectionList);
        this.add((Component)scrollPane, "Center");
        this.add(Box.createHorizontalStrut(240), "South");
    }

    public void updateLocale() {
        this.border.setTitle(ElanLocale.getString("Recognizer.SelectionsPanel.Title"));
        this.addSelection.setText(ElanLocale.getString("Recognizer.SelectionsPanel.Add"));
        this.addSelection1.setText(ElanLocale.getString("Recognizer.SelectionsPanel.Add.Channel1"));
        this.addSelection2.setText(ElanLocale.getString("Recognizer.SelectionsPanel.Add.Channel2"));
        this.removeSelection.setText(ElanLocale.getString("Recognizer.SelectionsPanel.Remove"));
        this.addFromTier.setText(ElanLocale.getString("Recognizer.SelectionsPanel.Add.FromTier"));
        if (this.addFromTier2 != null) {
            this.addFromTier.setText(ElanLocale.getString("Recognizer.SelectionsPanel.Add.FromTier1"));
            this.addFromTier2.setText(ElanLocale.getString("Recognizer.SelectionsPanel.Add.FromTier2"));
        }
    }

    public void setStereoMode(boolean stereoMode) {
        if (this.stereoMode == stereoMode) {
            return;
        }
        this.stereoMode = stereoMode;
        if (stereoMode) {
            this.buttonPanel.removeAll();
            this.buttonPanel.add(this.addSelection1);
            this.buttonPanel.add(this.addSelection2);
            this.buttonPanel.add(this.removeSelection);
            this.buttonPanel2.add(this.addFromTier);
            this.buttonPanel2.add(this.addFromTier2);
        } else {
            this.buttonPanel.removeAll();
            this.buttonPanel.add(this.addSelection);
            this.buttonPanel.add(this.removeSelection);
            this.buttonPanel2.add(this.addFromTier);
        }
        this.getParent().validate();
        this.selectionModel.removeAllElements();
    }

    public boolean getStereoMode() {
        return this.stereoMode;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source.equals(this.addSelection)) {
            if (this.selection.getBeginTime() < this.selection.getEndTime()) {
                if (this.avMode == 0) {
                    this.addSelection(new AudioSegment(this.selection.getBeginTime(), this.selection.getEndTime(), null, 1));
                } else {
                    this.addSelection(new VideoSegment(this.selection.getBeginTime(), this.selection.getEndTime(), null, null));
                }
            }
        } else if (source.equals(this.addSelection1)) {
            if (this.selection.getBeginTime() < this.selection.getEndTime()) {
                this.addSelection(new AudioSegment(this.selection.getBeginTime(), this.selection.getEndTime(), null, 1));
            }
        } else if (source.equals(this.addSelection2)) {
            if (this.selection.getBeginTime() < this.selection.getEndTime()) {
                this.addSelection(new AudioSegment(this.selection.getBeginTime(), this.selection.getEndTime(), null, 2));
            }
        } else if (source.equals(this.removeSelection)) {
            int[] selIndices = this.selectionList.getSelectedIndices();
            if (selIndices != null) {
                for (int i = selIndices.length - 1; i >= 0; --i) {
                    this.selectionModel.remove(selIndices[i]);
                }
            }
        } else if (source == this.addFromTier) {
            this.addTier(1);
        } else if (source == this.addFromTier2) {
            this.addTier(2);
        }
    }

    void setMediaFilePaths(List<String> mediaFiles) {
        if (this.avMode == 1) {
            this.mediaFiles = mediaFiles;
        }
    }

    private void addSelection(RSelection sel) {
        if (this.selectionModel.isEmpty()) {
            this.selectionModel.addElement(sel);
            return;
        }
        for (int i = 0; i < this.selectionModel.getSize(); ++i) {
            Object iter = this.selectionModel.get(i);
            if (iter instanceof RSelection) {
                RSelection otherSel = (RSelection)iter;
                if (otherSel.beginTime == sel.beginTime && otherSel.endTime == sel.endTime) {
                    if (otherSel instanceof AudioSegment && sel instanceof AudioSegment) {
                        if (((AudioSegment)otherSel).channel == ((AudioSegment)sel).channel) {
                            return;
                        }
                        if (((AudioSegment)sel).channel < ((AudioSegment)otherSel).channel) {
                            this.selectionModel.add(i, sel);
                            return;
                        }
                        if (i < this.selectionModel.getSize() - 1) {
                            this.selectionModel.add(i, sel);
                            return;
                        }
                        this.selectionModel.addElement(sel);
                        return;
                    }
                    return;
                }
                if (otherSel.beginTime == sel.beginTime && otherSel.endTime > sel.endTime) {
                    this.selectionModel.add(i, sel);
                    return;
                }
                if (sel.beginTime < otherSel.beginTime) {
                    this.selectionModel.add(i, sel);
                    return;
                }
            }
            if (i != this.selectionModel.getSize() - 1) continue;
            this.selectionModel.addElement(sel);
        }
    }

    private void addSegmentation(Segmentation segmentation) {
        if (this.selectionModel.isEmpty()) {
            this.selectionModel.addElement(segmentation);
            return;
        }
        for (int i = 0; i < this.selectionModel.getSize(); ++i) {
            Object iter = this.selectionModel.get(i);
            if (!(iter instanceof RSelection)) continue;
            this.selectionModel.add(i, segmentation);
            return;
        }
        this.selectionModel.addElement(segmentation);
    }

    private void addTier(int channel) {
        Vector tiers = this.viewerManager.getTranscription().getTiers();
        if (tiers.size() == 0) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("LabelAndNumberDialog.Warning.NoTiers"), ElanLocale.getString("Message.Warning"), 2);
            return;
        }
        ArrayList<String> tierNames = new ArrayList<String>(tiers.size());
        for (int i = 0; i < tiers.size(); ++i) {
            Tier t = (Tier)tiers.get(i);
            tierNames.add(t.getName());
        }
        Window w = SwingUtilities.getWindowAncestor(this);
        Window tsd = null;
        if (w instanceof Frame) {
            tsd = new TierSelectionDialog((Frame)w, tierNames, new ArrayList<String>(0));
        } else if (w instanceof Dialog) {
            tsd = new TierSelectionDialog((Dialog)w, tierNames, new ArrayList<String>(0));
        }
        tsd.setLocationRelativeTo(this);
        ((Dialog)tsd).setVisible(true);
        List<String> selTiers = ((TierSelectionDialog)tsd).getValue();
        if (selTiers == null || selTiers.size() == 0) {
            return;
        }
        for (String name : selTiers) {
            TierImpl ti = (TierImpl)this.viewerManager.getTranscription().getTierWithId(name);
            if (ti == null) continue;
            Vector anns = ti.getAnnotations();
            ArrayList<RSelection> segments = new ArrayList<RSelection>(anns.size());
            for (int j = 0; j < anns.size(); ++j) {
                AbstractAnnotation aa = (AbstractAnnotation)anns.get(j);
                segments.add(new AudioSegment(aa.getBeginTimeBoundary(), aa.getEndTimeBoundary(), aa.getValue(), channel));
            }
            Segmentation segmentation = new Segmentation(name, segments, "", channel);
            this.addSegmentation(segmentation);
        }
    }

    private void handlePopUp(Point p) {
        int row = this.selectionList.locationToIndex(p);
        if (row > -1) {
            Object sel = this.selectionModel.elementAt(row);
            if (sel instanceof AudioSegment) {
                AudioSegment as = (AudioSegment)sel;
                JPopupMenu popup = new JPopupMenu();
                JMenuItem mi = new JMenuItem(new LabelAction(as));
                popup.add(mi);
                popup.add(new SaveTierAction(null));
                popup.show(this.selectionList, p.x, p.y);
            } else if (sel instanceof VideoSegment) {
                VideoSegment vs = (VideoSegment)sel;
                JPopupMenu popup = new JPopupMenu();
                JMenuItem mi = new JMenuItem(new LabelAction(vs));
                popup.add(mi);
                mi = new JMenuItem(new ShapeAction(vs));
                popup.add(mi);
                popup.add(new SaveTierAction(null));
                popup.show(this.selectionList, p.x, p.y);
            } else if (sel instanceof Segmentation) {
                Segmentation tier = (Segmentation)sel;
                JPopupMenu popup = new JPopupMenu();
                JMenuItem mi = new JMenuItem(new SaveTierAction(tier));
                popup.add(mi);
                popup.add(new SaveTierAction(null));
                popup.show(this.selectionList, p.x, p.y);
            } else if (!this.selectionModel.isEmpty()) {
                JPopupMenu popup = new JPopupMenu();
                popup.add(new SaveTierAction(null));
                popup.show(this.selectionList, p.x, p.y);
            }
        }
    }

    private String promptForTierFile() {
        String prefPath = null;
        Object val = Preferences.get("Recognizer.Path", null);
        prefPath = val instanceof String ? (String)val : System.getProperty("user.home");
        JFileChooser chooser = null;
        chooser = prefPath != null ? new JFileChooser(prefPath) : new JFileChooser();
        FileFilter ff = ElanFileFilter.createFileFilter(20);
        FileFilter ff2 = ElanFileFilter.createFileFilter(23);
        chooser.addChoosableFileFilter(ff);
        chooser.addChoosableFileFilter(ff2);
        chooser.setFileFilter(ff2);
        if (chooser.showSaveDialog(this) == 0) {
            File f = chooser.getSelectedFile();
            File par = f.getParentFile();
            if (par != null && par.isDirectory()) {
                Preferences.set("Recognizer.Path", par.getAbsolutePath(), null);
            }
            if (chooser.getFileFilter() == ff) {
                String lower = f.getAbsolutePath().toLowerCase();
                boolean valid = false;
                for (int i = 0; i < FileExtension.CSV_EXT.length; ++i) {
                    if (!lower.endsWith(FileExtension.CSV_EXT[i])) continue;
                    valid = true;
                    break;
                }
                if (!valid) {
                    f = new File(f.getAbsolutePath() + "." + FileExtension.CSV_EXT[0]);
                }
            } else if (!f.getAbsolutePath().toLowerCase().endsWith("xml")) {
                f = new File(f.getAbsolutePath() + ".xml");
            }
            return f.getAbsolutePath();
        }
        return null;
    }

    public ArrayList<RSelection> getSelections() {
        ArrayList<RSelection> selectionObjects = new ArrayList<RSelection>();
        boolean needsSorting = false;
        for (int i = 0; i < this.selectionModel.getSize(); ++i) {
            Object iter = this.selectionModel.get(i);
            if (iter instanceof RSelection) {
                selectionObjects.add((RSelection)iter);
                continue;
            }
            if (!(iter instanceof Segmentation)) continue;
            selectionObjects.addAll(((Segmentation)iter).getSegments());
            needsSorting = true;
        }
        if (needsSorting && selectionObjects.size() > 1) {
            Collections.sort(selectionObjects, new SelectionComparator());
        }
        return selectionObjects;
    }

    public ArrayList<Object> getTiersAndSelections() {
        ArrayList<Object> copy = new ArrayList<Object>(this.selectionModel.getSize());
        for (int i = 0; i < this.selectionModel.getSize(); ++i) {
            Object iter = this.selectionModel.get(i);
            copy.add(iter);
        }
        return copy;
    }

    public boolean hasSelections() {
        int numSels = 0;
        for (int i = 0; i < this.selectionModel.getSize(); ++i) {
            Object iter = this.selectionModel.get(i);
            if (iter instanceof RSelection) {
                ++numSels;
                break;
            }
            if (!(iter instanceof Segmentation) || ((Segmentation)iter).getSegments().size() <= 0) continue;
            ++numSels;
            break;
        }
        return numSels > 0;
    }

    public void clearSelections() {
        if (!this.selectionModel.isEmpty()) {
            this.selectionModel.clear();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.addSelection != null) {
            this.addSelection.setEnabled(enabled);
        }
        if (this.addSelection1 != null) {
            this.addSelection1.setEnabled(enabled);
        }
        if (this.addSelection2 != null) {
            this.addSelection2.setEnabled(enabled);
        }
        if (this.addFromTier != null) {
            this.addFromTier.setEnabled(enabled);
        }
        if (this.addFromTier2 != null) {
            this.addFromTier2.setEnabled(enabled);
        }
        if (this.removeSelection != null) {
            this.removeSelection.setEnabled(enabled);
        }
    }

    class SaveTierAction
    extends AbstractAction {
        private Segmentation segmentation;

        public SaveTierAction(Segmentation segmentation) {
            if (segmentation != null) {
                this.putValue("Name", ElanLocale.getString("Recognizer.SelectionsPanel.SaveTier"));
            } else {
                this.putValue("Name", ElanLocale.getString("Recognizer.SelectionsPanel.SaveSelections"));
            }
            this.segmentation = segmentation;
        }

        public void actionPerformed(ActionEvent e) {
            String filePath = SelectionPanel.this.promptForTierFile();
            File tf = new File(filePath);
            try {
                int answer;
                if (tf.exists() && (answer = JOptionPane.showConfirmDialog(SelectionPanel.this, ElanLocale.getString("Message.Overwrite"), ElanLocale.getString("SaveDialog.Message.Title"), 0, 2)) == 1) {
                    return;
                }
            }
            catch (Exception ex) {
                return;
            }
            if (this.segmentation != null) {
                ArrayList<Object> list = new ArrayList<Object>(1);
                list.add(this.segmentation);
                try {
                    RecTierWriter xTierWriter = new RecTierWriter();
                    xTierWriter.write(tf, list, false);
                }
                catch (IOException ioe) {
                    JOptionPane.showMessageDialog(SelectionPanel.this, ElanLocale.getString("Recognizer.RecognizerPanel.Warning.SaveFailed") + ioe.getMessage(), ElanLocale.getString("Message.Warning"), 0);
                }
            } else if (!SelectionPanel.this.selectionModel.isEmpty()) {
                try {
                    RecTierWriter xTierWriter = new RecTierWriter();
                    xTierWriter.write(tf, SelectionPanel.this.getTiersAndSelections(), true);
                }
                catch (IOException ioe) {
                    JOptionPane.showMessageDialog(SelectionPanel.this, ElanLocale.getString("Recognizer.RecognizerPanel.Warning.SaveFailed") + ioe.getMessage(), ElanLocale.getString("Message.Warning"), 0);
                }
            }
        }
    }

    class ShapeAction
    extends AbstractAction {
        private VideoSegment segment;

        public ShapeAction(VideoSegment segment) {
            super(ElanLocale.getString("Recognizer.SelectionsPanel.SetShape"));
            this.segment = segment;
        }

        public void actionPerformed(ActionEvent e) {
            String url;
            if (SelectionPanel.this.mediaFiles == null || SelectionPanel.this.mediaFiles.size() == 0) {
                JOptionPane.showMessageDialog(SelectionPanel.this, ElanLocale.getString("Recognizer.SelectionsPanel.WarnNoMedia"), ElanLocale.getString("Message.Warning"), 2);
                return;
            }
            String mediaPathToUse = null;
            if (SelectionPanel.this.mediaFiles.size() > 1) {
                Object[] options = new String[SelectionPanel.this.mediaFiles.size()];
                for (int i = 0; i < SelectionPanel.this.mediaFiles.size(); ++i) {
                    String p = (String)SelectionPanel.this.mediaFiles.get(i);
                    int index = p.lastIndexOf(47);
                    if (index > -1 && index < p.length() - 1) {
                        p = p.substring(index + 1);
                    }
                    options[i] = p;
                }
                String sel = (String)JOptionPane.showInputDialog(SelectionPanel.this, ElanLocale.getString("Recognizer.SelectionsPanel.SelectMedia"), "", 3, null, options, options[0]);
                if (sel != null) {
                    for (int i = 0; i < options.length; ++i) {
                        if (!((String)options[i]).equals(sel)) continue;
                        mediaPathToUse = (String)SelectionPanel.this.mediaFiles.get(i);
                        break;
                    }
                }
            } else {
                mediaPathToUse = (String)SelectionPanel.this.mediaFiles.get(0);
            }
            ElanMediaPlayer player = null;
            if (SelectionPanel.this.viewerManager.getMasterMediaPlayer().getMediaDescriptor() != null && (url = ((SelectionPanel)SelectionPanel.this).viewerManager.getMasterMediaPlayer().getMediaDescriptor().mediaURL) != null && url.endsWith(mediaPathToUse)) {
                player = SelectionPanel.this.viewerManager.getMasterMediaPlayer();
            }
            if (player == null) {
                Vector slaves = SelectionPanel.this.viewerManager.getSlaveMediaPlayers();
                for (int i = 0; i < slaves.size(); ++i) {
                    ElanMediaPlayer slayer = (ElanMediaPlayer)slaves.get(i);
                    if (slayer.getMediaDescriptor() == null || (url = slayer.getMediaDescriptor().mediaURL) == null || !url.endsWith(mediaPathToUse)) continue;
                    player = slayer;
                    break;
                }
            }
            if (player == null) {
                JOptionPane.showMessageDialog(SelectionPanel.this, ElanLocale.getString("Recognizer.SelectionsPanel.WarnNoPlayer"), ElanLocale.getString("Message.Warning"), 2);
                return;
            }
            if (!(player instanceof VideoFrameGrabber)) {
                JOptionPane.showMessageDialog(SelectionPanel.this, ElanLocale.getString("Recognizer.SelectionsPanel.WarnNoGrabber"), ElanLocale.getString("Message.Warning"), 2);
                return;
            }
            ArrayList<Shape> curSh = new ArrayList<Shape>(4);
            if (this.segment.shape != null) {
                curSh.add(this.segment.shape);
            }
            Graphics2DEditor editor = new Graphics2DEditor(ELANCommandFactory.getRootFrame(SelectionPanel.this.viewerManager.getTranscription()), (VideoFrameGrabber)((Object)player), this.segment.beginTime, this.segment.endTime, curSh);
            editor.setVisible(true);
            List<Shape> shapes = editor.getShapes();
            if (shapes != null && shapes.size() > 0) {
                this.segment.shape = shapes.get(0);
            }
        }
    }

    class LabelAction
    extends AbstractAction {
        private Segment segment;

        public LabelAction(Segment segment) {
            super(ElanLocale.getString("Recognizer.SelectionsPanel.SetLabel"));
            this.segment = segment;
        }

        public void actionPerformed(ActionEvent e) {
            String val;
            String initial = "";
            if (this.segment.label != null) {
                initial = this.segment.label;
            }
            if ((val = (String)JOptionPane.showInputDialog(SelectionPanel.this, ElanLocale.getString("Recognizer.SelectionsPanel.SetLabelDesc"), ElanLocale.getString("Recognizer.SelectionsPanel.SetLabel"), -1, null, null, initial)) != null) {
                this.segment.label = val;
            }
        }
    }

    public class MouseHandler
    extends MouseAdapter {
        public void mouseClicked(MouseEvent event) {
            Object o;
            if (event.getClickCount() > 1 && (o = SelectionPanel.this.selectionList.getSelectedValue()) instanceof RSelection) {
                long bt = ((RSelection)o).beginTime;
                long et = ((RSelection)o).endTime;
                SelectionPanel.this.selection.setSelection(bt, et);
                SelectionPanel.this.viewerManager.getMasterMediaPlayer().setMediaTime(bt);
            }
        }

        public void mousePressed(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e) && e.getButton() == 1 ^ e.isMetaDown() || e.isPopupTrigger()) {
                SelectionPanel.this.handlePopUp(e.getPoint());
            }
        }
    }
}

