/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.recognizer.impl;

import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.recognizer.api.ParamPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DemoRecognizerPanel
extends JPanel
implements ChangeListener,
ParamPreferences {
    private JLabel stepDurationLabel;
    private JSlider stepSlider;

    public DemoRecognizerPanel() {
        int initialStepDuration = 5;
        this.setLayout(new BoxLayout(this, 1));
        this.add(Box.createVerticalStrut(10));
        this.stepDurationLabel = new JLabel("Step Duration: " + initialStepDuration + " seconds");
        this.add(this.stepDurationLabel);
        this.stepSlider = new JSlider(0, 1, 10, initialStepDuration);
        this.stepSlider.setMajorTickSpacing(1);
        this.stepSlider.setPaintTicks(true);
        this.stepSlider.setPaintLabels(true);
        this.stepSlider.addChangeListener(this);
        this.add(this.stepSlider);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.stepSlider) {
            this.stepDurationLabel.setText("Step Duration: " + this.stepSlider.getValue() + " seconds");
        }
    }

    public int getStepDuration() {
        return this.stepSlider.getValue();
    }

    public void setStepDuration(int stepDur) {
        if (stepDur >= this.stepSlider.getMinimum() && stepDur <= this.stepSlider.getMaximum()) {
            this.stepSlider.setValue(stepDur);
        }
    }

    @Override
    public Map<String, Object> getParamPreferences() {
        HashMap<String, Object> prefs = new HashMap<String, Object>(1);
        prefs.put("StepDuration", this.stepSlider.getValue());
        return prefs;
    }

    @Override
    public void setParamPreferences(Map<String, Object> storedPrefs) {
        int step;
        Object val;
        if (storedPrefs != null && (val = storedPrefs.get("StepDuration")) instanceof Integer && (step = ((Integer)val).intValue()) >= this.stepSlider.getMinimum() && step <= this.stepSlider.getMaximum()) {
            this.stepSlider.setValue(step);
        }
    }
}

