/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.recognizer.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JPanel;
import mpi.eudico.client.annotator.recognizer.api.Recognizer;
import mpi.eudico.client.annotator.recognizer.api.RecognizerHost;
import mpi.eudico.client.annotator.recognizer.data.RSelection;
import mpi.eudico.client.annotator.recognizer.data.Segment;
import mpi.eudico.client.annotator.recognizer.data.Segmentation;
import mpi.eudico.client.annotator.recognizer.data.VideoSegment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoTestRecognizer
implements Recognizer {
    private RecognizerHost host;
    private StringBuilder report;
    private boolean isRunning = false;
    private Segmentation results;
    private String mediaPath;

    @Override
    public boolean canCombineMultipleFiles() {
        return false;
    }

    @Override
    public boolean canHandleMedia(String mediaFilePath) {
        return true;
    }

    @Override
    public void dispose() {
        System.out.println("Video TEst dispose.");
    }

    @Override
    public JPanel getControlPanel() {
        return null;
    }

    @Override
    public int getExamplesSupport() {
        return 1;
    }

    @Override
    public String getName() {
        return "Test Video Recognizer";
    }

    @Override
    public Object getParameterValue(String param) {
        return null;
    }

    @Override
    public int getRecognizerType() {
        return 1;
    }

    @Override
    public String getReport() {
        if (this.report != null) {
            return this.report.toString();
        }
        return null;
    }

    @Override
    public boolean setMedia(List<String> mediaFilePaths) {
        this.mediaPath = mediaFilePaths != null && mediaFilePaths.size() > 0 ? mediaFilePaths.get(0) : "";
        return true;
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public void setParameterValue(String param, String value) {
    }

    @Override
    public void setParameterValue(String param, float value) {
    }

    @Override
    public void setRecognizerHost(RecognizerHost host) {
        this.host = host;
    }

    @Override
    public void start() {
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        if (this.host != null) {
            this.report = new StringBuilder();
            ArrayList<RSelection> selections = this.host.getSelections();
            if (selections != null && selections.size() > 0) {
                this.results = new Segmentation("VidSeg", new ArrayList<RSelection>(), this.mediaPath);
                float prog = 1.0f / (float)selections.size();
                for (int i = 0; i < selections.size(); ++i) {
                    if (!this.isRunning) {
                        this.host.addSegmentation(this.results);
                        break;
                    }
                    RSelection sel = selections.get(i);
                    Segment segment = new Segment(sel.beginTime, sel.endTime, "");
                    this.report.append("Selection " + (i + 1) + ": " + sel.beginTime + " - " + sel.endTime);
                    if (sel instanceof VideoSegment) {
                        VideoSegment vs = (VideoSegment)sel;
                        if (vs.label != null) {
                            this.report.append(", " + vs.label);
                            segment.label = vs.label;
                        }
                        if (vs.shape != null) {
                            this.report.append(", " + vs.shape.toString());
                        }
                    }
                    this.report.append("\n");
                    this.results.getSegments().add(segment);
                    this.host.setProgress((float)(i + 1) * prog, "Segment " + (i + 1));
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
                this.host.addSegmentation(this.results);
            }
        }
    }

    @Override
    public void stop() {
        if (this.isRunning && this.report != null) {
            this.report.append("Cancelled...");
            this.isRunning = false;
        }
    }

    @Override
    public void updateLocale(Locale locale) {
    }
}

