/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.recognizer.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import mpi.eudico.client.annotator.recognizer.data.RSelection;
import mpi.eudico.client.annotator.recognizer.data.Segment;
import mpi.eudico.client.annotator.recognizer.data.Segmentation;
import mpi.eudico.client.annotator.util.ClientLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvTierIO {
    private final String SC = ";";

    public List<Segmentation> read(File csvFile) {
        if (csvFile == null || !csvFile.exists() || !csvFile.canRead() || csvFile.isDirectory()) {
            return null;
        }
        try {
            InputStreamReader fileRead = new InputStreamReader((InputStream)new FileInputStream(csvFile), "UTF-8");
            BufferedReader bufRead = new BufferedReader(fileRead);
            String line = null;
            Pattern pat = Pattern.compile(";");
            boolean headerRead = false;
            ArrayList<String> columnOrder = null;
            int numCols = 0;
            HashMap<String, Segmentation> segmentations = null;
            long bt = -1L;
            long et = -1L;
            int btColumn = 0;
            int etColumn = 1;
            block3: while ((line = bufRead.readLine()) != null) {
                String tok;
                int i;
                String[] nextRow;
                if (line.length() == 0) continue;
                if (!headerRead) {
                    nextRow = pat.split(line);
                    if (nextRow.length < 3) {
                        ClientLogger.LOG.warning("Too few columns in the file; there should at least be a begintime, endtime and one data column.");
                        return null;
                    }
                    columnOrder = new ArrayList<String>(nextRow.length);
                    segmentations = new HashMap<String, Segmentation>(nextRow.length - 2);
                    for (i = 0; i < nextRow.length; ++i) {
                        tok = nextRow[i];
                        if (tok.charAt(0) == '\"') {
                            tok = tok.substring(1);
                        }
                        if (tok.charAt(tok.length() - 1) == '\"') {
                            tok = tok.substring(0, tok.length() - 1);
                        }
                        if (i > 1) {
                            if (tok.charAt(0) == '#') {
                                tok = tok.substring(1);
                            }
                            Segmentation seg = new Segmentation(tok, new ArrayList<RSelection>(), "");
                            segmentations.put(tok, seg);
                        }
                        columnOrder.add(tok);
                    }
                    headerRead = true;
                    numCols = nextRow.length;
                    continue;
                }
                nextRow = pat.split(line);
                if (nextRow.length < 3) continue;
                for (i = 0; i < nextRow.length; ++i) {
                    tok = nextRow[i];
                    if (i == btColumn) {
                        bt = this.parseTime(tok);
                        continue;
                    }
                    if (i != etColumn) continue;
                    et = this.parseTime(tok);
                }
                if (bt <= -1L || et <= -1L) continue;
                for (i = 0; i < nextRow.length; ++i) {
                    tok = nextRow[i];
                    if (i != btColumn && i != etColumn) {
                        Segment segment = new Segment(bt, et, tok);
                        ((Segmentation)segmentations.get(columnOrder.get(i))).getSegments().add(segment);
                    }
                    if (i > numCols) continue block3;
                }
            }
            if (segmentations != null) {
                ArrayList<Segmentation> segmentList = new ArrayList<Segmentation>(segmentations.values());
                for (Segmentation s : segmentList) {
                    s.getMediaDescriptors().clear();
                }
                return segmentList;
            }
            return null;
        }
        catch (FileNotFoundException fnfe) {
            ClientLogger.LOG.warning("CSV file not found: " + fnfe.getMessage());
        }
        catch (IOException ioe) {
            ClientLogger.LOG.warning("Error while readring file: " + ioe.getMessage());
        }
        return null;
    }

    private long parseTime(String token) {
        if (token != null) {
            try {
                if (token.indexOf(46) > -1) {
                    float val = Float.parseFloat(token);
                    return (long)(1000.0f * val);
                }
                return Long.parseLong(token);
            }
            catch (NumberFormatException nfe) {
                return -1L;
            }
        }
        return -1L;
    }
}

