/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.recognizer.silence;

import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.recognizer.api.ParamPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SilenceRecognizerPanel
extends JPanel
implements ChangeListener,
ParamPreferences {
    private JLabel minimalSilenceDurationLabel;
    private JSlider minimalSilenceDuration;
    private JLabel minimalNonSilenceDurationLabel;
    private JSlider minimalNonSilenceDuration;

    public SilenceRecognizerPanel() {
        int initialSilenceDuration = 400;
        int initialNonSilenceDuration = 300;
        this.setLayout(new BoxLayout(this, 1));
        this.add(Box.createVerticalStrut(4));
        this.minimalSilenceDurationLabel = new JLabel(ElanLocale.getString("Recognizer.Silence.MinimalSilenceDuration") + " " + initialSilenceDuration + " " + ElanLocale.getString("PlayAroundSelDialog.Ms"));
        this.add(this.minimalSilenceDurationLabel);
        this.minimalSilenceDuration = new JSlider(0, 0, 1000, initialSilenceDuration);
        this.minimalSilenceDuration.setMajorTickSpacing(200);
        this.minimalSilenceDuration.setMinorTickSpacing(25);
        this.minimalSilenceDuration.setPaintTicks(true);
        this.minimalSilenceDuration.setPaintLabels(true);
        this.minimalSilenceDuration.addChangeListener(this);
        this.add(this.minimalSilenceDuration);
        this.add(Box.createVerticalStrut(4));
        this.minimalNonSilenceDurationLabel = new JLabel(ElanLocale.getString("Recognizer.Silence.MinimalNonSilenceDuration") + " " + initialNonSilenceDuration + " " + ElanLocale.getString("PlayAroundSelDialog.Ms"));
        this.add(this.minimalNonSilenceDurationLabel);
        this.minimalNonSilenceDuration = new JSlider(0, 0, 1000, initialNonSilenceDuration);
        this.minimalNonSilenceDuration.setMajorTickSpacing(200);
        this.minimalNonSilenceDuration.setMinorTickSpacing(25);
        this.minimalNonSilenceDuration.setPaintTicks(true);
        this.minimalNonSilenceDuration.setPaintLabels(true);
        this.minimalNonSilenceDuration.addChangeListener(this);
        this.add(this.minimalNonSilenceDuration);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        int duration = source.getValue();
        if (source == this.minimalSilenceDuration) {
            this.minimalSilenceDurationLabel.setText(ElanLocale.getString("Recognizer.Silence.MinimalSilenceDuration") + " " + duration + " " + ElanLocale.getString("PlayAroundSelDialog.Ms"));
        } else if (source == this.minimalNonSilenceDuration) {
            this.minimalNonSilenceDurationLabel.setText(ElanLocale.getString("Recognizer.Silence.MinimalNonSilenceDuration") + " " + duration + " " + ElanLocale.getString("PlayAroundSelDialog.Ms"));
        }
    }

    public int getMinimalSilenceDuration() {
        return this.minimalSilenceDuration.getValue();
    }

    public int getMinimalNonSilenceDuration() {
        return this.minimalNonSilenceDuration.getValue();
    }

    public void updateLocale() {
        int duration = this.minimalSilenceDuration.getValue();
        this.minimalSilenceDurationLabel.setText(ElanLocale.getString("Recognizer.Silence.MinimalSilenceDuration") + " " + duration + " " + ElanLocale.getString("PlayAroundSelDialog.Ms"));
        duration = this.minimalNonSilenceDuration.getValue();
        this.minimalNonSilenceDurationLabel.setText(ElanLocale.getString("Recognizer.Silence.MinimalNonSilenceDuration") + " " + duration + " " + ElanLocale.getString("PlayAroundSelDialog.Ms"));
    }

    @Override
    public Map<String, Object> getParamPreferences() {
        HashMap<String, Object> sps = new HashMap<String, Object>(4);
        sps.put("MinimalSilenceDuration", new Integer(this.minimalSilenceDuration.getValue()));
        sps.put("MinimalNonSilenceDuration", new Integer(this.minimalNonSilenceDuration.getValue()));
        return sps;
    }

    @Override
    public void setParamPreferences(Map<String, Object> storedPrefs) {
        if (storedPrefs != null) {
            Object val = storedPrefs.get("MinimalSilenceDuration");
            if (val instanceof Integer) {
                this.minimalSilenceDuration.setValue((Integer)val);
            }
            if ((val = storedPrefs.get("MinimalNonSilenceDuration")) instanceof Integer) {
                this.minimalNonSilenceDuration.setValue((Integer)val);
            }
        }
    }
}

