/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.search.model;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.tree.TreeNode;
import mpi.eudico.client.annotator.search.result.model.ElanMatch;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.util.TimeRelation;
import mpi.search.SearchLocale;
import mpi.search.content.model.CorpusType;
import mpi.search.content.query.model.AnchorConstraint;
import mpi.search.content.query.model.Constraint;
import mpi.search.content.query.model.ContentQuery;
import mpi.search.content.query.model.QueryFormulationException;
import mpi.search.content.query.model.RestrictedAnchorConstraint;
import mpi.search.content.query.model.Utilities;
import mpi.search.model.SearchEngine;
import mpi.search.model.SearchListener;
import mpi.search.query.model.Query;

public class ElanSearchEngine
implements SearchEngine {
    private static final Logger logger = Logger.getLogger(ElanSearchEngine.class.getName());
    private Hashtable annotationHash = new Hashtable();
    private Hashtable patternHash = new Hashtable();
    private Hashtable relationshipHash = new Hashtable();
    private Hashtable unitTierHash = new Hashtable();
    private Transcription transcription;

    public ElanSearchEngine(SearchListener searchTool, Transcription transcription) {
        this.transcription = transcription;
        logger.setLevel(Level.ALL);
    }

    public void executeThread(ContentQuery query) throws PatternSyntaxException, QueryFormulationException, NullPointerException {
        query.getResult().setPageSize(Integer.MAX_VALUE);
        this.initHashtables(query);
        AnchorConstraint anchorConstraint = query.getAnchorConstraint();
        String[] tierNames = anchorConstraint.getTierNames();
        if (tierNames[0].equals("Search.Constraint.AllTiers")) {
            tierNames = this.annotationHash.keySet().toArray(new String[0]);
        }
        for (int i = 0; i < tierNames.length; ++i) {
            List anchorMatches;
            List anchorAnnotations = (List)this.annotationHash.get(tierNames[i]);
            if (!(anchorConstraint instanceof RestrictedAnchorConstraint)) {
                int[] range = ElanSearchEngine.getAnnotationIndicesInScope(anchorAnnotations, anchorConstraint.getLowerBoundary(), anchorConstraint.getUpperBoundary(), anchorConstraint.getUnit());
                anchorMatches = ElanSearchEngine.getMatches(null, (Pattern)this.patternHash.get(anchorConstraint), anchorConstraint.getId(), anchorAnnotations, range);
            } else {
                anchorMatches = ((RestrictedAnchorConstraint)anchorConstraint).getResult().getMatches(tierNames[i]);
            }
            this.filterDependentConstraints(anchorMatches, anchorConstraint);
            for (int j = 0; j < anchorMatches.size(); ++j) {
                query.getResult().addMatch((ElanMatch)anchorMatches.get(j));
            }
        }
    }

    public void performSearch(Query query) throws Exception {
        this.executeThread((ContentQuery)query);
    }

    private static int[] getAnnotationIndicesInScope(List annotationList, long intervalBegin, long intervalEnd, String timeComparisonMode) {
        return ElanSearchEngine.getAnnotationIndicesInScope(annotationList, intervalBegin, intervalEnd, 0L, timeComparisonMode);
    }

    private static int[] getAnnotationIndicesInScope(List annotationList, long intervalBegin, long intervalEnd, long distance, String timeComparisonMode) {
        int[] annotationsInInterval = new int[annotationList.size()];
        int index = 0;
        for (int i = 0; i < annotationList.size(); ++i) {
            Annotation annotation = (Annotation)annotationList.get(i);
            boolean constraintFulfilled = false;
            if ("Search.Constraint.Overlap".equals(timeComparisonMode)) {
                constraintFulfilled = TimeRelation.overlaps(annotation, intervalBegin, intervalEnd);
            } else if ("Search.Constraint.Inside".equals(timeComparisonMode)) {
                constraintFulfilled = TimeRelation.isInside(annotation, intervalBegin, intervalEnd);
            } else if ("Search.Constraint.NoOverlap".equals(timeComparisonMode)) {
                constraintFulfilled = TimeRelation.doesNotOverlap(annotation, intervalBegin, intervalEnd);
            } else if ("Search.Constraint.NotInside".equals(timeComparisonMode)) {
                constraintFulfilled = TimeRelation.isNotInside(annotation, intervalBegin, intervalEnd);
            } else if ("Search.Constraint.LeftOverlap".equals(timeComparisonMode)) {
                constraintFulfilled = TimeRelation.overlapsOnLeftSide(annotation, intervalBegin, intervalEnd);
            } else if ("Search.Constraint.RightOverlap".equals(timeComparisonMode)) {
                constraintFulfilled = TimeRelation.overlapsOnRightSide(annotation, intervalBegin, intervalEnd);
            } else if ("Search.Constraint.WithinOverallDistance".equals(timeComparisonMode)) {
                constraintFulfilled = TimeRelation.isWithinDistance(annotation, intervalBegin, intervalEnd, distance);
            } else if ("Search.Constraint.WithinLeftDistance".equals(timeComparisonMode)) {
                constraintFulfilled = TimeRelation.isWithinLeftDistance(annotation, intervalBegin, distance);
            } else if ("Search.Constraint.WithinRightDistance".equals(timeComparisonMode)) {
                constraintFulfilled = TimeRelation.isWithinRightDistance(annotation, intervalEnd, distance);
            } else if ("Search.Constraint.BeforeLeftDistance".equals(timeComparisonMode)) {
                constraintFulfilled = TimeRelation.isBeforeLeftDistance(annotation, intervalBegin, distance);
            } else if ("Search.Constraint.AfterRightDistance".equals(timeComparisonMode)) {
                constraintFulfilled = TimeRelation.isAfterRightDistance(annotation, intervalEnd, distance);
            }
            if (!constraintFulfilled) continue;
            annotationsInInterval[index++] = i;
        }
        int[] range = new int[index];
        System.arraycopy(annotationsInInterval, 0, range, 0, index);
        return range;
    }

    private static List getAnnotationsInScope(long lowerBoundary, long upperBoundary, TierImpl unitTier, List unitAnnotations, TierImpl[] relationship, Annotation centralAnnotation) throws NullPointerException {
        Annotation centralUnitAnnotation;
        ArrayList annotationsInScope = new ArrayList();
        for (centralUnitAnnotation = centralAnnotation; centralUnitAnnotation.getTier() != unitTier && centralUnitAnnotation != null; centralUnitAnnotation = centralUnitAnnotation.getParentAnnotation()) {
        }
        if (centralUnitAnnotation == null) {
            throw new NullPointerException();
        }
        int unitAnnotationIndex = unitAnnotations.indexOf(centralUnitAnnotation);
        int[] unitAnnotationIndicesInScope = ElanSearchEngine.getRangeForTier(unitTier, lowerBoundary, upperBoundary, unitAnnotationIndex);
        Annotation rootOfCentralAnnotation = centralUnitAnnotation;
        while (rootOfCentralAnnotation.hasParentAnnotation()) {
            rootOfCentralAnnotation = rootOfCentralAnnotation.getParentAnnotation();
        }
        logger.log(Level.FINE, "Unit annotation " + centralUnitAnnotation.getValue());
        for (int k = 0; k < unitAnnotationIndicesInScope.length; ++k) {
            Annotation unitAnnotation = (Annotation)unitAnnotations.get(unitAnnotationIndicesInScope[k]);
            boolean haveSameRoot = true;
            if (unitAnnotation.hasParentAnnotation()) {
                Annotation rootOfUnitAnnotation = unitAnnotation;
                while (rootOfUnitAnnotation.hasParentAnnotation()) {
                    rootOfUnitAnnotation = rootOfUnitAnnotation.getParentAnnotation();
                }
                boolean bl = haveSameRoot = rootOfUnitAnnotation == rootOfCentralAnnotation;
            }
            if (!haveSameRoot) continue;
            annotationsInScope.addAll(ElanSearchEngine.getDescAnnotations(unitAnnotation, relationship));
        }
        return annotationsInScope;
    }

    private static List getDescAnnotations(Annotation ancestorAnnotation, TierImpl[] relationship) {
        ArrayList childAnnotations = new ArrayList();
        ArrayList<Annotation> parentAnnotations = new ArrayList<Annotation>();
        parentAnnotations.add(ancestorAnnotation);
        for (int r = relationship.length - 1; r >= 0; --r) {
            childAnnotations = new ArrayList();
            try {
                for (int i = 0; i < parentAnnotations.size(); ++i) {
                    childAnnotations.addAll(((Annotation)parentAnnotations.get(i)).getChildrenOnTier(relationship[r]));
                }
            }
            catch (Exception re) {
                re.printStackTrace();
                return new ArrayList();
            }
            parentAnnotations = childAnnotations;
        }
        return parentAnnotations;
    }

    private static List getMatches(ElanMatch parentMatch, Pattern pattern, String constraintId, List annotationList, int[] range) {
        ArrayList<ElanMatch> matchList = new ArrayList<ElanMatch>();
        for (int i = 0; i < range.length; ++i) {
            Annotation annotation = (Annotation)annotationList.get(range[i]);
            Matcher matcher = pattern.matcher(annotation.getValue());
            if (!matcher.find()) continue;
            ArrayList<int[]> substringIndices = new ArrayList<int[]>();
            do {
                substringIndices.add(new int[]{matcher.start(0), matcher.end(0)});
            } while (matcher.find());
            ElanMatch match = new ElanMatch(parentMatch, annotation, constraintId, range[i], (int[][])substringIndices.toArray((T[])new int[0][0]));
            if (range[i] > 0) {
                match.setLeftContext(((Annotation)annotationList.get(range[i] - 1)).getValue());
            }
            if (match.getIndex() + 1 < annotationList.size()) {
                match.setRightContext(((Annotation)annotationList.get(range[i] + 1)).getValue());
            }
            matchList.add(match);
        }
        return matchList;
    }

    private static int[] getRangeForTier(TierImpl tier, long lowerBoundary, long upperBoundary, int center) {
        int newLowerBoundary = lowerBoundary == Long.MIN_VALUE ? 0 : (int)Math.max(0L, (long)center + lowerBoundary);
        int newUpperBoundary = upperBoundary == Long.MAX_VALUE ? tier.getNumberOfAnnotations() - 1 : (int)Math.min((long)(tier.getNumberOfAnnotations() - 1), (long)center + upperBoundary);
        int[] range = new int[-newLowerBoundary + newUpperBoundary + 1];
        for (int i = 0; i < range.length; ++i) {
            range[i] = i + newLowerBoundary;
        }
        return range;
    }

    private static TierImpl[] getRelationship(TierImpl ancesterTier, TierImpl descendTier) {
        ArrayList<TierImpl> relationship = new ArrayList<TierImpl>();
        TierImpl parentTier = descendTier;
        try {
            if (descendTier.hasAncestor(ancesterTier)) {
                while (!ancesterTier.equals(parentTier)) {
                    relationship.add(parentTier);
                    parentTier = (TierImpl)parentTier.getParentTier();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return relationship.toArray(new TierImpl[0]);
    }

    private List getChildMatches(ElanMatch match, Constraint constraint) throws NullPointerException {
        int[] annotationIndicesInScope;
        TierImpl unitTier = null;
        List unitAnnotations = null;
        List constraintAnnotations = null;
        TierImpl[] relShip = null;
        long lowerBoundary = constraint.getLowerBoundary();
        long upperBoundary = constraint.getUpperBoundary();
        Pattern pattern = (Pattern)this.patternHash.get(constraint);
        constraintAnnotations = (List)this.annotationHash.get(constraint.getTierName());
        if ("Search.Constraint.Structural".equals(constraint.getMode())) {
            unitTier = (TierImpl)this.unitTierHash.get(constraint);
            unitAnnotations = (List)this.annotationHash.get(unitTier.getName());
            relShip = (TierImpl[])this.relationshipHash.get(constraint);
        }
        Annotation annotation = match.getAnnotation();
        if ("Search.Constraint.Temporal".equals(constraint.getMode())) {
            annotationIndicesInScope = ElanSearchEngine.getAnnotationIndicesInScope(constraintAnnotations, annotation.getBeginTimeBoundary(), annotation.getEndTimeBoundary(), upperBoundary, constraint.getUnit());
        } else {
            List annotationsInScope = ElanSearchEngine.getAnnotationsInScope(lowerBoundary, upperBoundary, unitTier, unitAnnotations, relShip, annotation);
            annotationIndicesInScope = new int[annotationsInScope.size()];
            for (int j = 0; j < annotationsInScope.size(); ++j) {
                annotationIndicesInScope[j] = constraintAnnotations.indexOf(annotationsInScope.get(j));
                logger.log(Level.FINE, "Constraint annotation: " + ((Annotation)annotationsInScope.get(j)).getValue());
            }
        }
        List matches = ElanSearchEngine.getMatches(match, pattern, constraint.getId(), constraintAnnotations, annotationIndicesInScope);
        this.filterDependentConstraints(matches, constraint);
        return matches;
    }

    private void fillAnnotationHash(Constraint constraint) throws QueryFormulationException {
        int i;
        TierImpl[] tiers;
        String[] tierNames = constraint.getTierNames();
        if (tierNames[0].equals("Search.Constraint.AllTiers")) {
            tiers = this.transcription.getTiers().toArray(new TierImpl[0]);
        } else {
            tiers = new TierImpl[tierNames.length];
            for (i = 0; i < tierNames.length; ++i) {
                tiers[i] = (TierImpl)this.transcription.getTierWithId(tierNames[i]);
                if (tiers[i] != null) continue;
                throw new QueryFormulationException(SearchLocale.getString("Search.Exception.CannotFindTier") + " '" + tierNames[i] + "'");
            }
        }
        for (i = 0; i < tiers.length; ++i) {
            this.annotationHash.put(tiers[i].getName(), tiers[i].getAnnotations());
        }
        if ("Search.Constraint.Structural".equals(constraint.getMode())) {
            String tierName = constraint.getUnit().substring(0, constraint.getUnit().lastIndexOf(32));
            TierImpl unitTier = (TierImpl)this.transcription.getTierWithId(tierName);
            if (unitTier == null) {
                throw new QueryFormulationException(SearchLocale.getString("Search.Exception.CannotFindTier") + " '" + tierName + "'");
            }
            this.unitTierHash.put(constraint, unitTier);
            this.relationshipHash.put(constraint, ElanSearchEngine.getRelationship(unitTier, tiers[0]));
            if (!this.annotationHash.containsKey(tierName)) {
                Vector annotations = unitTier.getAnnotations();
                this.annotationHash.put(tierName, annotations);
            }
        }
    }

    private void fillHashes(CorpusType type, Constraint constraint) throws QueryFormulationException {
        Enumeration<? extends TreeNode> e = constraint.children();
        while (e.hasMoreElements()) {
            this.fillHashes(type, (Constraint)e.nextElement());
        }
        this.fillAnnotationHash(constraint);
        this.patternHash.put(constraint, Utilities.getPattern(constraint, type));
    }

    private void filterDependentConstraints(List startingMatches, Constraint constraint) throws NullPointerException {
        Enumeration<? extends TreeNode> e = constraint.children();
        while (e.hasMoreElements()) {
            int j = 0;
            Constraint childConstraint = (Constraint)e.nextElement();
            while (j < startingMatches.size()) {
                ElanMatch match = (ElanMatch)startingMatches.get(j);
                List childMatches = this.getChildMatches(match, childConstraint);
                if ("Search.Constraint.Any".equals(childConstraint.getQuantifier()) && childMatches.size() > 0 || "Search.Constraint.None".equals(childConstraint.getQuantifier()) && childMatches.size() == 0) {
                    ++j;
                    match.addChildren(childMatches);
                    continue;
                }
                startingMatches.remove(j);
            }
        }
    }

    private void initHashtables(ContentQuery query) throws QueryFormulationException, PatternSyntaxException {
        this.patternHash.clear();
        this.annotationHash.clear();
        this.unitTierHash.clear();
        this.relationshipHash.clear();
        this.fillHashes(query.getType(), query.getAnchorConstraint());
    }
}

