/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.search.result.model;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.TreeNode;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.search.content.result.model.AbstractContentMatch;

public class ElanMatch
extends AbstractContentMatch
implements TreeNode {
    private final Annotation annotation;
    private final ElanMatch parentMatch;
    private final String constraintId;
    private final Vector children = new Vector();

    public ElanMatch(ElanMatch parentMatch, Annotation annotation, String constraintId, int indexWithinTier, int[][] substringIndices) {
        this(parentMatch, annotation, constraintId, indexWithinTier, "", "", substringIndices);
    }

    public ElanMatch(ElanMatch parentMatch, Annotation annotation, String constraintId, int indexWithinTier, String leftContext, String rightContext, int[][] substringIndices) {
        this.parentMatch = parentMatch;
        this.annotation = annotation;
        this.constraintId = constraintId;
        this.setIndex(indexWithinTier);
        this.setLeftContext(leftContext);
        this.setRightContext(rightContext);
        this.setMatchedSubstringIndices(substringIndices);
    }

    public void addChild(ElanMatch subMatch) {
        this.children.add(subMatch);
    }

    public void addChildren(Collection subMatches) {
        this.children.addAll(subMatches);
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getConstraintId() {
        return this.constraintId;
    }

    public String getTierName() {
        String name = "";
        try {
            name = this.annotation.getTier().getName();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return name;
    }

    public String getValue() {
        return this.annotation.getValue();
    }

    public long getBeginTimeBoundary() {
        return this.annotation.getBeginTimeBoundary();
    }

    public long getEndTimeBoundary() {
        return this.annotation.getEndTimeBoundary();
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public void setLeftContext(String context) {
        this.leftContext = context;
    }

    public void setRightContext(String context) {
        this.rightContext = context;
    }

    public void setMatchedSubstringIndices(int[][] substringIndices) {
        this.matchedSubstringIndices = substringIndices;
    }

    public Enumeration children() {
        return this.children.elements();
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int index) {
        return (TreeNode)this.children.get(index);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public int getIndex(TreeNode node) {
        return this.children.indexOf(node);
    }

    public TreeNode getParent() {
        return this.parentMatch;
    }

    public boolean isLeaf() {
        return this.children.size() == 0;
    }

    public String toString() {
        return this.annotation.getValue();
    }

    public String toHTML() {
        StringBuffer sb = new StringBuffer("<HTML><BODY>");
        for (TreeNode loopNode = this.parentMatch; loopNode != null; loopNode = loopNode.getParent()) {
        }
        sb.append(this.annotation.getValue() + "<ul>");
        for (int i = 0; i < this.children.size(); ++i) {
            sb.append(this.children.get(i));
        }
        sb.append("</ul>");
        sb.append("</BODY></HTML>");
        return sb.toString();
    }
}

