/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.search.viewer;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.MultiFileChooser;
import mpi.eudico.client.annotator.util.ElanFileFilter;

public class EAFMultipleFileUtilities {
    public static final String extension = ".eaf";

    public static boolean specifyDomain(Component parent, List searchDirs, List searchPaths) {
        int option;
        MultiFileChooser chooser = new MultiFileChooser();
        chooser.setDialogTitle(ElanLocale.getString("MultipleFileSearch.DomainDialogTitle"));
        chooser.setFileFilter(ElanFileFilter.createFileFilter(3));
        chooser.setFileSelectionMode(2);
        File lastDir = new File(System.getProperty("user.dir"));
        String dirPath = (String)Preferences.get("MultipleFileSearchLastDir", null);
        if (dirPath != null) {
            lastDir = new File(dirPath);
        }
        chooser.setCurrentDirectory(lastDir);
        int nDirs = searchDirs.size();
        int nFiles = searchPaths.size();
        if (nDirs + nFiles > 0) {
            int i;
            File[] currentFiles = new File[nDirs + nFiles];
            for (i = 0; i < searchDirs.size(); ++i) {
                currentFiles[i] = new File((String)searchDirs.get(i));
            }
            for (i = 0; i < searchPaths.size(); ++i) {
                currentFiles[i + nDirs] = new File((String)searchPaths.get(i));
            }
            chooser.setFiles(currentFiles);
        }
        if ((option = chooser.showDialog(parent, null)) == 0) {
            String lastDirPath = chooser.getCurrentDirectory().getAbsolutePath();
            Preferences.set("MultipleFileSearchLastDir", lastDirPath, null);
            searchDirs.clear();
            searchPaths.clear();
            Object[] names = chooser.getFiles();
            for (int i = 0; i < names.length; ++i) {
                String name = "" + names[i];
                File f = new File(name);
                if (f.isFile()) {
                    searchPaths.add(f.getPath());
                    continue;
                }
                if (!f.isDirectory()) continue;
                searchDirs.add(f.getPath());
            }
            Preferences.set("MultipleFileSearchDirs", searchDirs, null);
            Preferences.set("MultipleFileSearchPaths", searchPaths, null);
        }
        return option == 0;
    }

    public static File[] getUniqueEAFFilesIn(List dirs, List paths) {
        int i;
        TreeSet<File> sortedUniqueFiles = new TreeSet<File>();
        for (i = 0; i < dirs.size(); ++i) {
            File dir = new File((String)dirs.get(i));
            if (!dir.exists() || !dir.isDirectory() || !dir.canRead()) continue;
            sortedUniqueFiles.addAll(EAFMultipleFileUtilities.getAllEafFilesUnder(dir));
        }
        for (i = 0; i < paths.size(); ++i) {
            File file;
            String path = (String)paths.get(i);
            if (!path.toLowerCase().endsWith(extension) || !(file = new File(path)).exists() || !file.canRead()) continue;
            sortedUniqueFiles.add(file);
        }
        return sortedUniqueFiles.toArray(new File[0]);
    }

    public static List getAllEafFilesUnder(File directory) {
        ArrayList<File> eafFiles = new ArrayList<File>();
        File[] filesAndDirs = directory.listFiles();
        for (int i = 0; i < filesAndDirs.length; ++i) {
            File fileOrDir = filesAndDirs[i];
            if (fileOrDir.isFile() && fileOrDir.canRead()) {
                if (!fileOrDir.getName().toLowerCase().endsWith(extension)) continue;
                eafFiles.add(fileOrDir);
                continue;
            }
            if (!fileOrDir.isDirectory() || !fileOrDir.canRead()) continue;
            eafFiles.addAll(EAFMultipleFileUtilities.getAllEafFilesUnder(fileOrDir));
        }
        return eafFiles;
    }
}

