/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.search.viewer;

import guk.im.GateIM;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.MultiFindAndReplaceCommand;
import mpi.eudico.client.annotator.gui.MFDomainDialog;
import mpi.eudico.client.annotator.gui.ReportDialog;
import mpi.eudico.client.annotator.gui.TierSelectionDialog;
import mpi.eudico.client.annotator.search.query.viewer.EAFPopupMenu;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.client.annotator.util.FileUtility;
import mpi.eudico.client.annotator.util.ProgressListener;
import mpi.eudico.server.corpora.clomimpl.abstr.ParseException;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.EAFSkeletonParser;
import mpi.eudico.server.corpora.util.SimpleReport;
import mpi.search.SearchLocale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EAFMultipleFindReplaceDialog
extends JDialog
implements ActionListener,
FocusListener,
CaretListener,
ProgressListener {
    private File[] domainFiles;
    private File[] searchFiles;
    private List<String> selTiersList;
    private List<String> allTiersList;
    private JButton domainButton;
    private JPanel domainPanel;
    private JTable filesTable;
    private JRadioButton allTiersRB;
    private JRadioButton selectedTiersRB;
    private JButton selTiersButton;
    private JProgressBar loadTiersBar;
    private JPanel definePanel;
    private JLabel defineLabel;
    private JTextField findField;
    private Locale orgLocale;
    private JCheckBox caseSensitiveCheckBox;
    private JCheckBox regexCheckBox;
    private JLabel replaceLabel;
    private JTextField replaceField;
    private JPanel progPanel;
    private JButton startStopButton;
    private JProgressBar progressBar;
    private JButton closeButton;
    private boolean isRunning = false;
    private boolean reloadTierList = false;
    private MultiFindAndReplaceCommand command;
    private ArrayList<String> searchDirs;
    private ArrayList<String> searchPaths;

    public EAFMultipleFindReplaceDialog() throws HeadlessException {
        this((Frame)null);
    }

    public EAFMultipleFindReplaceDialog(Frame owner) throws HeadlessException {
        super(owner, true);
        this.initComponents();
        this.pack();
        this.postInit();
    }

    private void postInit() {
        this.pack();
        int w = 460;
        int h = 400;
        this.setSize(this.getSize().width < w ? w : this.getSize().width, this.getSize().height < h ? h : this.getSize().height);
        this.setLocationRelativeTo(this.getParent());
    }

    private void initComponents() {
        this.setDefaultCloseOperation(0);
        this.setTitle(ElanLocale.getString("MultipleFileSearch.FindReplace.Title"));
        this.domainButton = new JButton();
        this.domainPanel = new JPanel();
        this.filesTable = new JTable();
        this.filesTable.setEnabled(false);
        this.filesTable.setAutoResizeMode(0);
        this.allTiersRB = new JRadioButton();
        this.allTiersRB.setSelected(true);
        this.selectedTiersRB = new JRadioButton();
        this.selTiersButton = new JButton("...");
        this.selTiersButton.setEnabled(false);
        this.loadTiersBar = new JProgressBar(0, 100);
        this.loadTiersBar.setEnabled(false);
        this.loadTiersBar.setStringPainted(true);
        this.loadTiersBar.setString("");
        ButtonGroup bgroup = new ButtonGroup();
        bgroup.add(this.allTiersRB);
        bgroup.add(this.selectedTiersRB);
        this.definePanel = new JPanel();
        this.defineLabel = new JLabel();
        this.findField = new JTextField();
        this.findField.setFont(Constants.DEFAULTFONT.deriveFont(1));
        this.caseSensitiveCheckBox = new JCheckBox();
        this.caseSensitiveCheckBox.setFont(this.caseSensitiveCheckBox.getFont().deriveFont(0, 9.0f));
        this.regexCheckBox = new JCheckBox();
        this.regexCheckBox.setFont(this.regexCheckBox.getFont().deriveFont(0, 9.0f));
        this.replaceLabel = new JLabel();
        this.replaceField = new JTextField();
        this.replaceField.setFont(Constants.DEFAULTFONT.deriveFont(1));
        this.startStopButton = new JButton();
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(true);
        this.closeButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        Insets insets = new Insets(4, 6, 4, 6);
        this.domainPanel.setLayout(new GridBagLayout());
        this.domainPanel.setPreferredSize(new Dimension(300, 180));
        gbc.anchor = 12;
        gbc.insets = insets;
        this.domainPanel.add((Component)this.domainButton, gbc);
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.domainPanel.add((Component)new JScrollPane(this.filesTable), gbc);
        JPanel tierPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.anchor = 17;
        gbc2.insets = new Insets(0, 0, 0, 6);
        tierPanel.add((Component)this.allTiersRB, gbc2);
        gbc2.gridx = 1;
        tierPanel.add((Component)this.selectedTiersRB, gbc2);
        gbc2.gridx = 2;
        tierPanel.add((Component)this.selTiersButton, gbc2);
        gbc2.gridx = 3;
        gbc2.fill = 2;
        gbc2.weightx = 1.0;
        tierPanel.add((Component)this.loadTiersBar, gbc2);
        gbc.gridy = 2;
        gbc.fill = 2;
        gbc.weighty = 0.0;
        this.domainPanel.add((Component)tierPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.insets = insets;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        this.getContentPane().add((Component)this.domainPanel, gbc);
        this.definePanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.insets = insets;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.gridwidth = 2;
        this.definePanel.add((Component)this.defineLabel, gbc);
        gbc.gridy = 1;
        this.definePanel.add((Component)this.findField, gbc);
        gbc.gridy = 2;
        gbc.fill = 0;
        gbc.gridwidth = 1;
        this.definePanel.add((Component)this.regexCheckBox, gbc);
        gbc.gridx = 1;
        this.definePanel.add((Component)this.caseSensitiveCheckBox, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.definePanel.add((Component)this.replaceLabel, gbc);
        gbc.gridy = 4;
        this.definePanel.add((Component)this.replaceField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.insets = insets;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        this.getContentPane().add((Component)this.definePanel, gbc);
        this.progPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.insets = insets;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        this.progPanel.add((Component)this.progressBar, gbc);
        gbc.gridx = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 13;
        this.progPanel.add((Component)this.startStopButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 2;
        gbc.insets = insets;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        this.getContentPane().add((Component)this.progPanel, gbc);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 1, 6, 2));
        buttonPanel.add(this.closeButton);
        gbc = new GridBagConstraints();
        gbc.gridy = 3;
        gbc.insets = insets;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 15;
        this.getContentPane().add((Component)buttonPanel, gbc);
        this.domainButton.addActionListener(this);
        this.startStopButton.setEnabled(false);
        this.startStopButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.updateLocale();
        if (this.findField.getInputContext() != null) {
            this.orgLocale = this.findField.getInputContext().getLocale();
        }
        new EAFPopupMenu(this.findField, null);
        this.findField.addFocusListener(this);
        if (this.orgLocale != null) {
            this.findField.setLocale(this.orgLocale);
        }
        new EAFPopupMenu(this.replaceField, null);
        this.replaceField.addFocusListener(this);
        if (this.orgLocale != null) {
            this.replaceField.setLocale(this.orgLocale);
        }
        this.findField.addActionListener(this);
        this.findField.addCaretListener(this);
        this.allTiersRB.addActionListener(this);
        this.selectedTiersRB.addActionListener(this);
        this.selTiersButton.addActionListener(this);
    }

    private void updateLocale() {
        this.domainPanel.setBorder(new TitledBorder(ElanLocale.getString("MultipleFileSearch.SearchDomain")));
        this.domainButton.setText(ElanLocale.getString("MultipleFileSearch.DomainDefKey"));
        this.allTiersRB.setText(ElanLocale.getString("MultipleFileSearch.FindReplace.AllTiers"));
        this.selectedTiersRB.setText(ElanLocale.getString("MultipleFileSearch.FindReplace.SelectedTiers"));
        this.definePanel.setBorder(new TitledBorder(ElanLocale.getString("MultipleFileSearch.FindReplace")));
        this.defineLabel.setText(ElanLocale.getString("MultipleFileSearch.FindReplace.Find"));
        this.caseSensitiveCheckBox.setText(SearchLocale.getString("Search.Constraint.CaseSensitive"));
        this.regexCheckBox.setText(SearchLocale.getString("Search.Constraint.RegularExpression"));
        this.replaceLabel.setText(ElanLocale.getString("MultipleFileSearch.FindReplace.Replace"));
        this.progPanel.setBorder(new TitledBorder(ElanLocale.getString("MultipleFileSearch.FindReplace.Progress")));
        this.startStopButton.setText(ElanLocale.getString("MultipleFileSearch.FindReplace"));
        this.closeButton.setText(ElanLocale.getString("Button.Close"));
    }

    private void enableUI(boolean enable) {
        this.domainButton.setEnabled(enable);
        this.findField.setEnabled(enable);
        this.regexCheckBox.setEnabled(enable);
        this.caseSensitiveCheckBox.setEnabled(enable);
        this.replaceField.setEnabled(enable);
        this.closeButton.setEnabled(enable);
    }

    private void checkStartStopState() {
        if (!this.isRunning) {
            if (this.searchFiles != null && this.searchFiles.length > 0 && this.findField.getText() != null && this.findField.getText().length() > 0) {
                this.startStopButton.setEnabled(true);
            } else {
                this.startStopButton.setEnabled(false);
            }
        }
    }

    private void updateFileList() {
        ArrayList<File> files = this.getMultipleFiles(null, ElanLocale.getString("MultipleFileSearch.DomainDialogTitle"));
        if (files != null && files.size() > 0) {
            this.reloadTierList = true;
            this.searchFiles = files.toArray(new File[0]);
            Object[][] data = new String[files.size()][2];
            Object[] headers = new String[]{ElanLocale.getString("Menu.File"), ElanLocale.getString("LinkedFilesDialog.Label.MediaURL")};
            for (int i = 0; i < files.size(); ++i) {
                File f = files.get(i);
                data[i][1] = f.getAbsolutePath();
                data[i][0] = FileUtility.fileNameFromPath((String)data[i][1]);
            }
            DefaultTableModel model = new DefaultTableModel(data, headers);
            this.filesTable.setModel(model);
            TableColumn tc = this.filesTable.getColumnModel().getColumn(0);
            tc.setPreferredWidth(140);
            tc = this.filesTable.getColumnModel().getColumn(1);
            tc.setPreferredWidth(600);
            this.filesTable.doLayout();
            this.startStopButton.setEnabled(true);
        }
    }

    protected ArrayList<File> getMultipleFiles(JFrame parent, String title) {
        File f;
        String name;
        int i;
        ArrayList<File> files = new ArrayList<File>();
        if (this.searchDirs == null) {
            this.searchDirs = new ArrayList();
        }
        if (this.searchPaths == null) {
            this.searchPaths = new ArrayList();
        }
        MFDomainDialog mfDialog = new MFDomainDialog(this, ElanLocale.getString("MultipleFileSearch.SearchDomain"), true);
        mfDialog.setSearchDirs(this.searchDirs);
        mfDialog.setSearchPaths(this.searchPaths);
        mfDialog.setVisible(true);
        this.searchDirs = (ArrayList)mfDialog.getSearchDirs();
        this.searchPaths = (ArrayList)mfDialog.getSearchPaths();
        if (this.searchPaths.size() > 0) {
            for (i = 0; i < this.searchPaths.size(); ++i) {
                name = this.searchPaths.get(i);
                f = new File(name);
                if (f.isFile() && f.canRead()) {
                    files.add(f);
                    continue;
                }
                if (!f.isDirectory() || !f.canRead()) continue;
                this.addFiles(f, files);
            }
        }
        if (this.searchDirs.size() > 0) {
            for (i = 0; i < this.searchDirs.size(); ++i) {
                name = this.searchDirs.get(i);
                f = new File(name);
                if (f.isFile() && f.canRead()) {
                    files.add(f);
                    continue;
                }
                if (!f.isDirectory() || !f.canRead()) continue;
                this.addFiles(f, files);
            }
        }
        return files;
    }

    protected void addFiles(File dir, ArrayList<File> files) {
        if (dir == null && files == null) {
            return;
        }
        File[] allSubs = dir.listFiles();
        for (int i = 0; i < allSubs.length; ++i) {
            if (allSubs[i].isDirectory() && allSubs[i].canRead()) {
                this.addFiles(allSubs[i], files);
                continue;
            }
            if (!allSubs[i].canRead() || !allSubs[i].getName().toLowerCase().endsWith(FileExtension.EAF_EXT[0])) continue;
            files.add(allSubs[i]);
        }
    }

    private void selectTiers() {
        if (this.searchFiles == null || this.searchFiles.length == 0) {
            this.showWarningDialog(ElanLocale.getString("MultipleFileSearch.FindReplace.Warn1"));
            this.enableUI(true);
            return;
        }
        if (this.allTiersList == null || this.reloadTierList) {
            this.loadTierNames();
            this.reloadTierList = false;
        } else {
            this.showTierSelectionDialog();
        }
    }

    private void showTierSelectionDialog() {
        if (this.allTiersList != null) {
            TierSelectionDialog tsd = new TierSelectionDialog((Dialog)this, this.allTiersList, this.selTiersList);
            tsd.setVisible(true);
            List<String> selTiers = tsd.getValue();
            if (selTiers != null) {
                this.selTiersList = selTiers;
            }
        }
    }

    private void loadTierNames() {
        this.selTiersButton.setEnabled(false);
        this.loadTiersBar.setString(ElanLocale.getString("MultipleFileSearch.FindReplace.LoadingTiers"));
        this.allTiersList = new ArrayList<String>();
        TierLoadThread tlt = new TierLoadThread(this.allTiersList);
        try {
            tlt.start();
        }
        catch (IllegalThreadStateException ie) {
            ie.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void start() {
        int option;
        int option2;
        if (this.searchFiles == null || this.searchFiles.length == 0) {
            this.showWarningDialog(ElanLocale.getString("MultipleFileSearch.FindReplace.Warn1"));
            this.enableUI(true);
            return;
        }
        if (this.findField.getText() == null || this.findField.getText().length() == 0) {
            this.showWarningDialog(ElanLocale.getString("MultipleFileSearch.FindReplace.Warn2"));
            this.enableUI(true);
            return;
        }
        if ((this.replaceField.getText() == null || this.replaceField.getText().length() == 0) && (option2 = JOptionPane.showConfirmDialog(this, ElanLocale.getString("MultipleFileSearch.FindReplace.Warn3"), ElanLocale.getString("Message.Warning"), 0, 3)) != 0) {
            this.enableUI(true);
            return;
        }
        String searchPattern = this.findField.getText();
        Boolean regEx = new Boolean(this.regexCheckBox.isSelected());
        Boolean caseSens = new Boolean(this.caseSensitiveCheckBox.isSelected());
        String replPattern = this.replaceField.getText();
        if (replPattern == null) {
            replPattern = "";
        }
        if (regEx.booleanValue()) {
            int flag = caseSens != false ? 0 : 2;
            try {
                Pattern.compile(searchPattern, flag);
            }
            catch (PatternSyntaxException pse) {
                this.showWarningDialog(ElanLocale.getString("MultipleFileSearch.FindReplace.Warn4") + " " + pse.getMessage());
                this.enableUI(true);
                return;
            }
        }
        String[] selTiers = null;
        if (this.selectedTiersRB.isSelected() && this.selTiersList != null) {
            selTiers = this.selTiersList.toArray(new String[0]);
        }
        if ((option = JOptionPane.showConfirmDialog(this, ElanLocale.getString("MultipleFileSearch.FindReplace.WarnFinal"), ElanLocale.getString("Message.Warning"), 0, 3)) != 0) {
            this.enableUI(true);
            return;
        }
        this.command = new MultiFindAndReplaceCommand("Menu.Search.FindReplaceMulti");
        this.command.setProcessReport(new SimpleReport(ElanLocale.getString("MultipleFileSearch.FindReplace.Report")));
        this.command.addProgressListener(this);
        this.command.execute(null, new Object[]{this.searchFiles, selTiers, searchPattern, replPattern, regEx, caseSens});
        this.isRunning = true;
        this.startStopButton.setText(ElanLocale.getString("Button.Stop"));
    }

    private void stop() {
        if (this.command != null) {
            this.command.interrupt();
        }
    }

    protected void showWarningDialog(String message) {
        JOptionPane.showMessageDialog(this, message, ElanLocale.getString("Message.Warning"), 2);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.closeButton) {
            if (!this.isRunning) {
                this.setVisible(false);
                this.dispose();
            }
        } else if (e.getSource() == this.domainButton) {
            if (!this.isRunning) {
                this.updateFileList();
                this.checkStartStopState();
            }
        } else if (e.getSource() == this.allTiersRB) {
            this.selTiersButton.setEnabled(false);
            this.loadTiersBar.setEnabled(false);
        } else if (e.getSource() == this.selectedTiersRB) {
            this.selTiersButton.setEnabled(true);
            this.loadTiersBar.setEnabled(true);
        } else if (e.getSource() == this.selTiersButton) {
            if (!this.isRunning) {
                this.selectTiers();
            }
        } else if (e.getSource() == this.startStopButton) {
            if (!this.isRunning) {
                this.enableUI(false);
                this.start();
            } else {
                this.stop();
            }
        } else if (e.getSource() == this.findField) {
            this.checkStartStopState();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.orgLocale != null) {
            e.getComponent().setLocale(this.orgLocale);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        Object imObject;
        if (e.getComponent().getInputContext() != null && (imObject = e.getComponent().getInputContext().getInputMethodControlObject()) != null && imObject instanceof GateIM) {
            ((GateIM)imObject).setMapVisible(false);
        }
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        this.checkStartStopState();
    }

    @Override
    public void progressCompleted(Object source, String message) {
        if (source instanceof TierLoadThread) {
            this.showTierSelectionDialog();
            this.selTiersButton.setEnabled(true);
            this.loadTiersBar.setValue(0);
            this.loadTiersBar.setString("");
        } else {
            this.progressBar.setValue(100);
            this.progressBar.setString(message);
            if (this.command != null && this.command.getProcessReport() != null) {
                new ReportDialog((Dialog)this, this.command.getProcessReport()).setVisible(true);
            } else {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("Message.Complete"), "", 1);
            }
            this.enableUI(true);
            this.isRunning = false;
            this.startStopButton.setText(ElanLocale.getString("MultipleFileSearch.FindReplace"));
            this.progressBar.setValue(0);
            this.progressBar.setString("");
        }
    }

    @Override
    public void progressInterrupted(Object source, String message) {
        if (source instanceof TierLoadThread) {
            this.showTierSelectionDialog();
            this.selTiersButton.setEnabled(true);
            this.loadTiersBar.setValue(0);
            this.loadTiersBar.setString("");
        } else {
            this.progressBar.setString(message);
            this.showWarningDialog(ElanLocale.getString("MultipleFileSearch.FindReplace.Warn5"));
            if (this.command != null && this.command.getProcessReport() != null) {
                new ReportDialog((Dialog)this, this.command.getProcessReport()).setVisible(true);
            }
            this.enableUI(true);
            this.isRunning = false;
            this.startStopButton.setText(ElanLocale.getString("MultipleFileSearch.FindReplace"));
            this.progressBar.setValue(0);
            this.progressBar.setString("");
        }
    }

    @Override
    public void progressUpdated(Object source, int percent, String message) {
        if (source instanceof TierLoadThread) {
            this.loadTiersBar.setValue(percent);
            if (message != null) {
                this.loadTiersBar.setString(message);
            }
        } else if (percent == this.progressBar.getMaximum()) {
            this.progressCompleted(source, message);
        } else {
            this.progressBar.setValue(percent);
            this.progressBar.setString(message);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TierLoadThread
    extends Thread {
        List<String> loadedTierNames = null;

        public TierLoadThread(List<String> loadedTierNames) {
            this.loadedTierNames = loadedTierNames;
        }

        @Override
        public void run() {
            if (EAFMultipleFindReplaceDialog.this.searchFiles != null && EAFMultipleFindReplaceDialog.this.searchFiles.length != 0) {
                String fileName = null;
                float perFile = 100.0f / (float)EAFMultipleFindReplaceDialog.this.searchFiles.length;
                int count = 0;
                for (File file : EAFMultipleFindReplaceDialog.this.searchFiles) {
                    if (file == null) {
                        EAFMultipleFindReplaceDialog.this.progressUpdated(this, (int)((float)(++count) * perFile), null);
                        continue;
                    }
                    fileName = file.getAbsolutePath();
                    fileName = FileUtility.pathToURLString(fileName).substring(5);
                    try {
                        EAFSkeletonParser parser = new EAFSkeletonParser(fileName);
                        parser.parse();
                        ArrayList tiers = parser.getTiers();
                        for (int i = 0; i < tiers.size(); ++i) {
                            TierImpl tier = (TierImpl)tiers.get(i);
                            if (tier == null || this.loadedTierNames.contains(tier.getName())) continue;
                            this.loadedTierNames.add(tier.getName());
                        }
                    }
                    catch (ParseException pe) {
                        pe.printStackTrace();
                    }
                    EAFMultipleFindReplaceDialog.this.progressUpdated(this, (int)((float)(++count) * perFile), null);
                }
                EAFMultipleFindReplaceDialog.this.progressCompleted(this, null);
            }
        }
    }
}

