/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.svg;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import mpi.eudico.client.annotator.svg.GraphicNode2D;
import mpi.eudico.client.annotator.svg.GraphicTier2D;
import mpi.eudico.client.annotator.svg.SVGParserAndStore;
import mpi.eudico.client.annotator.viewer.AbstractViewer;
import mpi.eudico.client.annotator.viewer.MultiTierControlPanel;
import mpi.eudico.client.annotator.viewer.MultiTierViewer;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.SVGAlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.event.ACMEditEvent;
import mpi.eudico.server.corpora.event.ACMEditListener;

public abstract class AbstractSVGViewer
extends AbstractViewer
implements MultiTierViewer,
ACMEditListener {
    Transcription transcription;
    ArrayList allGraphicTiers;
    public final Color STROKE_COLOR = Color.red;

    public AbstractSVGViewer(Transcription transcription) {
        this.transcription = transcription;
        SVGParserAndStore.parse(transcription);
        this.allGraphicTiers = new ArrayList();
        this.initViewer();
    }

    void initViewer() {
        for (TierImpl tier : this.transcription.getTiers()) {
            GraphicTier2D tier2d = this.createTier2D(tier);
            if (tier2d == null) continue;
            this.allGraphicTiers.add(tier2d);
        }
    }

    GraphicTier2D createTier2D(TierImpl tier) {
        Annotation a;
        if (tier == null || tier.getLinguisticType() == null || !tier.getLinguisticType().hasGraphicReferences()) {
            return null;
        }
        GraphicTier2D tier2d = new GraphicTier2D(tier);
        Vector annotations = tier.getAnnotations();
        Iterator annIt = annotations.iterator();
        while (annIt.hasNext() && (a = (Annotation)annIt.next()) instanceof SVGAlignableAnnotation) {
            SVGAlignableAnnotation ann = (SVGAlignableAnnotation)a;
            if (ann.getShape() == null) continue;
            GraphicNode2D node2d = new GraphicNode2D(ann, ann.getShape());
            tier2d.insertNode(node2d);
        }
        return tier2d;
    }

    public void updateActiveAnnotation() {
    }

    public void setVisibleTiers(Vector tiers) {
        for (int i = 0; i < this.allGraphicTiers.size(); ++i) {
            GraphicTier2D tier2d = (GraphicTier2D)this.allGraphicTiers.get(i);
            if (tiers.contains(tier2d.getTier())) {
                tier2d.setVisible(true);
                continue;
            }
            tier2d.setVisible(false);
        }
        this.requestRepaint();
    }

    void tierAdded(TierImpl tier) {
        GraphicTier2D tier2d = this.createTier2D(tier);
        if (tier2d != null) {
            this.allGraphicTiers.add(tier2d);
            this.requestRepaint();
        }
    }

    void tierRemoved(TierImpl tier) {
        if (tier != null && tier.getLinguisticType() != null && tier.getLinguisticType().hasGraphicReferences()) {
            GraphicTier2D tier2d = null;
            for (int i = 0; i < this.allGraphicTiers.size(); ++i) {
                tier2d = (GraphicTier2D)this.allGraphicTiers.get(i);
                if (tier2d.getTier() != tier) continue;
                this.allGraphicTiers.remove(i);
                this.requestRepaint();
                return;
            }
        }
    }

    void annotationAdded(SVGAlignableAnnotation annotation) {
        if (annotation != null) {
            int mode = this.transcription.getTimeChangePropagationMode();
            if (mode != 2) {
                TierImpl tier = (TierImpl)annotation.getTier();
                Vector depTiers = tier.getDependentTiers();
                GraphicTier2D tier2d = null;
                for (int i = 0; i < this.allGraphicTiers.size(); ++i) {
                    tier2d = (GraphicTier2D)this.allGraphicTiers.get(i);
                    if (tier2d.getTier() != tier && !depTiers.contains(tier2d.getTier())) continue;
                    this.reextractNodesForTier2D(tier2d);
                }
            } else {
                this.transcriptionChanged();
                return;
            }
            this.requestRepaint();
        }
    }

    void transcriptionChanged() {
        Vector tiers = this.transcription.getTiers();
        for (int i = 0; i < this.allGraphicTiers.size(); ++i) {
            GraphicTier2D tier2d = (GraphicTier2D)this.allGraphicTiers.get(i);
            if (!tiers.contains(tier2d.getTier())) continue;
            this.reextractNodesForTier2D(tier2d);
        }
        this.requestRepaint();
    }

    void linguisticTypeChanged() {
        Vector tiers = this.transcription.getTiers();
        block0: for (int i = 0; i < tiers.size(); ++i) {
            GraphicTier2D tier2d;
            TierImpl tier = (TierImpl)tiers.get(i);
            LinguisticType type = tier.getLinguisticType();
            if (type != null && type.hasGraphicReferences()) {
                boolean alreadyThere = false;
                for (int j = 0; j < this.allGraphicTiers.size(); ++j) {
                    tier2d = (GraphicTier2D)this.allGraphicTiers.get(j);
                    if (tier2d.getTier() != tier) continue;
                    alreadyThere = true;
                    break;
                }
                if (alreadyThere) continue;
                this.tierAdded(tier);
                continue;
            }
            for (int j = 0; j < this.allGraphicTiers.size(); ++j) {
                tier2d = (GraphicTier2D)this.allGraphicTiers.get(j);
                if (tier2d.getTier() != tier) continue;
                this.allGraphicTiers.remove(j);
                this.requestRepaint();
                continue block0;
            }
        }
        this.requestRepaint();
    }

    void annotationTimeChanged(SVGAlignableAnnotation annotation) {
        if (annotation != null) {
            int mode = this.transcription.getTimeChangePropagationMode();
            if (mode != 2) {
                TierImpl tier = (TierImpl)annotation.getTier();
                Vector depTiers = tier.getDependentTiers();
                GraphicTier2D tier2d = null;
                for (int i = 0; i < this.allGraphicTiers.size(); ++i) {
                    tier2d = (GraphicTier2D)this.allGraphicTiers.get(i);
                    if (tier2d.getTier() != tier && !depTiers.contains(tier2d.getTier())) continue;
                    this.reextractNodesForTier2D(tier2d);
                }
            } else {
                this.transcriptionChanged();
                return;
            }
            this.requestRepaint();
        }
    }

    void annotationGraphicChanged(SVGAlignableAnnotation annotation) {
        if (annotation != null) {
            GraphicTier2D tier2d = null;
            for (int i = 0; i < this.allGraphicTiers.size() && (tier2d = (GraphicTier2D)this.allGraphicTiers.get(i)).getTier() != annotation.getTier(); ++i) {
            }
            if (tier2d != null) {
                int index = Collections.binarySearch(tier2d.getNodeList(), new Long(annotation.getBeginTimeBoundary()));
                if (index >= 0) {
                    GraphicNode2D node2d = (GraphicNode2D)tier2d.getNodeList().get(index);
                    if (node2d.getAnnotation() == annotation) {
                        if (annotation.getShape() == null) {
                            tier2d.removeNode(node2d);
                        } else {
                            node2d.setShape(annotation.getShape());
                        }
                        this.requestRepaint();
                    }
                } else if (annotation.getShape() != null) {
                    GraphicNode2D node2d = new GraphicNode2D(annotation, annotation.getShape());
                    tier2d.insertNode(node2d);
                    this.requestRepaint();
                }
            } else {
                tier2d = this.createTier2D((TierImpl)annotation.getTier());
                if (tier2d != null) {
                    this.allGraphicTiers.add(tier2d);
                    if (annotation.getShape() != null) {
                        GraphicNode2D node2d = new GraphicNode2D(annotation, annotation.getShape());
                        tier2d.insertNode(node2d);
                        this.requestRepaint();
                    }
                }
            }
        }
    }

    void reextractNodesForTier2D(GraphicTier2D tier2d) {
        if (tier2d == null || tier2d.getTier() == null) {
            return;
        }
        Vector annotations = tier2d.getTier().getAnnotations();
        tier2d.getNodeList().clear();
        for (SVGAlignableAnnotation ann : annotations) {
            if (ann.getShape() == null) continue;
            GraphicNode2D node2d = new GraphicNode2D(ann, ann.getShape());
            tier2d.insertNode(node2d);
        }
    }

    public void updateLocale() {
    }

    public void setActiveTier(Tier tier) {
    }

    public void setMultiTierControlPanel(MultiTierControlPanel controller) {
    }

    public void ACMEdited(ACMEditEvent e) {
        switch (e.getOperation()) {
            case 0: {
                if (!(e.getModification() instanceof TierImpl)) break;
                this.tierAdded((TierImpl)e.getModification());
                break;
            }
            case 1: {
                if (!(e.getModification() instanceof TierImpl)) break;
                this.tierRemoved((TierImpl)e.getModification());
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                if (!(e.getInvalidatedObject() instanceof TierImpl) || !(e.getModification() instanceof SVGAlignableAnnotation)) break;
                this.annotationAdded((SVGAlignableAnnotation)e.getModification());
                break;
            }
            case 14: {
                if (!(e.getInvalidatedObject() instanceof Transcription)) break;
                this.transcriptionChanged();
                break;
            }
            case 6: {
                if (e.getModification() instanceof Annotation || !(e.getInvalidatedObject() instanceof Transcription)) break;
                this.transcriptionChanged();
                break;
            }
            case 7: {
                if (!(e.getModification() instanceof SVGAlignableAnnotation)) break;
                this.annotationTimeChanged((SVGAlignableAnnotation)e.getModification());
                break;
            }
            case 10: 
            case 11: {
                this.linguisticTypeChanged();
                break;
            }
            case 12: {
                if (!(e.getModification() instanceof SVGAlignableAnnotation)) break;
                this.annotationGraphicChanged((SVGAlignableAnnotation)e.getModification());
                break;
            }
        }
    }

    public void controllerUpdate(ControllerEvent event) {
    }

    public void updateSelection() {
    }

    public void preferencesChanged() {
    }

    abstract void requestRepaint();

    abstract void paintAnnotations(Graphics2D var1);

    abstract void paintAnnotations();
}

