/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.svg;

import java.awt.Graphics2D;
import java.awt.Shape;
import mpi.eudico.client.annotator.svg.GraphicTier2D;
import mpi.eudico.server.corpora.clom.Annotation;

public class GraphicNode2D
implements Comparable {
    private Annotation annotation;
    private GraphicTier2D tier2d;
    private Shape shape;

    public GraphicNode2D(Annotation annotation, Shape shape) {
        this.annotation = annotation;
        this.shape = shape;
    }

    public void setTier2D(GraphicTier2D tier2d) {
        this.tier2d = tier2d;
    }

    public GraphicTier2D getTier2D() {
        return this.tier2d;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public void paintShape(Graphics2D g2d) {
        if (this.shape != null) {
            g2d.draw(this.shape);
        }
    }

    public void paintShape(Graphics2D g2d, boolean preserveStyle) {
        if (this.shape != null) {
            g2d.draw(this.shape);
        }
    }

    public void paintActiveMarker(Graphics2D g2d) {
        if (this.shape != null) {
            g2d.draw(this.shape.getBounds2D());
        }
    }

    public int compareTo(Object o) {
        if (o instanceof Long) {
            long time = (Long)o;
            return this.compareTo(time);
        }
        if (o instanceof Annotation) {
            Annotation other = (Annotation)o;
            return this.compareTo(other.getBeginTimeBoundary());
        }
        if (o instanceof GraphicNode2D) {
            return this.compareTo(((GraphicNode2D)o).getAnnotation());
        }
        return -1;
    }

    private int compareTo(long time) {
        if (time < this.annotation.getBeginTimeBoundary()) {
            return 1;
        }
        if (time >= this.annotation.getEndTimeBoundary()) {
            return -1;
        }
        return 0;
    }
}

