/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.svg;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.util.Collections;
import java.util.List;
import javax.media.renderer.VideoRenderer;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.player.JMFGraphicMediaPlayer;
import mpi.eudico.client.annotator.svg.AbstractSVGViewer;
import mpi.eudico.client.annotator.svg.GraphicNode2D;
import mpi.eudico.client.annotator.svg.GraphicTier2D;
import mpi.eudico.client.annotator.svg.JMFGraphicVideoRenderer;
import mpi.eudico.server.corpora.clom.Transcription;

public class JMFSVGViewer
extends AbstractSVGViewer {
    public JMFSVGViewer(Transcription transcription) {
        super(transcription);
    }

    public void paintAnnotations(Graphics2D big2d) {
        long time = this.getMediaTime();
        big2d.setStroke(new BasicStroke((float)(1.0 / big2d.getTransform().getScaleX())));
        for (int i = 0; i < this.allGraphicTiers.size(); ++i) {
            GraphicTier2D tier2d = (GraphicTier2D)this.allGraphicTiers.get(i);
            if (!tier2d.isVisible()) continue;
            GraphicNode2D node2d = null;
            int index = tier2d.getCurrentIndex();
            if (index > -1 && ((node2d = (GraphicNode2D)tier2d.getNodeList().get(index)).getAnnotation().getBeginTimeBoundary() > time || node2d.getAnnotation().getEndTimeBoundary() <= time)) {
                index = -1;
            }
            if (index == -1) {
                index = Collections.binarySearch(tier2d.getNodeList(), new Long(time));
                if (index >= 0) {
                    node2d = (GraphicNode2D)tier2d.getNodeList().get(index);
                    tier2d.setCurrentIndex(index);
                } else {
                    node2d = null;
                    tier2d.setCurrentIndex(-1);
                }
            }
            if (node2d == null) continue;
            big2d.setColor(this.STROKE_COLOR);
            node2d.paintShape(big2d, true);
            if (node2d.getAnnotation() != this.getActiveAnnotation()) continue;
            big2d.setColor(Constants.ACTIVEANNOTATIONCOLOR);
            node2d.paintActiveMarker(big2d);
        }
    }

    public void paintAnnotations() {
    }

    protected void requestRepaint() {
        VideoRenderer renderer;
        if (this.getViewerManager().getMasterMediaPlayer() instanceof JMFGraphicMediaPlayer && (renderer = ((JMFGraphicMediaPlayer)this.getViewerManager().getMasterMediaPlayer()).getRenderer()) != null && renderer instanceof JMFGraphicVideoRenderer) {
            ((JMFGraphicVideoRenderer)renderer).repaint();
        }
    }

    public void setVisibleTiers(List tiers) {
    }
}

