/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.svg;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.player.VideoFrameGrabber;
import mpi.eudico.client.annotator.svg.SVGParserAndStore;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.SVGAlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

public class SVGEditor
extends JDialog
implements ActionListener,
ItemListener {
    protected Rectangle dialogBounds;
    protected Transcription transcription;
    protected ViewerManager2 viewerManager;
    protected SVGAlignableAnnotation annotation;
    protected JInternalFrame libraryFrame;
    protected Hashtable iconTable;
    private Hashtable libTable = null;
    protected JList iconList;
    protected JInternalFrame editFrame;
    protected EditorPanel editorPanel;
    protected final Dimension iconDimension = new Dimension(26, 26);
    public final int[] ZOOMLEVELS = new int[]{50, 75, 100, 150, 200};
    public final Color STROKE_COLOR = Color.red;
    private int msPerFrame = 40;
    private long currentFrame = 0L;
    private JButton deleteButton;
    private JButton cutButton;
    private JButton copyButton;
    private JButton pasteButton;
    private JButton firstFrameButton;
    private JButton lastFrameButton;
    private JButton frameBackButton;
    private JButton frameForwardButton;
    private JToolBar statusBar;
    private JLabel xValue;
    private JLabel yValue;
    private JLabel wValue;
    private JLabel hValue;
    private JLabel dValue;
    private JLabel mxValue;
    private JLabel myValue;
    private NumberFormat numbFormat;

    public SVGEditor(Transcription transcription, SVGAlignableAnnotation annotation) {
        super((Frame)ELANCommandFactory.getRootFrame(transcription), true);
        this.annotation = annotation;
        this.transcription = transcription;
        this.loadPreferences();
        this.initDialog();
        this.setBounds(this.dialogBounds);
        this.setTitle(ElanLocale.getString("GraphicsEditor.Title"));
        this.setVisible(true);
    }

    protected void initDialog() {
        this.numbFormat = NumberFormat.getInstance();
        this.numbFormat.setMaximumFractionDigits(3);
        this.getContentPane().setLayout(new BorderLayout());
        this.setJMenuBar(this.createMenuBar());
        this.getContentPane().add((Component)this.createToolBar(), "North");
        this.getContentPane().add((Component)this.createDesktopPane(), "Center");
        this.getContentPane().add((Component)this.createStatusBar(), "South");
        this.initLibrary();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                SVGEditor.this.cancelEdit();
            }
        });
        this.updateToolBarShapeButtons();
        this.updateFramePositionButtons();
        this.updateObjectStatus();
    }

    protected JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu editMenu = new JMenu(ElanLocale.getString("Menu.Edit"));
        menuBar.add(editMenu);
        JMenuItem cancelMI = new JMenuItem(ElanLocale.getString("GraphicsEditor.Menu.Cancel"));
        cancelMI.addActionListener(this);
        cancelMI.setActionCommand("cancel");
        cancelMI.setAccelerator(KeyStroke.getKeyStroke(27, 0));
        editMenu.add(cancelMI);
        JMenuItem commitMI = new JMenuItem(ElanLocale.getString("GraphicsEditor.Menu.Commit"));
        commitMI.addActionListener(this);
        commitMI.setActionCommand("commit");
        commitMI.setAccelerator(KeyStroke.getKeyStroke(10, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        editMenu.add(commitMI);
        return menuBar;
    }

    protected JToolBar createToolBar() {
        JToolBar bar = new JToolBar(0);
        ImageIcon selIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/SelectTool16.gif"));
        ImageIcon rectIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/RectangleTool16.gif"));
        ImageIcon ovalIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/OvalTool16.gif"));
        ImageIcon lineIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/LineTool16.gif"));
        ImageIcon deleteIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Delete16.gif"));
        ImageIcon cutIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Cut16.gif"));
        ImageIcon copyIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Copy16.gif"));
        ImageIcon pasteIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Paste16.gif"));
        ImageIcon firstFrameIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/GoToPreviousScrollviewButton.gif"));
        ImageIcon lastFrameIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/GoToNextScrollviewButton.gif"));
        ImageIcon nextFrameIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/NextButton.gif"));
        ImageIcon prevFrameIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/PreviousButton.gif"));
        this.deleteButton = new JButton(deleteIcon);
        this.deleteButton.setActionCommand("delete");
        this.deleteButton.addActionListener(this);
        this.deleteButton.setEnabled(false);
        bar.add(this.deleteButton);
        bar.addSeparator();
        this.cutButton = new JButton(cutIcon);
        this.cutButton.setActionCommand("cut");
        this.cutButton.addActionListener(this);
        this.cutButton.setEnabled(false);
        bar.add(this.cutButton);
        this.copyButton = new JButton(copyIcon);
        this.copyButton.setActionCommand("copy");
        this.copyButton.addActionListener(this);
        this.copyButton.setEnabled(false);
        bar.add(this.copyButton);
        this.pasteButton = new JButton(pasteIcon);
        this.pasteButton.setActionCommand("paste");
        this.pasteButton.addActionListener(this);
        this.pasteButton.setEnabled(false);
        bar.add(this.pasteButton);
        bar.addSeparator();
        JToggleButton selButton = new JToggleButton(selIcon, true);
        selButton.setActionCommand("select");
        selButton.addActionListener(this);
        JToggleButton rectButton = new JToggleButton(rectIcon, false);
        rectButton.setActionCommand("recttool");
        rectButton.addActionListener(this);
        JToggleButton ovalButton = new JToggleButton(ovalIcon, false);
        ovalButton.setActionCommand("ovaltool");
        ovalButton.addActionListener(this);
        JToggleButton lineButton = new JToggleButton(lineIcon, false);
        lineButton.setActionCommand("linetool");
        lineButton.addActionListener(this);
        ButtonGroup toolGroup = new ButtonGroup();
        toolGroup.add(selButton);
        toolGroup.add(rectButton);
        toolGroup.add(ovalButton);
        toolGroup.add(lineButton);
        bar.add(selButton);
        bar.add(rectButton);
        bar.add(ovalButton);
        bar.add(lineButton);
        bar.addSeparator();
        this.firstFrameButton = new JButton(firstFrameIcon);
        this.firstFrameButton.setActionCommand("first");
        this.firstFrameButton.addActionListener(this);
        this.firstFrameButton.setEnabled(false);
        bar.add(this.firstFrameButton);
        this.frameBackButton = new JButton(prevFrameIcon);
        this.frameBackButton.setActionCommand("prev");
        this.frameBackButton.addActionListener(this);
        this.frameBackButton.setEnabled(false);
        bar.add(this.frameBackButton);
        this.frameForwardButton = new JButton(nextFrameIcon);
        this.frameForwardButton.setActionCommand("next");
        this.frameForwardButton.addActionListener(this);
        bar.add(this.frameForwardButton);
        this.lastFrameButton = new JButton(lastFrameIcon);
        this.lastFrameButton.setActionCommand("last");
        this.lastFrameButton.addActionListener(this);
        bar.add(this.lastFrameButton);
        bar.addSeparator();
        JPanel zoomPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(1, 3, 1, 3);
        gbc.anchor = 17;
        zoomPanel.add((Component)new JLabel(ElanLocale.getString("Menu.Zoom")), gbc);
        JComboBox zoomBox = new JComboBox();
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        for (int i = 0; i < this.ZOOMLEVELS.length; ++i) {
            model.addElement(this.ZOOMLEVELS[i] + "%");
        }
        model.setSelectedItem("100%");
        zoomBox.setModel(model);
        zoomBox.setPreferredSize(new Dimension(60, 24));
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        zoomPanel.add(zoomBox, gbc);
        zoomBox.addItemListener(this);
        bar.add(zoomPanel);
        return bar;
    }

    protected JToolBar createStatusBar() {
        this.statusBar = new JToolBar(0);
        this.statusBar.setFloatable(false);
        JPanel objStatusPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        Insets insets = new Insets(2, 2, 2, 2);
        gbc.gridx = 0;
        gbc.insets = insets;
        gbc.anchor = 17;
        JLabel xLabel = this.createLabel("X: ", null);
        objStatusPanel.add((Component)xLabel, gbc);
        int lw = xLabel.getFontMetrics(xLabel.getFont()).stringWidth("0000");
        Dimension labdim = new Dimension(lw, Constants.DEFAULTFONT.getSize() + 2);
        this.xValue = this.createLabel(null, labdim);
        ++gbc.gridx;
        objStatusPanel.add((Component)this.xValue, gbc);
        JLabel yLabel = this.createLabel("Y: ", null);
        this.yValue = this.createLabel(null, labdim);
        ++gbc.gridx;
        objStatusPanel.add((Component)yLabel, gbc);
        ++gbc.gridx;
        objStatusPanel.add((Component)this.yValue, gbc);
        JLabel wLabel = this.createLabel("W: ", null);
        ++gbc.gridx;
        objStatusPanel.add((Component)wLabel, gbc);
        this.wValue = this.createLabel(null, labdim);
        ++gbc.gridx;
        objStatusPanel.add((Component)this.wValue, gbc);
        JLabel hLabel = this.createLabel("H: ", null);
        ++gbc.gridx;
        objStatusPanel.add((Component)hLabel, gbc);
        this.hValue = this.createLabel(null, labdim);
        ++gbc.gridx;
        objStatusPanel.add((Component)this.hValue, gbc);
        JLabel dLabel = this.createLabel("D: ", null);
        ++gbc.gridx;
        objStatusPanel.add((Component)dLabel, gbc);
        this.dValue = this.createLabel(null, labdim);
        this.dValue.setPreferredSize(new Dimension(labdim.width * 2, labdim.height));
        ++gbc.gridx;
        objStatusPanel.add((Component)this.dValue, gbc);
        JPanel sep = new JPanel();
        Dimension sepSize = new Dimension(10, labdim.height);
        sep.setPreferredSize(sepSize);
        sep.setMinimumSize(sepSize);
        ++gbc.gridx;
        objStatusPanel.add((Component)sep, gbc);
        JLabel mxLabel = this.createLabel("MX: ", null);
        this.mxValue = this.createLabel(null, labdim);
        JLabel myLabel = this.createLabel("MY: ", null);
        this.myValue = this.createLabel(null, labdim);
        ++gbc.gridx;
        objStatusPanel.add((Component)mxLabel, gbc);
        ++gbc.gridx;
        objStatusPanel.add((Component)this.mxValue, gbc);
        ++gbc.gridx;
        objStatusPanel.add((Component)myLabel, gbc);
        ++gbc.gridx;
        objStatusPanel.add((Component)this.myValue, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        objStatusPanel.add((Component)new JPanel(), gbc);
        this.statusBar.add(objStatusPanel);
        return this.statusBar;
    }

    protected JLabel createLabel(String s, Dimension dim) {
        JLabel l = new JLabel(s);
        l.setFont(Constants.DEFAULTFONT);
        if (dim != null) {
            l.setPreferredSize(dim);
            l.setMinimumSize(dim);
        }
        return l;
    }

    protected JDesktopPane createDesktopPane() {
        JDesktopPane desktop = new JDesktopPane();
        desktop.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
        this.editFrame = new JInternalFrame("", true);
        desktop.add(this.editFrame);
        Object rect = Preferences.get("EditorIFrameBounds", null);
        if (rect != null) {
            this.editFrame.setBounds((Rectangle)rect);
        } else {
            this.editFrame.setBounds(0, 0, 350, 350);
        }
        this.editorPanel = new EditorPanel(this.grabFirstFrameImage(), this.annotation.getShape());
        JScrollPane scrollPane = new JScrollPane(this.editorPanel);
        this.editFrame.getContentPane().add(scrollPane);
        this.editFrame.setVisible(true);
        return desktop;
    }

    protected void initLibrary() {
        Object o = SVGParserAndStore.getLibrary(this.transcription);
        if (o instanceof Hashtable) {
            this.libTable = (Hashtable)o;
        }
        if (this.libTable != null && this.libTable.size() > 0) {
            BufferedImage iconImg = null;
            Graphics2D g2d = null;
            this.iconTable = new Hashtable(this.libTable.size());
            Enumeration keys = this.libTable.keys();
            while (keys.hasMoreElements()) {
                String id = (String)keys.nextElement();
                Shape shape = (Shape)this.libTable.get(id);
                if (shape == null) continue;
                iconImg = new BufferedImage(this.iconDimension.width, this.iconDimension.height, 1);
                g2d = iconImg.createGraphics();
                g2d.setColor(Color.white);
                g2d.fillRect(0, 0, this.iconDimension.width, this.iconDimension.height);
                Rectangle2D bounds = shape.getBounds2D();
                float scaleX = (float)((double)(this.iconDimension.width - 6) / bounds.getWidth());
                float scaleY = (float)((double)(this.iconDimension.height - 6) / bounds.getHeight());
                float scale = scaleX >= scaleY ? scaleY : scaleX;
                float realIconWidth = (float)((double)scale * bounds.getWidth());
                float realIconHeight = (float)((double)scale * bounds.getHeight());
                float transX = (float)(-bounds.getX() + (double)(((float)(this.iconDimension.width - 6) - realIconWidth) / 2.0f));
                float transY = (float)(-bounds.getY() + (double)(((float)(this.iconDimension.height - 6) - realIconHeight) / 2.0f));
                AffineTransform at = AffineTransform.getTranslateInstance(3.0f + transX, 3.0f + transY);
                at.scale(scale, scale);
                g2d.setTransform(at);
                g2d.setColor(this.STROKE_COLOR);
                g2d.draw(shape);
                ImageIcon icon = new ImageIcon(iconImg);
                if (icon == null) continue;
                this.iconTable.put(id, icon);
            }
            this.iconList = new JList<Object>(this.iconTable.keySet().toArray());
            this.iconList.setFixedCellHeight(this.iconDimension.height + 4);
            this.iconList.setDragEnabled(true);
            this.iconList.setCellRenderer(new LibraryIconRenderer());
            this.iconList.setSelectionMode(0);
            this.iconList.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent me) {
                    Object o;
                    if (me.getClickCount() > 1 && me.getSource() == SVGEditor.this.iconList && (o = SVGEditor.this.iconList.getSelectedValue()) instanceof String && SVGEditor.this.editorPanel != null) {
                        SVGEditor.this.editorPanel.addGraphicAnnotation((String)o);
                    }
                }
            });
        }
        if (this.iconList != null) {
            JScrollPane iconPane = new JScrollPane(this.iconList);
            this.libraryFrame.getContentPane().add(iconPane);
        }
    }

    protected Image grabFirstFrameImage() {
        ElanMediaPlayer player = ELANCommandFactory.getViewerManager(this.transcription).getMasterMediaPlayer();
        if (player instanceof VideoFrameGrabber) {
            return ((VideoFrameGrabber)((Object)player)).getCurrentFrameImage();
        }
        return null;
    }

    protected Image getFrameForTime(long time) {
        ElanMediaPlayer player = ELANCommandFactory.getViewerManager(this.transcription).getMasterMediaPlayer();
        if (player instanceof VideoFrameGrabber) {
            return ((VideoFrameGrabber)((Object)player)).getFrameImageForTime(time);
        }
        return null;
    }

    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command.equals("cancel")) {
            this.cancelEdit();
        } else if (command.equals("commit")) {
            this.commitEdit();
        } else if (command.equals("delete")) {
            if (this.editorPanel != null) {
                this.editorPanel.setShape(null);
                this.updateToolBarShapeButtons();
            }
        } else if (command.equals("cut")) {
            this.cut();
        } else if (command.equals("copy")) {
            this.copy();
        } else if (command.equals("paste")) {
            this.paste();
        } else if (command.equals("select")) {
            if (this.editorPanel != null) {
                this.editorPanel.setToolMode(0);
            }
        } else if (command.equals("recttool")) {
            if (this.editorPanel != null) {
                this.editorPanel.setToolMode(1);
            }
        } else if (command.equals("ovaltool")) {
            if (this.editorPanel != null) {
                this.editorPanel.setToolMode(2);
            }
        } else if (command.equals("linetool")) {
            if (this.editorPanel != null) {
                this.editorPanel.setToolMode(3);
            }
        } else if (command.equals("next")) {
            if (this.editorPanel != null) {
                this.nextFrame();
            }
        } else if (command.equals("prev")) {
            if (this.editorPanel != null) {
                this.previousFrame();
            }
        } else if (command.equals("first")) {
            if (this.editorPanel != null) {
                this.firstFrame();
            }
        } else if (command.equals("last") && this.editorPanel != null) {
            this.lastFrame();
        }
    }

    public void itemStateChanged(ItemEvent ie) {
        if (ie.getStateChange() == 1) {
            String zoomString = (String)ie.getItem();
            int index = zoomString.indexOf(37);
            if (index > 0) {
                zoomString = zoomString.substring(0, index);
            }
            int zoom = 100;
            try {
                zoom = Integer.parseInt(zoomString);
            }
            catch (NumberFormatException nfe) {
                System.err.println("Error parsing the zoom level");
            }
            if (this.editorPanel != null) {
                this.editorPanel.setZoom(zoom);
            }
        }
    }

    public void updateToolBarShapeButtons() {
        if (this.editorPanel != null) {
            if (this.editorPanel.getShape() != null) {
                this.deleteButton.setEnabled(true);
                this.cutButton.setEnabled(true);
                this.copyButton.setEnabled(true);
            } else {
                this.deleteButton.setEnabled(false);
                this.cutButton.setEnabled(false);
                this.copyButton.setEnabled(false);
            }
            if (this.getClipboardContents() instanceof Shape) {
                this.pasteButton.setEnabled(true);
            } else {
                this.pasteButton.setEnabled(false);
            }
        }
    }

    public void updateObjectStatus() {
        if (this.editorPanel != null) {
            if (this.editorPanel.getShape() != null) {
                Shape s = this.editorPanel.getShape();
                this.xValue.setText("" + s.getBounds().x);
                this.yValue.setText("" + s.getBounds().y);
                this.wValue.setText("" + s.getBounds().width);
                this.hValue.setText("" + s.getBounds().height);
                double d = Math.sqrt(Math.pow(s.getBounds().width, 2.0) + Math.pow(s.getBounds().height, 2.0));
                this.dValue.setText("" + this.numbFormat.format(d));
            } else {
                this.xValue.setText(null);
                this.yValue.setText(null);
                this.wValue.setText(null);
                this.hValue.setText(null);
                this.dValue.setText(null);
            }
        }
    }

    public void updateMouseStatus(int xPos, int yPos) {
        this.mxValue.setText("" + xPos);
        this.myValue.setText("" + yPos);
    }

    protected void updateFramePositionButtons() {
        if (this.currentFrame == this.annotation.getBeginTimeBoundary() / (long)this.msPerFrame) {
            this.firstFrameButton.setEnabled(false);
            this.frameBackButton.setEnabled(false);
            this.frameForwardButton.setEnabled(true);
            this.lastFrameButton.setEnabled(true);
        } else {
            this.firstFrameButton.setEnabled(true);
            this.frameBackButton.setEnabled(true);
            if (this.currentFrame == (this.annotation.getEndTimeBoundary() - 1L) / (long)this.msPerFrame) {
                this.frameForwardButton.setEnabled(false);
                this.lastFrameButton.setEnabled(false);
            } else {
                this.frameForwardButton.setEnabled(true);
                this.lastFrameButton.setEnabled(true);
            }
        }
    }

    private void nextFrame() {
        long next = this.currentFrame + 1L;
        long time = next * (long)this.msPerFrame;
        if (time >= this.annotation.getBeginTimeBoundary() && time < this.annotation.getEndTimeBoundary()) {
            Image nextImage = this.getFrameForTime(time);
            ++this.currentFrame;
            if (this.editorPanel != null) {
                this.editorPanel.setImage(nextImage);
            }
        }
        this.updateFramePositionButtons();
    }

    private void previousFrame() {
        long prev = this.currentFrame - 1L;
        long time = prev * (long)this.msPerFrame;
        if (time >= this.annotation.getBeginTimeBoundary() && time < this.annotation.getEndTimeBoundary()) {
            Image prevImage = this.getFrameForTime(time);
            --this.currentFrame;
            if (this.editorPanel != null) {
                this.editorPanel.setImage(prevImage);
            }
        }
        this.updateFramePositionButtons();
    }

    private void firstFrame() {
        Image firstImage = this.getFrameForTime(this.annotation.getBeginTimeBoundary());
        this.currentFrame = this.annotation.getBeginTimeBoundary() / (long)this.msPerFrame;
        if (this.editorPanel != null) {
            this.editorPanel.setImage(firstImage);
        }
        this.updateFramePositionButtons();
    }

    private void lastFrame() {
        Image lastImage = this.getFrameForTime(this.annotation.getEndTimeBoundary());
        this.currentFrame = (this.annotation.getEndTimeBoundary() - 1L) / (long)this.msPerFrame;
        if (this.editorPanel != null) {
            this.editorPanel.setImage(lastImage);
        }
        this.updateFramePositionButtons();
    }

    private void cut() {
        Shape s;
        if (this.editorPanel != null && this.canAccessSystemClipboard() && (s = this.editorPanel.getShape()) != null) {
            ShapeTransferable st = new ShapeTransferable(s, this.editorPanel);
            Clipboard board = this.getToolkit().getSystemClipboard();
            board.setContents(st, null);
            this.editorPanel.setShape(null);
            this.updateToolBarShapeButtons();
        }
    }

    private void copy() {
        Shape s;
        if (this.editorPanel != null && this.canAccessSystemClipboard() && (s = this.editorPanel.getShape()) != null) {
            Shape copy = null;
            if (s instanceof RectangularShape) {
                copy = (Shape)((RectangularShape)s).clone();
            } else if (s instanceof GeneralPath) {
                copy = (Shape)((GeneralPath)s).clone();
            }
            if (copy != null) {
                ShapeTransferable st = new ShapeTransferable(copy, this.editorPanel);
                Clipboard board = this.getToolkit().getSystemClipboard();
                board.setContents(st, null);
                this.updateToolBarShapeButtons();
            }
        }
    }

    private void paste() {
        if (this.editorPanel != null) {
            Object contents = this.getClipboardContents();
            if (contents instanceof Shape) {
                this.editorPanel.setShape((Shape)contents);
            }
            this.updateToolBarShapeButtons();
        }
    }

    protected boolean canAccessSystemClipboard() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkSystemClipboardAccess();
                return true;
            }
            catch (SecurityException se) {
                se.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private Object getClipboardContents() {
        if (this.canAccessSystemClipboard()) {
            Transferable t = this.getToolkit().getSystemClipboard().getContents(null);
            try {
                DataFlavor df = new DataFlavor("application/x-java-jvm-local-objectref;class=" + Shape.class.getName());
                return t.getTransferData(df);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected void cancelEdit() {
        this.savePreferences();
        this.setVisible(false);
        this.dispose();
    }

    protected void commitEdit() {
        Shape shape = this.editorPanel.getShape();
        Command c = ELANCommandFactory.createCommand(this.transcription, "Menu.Annotation.ModifyGraphicAnnotation");
        c.execute(this.annotation, new Object[]{shape});
        this.savePreferences();
        this.setVisible(false);
        this.dispose();
    }

    protected void loadPreferences() {
        this.dialogBounds = (Rectangle)Preferences.get("GraphicsEditorBounds", null);
        if (this.dialogBounds == null) {
            Window owner = this.getOwner();
            if (owner != null) {
                Dimension dim = owner.getSize();
                Point loc = owner.getLocation();
                this.dialogBounds = new Rectangle(loc.x + dim.width / 4, loc.y + dim.height / 4, dim.width / 2, dim.height / 2);
            } else {
                this.dialogBounds = new Rectangle(0, 0, 600, 500);
            }
        }
    }

    protected void savePreferences() {
        Preferences.set("GraphicsEditorBounds", this.getBounds(), null);
        if (this.libraryFrame != null) {
            Preferences.set("LibraryIFrameBounds", this.libraryFrame.getBounds(), null);
        }
        if (this.editFrame != null) {
            Preferences.set("EditorIFrameBounds", this.editFrame.getBounds(), null);
        }
    }

    protected class ShapeTransferable
    implements Transferable {
        JComponent component;
        Shape shape;

        ShapeTransferable(Shape shape, JComponent component) {
            this.shape = shape;
            this.component = component;
        }

        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] flavors = new DataFlavor[1];
            Class<?> shapeType = this.shape.getClass();
            String mimeType = "application/x-java-jvm-local-objectref;class=" + shapeType.getName();
            try {
                flavors[0] = new DataFlavor(mimeType);
            }
            catch (ClassNotFoundException cnfe) {
                flavors = new DataFlavor[]{};
            }
            return flavors;
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            Class<?> shapeType = this.shape.getClass();
            return "application".equals(flavor.getPrimaryType()) && "x-java-jvm-local-objectref".equals(flavor.getSubType()) && flavor.getRepresentationClass().isAssignableFrom(shapeType);
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.shape;
        }
    }

    protected class IDTransferHandler
    extends TransferHandler {
        protected IDTransferHandler() {
        }

        public boolean importData(JComponent c, Transferable t) {
            if (this.canImport(c, t.getTransferDataFlavors())) {
                try {
                    Object o = t.getTransferData(DataFlavor.stringFlavor);
                    if (o instanceof String && c instanceof EditorPanel) {
                        ((EditorPanel)c).addGraphicAnnotation((String)o);
                        return true;
                    }
                }
                catch (UnsupportedFlavorException ufe) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return false;
        }

        public boolean canImport(JComponent c, DataFlavor[] flavors) {
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].equals(DataFlavor.stringFlavor)) continue;
                return true;
            }
            return false;
        }
    }

    protected class EditorPanel
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        public static final int SELECT_TOOL = 0;
        public static final int RECT_TOOL = 1;
        public static final int ELLIPSE_TOOL = 2;
        public static final int LINE_TOOL = 3;
        public static final int MOVE_TOOL = 10;
        public static final int MOVE_POINT_TOOL = 11;
        public static final int RESIZE_NW_TOOL = 20;
        public static final int RESIZE_N_TOOL = 21;
        public static final int RESIZE_NE_TOOL = 22;
        public static final int RESIZE_E_TOOL = 23;
        public static final int RESIZE_SE_TOOL = 24;
        public static final int RESIZE_S_TOOL = 25;
        public static final int RESIZE_SW_TOOL = 26;
        public static final int RESIZE_W_TOOL = 27;
        protected Image image;
        protected BufferedImage compoundImg;
        protected Graphics2D comG2d;
        protected final AlphaComposite alpha = AlphaComposite.getInstance(3, 0.5f);
        private final BasicStroke selectionStroke = new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{2.0f, 3.0f}, 1.0f);
        private int zoom = 100;
        private float zoomFactor = 1.0f;
        private AffineTransform trans = new AffineTransform();
        protected Shape currentShape;
        protected Shape copyShape;
        protected Rectangle2D bBox;
        protected Polygon lineBox;
        protected Rectangle2D[] corners;
        private final int MARKER_SIZE = 6;
        private final int MIN_RESIZE_SIZE = 8;
        private Rectangle editRect;
        private Point editPoint;
        private boolean dragging = false;
        private Point dragStart;
        private Rectangle2D resizeStartRect;
        private int toolMode = 0;
        private int toolSubMode = 10;

        public EditorPanel() {
            this.setBackground(Color.white);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.setTransferHandler(new IDTransferHandler());
            this.editRect = new Rectangle();
            this.corners = new Rectangle2D[]{new Rectangle(0, 0, 6, 6), new Rectangle(0, 0, 6, 6), new Rectangle(0, 0, 6, 6), new Rectangle(0, 0, 6, 6)};
        }

        public EditorPanel(Image image, Shape shape) {
            this();
            this.setImage(image);
            this.currentShape = shape;
            this.setShape(shape);
        }

        public void setImage(Image image) {
            this.image = image;
            if (image != null) {
                this.setPreferredSize(new Dimension((int)((float)image.getWidth(null) * this.zoomFactor), (int)((float)image.getHeight(null) * this.zoomFactor)));
                this.editRect.setRect(0.0, 0.0, this.getPreferredSize().width, this.getPreferredSize().height);
            }
            this.paintBuffer();
        }

        protected void paintBuffer() {
            if (this.compoundImg == null || this.compoundImg.getWidth() != this.getPreferredSize().width) {
                this.compoundImg = new BufferedImage(this.getPreferredSize().width, this.getPreferredSize().height, 1);
                this.comG2d = this.compoundImg.createGraphics();
                this.comG2d.scale(this.zoomFactor, this.zoomFactor);
            }
            if (this.image != null) {
                this.comG2d.drawImage(this.image, 0, 0, this);
            }
            this.comG2d.setComposite(this.alpha);
            this.comG2d.setColor(SVGEditor.this.STROKE_COLOR);
            long currentFrameTime = SVGEditor.this.currentFrame * (long)SVGEditor.this.msPerFrame;
            block0: for (TierImpl tier : SVGEditor.this.transcription.getTiers()) {
                if (tier == SVGEditor.this.annotation.getTier() || tier.getLinguisticType() == null || !tier.getLinguisticType().hasGraphicReferences()) continue;
                Vector anns = tier.getAnnotations();
                for (Annotation a : anns) {
                    if (currentFrameTime > -1L) {
                        if (a.getBeginTimeBoundary() > currentFrameTime || a.getEndTimeBoundary() <= currentFrameTime || ((SVGAlignableAnnotation)a).getShape() == null) continue;
                        this.comG2d.draw(((SVGAlignableAnnotation)a).getShape());
                        continue block0;
                    }
                    if (a.getBeginTimeBoundary() > SVGEditor.this.annotation.getBeginTimeBoundary() || a.getEndTimeBoundary() <= SVGEditor.this.annotation.getBeginTimeBoundary() || ((SVGAlignableAnnotation)a).getShape() == null) continue;
                    this.comG2d.draw(((SVGAlignableAnnotation)a).getShape());
                    continue block0;
                }
            }
            this.comG2d.setComposite(AlphaComposite.Src);
            this.repaint();
        }

        public Image getImage() {
            return this.image;
        }

        public void paintComponent(Graphics g) {
            block4: {
                Graphics2D g2d;
                block5: {
                    super.paintComponent(g);
                    g2d = (Graphics2D)g;
                    if (this.compoundImg != null) {
                        g2d.drawImage((Image)this.compoundImg, 0, 0, this);
                    }
                    if (this.copyShape == null) break block4;
                    g2d.setColor(SVGEditor.this.STROKE_COLOR);
                    g2d.scale(this.zoomFactor, this.zoomFactor);
                    g2d.draw(this.copyShape);
                    if (this.bBox == null) break block4;
                    g2d.setColor(Constants.ACTIVEANNOTATIONCOLOR);
                    g2d.setStroke(this.createScaledStroke());
                    if (!(this.copyShape instanceof Line2D)) break block5;
                    if (this.dragging) break block4;
                    for (int i = 0; i < this.corners.length; ++i) {
                        if (!this.corners[i].contains(((Line2D)this.copyShape).getP1()) && !this.corners[i].contains(((Line2D)this.copyShape).getP2())) continue;
                        g2d.fill(this.corners[i]);
                    }
                    break block4;
                }
                g2d.draw(this.bBox);
                if (!this.dragging) {
                    for (int i = 0; i < this.corners.length; ++i) {
                        g2d.fill(this.corners[i]);
                    }
                }
            }
        }

        public void setShape(Shape shape) {
            if (shape != null) {
                if (shape instanceof RectangularShape) {
                    this.copyShape = (RectangularShape)((RectangularShape)shape).clone();
                } else if (shape instanceof GeneralPath) {
                    this.copyShape = (GeneralPath)((GeneralPath)shape).clone();
                } else if (shape instanceof Line2D) {
                    this.copyShape = (Line2D)((Line2D)shape).clone();
                    this.adjustActiveLineArea();
                }
                if (this.copyShape != null) {
                    this.bBox = this.copyShape.getBounds2D();
                    this.adjustAnchors();
                }
            } else {
                this.copyShape = null;
                this.bBox = null;
            }
            this.repaint();
            SVGEditor.this.updateObjectStatus();
        }

        public Shape getShape() {
            return this.copyShape;
        }

        public void addGraphicAnnotation(String id) {
            Shape s;
            if (SVGEditor.this.libTable != null && (s = (Shape)SVGEditor.this.libTable.get(id)) != null) {
                this.setShape(s);
                if (this.copyShape != null) {
                    double w = this.copyShape.getBounds().getWidth();
                    double h = this.copyShape.getBounds().getHeight();
                    if (this.copyShape instanceof RectangularShape) {
                        ((RectangularShape)this.copyShape).setFrame((double)(this.image.getWidth(null) / 2) - w / 2.0, (double)(this.image.getHeight(null) / 2) - h / 2.0, w, h);
                        this.bBox.setRect(this.copyShape.getBounds2D());
                        this.adjustAnchors();
                    } else if (this.copyShape instanceof Line2D) {
                        int wi = this.image.getWidth(null);
                        int he = this.image.getHeight(null);
                        ((Line2D)this.copyShape).setLine(wi / 2 - wi / 4, he / 2 - he / 4, wi / 2 + wi / 4, he / 2 + he / 4);
                        this.adjustActiveLineArea();
                    }
                    SVGEditor.this.updateObjectStatus();
                }
            }
        }

        public int getZoom() {
            return this.zoom;
        }

        public void setZoom(int zoom) {
            this.zoom = zoom;
            this.zoomFactor = (float)zoom / 100.0f;
            this.trans.scale(this.zoomFactor, this.zoomFactor);
            this.setPreferredSize(new Dimension((int)((float)this.image.getWidth(null) * this.zoomFactor), (int)((float)this.image.getHeight(null) * this.zoomFactor)));
            this.editRect.setRect(0.0, 0.0, this.getPreferredSize().width, this.getPreferredSize().height);
            this.paintBuffer();
            this.revalidate();
        }

        public void setToolMode(int mode) {
            this.toolMode = mode;
        }

        public int getToolMode() {
            return this.toolMode;
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent me) {
            Point p = me.getPoint();
            p.x = (int)((float)p.x / this.zoomFactor);
            p.y = (int)((float)p.y / this.zoomFactor);
            this.dragStart = p;
            this.dragging = true;
            block0 : switch (this.toolMode) {
                case 0: {
                    if (this.bBox == null) break;
                    block6 : switch (this.toolSubMode) {
                        case 10: {
                            if (this.copyShape instanceof RectangularShape) {
                                if (this.bBox.contains(p)) break;
                                this.dragging = false;
                                break;
                            }
                            if (!(this.copyShape instanceof Line2D) || this.lineBox.contains(p)) break;
                            this.dragging = false;
                            break;
                        }
                        case 11: {
                            if (!(this.copyShape instanceof Line2D)) break;
                            Point2D p1 = ((Line2D)this.copyShape).getP1();
                            Point2D p2 = ((Line2D)this.copyShape).getP2();
                            for (int i = 0; i < this.corners.length; ++i) {
                                if (this.corners[i].contains(p) && this.corners[i].contains(p1)) {
                                    this.editPoint = new Point((int)p1.getX(), (int)p1.getY());
                                    break block6;
                                }
                                if (!this.corners[i].contains(p) || !this.corners[i].contains(p2)) continue;
                                this.editPoint = new Point((int)p2.getX(), (int)p2.getY());
                                break block6;
                            }
                            break block0;
                        }
                        default: {
                            this.resizeStartRect = (Rectangle2D)this.bBox.clone();
                            break;
                        }
                    }
                    break;
                }
                case 1: {
                    if (!this.editRect.contains(me.getPoint())) break;
                    this.copyShape = new Rectangle(p.x, p.y, 1, 1);
                    this.bBox = this.copyShape.getBounds2D();
                    SVGEditor.this.updateToolBarShapeButtons();
                    break;
                }
                case 2: {
                    if (!this.editRect.contains(me.getPoint())) break;
                    this.copyShape = new Ellipse2D.Float(p.x, p.y, 1.0f, 1.0f);
                    this.bBox = this.copyShape.getBounds2D();
                    SVGEditor.this.updateToolBarShapeButtons();
                    break;
                }
                case 3: {
                    if (!this.editRect.contains(me.getPoint())) break;
                    this.copyShape = new Line2D.Float(p.x, p.y, p.x + 1, p.y + 1);
                    this.bBox = this.copyShape.getBounds2D();
                    this.adjustActiveLineArea();
                    SVGEditor.this.updateToolBarShapeButtons();
                    break;
                }
            }
            SVGEditor.this.updateObjectStatus();
            SVGEditor.this.updateMouseStatus(p.x, p.y);
        }

        public void mouseReleased(MouseEvent me) {
            this.adjustAnchors();
            this.adjustActiveLineArea();
            this.dragging = false;
            this.setCursor(Cursor.getDefaultCursor());
            this.repaint();
            SVGEditor.this.updateObjectStatus();
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
            SVGEditor.this.updateMouseStatus(0, 0);
        }

        public void mouseDragged(MouseEvent me) {
            boolean shiftDown = me.isShiftDown();
            if (this.dragging) {
                Point p = me.getPoint();
                p.x = (int)((float)p.x / this.zoomFactor);
                p.y = (int)((float)p.y / this.zoomFactor);
                if (this.editRect.contains(me.getPoint())) {
                    switch (this.toolMode) {
                        case 0: {
                            if (this.bBox == null) break;
                            int xdif = p.x - this.dragStart.x;
                            int ydif = p.y - this.dragStart.y;
                            switch (this.toolSubMode) {
                                case 10: {
                                    this.dragMoveShape(p, xdif, ydif, shiftDown);
                                    break;
                                }
                                case 20: {
                                    this.dragResizeNW(xdif, ydif, shiftDown);
                                    break;
                                }
                                case 22: {
                                    this.dragResizeNE(xdif, ydif, shiftDown);
                                    break;
                                }
                                case 24: {
                                    this.dragResizeSE(xdif, ydif, shiftDown);
                                    break;
                                }
                                case 26: {
                                    this.dragResizeSW(xdif, ydif, shiftDown);
                                    break;
                                }
                                case 11: {
                                    this.dragLinePoint(p, shiftDown);
                                }
                            }
                            break;
                        }
                        case 1: 
                        case 2: {
                            this.dragCreateShape(p, shiftDown);
                            break;
                        }
                        case 3: {
                            this.dragCreateLine(p, shiftDown);
                        }
                    }
                }
                SVGEditor.this.updateMouseStatus(p.x, p.y);
            }
            SVGEditor.this.updateObjectStatus();
        }

        public void mouseMoved(MouseEvent me) {
            if (!this.dragging) {
                Point p = me.getPoint();
                p.x = (int)((float)p.x / this.zoomFactor);
                p.y = (int)((float)p.y / this.zoomFactor);
                SVGEditor.this.updateMouseStatus(p.x, p.y);
                if (this.toolMode == 0) {
                    if (this.copyShape instanceof RectangularShape) {
                        if (this.bBox != null) {
                            if (this.corners[0].contains(p)) {
                                this.setCursor(Cursor.getPredefinedCursor(6));
                                this.toolSubMode = 20;
                                return;
                            }
                            if (this.corners[1].contains(p)) {
                                this.setCursor(Cursor.getPredefinedCursor(7));
                                this.toolSubMode = 22;
                                return;
                            }
                            if (this.corners[2].contains(p)) {
                                this.setCursor(Cursor.getPredefinedCursor(5));
                                this.toolSubMode = 24;
                                return;
                            }
                            if (this.corners[3].contains(p)) {
                                this.setCursor(Cursor.getPredefinedCursor(4));
                                this.toolSubMode = 26;
                                return;
                            }
                            if (this.bBox.contains(p)) {
                                this.setCursor(Cursor.getPredefinedCursor(13));
                            } else {
                                this.setCursor(Cursor.getDefaultCursor());
                            }
                            this.toolSubMode = 10;
                            return;
                        }
                    } else if (this.copyShape instanceof Line2D) {
                        Point2D p1 = ((Line2D)this.copyShape).getP1();
                        Point2D p2 = ((Line2D)this.copyShape).getP2();
                        for (int i = 0; i < this.corners.length; ++i) {
                            if (!this.corners[i].contains(p) || !this.corners[i].contains(p1) && !this.corners[i].contains(p2)) continue;
                            this.setCursor(Cursor.getPredefinedCursor(13));
                            this.toolSubMode = 11;
                            return;
                        }
                        if (this.lineBox.contains(p)) {
                            this.setCursor(Cursor.getPredefinedCursor(13));
                            this.toolSubMode = 10;
                            return;
                        }
                    }
                    this.setCursor(Cursor.getDefaultCursor());
                    this.toolSubMode = 10;
                }
            }
        }

        private BasicStroke createScaledStroke() {
            if (this.zoomFactor == 1.0f) {
                return this.selectionStroke;
            }
            return new BasicStroke(1.0f / this.zoomFactor, this.selectionStroke.getEndCap(), this.selectionStroke.getLineJoin(), this.selectionStroke.getMiterLimit(), this.selectionStroke.getDashArray(), 1.0f);
        }

        private void adjustAnchors() {
            if (this.bBox != null) {
                this.corners[0].setRect(this.bBox.getMinX() - 3.0, this.bBox.getMinY() - 3.0, 6.0, 6.0);
                this.corners[1].setRect(this.bBox.getMaxX() - 3.0, this.bBox.getMinY() - 3.0, 6.0, 6.0);
                this.corners[2].setRect(this.bBox.getMaxX() - 3.0, this.bBox.getMaxY() - 3.0, 6.0, 6.0);
                this.corners[3].setRect(this.bBox.getMinX() - 3.0, this.bBox.getMaxY() - 3.0, 6.0, 6.0);
            }
        }

        private void adjustActiveLineArea() {
            if (this.copyShape instanceof Line2D) {
                Point2D p1 = ((Line2D)this.copyShape).getP1();
                Point2D p2 = ((Line2D)this.copyShape).getP2();
                double w = p1.getX() - p2.getX();
                double h = p1.getY() - p2.getY();
                double f = 0.0;
                f = w == 0.0 || h == 0.0 ? 1.0 : h / w;
                Rectangle2D.Double r1 = new Rectangle2D.Double(p1.getX() - 6.0, p1.getY() - 6.0, 12.0, 12.0);
                Rectangle2D.Double r2 = new Rectangle2D.Double(p2.getX() - 6.0, p2.getY() - 6.0, 12.0, 12.0);
                if (this.lineBox != null) {
                    this.lineBox.reset();
                } else {
                    this.lineBox = new Polygon();
                }
                if (f >= 0.0) {
                    this.lineBox.addPoint((int)r1.getMaxX(), (int)r1.getMinY());
                    this.lineBox.addPoint((int)r2.getMaxX(), (int)r2.getMinY());
                    this.lineBox.addPoint((int)r2.getMinX(), (int)r2.getMaxY());
                    this.lineBox.addPoint((int)r1.getMinX(), (int)r1.getMaxY());
                } else {
                    this.lineBox.addPoint((int)r1.getMinX(), (int)r1.getMinY());
                    this.lineBox.addPoint((int)r2.getMinX(), (int)r2.getMinY());
                    this.lineBox.addPoint((int)r2.getMaxX(), (int)r2.getMaxY());
                    this.lineBox.addPoint((int)r1.getMaxX(), (int)r1.getMaxY());
                }
            }
        }

        private void dragCreateShape(Point p, boolean constrain) {
            int nh;
            int ny;
            int nw;
            int nx;
            if (this.dragStart.x <= p.x) {
                nx = this.dragStart.x;
                nw = p.x - nx;
            } else {
                nx = p.x;
                nw = this.dragStart.x - nx;
            }
            if (this.dragStart.y <= p.y) {
                ny = this.dragStart.y;
                nh = p.y - ny;
            } else {
                ny = p.y;
                nh = this.dragStart.y - ny;
            }
            if (constrain) {
                if (nw >= nh) {
                    nh = nw;
                } else {
                    nw = nh;
                }
                if (this.dragStart.x > p.x) {
                    nx = this.dragStart.x - nw;
                }
                if (this.dragStart.y > p.y) {
                    ny = this.dragStart.y - nh;
                }
            }
            ((RectangularShape)this.copyShape).setFrame(nx, ny, nw, nh);
            this.bBox.setRect(this.copyShape.getBounds2D());
            this.repaint();
        }

        private void dragCreateLine(Point p, boolean constrain) {
            if (constrain) {
                int nx = p.x;
                int ny = p.y;
                int nw = this.dragStart.x - p.x;
                int nh = this.dragStart.y - p.y;
                if (Math.abs(nw) >= Math.abs(nh)) {
                    ny = this.dragStart.y;
                } else {
                    nx = this.dragStart.x;
                }
                ((Line2D)this.copyShape).setLine(this.dragStart.x, this.dragStart.y, nx, ny);
            } else {
                ((Line2D)this.copyShape).setLine(this.dragStart.x, this.dragStart.y, p.x, p.y);
            }
            this.bBox.setRect(this.copyShape.getBounds2D());
            this.repaint();
        }

        private void dragMoveShape(Point p, int xdif, int ydif, boolean constrain) {
            if (constrain) {
                if (Math.abs(xdif) >= Math.abs(ydif)) {
                    ydif = 0;
                } else {
                    xdif = 0;
                }
            }
            if (this.copyShape instanceof RectangularShape) {
                ((RectangularShape)this.copyShape).setFrame(this.copyShape.getBounds2D().getX() + (double)xdif, this.copyShape.getBounds2D().getY() + (double)ydif, this.copyShape.getBounds2D().getWidth(), this.copyShape.getBounds().getHeight());
            } else if (this.copyShape instanceof Line2D) {
                Point2D p1 = ((Line2D)this.copyShape).getP1();
                Point2D p2 = ((Line2D)this.copyShape).getP2();
                ((Line2D)this.copyShape).setLine(p1.getX() + (double)xdif, p1.getY() + (double)ydif, p2.getX() + (double)xdif, p2.getY() + (double)ydif);
                this.lineBox.translate(xdif, ydif);
            }
            this.bBox.setRect(this.copyShape.getBounds());
            this.dragStart = p;
            this.repaint();
        }

        private void dragResizeNW(int xdif, int ydif, boolean constrain) {
            double xPoint = this.resizeStartRect.getMinX();
            double yPoint = this.resizeStartRect.getMinY();
            double width = this.resizeStartRect.getWidth();
            double height = this.resizeStartRect.getHeight();
            if (constrain) {
                double ar = width / height;
                ydif = (int)((double)xdif / ar);
            }
            if (this.copyShape instanceof RectangularShape) {
                if (width - (double)xdif > 8.0) {
                    xPoint += (double)xdif;
                    width -= (double)xdif;
                } else {
                    xPoint = this.copyShape.getBounds().getMinX();
                    width = this.copyShape.getBounds().getWidth();
                }
                if (height - (double)ydif > 8.0) {
                    yPoint += (double)ydif;
                    height -= (double)ydif;
                } else {
                    yPoint = this.copyShape.getBounds().getMinY();
                    height = this.copyShape.getBounds().getHeight();
                }
                ((RectangularShape)this.copyShape).setFrame(xPoint, yPoint, width, height);
                this.bBox.setRect(this.copyShape.getBounds());
            }
            this.repaint();
        }

        private void dragResizeNE(int xdif, int ydif, boolean constrain) {
            double xPoint = this.resizeStartRect.getMinX();
            double yPoint = this.resizeStartRect.getMinY();
            double width = this.resizeStartRect.getWidth();
            double height = this.resizeStartRect.getHeight();
            if (constrain) {
                double ar = width / height;
                ydif = (int)((double)(-xdif) / ar);
            }
            if (this.copyShape instanceof RectangularShape) {
                width = width + (double)xdif > 8.0 ? (width += (double)xdif) : this.copyShape.getBounds().getWidth();
                if (height - (double)ydif > 8.0) {
                    yPoint += (double)ydif;
                    height -= (double)ydif;
                } else {
                    yPoint = this.copyShape.getBounds().getMinY();
                    height = this.copyShape.getBounds().getHeight();
                }
                ((RectangularShape)this.copyShape).setFrame(xPoint, yPoint, width, height);
                this.bBox.setRect(this.copyShape.getBounds());
            }
            this.repaint();
        }

        private void dragResizeSE(int xdif, int ydif, boolean constrain) {
            double xPoint = this.resizeStartRect.getMinX();
            double yPoint = this.resizeStartRect.getMinY();
            double width = this.resizeStartRect.getWidth();
            double height = this.resizeStartRect.getHeight();
            if (constrain) {
                double ar = width / height;
                ydif = (int)((double)xdif / ar);
            }
            if (this.copyShape instanceof RectangularShape) {
                width = width + (double)xdif > 8.0 ? (width += (double)xdif) : this.copyShape.getBounds().getWidth();
                height = height + (double)ydif > 8.0 ? (height += (double)ydif) : this.copyShape.getBounds().getHeight();
                ((RectangularShape)this.copyShape).setFrame(xPoint, yPoint, width, height);
                this.bBox.setRect(this.copyShape.getBounds());
            }
            this.repaint();
        }

        private void dragResizeSW(int xdif, int ydif, boolean constrain) {
            double xPoint = this.resizeStartRect.getMinX();
            double yPoint = this.resizeStartRect.getMinY();
            double width = this.resizeStartRect.getWidth();
            double height = this.resizeStartRect.getHeight();
            if (constrain) {
                double ar = width / height;
                ydif = (int)((double)(-xdif) / ar);
            }
            if (this.copyShape instanceof RectangularShape) {
                if (width - (double)xdif > 8.0) {
                    xPoint += (double)xdif;
                    width -= (double)xdif;
                } else {
                    xPoint = this.copyShape.getBounds().getMinX();
                    width = this.copyShape.getBounds().getWidth();
                }
                height = height + (double)ydif > 8.0 ? (height += (double)ydif) : this.copyShape.getBounds().getHeight();
                ((RectangularShape)this.copyShape).setFrame(xPoint, yPoint, width, height);
                this.bBox.setRect(this.copyShape.getBounds());
            }
            this.repaint();
        }

        private void dragLinePoint(Point p, boolean constrain) {
            if (this.copyShape instanceof Line2D && this.editPoint != null) {
                Point2D p1 = ((Line2D)this.copyShape).getP1();
                Point2D p2 = ((Line2D)this.copyShape).getP2();
                int p1x = (int)p1.getX();
                int p1y = (int)p1.getY();
                int p2x = (int)p2.getX();
                int p2y = (int)p2.getY();
                if (!constrain) {
                    if (this.editPoint.x == p1x && this.editPoint.y == p1y) {
                        ((Line2D)this.copyShape).setLine(p.getX(), p.getY(), p2x, p2y);
                    } else if (this.editPoint.x == p2x && this.editPoint.y == p2y) {
                        ((Line2D)this.copyShape).setLine(p1x, p1y, p.getX(), p.getY());
                    }
                    this.editPoint.setLocation(p);
                } else {
                    if (this.editPoint.x == p1x && this.editPoint.y == p1y) {
                        if (p1x == p2x || p1y == p2y) {
                            // empty if block
                        }
                        ((Line2D)this.copyShape).setLine(p.getX(), p.getY(), p2x, p2y);
                    } else if (this.editPoint.x == p2x && this.editPoint.y == p2y) {
                        ((Line2D)this.copyShape).setLine(p1x, p1y, p.getX(), p.getY());
                    }
                    if (p1x == p2x) {
                        if (this.editPoint.x == p1x && this.editPoint.y == p1y) {
                            ((Line2D)this.copyShape).setLine(p1x, p.y, p2x, p2y);
                            this.editPoint.setLocation(p1x, p.y);
                        } else if (this.editPoint.x == p2x && this.editPoint.y == p2y) {
                            ((Line2D)this.copyShape).setLine(p1x, p1y, p2x, p.y);
                            this.editPoint.setLocation(p2x, p.y);
                        }
                    } else if (p1y == p2y) {
                        if (this.editPoint.x == p1x && this.editPoint.y == p1y) {
                            ((Line2D)this.copyShape).setLine(p.x, p1y, p2x, p2y);
                            this.editPoint.setLocation(p.x, p1y);
                        } else if (this.editPoint.x == p2x && this.editPoint.y == p2y) {
                            ((Line2D)this.copyShape).setLine(p1x, p1y, p.x, p2y);
                            this.editPoint.setLocation(p.x, p2y);
                        }
                    } else if (Math.abs(p1x - p2x) >= Math.abs(p1y - p2y)) {
                        if (this.editPoint.x == p1x && this.editPoint.y == p1y) {
                            ((Line2D)this.copyShape).setLine(p.x, p2y, p2x, p2y);
                            this.editPoint.setLocation(p.x, p2y);
                        } else if (this.editPoint.x == p2x && this.editPoint.y == p2y) {
                            ((Line2D)this.copyShape).setLine(p1x, p1y, p.x, p1y);
                            this.editPoint.setLocation(p.x, p1y);
                        }
                    } else if (this.editPoint.x == p1x && this.editPoint.y == p1y) {
                        ((Line2D)this.copyShape).setLine(p2x, p.y, p2x, p2y);
                        this.editPoint.setLocation(p2x, p.y);
                    } else if (this.editPoint.x == p2x && this.editPoint.y == p2y) {
                        ((Line2D)this.copyShape).setLine(p1x, p1y, p1x, p.y);
                        this.editPoint.setLocation(p1x, p.y);
                    }
                }
                this.bBox.setRect(this.copyShape.getBounds());
                this.adjustActiveLineArea();
                this.repaint();
            }
        }
    }

    protected class LibraryIconRenderer
    extends DefaultListCellRenderer {
        LibraryIconRenderer() {
            this.setIconTextGap(8);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ImageIcon icon;
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof String && (icon = (ImageIcon)SVGEditor.this.iconTable.get(value)) != null) {
                this.setIcon(icon);
            }
            return this;
        }
    }
}

